/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.util;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopyFileServer
implements Runnable {
    private static final Logger logger = Logger.getLogger(CopyFileServer.class.getName());
    public static final int BUFFER_SIZE = 4000;
    private final ServerSocket serverSocket;
    private final String filePath;
    private final InputStream fileInput;
    private final byte[] buffer = new byte[4000];
    private Exception failureException = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyFileServer(String filePath) throws Exception {
        this.filePath = filePath;
        this.serverSocket = new ServerSocket(2376);
        boolean openedFile = false;
        try {
            this.fileInput = new FileInputStream(filePath);
            openedFile = true;
        }
        finally {
            if (!openedFile) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Ignoring exception when closing socket", e);
                }
            }
        }
    }

    public synchronized Exception getFailureException() {
        return this.failureException;
    }

    private synchronized void setFailureException(Exception e) {
        this.failureException = e;
    }

    @Override
    public void run() {
        this.serveFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveFile() {
        Socket socket = null;
        FilterOutputStream out = null;
        try {
            int n;
            block35: {
                socket = this.serverSocket.accept();
                logger.log(Level.FINE, "CopyFileServer: Accepted client connection");
                out = new DataOutputStream(socket.getOutputStream());
                do {
                    if ((n = this.fileInput.read(this.buffer)) <= 0) break block35;
                    ((DataOutputStream)out).writeShort((short)n);
                    ((DataOutputStream)out).write(this.buffer, 0, n);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "CopyFileServer: Sent " + n + " bytes");
                } while (!Thread.interrupted());
                throw new InterruptedException("Copy server interrupted");
            }
            ((DataOutputStream)out).write(0);
            ((DataOutputStream)out).write(0);
            ((DataOutputStream)out).flush();
            logger.log(Level.FINE, "CopyFileServer: Waiting for client");
            try {
                n = socket.getInputStream().read();
                if (n != -1) {
                    throw new IOException("Unexpected value read from socket input stream: " + n);
                }
            }
            catch (SocketException e) {
                // empty catch block
            }
            out.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "CopyFileServer: Error while serving file: " + this.filePath, e);
            this.setFailureException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
            try {
                this.fileInput.close();
            }
            catch (IOException e) {}
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

