/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.util;

import com.vmware.sva.common.ShutdownMode;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.common.SvaUtilities;
import com.vmware.sva.common.util.SystemCommand;
import com.vmware.sva.services.watchdog.WatchdogTimer;
import com.vmware.sva.util.BasicLoggerInterface;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public class SystemUtils {
    private static final String PROC_SYS_KERNEL_SYSRQ = "/proc/sys/kernel/sysrq";
    private static final String PROC_SYSRQ_TRIGGER = "/proc/sysrq-trigger";
    private static final String PROC_SVATESTMOD = "/proc/svatestmod";
    private static final String SYNC_FILES_WATCHDOG_NAME = "SyncFilesWatchdog";
    private static final String VSA_REBOOT_SIGNATURE = "/etc/sva/.vsa-reboot";
    private static List<WatchdogTimer> timers = new ArrayList<WatchdogTimer>();
    private static Object syncLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown(ShutdownMode mode, WatchdogTimer timer, BasicLoggerInterface logger, StackTraceElement[] stackTrace) {
        SystemUtils.writeVsaRebootSignature(logger);
        SystemUtils.syncSystem(mode, timer, logger, stackTrace);
        Object object = syncLock;
        synchronized (object) {
            block19: {
                try {
                    if (SvaDebug.TERMINATE_INSTEAD_OF_REBOOT) {
                        SystemCommand.executePlatformCommand((String[])new String[]{"/sbin/service", "sva", "stop"});
                        break block19;
                    }
                    switch (mode) {
                        case SHUTDOWN: {
                            SystemCommand.executePlatformCommand((String[])new String[]{"/sbin/shutdown", "-h", "now"});
                            break;
                        }
                        case FORCED_SHUTDOWN: {
                            SvaUtilities.writeToFile((String)PROC_SYS_KERNEL_SYSRQ, (String)"1");
                            SvaUtilities.writeToFile((String)PROC_SYSRQ_TRIGGER, (String)"o");
                            assert (false) : "Shouldn't get here!";
                            break;
                        }
                        case REBOOT: {
                            SystemCommand.executePlatformCommand((String[])new String[]{"/sbin/reboot"});
                            break;
                        }
                        case FORCED_REBOOT: {
                            logger.log(Level.WARNING, "Force reboot of the system.");
                            WatchdogTimer.rebootSystem();
                            assert (false) : "Shouldn't get here!";
                            break;
                        }
                        case CRASH: {
                            SvaUtilities.writeToFile((String)PROC_SYS_KERNEL_SYSRQ, (String)"1");
                            SvaUtilities.writeToFile((String)PROC_SYSRQ_TRIGGER, (String)"c");
                            assert (false) : "Shouldn't get here!";
                            break;
                        }
                        case HANG: {
                            SvaUtilities.writeToFile((String)PROC_SVATESTMOD, (String)"H");
                            assert (false) : "Shouldn't get here!";
                            break;
                        }
                        default: {
                            assert (false) : "Invalid shutdown mode!";
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError((Object)(mode.toString() + " failed: " + e.toString()));
                }
            }
            SystemUtils.waitHere();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncSystem(ShutdownMode mode, WatchdogTimer timer, BasicLoggerInterface logger, StackTraceElement[] stackTrace) {
        Object object = syncLock;
        synchronized (object) {
            try {
                SystemUtils.setSyncOpenFilesWatchdog(timer, mode);
                if (logger != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(mode);
                    for (StackTraceElement elm : stackTrace) {
                        sb.append("\n").append(elm);
                    }
                    logger.log(Level.WARNING, sb.toString());
                }
                SystemUtils.dumpCodeCoverageData(logger);
                WatchdogTimer.syncOpenFiles();
                SystemUtils.syncBlockDevs(logger);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Syncing open files during " + mode.toString() + " failed: " + e.getMessage(), e);
            }
        }
    }

    public static void reboot(boolean force, WatchdogTimer timer, BasicLoggerInterface logger) {
        if (!SvaConstants.IS_PSEUDO_SVA) {
            SystemUtils.shutdown(force ? ShutdownMode.FORCED_REBOOT : ShutdownMode.REBOOT, timer, logger, Thread.currentThread().getStackTrace());
        } else {
            logger.log(Level.INFO, "Method reboot() is disabled in VCS.");
        }
    }

    public static void shutdown(boolean force, WatchdogTimer timer, BasicLoggerInterface logger) {
        if (!SvaConstants.IS_PSEUDO_SVA) {
            SystemUtils.shutdown(force ? ShutdownMode.FORCED_SHUTDOWN : ShutdownMode.SHUTDOWN, timer, logger, Thread.currentThread().getStackTrace());
        } else {
            logger.log(Level.INFO, "Method shutdown() is disabled in VCS.");
        }
    }

    public static void crash(WatchdogTimer timer, BasicLoggerInterface logger) {
        if (!SvaConstants.IS_PSEUDO_SVA) {
            SystemUtils.shutdown(ShutdownMode.CRASH, timer, logger, Thread.currentThread().getStackTrace());
        } else {
            logger.log(Level.INFO, "Method crash() is disabled in VCS.");
        }
    }

    public static void hang(WatchdogTimer timer, BasicLoggerInterface logger) {
        if (!SvaConstants.IS_PSEUDO_SVA) {
            SystemUtils.shutdown(ShutdownMode.HANG, timer, logger, Thread.currentThread().getStackTrace());
        } else {
            logger.log(Level.INFO, "Method hang() is disabled in VCS.");
        }
    }

    public static void sync(WatchdogTimer timer, BasicLoggerInterface logger) {
        if (!SvaConstants.IS_PSEUDO_SVA) {
            SystemUtils.syncSystem(ShutdownMode.SYNC_ONLY, timer, logger, Thread.currentThread().getStackTrace());
        }
    }

    public static void writeVsaRebootSignature(BasicLoggerInterface logger) {
        try {
            SvaUtilities.writeToFile((String)VSA_REBOOT_SIGNATURE, (String)new Date().toString());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to write VSA reboot signature file.", e);
        }
    }

    public static boolean vsaRebootSignatureExists(BasicLoggerInterface logger) {
        return new File(VSA_REBOOT_SIGNATURE).exists();
    }

    public static void clearVsaRebootSignature(BasicLoggerInterface logger) {
        try {
            SvaUtilities.deleteFiles((File[])new File[]{new File(VSA_REBOOT_SIGNATURE)});
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to remove VSA reboot signature file.", e);
        }
    }

    public static List<Date> getDumpTimestamps() {
        ArrayList<Date> dumpDates = new ArrayList<Date>();
        File crashDir = new File("/var/crash");
        FilenameFilter vmcoreFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("vmcore");
            }
        };
        for (File f : crashDir.listFiles()) {
            if (f.getName().equals("lost+found") || !f.isDirectory()) continue;
            for (File core : f.listFiles(vmcoreFilter)) {
                dumpDates.add(new Date(core.lastModified()));
            }
        }
        Collections.sort(dumpDates);
        return dumpDates;
    }

    private static WatchdogTimer setSyncOpenFilesWatchdog(WatchdogTimer timer, ShutdownMode mode) throws Exception {
        int timeoutValue;
        switch (mode) {
            case REBOOT: 
            case FORCED_REBOOT: {
                timeoutValue = SvaDebug.PLATFORM_SYNC_FILES_TIMEOUT;
                break;
            }
            default: {
                timeoutValue = SvaConstants.BLC_EDGE_WATCHDOG_INTERVAL;
            }
        }
        if (timer == null) {
            timer = new WatchdogTimer(SYNC_FILES_WATCHDOG_NAME, timeoutValue, timers);
        } else {
            timer.reset(timeoutValue);
        }
        return timer;
    }

    private static void waitHere() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException e) {
                if ($assertionsDisabled) continue;
                throw new AssertionError((Object)"Should never get here!");
            }
            break;
        }
    }

    private static void syncBlockDevs(BasicLoggerInterface logger) {
        try {
            String[] devs = SvaConstants.SHUTDOWN_FLUSH_BLOCKDEVS.split("\\s");
            ArrayList<String> command = new ArrayList<String>();
            command.addAll(Arrays.asList("/sbin/blockdev", "--flushbufs"));
            command.addAll(Arrays.asList(devs));
            SystemCommand.executePlatformCommand((String[])command.toArray(new String[command.size()]));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to sync " + SvaConstants.SHUTDOWN_FLUSH_BLOCKDEVS, e);
        }
    }

    private static void dumpCodeCoverageData(BasicLoggerInterface logger) {
        try {
            Class<?> toolClass = Class.forName("net.sourceforge.cobertura.coveragedata.ProjectData");
            Method dumpMethod = toolClass.getDeclaredMethod("saveGlobalProjectData", new Class[0]);
            dumpMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "Cobertura class not found, code coverage disabled");
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.WARNING, "Can't find method to dump code coverage data", e);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to dump code coverage data", e);
        }
    }
}

