/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.NetworkInterface;
import com.vmware.sva.common.StoragePool;
import com.vmware.sva.common.SvaServerInfo;
import com.vmware.sva.common.SvaState;
import com.vmware.sva.common.SvaUtilities;
import java.util.UUID;

public class MemberSva
extends SvaServerInfo {
    private final UUID memberId;
    private SvaState state;
    private UUID[] exportedStorageEntities;
    private static final long serialVersionUID = 1L;

    public MemberSva(UUID theSvaId, UUID theMemberId, SvaState theState) {
        this(theSvaId, null, null, false, false, null, null, null, null, null, null, 0L, 0L, 0L, theState, theMemberId, null);
    }

    public MemberSva(UUID id, String name, UUID theStorageClusterID, boolean primaryMember, boolean inMaintenanceMode, NetworkInterface theManagementInterface, NetworkInterface theInternalInterface, String[] theDnsServers, String theDomainName, String theGateway, StoragePool[] theStoragePools, long curTotalStorage, long curUsedStorage, long curFreeStorage, SvaState theState, UUID theMemberId, UUID[] theExportedEntites) {
        super(id, name, theStorageClusterID, primaryMember, inMaintenanceMode, theManagementInterface, theInternalInterface, theDnsServers, theDomainName, theGateway, theStoragePools, curTotalStorage, curUsedStorage, curFreeStorage);
        this.memberId = theMemberId;
        this.state = theState;
        this.exportedStorageEntities = SvaUtilities.copyArray(theExportedEntites);
    }

    public MemberSva(SvaServerInfo svaServerInfo, SvaState theState, UUID theMemberId, UUID[] theExportedEntites) {
        super(svaServerInfo);
        this.memberId = theMemberId;
        this.state = theState;
        this.exportedStorageEntities = SvaUtilities.copyArray(theExportedEntites);
    }

    public UUID getMemberId() {
        return this.memberId;
    }

    public SvaState getState() {
        return this.state;
    }

    public void setState(SvaState state) {
        this.state = state;
    }

    public UUID[] getExportedStorageEntities() {
        return SvaUtilities.copyArray(this.exportedStorageEntities);
    }

    public void setExportedStorageEntities(UUID[] exportedStorageEntities) {
        this.exportedStorageEntities = SvaUtilities.copyArray(exportedStorageEntities);
    }
}

