/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common.exceptions;

import com.vmware.sva.common.exceptions.AbstractException;
import com.vmware.sva.common.exceptions.Messages;
import java.util.UUID;

public class ReplaceMemberException
extends AbstractException {
    private final UUID oldSvaId;
    private final UUID newSvaId;
    private static final long serialVersionUID = 1L;

    public ReplaceMemberException(UUID oldSvaId, UUID newSvaId, Throwable cause) {
        super(String.format(Messages.getString("ReplaceMemberException.0") + (cause != null ? " : " + cause.getMessage() : ""), oldSvaId, newSvaId), cause);
        assert (oldSvaId != null);
        assert (newSvaId != null);
        assert (cause != null);
        this.oldSvaId = oldSvaId;
        this.newSvaId = newSvaId;
    }

    public ReplaceMemberException(String message, UUID oldSvaId, UUID newSvaId, Throwable cause) {
        super(message, cause);
        assert (oldSvaId != null);
        assert (newSvaId != null);
        assert (message != null);
        assert (message.length() > 0);
        this.oldSvaId = oldSvaId;
        this.newSvaId = newSvaId;
    }

    public UUID getOldSvaId() {
        return this.oldSvaId;
    }

    public UUID getNewSvaId() {
        return this.newSvaId;
    }
}

