/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public abstract class AbstractErrors
implements Errors,
Serializable {
    private String nestedPath = "";
    private final Stack nestedPathStack = new Stack();

    public void setNestedPath(String nestedPath) {
        this.doSetNestedPath(nestedPath);
        this.nestedPathStack.clear();
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public void pushNestedPath(String subPath) {
        this.nestedPathStack.push(this.getNestedPath());
        this.doSetNestedPath(this.getNestedPath() + subPath);
    }

    public void popNestedPath() throws IllegalArgumentException {
        try {
            String formerNestedPath = (String)this.nestedPathStack.pop();
            this.doSetNestedPath(formerNestedPath);
        }
        catch (EmptyStackException ex) {
            throw new IllegalStateException("Cannot pop nested path: no nested path on stack");
        }
    }

    protected void doSetNestedPath(String nestedPath) {
        if (nestedPath == null) {
            nestedPath = "";
        }
        if ((nestedPath = this.canonicalFieldName(nestedPath)).length() > 0 && !nestedPath.endsWith(".")) {
            nestedPath = nestedPath + ".";
        }
        this.nestedPath = nestedPath;
    }

    protected String fixedField(String field) {
        if (StringUtils.hasLength(field)) {
            return this.getNestedPath() + this.canonicalFieldName(field);
        }
        String path = this.getNestedPath();
        return path.endsWith(".") ? path.substring(0, path.length() - ".".length()) : path;
    }

    protected String canonicalFieldName(String field) {
        return field;
    }

    public void reject(String errorCode) {
        this.reject(errorCode, null, null);
    }

    public void reject(String errorCode, String defaultMessage) {
        this.reject(errorCode, null, defaultMessage);
    }

    public void rejectValue(String field, String errorCode) {
        this.rejectValue(field, errorCode, null, null);
    }

    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.rejectValue(field, errorCode, null, defaultMessage);
    }

    public boolean hasErrors() {
        return !this.getAllErrors().isEmpty();
    }

    public int getErrorCount() {
        return this.getAllErrors().size();
    }

    public List getAllErrors() {
        LinkedList result = new LinkedList();
        result.addAll(this.getGlobalErrors());
        result.addAll(this.getFieldErrors());
        return Collections.unmodifiableList(result);
    }

    public boolean hasGlobalErrors() {
        return this.getGlobalErrorCount() > 0;
    }

    public int getGlobalErrorCount() {
        return this.getGlobalErrors().size();
    }

    public ObjectError getGlobalError() {
        List globalErrors = this.getGlobalErrors();
        return !globalErrors.isEmpty() ? (ObjectError)globalErrors.get(0) : null;
    }

    public boolean hasFieldErrors() {
        return this.getFieldErrorCount() > 0;
    }

    public int getFieldErrorCount() {
        return this.getFieldErrors().size();
    }

    public FieldError getFieldError() {
        List fieldErrors = this.getFieldErrors();
        return !fieldErrors.isEmpty() ? (FieldError)fieldErrors.get(0) : null;
    }

    public boolean hasFieldErrors(String field) {
        return this.getFieldErrorCount(field) > 0;
    }

    public int getFieldErrorCount(String field) {
        return this.getFieldErrors(field).size();
    }

    public List getFieldErrors(String field) {
        List fieldErrors = this.getFieldErrors();
        LinkedList result = new LinkedList();
        String fixedField = this.fixedField(field);
        Iterator it = fieldErrors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (!this.isMatchingFieldError(fixedField, (FieldError)error)) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public FieldError getFieldError(String field) {
        List fieldErrors = this.getFieldErrors(field);
        return !fieldErrors.isEmpty() ? (FieldError)fieldErrors.get(0) : null;
    }

    public Class getFieldType(String field) {
        Object value = this.getFieldValue(field);
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    protected boolean isMatchingFieldError(String field, FieldError fieldError) {
        return field.equals(fieldError.getField()) || field.endsWith("*") && fieldError.getField().startsWith(field.substring(0, field.length() - 1));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(": ").append(this.getErrorCount()).append(" errors");
        Iterator it = this.getAllErrors().iterator();
        while (it.hasNext()) {
            sb.append('\n').append(it.next());
        }
        return sb.toString();
    }
}

