/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkmgmtserver;

import com.vmware.sva.util.SvaHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ZkStandaloneServer
extends ZooKeeperServerMain {
    private final String configFile;
    private final ZooKeeperInstance zkInstance;
    private final Logger logger;

    public ZkStandaloneServer(String configFile, Logger logger) {
        this.logger = logger;
        this.configFile = configFile;
        this.zkInstance = new ZooKeeperInstance();
    }

    public void startServer() throws Exception {
        this.zkInstance.start();
    }

    public void shutdownServer() throws Exception {
        this.shutdown();
        this.zkInstance.join();
    }

    private class ZooKeeperInstance
    extends Thread {
        ZooKeeperInstance() {
            super("ZooKeeper Standalone Server");
        }

        @Override
        public void run() {
            String[] s = new String[]{ZkStandaloneServer.this.configFile};
            try {
                ZkStandaloneServer.this.initializeAndRun(s);
            }
            catch (IllegalArgumentException e) {
                ZkStandaloneServer.this.logger.log(Level.WARNING, "Invalid arguments, exiting abnormally: " + e.getMessage());
            }
            catch (QuorumPeerConfig.ConfigException e) {
                ZkStandaloneServer.this.logger.log(Level.WARNING, "Invalid configuration, exiting abnormally: " + e.getMessage());
            }
            catch (AssertionError e) {
                SvaHelper.handleAssertionError((String)"ZkStandaloneServer.ZooKeeperInstance", (AssertionError)e, (Logger)ZkStandaloneServer.this.logger);
            }
            catch (Throwable e) {
                ZkStandaloneServer.this.logger.log(Level.SEVERE, "Unexpected exception, exiting abnormally: " + e.getMessage(), e);
            }
        }
    }
}

