/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DQTMarkerSegment
extends MarkerSegment {
    List tables = new ArrayList();

    DQTMarkerSegment(float f, boolean bl) {
        super(219);
        this.tables.add(new Qtable(true, f));
        if (bl) {
            this.tables.add(new Qtable(false, f));
        }
    }

    DQTMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        Qtable qtable;
        for (int i = this.length; i > 0; i -= qtable.data.length + 1) {
            qtable = new Qtable(jPEGBuffer);
            this.tables.add(qtable);
        }
        jPEGBuffer.bufAvail -= this.length;
    }

    DQTMarkerSegment(JPEGQTable[] jPEGQTableArray) {
        super(219);
        for (int i = 0; i < jPEGQTableArray.length; ++i) {
            this.tables.add(new Qtable(jPEGQTableArray[i], i));
        }
    }

    DQTMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(219);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (n < 1 || n > 4) {
            throw new IIOInvalidTreeException("Invalid DQT node", node);
        }
        for (int i = 0; i < n; ++i) {
            this.tables.add(new Qtable(nodeList.item(i)));
        }
    }

    protected Object clone() {
        DQTMarkerSegment dQTMarkerSegment = (DQTMarkerSegment)super.clone();
        dQTMarkerSegment.tables = new ArrayList(this.tables.size());
        for (Qtable qtable : this.tables) {
            dQTMarkerSegment.tables.add(qtable.clone());
        }
        return dQTMarkerSegment;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dqt");
        for (int i = 0; i < this.tables.size(); ++i) {
            Qtable qtable = (Qtable)this.tables.get(i);
            iIOMetadataNode.appendChild(qtable.getNativeNode());
        }
        return iIOMetadataNode;
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    void print() {
        this.printTag("DQT");
        System.out.println("Num tables: " + Integer.toString(this.tables.size()));
        for (int i = 0; i < this.tables.size(); ++i) {
            Qtable qtable = (Qtable)this.tables.get(i);
            qtable.print();
        }
        System.out.println();
    }

    Qtable getChromaForLuma(Qtable qtable) {
        int n;
        Qtable qtable2 = null;
        boolean bl = true;
        for (n = 1; n < qtable.QTABLE_SIZE; ++n) {
            if (qtable.data[n] == qtable.data[n - 1]) continue;
            bl = false;
            break;
        }
        if (bl) {
            qtable2 = (Qtable)qtable.clone();
            qtable2.tableID = 1;
        } else {
            n = 0;
            for (int i = 1; i < qtable.QTABLE_SIZE; ++i) {
                if (qtable.data[i] <= qtable.data[n]) continue;
                n = i;
            }
            float f = (float)qtable.data[n] / (float)JPEGQTable.K1Div2Luminance.getTable()[n];
            JPEGQTable jPEGQTable = JPEGQTable.K2Div2Chrominance.getScaledInstance(f, true);
            qtable2 = new Qtable(jPEGQTable, 1);
        }
        return qtable2;
    }

    Qtable getQtableFromNode(Node node) throws IIOInvalidTreeException {
        return new Qtable(node);
    }

    class Qtable
    implements Cloneable {
        int elementPrecision;
        int tableID;
        final int QTABLE_SIZE = 64;
        int[] data;
        private final int[] zigzag = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};

        Qtable(boolean bl, float f) {
            this.elementPrecision = 0;
            JPEGQTable jPEGQTable = null;
            if (bl) {
                this.tableID = 0;
                jPEGQTable = JPEGQTable.K1Div2Luminance;
            } else {
                this.tableID = 1;
                jPEGQTable = JPEGQTable.K2Div2Chrominance;
            }
            if (f != 0.75f) {
                f = JPEG.convertToLinearQuality(f);
                jPEGQTable = bl ? JPEGQTable.K1Luminance.getScaledInstance(f, true) : JPEGQTable.K2Div2Chrominance.getScaledInstance(f, true);
            }
            this.data = jPEGQTable.getTable();
        }

        Qtable(JPEGBuffer jPEGBuffer) throws IIOException {
            this.elementPrecision = jPEGBuffer.buf[jPEGBuffer.bufPtr] >>> 4;
            this.tableID = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
            if (this.elementPrecision != 0) {
                throw new IIOException("Unsupported element precision");
            }
            this.data = new int[64];
            for (int i = 0; i < 64; ++i) {
                this.data[i] = jPEGBuffer.buf[jPEGBuffer.bufPtr + this.zigzag[i]] & 0xFF;
            }
            jPEGBuffer.bufPtr += 64;
        }

        Qtable(JPEGQTable jPEGQTable, int n) {
            this.elementPrecision = 0;
            this.tableID = n;
            this.data = jPEGQTable.getTable();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Qtable(Node node) throws IIOInvalidTreeException {
            if (!node.getNodeName().equals("dqtable")) throw new IIOInvalidTreeException("Invalid node, expected dqtable", node);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            if (n < 1 || n > 2) {
                throw new IIOInvalidTreeException("dqtable node must have 1 or 2 attributes", node);
            }
            this.elementPrecision = 0;
            this.tableID = MarkerSegment.getAttributeValue(node, namedNodeMap, "qtableId", 0, 3, true);
            if (!(node instanceof IIOMetadataNode)) throw new IIOInvalidTreeException("dqtable node must have user object", node);
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
            JPEGQTable jPEGQTable = (JPEGQTable)iIOMetadataNode.getUserObject();
            if (jPEGQTable == null) {
                throw new IIOInvalidTreeException("dqtable node must have user object", node);
            }
            this.data = jPEGQTable.getTable();
        }

        protected Object clone() {
            Qtable qtable = null;
            try {
                qtable = (Qtable)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.data != null) {
                qtable.data = (int[])this.data.clone();
            }
            return qtable;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dqtable");
            iIOMetadataNode.setAttribute("elementPrecision", Integer.toString(this.elementPrecision));
            iIOMetadataNode.setAttribute("qtableId", Integer.toString(this.tableID));
            iIOMetadataNode.setUserObject(new JPEGQTable(this.data));
            return iIOMetadataNode;
        }

        void print() {
            System.out.println("Table id: " + Integer.toString(this.tableID));
            System.out.println("Element precision: " + Integer.toString(this.elementPrecision));
            new JPEGQTable(this.data).toString();
        }
    }
}

