/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueuedSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414691L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile int state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;
    private static final long nextOffset;

    protected AbstractQueuedSynchronizer() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int n) {
        this.state = n;
    }

    protected final boolean compareAndSetState(int n, int n2) {
        return unsafe.compareAndSwapInt(this, stateOffset, n, n2);
    }

    private Node enq(Node node) {
        Node node2;
        while (true) {
            if ((node2 = this.tail) == null) {
                Node node3 = new Node();
                node3.next = node;
                node.prev = node3;
                if (!this.compareAndSetHead(node3)) continue;
                this.tail = node;
                return node3;
            }
            node.prev = node2;
            if (this.compareAndSetTail(node2, node)) break;
        }
        node2.next = node;
        return node2;
    }

    private Node addWaiter(Node node) {
        Node node2 = new Node(Thread.currentThread(), node);
        Node node3 = this.tail;
        if (node3 != null) {
            node2.prev = node3;
            if (this.compareAndSetTail(node3, node2)) {
                node3.next = node2;
                return node2;
            }
        }
        this.enq(node2);
        return node2;
    }

    private void setHead(Node node) {
        this.head = node;
        node.thread = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        Node node2;
        int n = node.waitStatus;
        if (n < 0) {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, n, 0);
        }
        if ((node2 = node.next) == null || node2.waitStatus > 0) {
            node2 = null;
            Node node3 = this.tail;
            while (node3 != null && node3 != node) {
                if (node3.waitStatus <= 0) {
                    node2 = node3;
                }
                node3 = node3.prev;
            }
        }
        if (node2 != null) {
            LockSupport.unpark(node2.thread);
        }
    }

    private void doReleaseShared() {
        while (true) {
            Node node;
            if ((node = this.head) != null && node != this.tail) {
                int n = node.waitStatus;
                if (n == -1) {
                    if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -1, 0)) continue;
                    this.unparkSuccessor(node);
                } else if (n == 0 && !AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, 0, -3)) continue;
            }
            if (node == this.head) break;
        }
    }

    private void setHeadAndPropagate(Node node, int n) {
        Node node2;
        Node node3 = this.head;
        this.setHead(node);
        if (!(n <= 0 && node3 != null && node3.waitStatus >= 0 || (node2 = node.next) != null && !node2.isShared())) {
            this.doReleaseShared();
        }
    }

    private void cancelAcquire(Node node) {
        if (node == null) {
            return;
        }
        node.thread = null;
        Node node2 = node.prev;
        while (node2.waitStatus > 0) {
            node.prev = node2 = node2.prev;
        }
        Node node3 = node2.next;
        node.waitStatus = 1;
        if (node == this.tail && this.compareAndSetTail(node, node2)) {
            AbstractQueuedSynchronizer.compareAndSetNext(node2, node3, null);
        } else {
            int n;
            if (node2 != this.head && ((n = node2.waitStatus) == -1 || n <= 0 && AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, n, -1)) && node2.thread != null) {
                Node node4 = node.next;
                if (node4 != null && node4.waitStatus <= 0) {
                    AbstractQueuedSynchronizer.compareAndSetNext(node2, node3, node4);
                }
            } else {
                this.unparkSuccessor(node);
            }
            node.next = node;
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node node, Node node2) {
        int n = node.waitStatus;
        if (n == -1) {
            return true;
        }
        if (n > 0) {
            do {
                node2.prev = node = node.prev;
            } while (node.waitStatus > 0);
            node.next = node2;
        } else {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, n, -1);
        }
        return false;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park(this);
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node, int n) {
        try {
            boolean bl = false;
            while (true) {
                Node node2;
                if ((node2 = node.predecessor()) == this.head && this.tryAcquire(n)) {
                    this.setHead(node);
                    node2.next = null;
                    return bl;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt()) continue;
                bl = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
    }

    private void doAcquireInterruptibly(int n) throws InterruptedException {
        Node node = this.addWaiter(Node.EXCLUSIVE);
        try {
            Node node2;
            do {
                if ((node2 = node.predecessor()) != this.head || !this.tryAcquire(n)) continue;
                this.setHead(node);
                node2.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private boolean doAcquireNanos(int n, long l) throws InterruptedException {
        long l2 = System.nanoTime();
        Node node = this.addWaiter(Node.EXCLUSIVE);
        try {
            do {
                Node node2;
                if ((node2 = node.predecessor()) == this.head && this.tryAcquire(n)) {
                    this.setHead(node);
                    node2.next = null;
                    return true;
                }
                if (l <= 0L) {
                    this.cancelAcquire(node);
                    return false;
                }
                if (l > 1000L && AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node)) {
                    LockSupport.parkNanos(this, l);
                }
                long l3 = System.nanoTime();
                l -= l3 - l2;
                l2 = l3;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private void doAcquireShared(int n) {
        Node node = this.addWaiter(Node.SHARED);
        try {
            boolean bl = false;
            while (true) {
                int n2;
                Node node2;
                if ((node2 = node.predecessor()) == this.head && (n2 = this.tryAcquireShared(n)) >= 0) {
                    this.setHeadAndPropagate(node, n2);
                    node2.next = null;
                    if (bl) {
                        AbstractQueuedSynchronizer.selfInterrupt();
                    }
                    return;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt()) continue;
                bl = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
    }

    private void doAcquireSharedInterruptibly(int n) throws InterruptedException {
        Node node = this.addWaiter(Node.SHARED);
        try {
            Node node2;
            do {
                int n2;
                if ((node2 = node.predecessor()) != this.head || (n2 = this.tryAcquireShared(n)) < 0) continue;
                this.setHeadAndPropagate(node, n2);
                node2.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private boolean doAcquireSharedNanos(int n, long l) throws InterruptedException {
        long l2 = System.nanoTime();
        Node node = this.addWaiter(Node.SHARED);
        try {
            do {
                int n2;
                Node node2;
                if ((node2 = node.predecessor()) == this.head && (n2 = this.tryAcquireShared(n)) >= 0) {
                    this.setHeadAndPropagate(node, n2);
                    node2.next = null;
                    return true;
                }
                if (l <= 0L) {
                    this.cancelAcquire(node);
                    return false;
                }
                if (l > 1000L && AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node)) {
                    LockSupport.parkNanos(this, l);
                }
                long l3 = System.nanoTime();
                l -= l3 - l2;
                l2 = l3;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    protected boolean tryAcquire(int n) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(int n) {
        throw new UnsupportedOperationException();
    }

    protected int tryAcquireShared(int n) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(int n) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(int n) {
        if (!this.tryAcquire(n) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), n)) {
            AbstractQueuedSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(int n) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquire(n)) {
            this.doAcquireInterruptibly(n);
        }
    }

    public final boolean tryAcquireNanos(int n, long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquire(n) || this.doAcquireNanos(n, l);
    }

    public final boolean release(int n) {
        if (this.tryRelease(n)) {
            Node node = this.head;
            if (node != null && node.waitStatus != 0) {
                this.unparkSuccessor(node);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(int n) {
        if (this.tryAcquireShared(n) < 0) {
            this.doAcquireShared(n);
        }
    }

    public final void acquireSharedInterruptibly(int n) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.tryAcquireShared(n) < 0) {
            this.doAcquireSharedInterruptibly(n);
        }
    }

    public final boolean tryAcquireSharedNanos(int n, long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireShared(n) >= 0 || this.doAcquireSharedNanos(n, l);
    }

    public final boolean releaseShared(int n) {
        if (this.tryReleaseShared(n)) {
            this.doReleaseShared();
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        return this.head != this.tail;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Thread thread;
        Node node;
        Node node2 = this.head;
        if (node2 != null && (node = node2.next) != null && node.prev == this.head && (thread = node.thread) != null || (node2 = this.head) != null && (node = node2.next) != null && node.prev == this.head && (thread = node.thread) != null) {
            return thread;
        }
        Node node3 = this.tail;
        Thread thread2 = null;
        while (node3 != null && node3 != this.head) {
            Thread thread3 = node3.thread;
            if (thread3 != null) {
                thread2 = thread3;
            }
            node3 = node3.prev;
        }
        return thread2;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node node = this.tail;
        while (node != null) {
            if (node.thread == thread) {
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node node;
        Node node2 = this.head;
        return node2 != null && (node = node2.next) != null && node.nextWaiter != Node.SHARED;
    }

    final boolean isFirst(Thread thread) {
        Node node;
        Node node2 = this.head;
        return node2 == null || (node = node2.next) != null && node.thread == thread || this.fullIsFirst(thread);
    }

    final boolean fullIsFirst(Thread thread) {
        Node node;
        Thread thread2 = null;
        Node node2 = this.head;
        if (node2 != null && (node = node2.next) != null && node.prev == this.head && (thread2 = node.thread) != null) {
            return thread2 == thread;
        }
        Node node3 = this.tail;
        while (node3 != null && node3 != this.head) {
            Thread thread3 = node3.thread;
            if (thread3 != null) {
                thread2 = thread3;
            }
            node3 = node3.prev;
        }
        return thread2 == thread || thread2 == null;
    }

    public final int getQueueLength() {
        int n = 0;
        Node node = this.tail;
        while (node != null) {
            if (node.thread != null) {
                ++n;
            }
            node = node.prev;
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread = node.thread;
            if (thread != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (!node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public String toString() {
        int n = this.getState();
        String string = this.hasQueuedThreads() ? "non" : "";
        return super.toString() + "[State = " + n + ", " + string + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node) {
        if (node.waitStatus == -2 || node.prev == null) {
            return false;
        }
        if (node.next != null) {
            return true;
        }
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node node2 = this.tail;
        while (node2 != node) {
            if (node2 == null) {
                return false;
            }
            node2 = node2.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node) {
        if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            return false;
        }
        Node node2 = this.enq(node);
        int n = node2.waitStatus;
        if (n > 0 || !AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, n, -1)) {
            LockSupport.unpark(node.thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node) {
        if (AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            this.enq(node);
            return true;
        }
        while (!this.isOnSyncQueue(node)) {
            Thread.yield();
        }
        return false;
    }

    final int fullyRelease(Node node) {
        try {
            int n = this.getState();
            if (this.release(n)) {
                return n;
            }
        }
        catch (RuntimeException runtimeException) {
            node.waitStatus = 1;
            throw runtimeException;
        }
        node.waitStatus = 1;
        throw new IllegalMonitorStateException();
    }

    public final boolean owns(ConditionObject conditionObject) {
        if (conditionObject == null) {
            throw new NullPointerException();
        }
        return conditionObject.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node node) {
        return unsafe.compareAndSwapObject(this, headOffset, null, node);
    }

    private final boolean compareAndSetTail(Node node, Node node2) {
        return unsafe.compareAndSwapObject(this, tailOffset, node, node2);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int n, int n2) {
        return unsafe.compareAndSwapInt(node, waitStatusOffset, n, n2);
    }

    private static final boolean compareAndSetNext(Node node, Node node2, Node node3) {
        return unsafe.compareAndSwapObject(node, nextOffset, node2, node3);
    }

    static {
        try {
            stateOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("state"));
            headOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("head"));
            tailOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("tail"));
            waitStatusOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("waitStatus"));
            nextOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("next"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;

        private Node addConditionWaiter() {
            Node node = this.lastWaiter;
            if (node != null && node.waitStatus != -2) {
                this.unlinkCancelledWaiters();
                node = this.lastWaiter;
            }
            Node node2 = new Node(Thread.currentThread(), -2);
            if (node == null) {
                this.firstWaiter = node2;
            } else {
                node.nextWaiter = node2;
            }
            this.lastWaiter = node2;
            return node2;
        }

        private void doSignal(Node node) {
            do {
                if ((this.firstWaiter = node.nextWaiter) == null) {
                    this.lastWaiter = null;
                }
                node.nextWaiter = null;
            } while (!AbstractQueuedSynchronizer.this.transferForSignal(node) && (node = this.firstWaiter) != null);
        }

        private void doSignalAll(Node node) {
            Node node2;
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                node2 = node.nextWaiter;
                node.nextWaiter = null;
                AbstractQueuedSynchronizer.this.transferForSignal(node);
            } while ((node = node2) != null);
        }

        private void unlinkCancelledWaiters() {
            Node node = this.firstWaiter;
            Node node2 = null;
            while (node != null) {
                Node node3 = node.nextWaiter;
                if (node.waitStatus != -2) {
                    node.nextWaiter = null;
                    if (node2 == null) {
                        this.firstWaiter = node3;
                    } else {
                        node2.nextWaiter = node3;
                    }
                    if (node3 == null) {
                        this.lastWaiter = node2;
                    }
                } else {
                    node2 = node;
                }
                node = node3;
            }
        }

        @Override
        public final void signal() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            if (node != null) {
                this.doSignal(node);
            }
        }

        @Override
        public final void signalAll() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            if (node != null) {
                this.doSignalAll(node);
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            Node node = this.addConditionWaiter();
            int n = AbstractQueuedSynchronizer.this.fullyRelease(node);
            boolean bl = false;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                LockSupport.park(this);
                if (!Thread.interrupted()) continue;
                bl = true;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n) || bl) {
                AbstractQueuedSynchronizer.selfInterrupt();
            }
        }

        private int checkInterruptWhileWaiting(Node node) {
            return Thread.interrupted() ? (AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node) ? -1 : 1) : 0;
        }

        private void reportInterruptAfterWait(int n) throws InterruptedException {
            if (n == -1) {
                throw new InterruptedException();
            }
            if (n == 1) {
                AbstractQueuedSynchronizer.selfInterrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            int n = AbstractQueuedSynchronizer.this.fullyRelease(node);
            int n2 = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                LockSupport.park(this);
                n2 = this.checkInterruptWhileWaiting(node);
                if (n2 == 0) continue;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n) && n2 != -1) {
                n2 = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n2 != 0) {
                this.reportInterruptAfterWait(n2);
            }
        }

        @Override
        public final long awaitNanos(long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            int n = AbstractQueuedSynchronizer.this.fullyRelease(node);
            long l2 = System.nanoTime();
            int n2 = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                if (l <= 0L) {
                    AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkNanos(this, l);
                n2 = this.checkInterruptWhileWaiting(node);
                if (n2 != 0) break;
                long l3 = System.nanoTime();
                l -= l3 - l2;
                l2 = l3;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n) && n2 != -1) {
                n2 = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n2 != 0) {
                this.reportInterruptAfterWait(n2);
            }
            return l - (System.nanoTime() - l2);
        }

        @Override
        public final boolean awaitUntil(Date date) throws InterruptedException {
            if (date == null) {
                throw new NullPointerException();
            }
            long l = date.getTime();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            int n = AbstractQueuedSynchronizer.this.fullyRelease(node);
            boolean bl = false;
            int n2 = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                if (System.currentTimeMillis() > l) {
                    bl = AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkUntil(this, l);
                n2 = this.checkInterruptWhileWaiting(node);
                if (n2 == 0) continue;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n) && n2 != -1) {
                n2 = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n2 != 0) {
                this.reportInterruptAfterWait(n2);
            }
            return !bl;
        }

        @Override
        public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            if (timeUnit == null) {
                throw new NullPointerException();
            }
            long l2 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            int n = AbstractQueuedSynchronizer.this.fullyRelease(node);
            long l3 = System.nanoTime();
            boolean bl = false;
            int n2 = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                if (l2 <= 0L) {
                    bl = AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkNanos(this, l2);
                n2 = this.checkInterruptWhileWaiting(node);
                if (n2 != 0) break;
                long l4 = System.nanoTime();
                l2 -= l4 - l3;
                l3 = l4;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n) && n2 != -1) {
                n2 = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n2 != 0) {
                this.reportInterruptAfterWait(n2);
            }
            return !bl;
        }

        final boolean isOwnedBy(AbstractQueuedSynchronizer abstractQueuedSynchronizer) {
            return abstractQueuedSynchronizer == AbstractQueuedSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            while (node != null) {
                if (node.waitStatus == -2) {
                    return true;
                }
                node = node.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n = 0;
            Node node = this.firstWaiter;
            while (node != null) {
                if (node.waitStatus == -2) {
                    ++n;
                }
                node = node.nextWaiter;
            }
            return n;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Thread> arrayList = new ArrayList<Thread>();
            Node node = this.firstWaiter;
            while (node != null) {
                Thread thread;
                if (node.waitStatus == -2 && (thread = node.thread) != null) {
                    arrayList.add(thread);
                }
                node = node.nextWaiter;
            }
            return arrayList;
        }
    }

    static final class Node {
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final int PROPAGATE = -3;
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node node = this.prev;
            if (node == null) {
                throw new NullPointerException();
            }
            return node;
        }

        Node() {
        }

        Node(Thread thread, Node node) {
            this.nextWaiter = node;
            this.thread = thread;
        }

        Node(Thread thread, int n) {
            this.waitStatus = n;
            this.thread = thread;
        }
    }
}

