/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.ws.pseudosva;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.messaging.MessagingInterfaceImpl;
import com.vmware.sva.messaging.interfaces.PseudosvaInterface;
import com.vmware.sva.messaging.ws.AbstractService;
import com.vmware.sva.messaging.ws.ConverterUtil;
import com.vmware.sva.messaging.ws.model.ExceptionMsg;
import com.vmware.sva.messaging.ws.model.LoginFailed;
import com.vmware.sva.messaging.ws.model.LoginFailedMsg;
import com.vmware.sva.messaging.ws.model.NoPermission;
import com.vmware.sva.messaging.ws.model.NoPermissionMsg;
import com.vmware.sva.messaging.ws.model.PingResult;
import com.vmware.sva.messaging.ws.model.PseudoSvaServerInfo;
import com.vmware.sva.messaging.ws.model.UserSession;
import com.vmware.sva.messaging.ws.pseudosva.Exception;
import com.vmware.sva.messaging.ws.pseudosva.ExecuteResponse;
import com.vmware.sva.messaging.ws.pseudosva.LoginFailedException;
import com.vmware.sva.messaging.ws.pseudosva.NoPermissionException;
import com.vmware.sva.messaging.ws.pseudosva.PseudosvaserviceSkeletonInterface;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PseudosvaserviceSkeleton
extends AbstractService
implements PseudosvaserviceSkeletonInterface {
    private static final Log log = LogFactory.getLog(PseudosvaserviceSkeleton.class);
    public static final String UPLOAD_DIRECTORY_NAME = "upload";
    private PseudosvaInterface pseudosva;

    public PseudosvaserviceSkeleton(MessagingInterfaceImpl messaging) {
        super(messaging, messaging.getPseudosvaController());
    }

    public void setPseudosvaInterface(PseudosvaInterface pseudosva) {
        this.pseudosva = pseudosva;
    }

    private PseudosvaInterface getPseudosvaInterface() {
        if (this.pseudosva == null) {
            this.pseudosva = this.getMessagingInterfaceImpl().getPseudosvaInterface();
        }
        return this.pseudosva;
    }

    protected void checkUserSession() throws NoPermissionException {
        if (this.getUserSession() == null) {
            NoPermission np = new NoPermission();
            np.setMessage("Please login first.");
            NoPermissionMsg npmsg = new NoPermissionMsg();
            npmsg.setNoPermissionMsg(np);
            NoPermissionException npe = new NoPermissionException();
            npe.setFaultMessage(npmsg);
            throw npe;
        }
    }

    protected Exception convertException(java.lang.Exception e) {
        log.error("sva Exception: ", e);
        ExceptionMsg msg = new ExceptionMsg();
        com.vmware.sva.messaging.ws.model.Exception ex = new com.vmware.sva.messaging.ws.model.Exception();
        ex.setMessage(e.getMessage());
        msg.setExceptionMsg(ex);
        Exception exp = new Exception();
        exp.setFaultMessage(msg);
        return exp;
    }

    @Override
    public UserSession login(String username, String password) throws LoginFailedException {
        try {
            this.pseudosva.authenticate(username, password);
            if (log.isInfoEnabled()) {
                log.info("SVA : login : username=" + username);
            }
        }
        catch (java.lang.Exception e) {
            log.error("SVA login failed: ", e);
            LoginFailed lf = new LoginFailed();
            lf.setMessage(e.getMessage());
            LoginFailedMsg lfmsg = new LoginFailedMsg();
            lfmsg.setLoginFailedMsg(lf);
            LoginFailedException lfe = new LoginFailedException();
            lfe.setFaultMessage(lfmsg);
            throw lfe;
        }
        UserSession user = new UserSession();
        user.setUsername(username);
        user.setSessionId(UUID.randomUUID().toString());
        this.setUserSession(user);
        return user;
    }

    @Override
    public PingResult ping() {
        if (this.getPseudosvaInterface() == null) {
            return null;
        }
        return (PingResult)ConverterUtil.convert(this.pseudosva.ping(), null);
    }

    @Override
    public PseudoSvaServerInfo getPseudoSvaServerInfo(String pseudoSvaIP) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            com.vmware.sva.common.PseudoSvaServerInfo si = this.pseudosva.getPseudoSvaServerInfo(pseudoSvaIP);
            return (PseudoSvaServerInfo)ConverterUtil.convert(si, null);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String getSvaVersion() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            if (log.isInfoEnabled()) {
                log.info("sva.getSvaVersion:");
            }
            return this.pseudosva.getSvaVersion();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void enterMaintenanceMode(boolean shutdownRMI) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            if (log.isInfoEnabled()) {
                log.info("enterMaintenanceMode");
            }
            this.pseudosva.enterMaintenanceMode(shutdownRMI);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void exitMaintenanceMode() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            if (log.isInfoEnabled()) {
                log.info("exitMaintenanceMode");
            }
            this.pseudosva.exitMaintenanceMode();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void restart() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            if (log.isInfoEnabled()) {
                log.info("restart");
            }
            this.pseudosva.restart();
        }
        catch (java.lang.Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void logout() {
        super.removeCurrentWsSession();
    }

    @Override
    public void noop(boolean validateSession) throws NoPermissionException {
        if (validateSession) {
            this.checkUserSession();
        }
    }

    @Override
    public DataHandler getDiagnosticInfo() throws Exception, NoPermissionException {
        this.checkUserSession();
        InputStream in = null;
        try {
            in = this.pseudosva.getDiagnosticInfo();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        final InputStream fin = in;
        DataHandler dh = new DataHandler(new DataSource(){

            @Override
            public String getContentType() {
                return "application/x-zip-compressed";
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return fin;
            }

            @Override
            public String getName() {
                return "";
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
        return dh;
    }

    @Override
    public String faultInsertion(String[] args) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            ArrayList<String> cArgs = new ArrayList<String>();
            for (String arg : args) {
                String cArg = (String)ConverterUtil.convert(arg, null);
                cArgs.add(cArg);
            }
            return this.pseudosva.faultInsertion(cArgs);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String listConstants() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            return this.pseudosva.listConstants();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String listDebug() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            return this.pseudosva.listDebug();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void destroyPseudoSva() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            this.pseudosva.destroyPseudoSva();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void writeToFile(String filename, DataHandler binaryData, boolean append) throws Exception, NoPermissionException {
        this.checkUserSession();
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(filename);
            fileOutputStream = new FileOutputStream(file, append);
            binaryData.writeTo(fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    log.error("Unable to close FileOutputStream", e);
                }
            }
        }
    }

    @Override
    public ExecuteResponse execute(String filename, String workDirectory, boolean async, String[] parameters, String stdinData) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            ArrayList<String> command = new ArrayList<String>(16);
            command.add(filename);
            if (parameters != null) {
                command.addAll(Arrays.asList(parameters));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            if (workDirectory != null && workDirectory.length() > 0) {
                File workDirFile = new File(workDirectory);
                if (workDirFile.exists() && workDirFile.isDirectory()) {
                    processBuilder.directory(new File(workDirectory));
                } else {
                    String errorMessage = "The specified work directory '" + workDirectory + "' does not exist.";
                    throw new Exception(errorMessage);
                }
            }
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try {
                if (stdinData != null) {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                    writer.write(stdinData);
                    writer.flush();
                    writer.close();
                }
            }
            catch (java.lang.Exception ex) {
                log.warn("Exception while writing data to the " + filename + "  process standard input.", ex);
            }
            ExecuteResponse response = new ExecuteResponse();
            StringWriter stdoutResult = new StringWriter();
            if (!async) {
                int length;
                InputStreamReader stdout = new InputStreamReader(process.getInputStream());
                char[] buffer = new char[2048];
                long maxSizeLimit = SvaConstants.getVcsExecuteMaxOutputSize();
                boolean maxSizeReached = false;
                while ((length = stdout.read(buffer)) != -1) {
                    if (maxSizeReached) continue;
                    stdoutResult.write(buffer, 0, length);
                    if ((long)stdoutResult.getBuffer().length() <= maxSizeLimit) continue;
                    maxSizeReached = true;
                }
                stdoutResult.flush();
                stdoutResult.close();
                response.setStdoutData(stdoutResult.toString());
                response.setErrorCode(process.waitFor());
            } else {
                response.setErrorCode(0);
            }
            return response;
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String getProductDirectoryName() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            File file = new File(".").getCanonicalFile();
            return file.getParent();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void deleteFile(String filename) throws Exception, NoPermissionException {
        block6: {
            this.checkUserSession();
            try {
                if (filename != null && filename.indexOf(UPLOAD_DIRECTORY_NAME) >= 0) {
                    File file = new File(filename);
                    try {
                        if (file.exists()) {
                            FileUtils.forceDelete(file);
                        }
                        break block6;
                    }
                    catch (IOException ex) {
                        log.error(ex);
                        throw new Exception(ex);
                    }
                }
                String errorMessage = "The file name must contain 'upload' substring in its name. The passed file name is " + filename;
                throw new Exception(errorMessage);
            }
            catch (java.lang.Exception e) {
                throw this.convertException(e);
            }
        }
    }

    @Override
    public void changePermissions(String filename, String permissions, boolean recursive) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            File file = new File(filename);
            if (!file.exists()) {
                String message = "A file with name " + filename + " does not exist.";
                throw new Exception(message);
            }
            this.validatePermissionString(permissions);
            this.changePermissionsInternal(file, permissions, recursive);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    private void validatePermissionString(String permissions) throws java.lang.Exception {
        boolean validationFailed = false;
        if (permissions == null || permissions.length() != 1) {
            validationFailed = true;
        } else if (permissions.charAt(0) > '7' || permissions.charAt(0) < '0') {
            validationFailed = true;
        }
        if (validationFailed) {
            String message = "The permission string must consist of one digit between 0 and 7. The requested permission string is " + permissions + ".";
            throw new java.lang.Exception(message);
        }
    }

    private void changePermissionsInternal(File file, String permissions, boolean recursive) throws Exception {
        boolean succeeded = true;
        boolean isLinux = SvaConstants.getOsName().equals("linux");
        int perm = Integer.parseInt(permissions);
        if (isLinux && (succeeded = file.setReadable(false, false))) {
            succeeded = (perm & 4) == 4 ? file.setReadable(true, false) : file.setReadable(true, true);
        }
        if (succeeded) {
            succeeded = file.setWritable(false, false);
        }
        if (succeeded) {
            succeeded = (perm & 2) == 2 ? file.setWritable(true, false) : file.setWritable(true, true);
        }
        if (succeeded && isLinux && (succeeded = file.setExecutable(false, false))) {
            succeeded = (perm & 1) == 1 ? file.setExecutable(true, false) : file.setExecutable(true, true);
        }
        if (!succeeded) {
            throw new Exception("Failed to change permissions on file '" + file.getPath() + "'");
        }
        if (file.isDirectory() && recursive) {
            File[] subFiles;
            for (File subFile : subFiles = file.listFiles()) {
                this.changePermissionsInternal(subFile, permissions, recursive);
            }
        }
    }

    @Override
    public long getAvailableSpace() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            return FileSystemUtils.freeSpaceKb(new File(".").getAbsolutePath());
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void createFile(String filename, String permissions, boolean isDirectory) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            boolean createResult;
            File file = new File(filename);
            if (file.exists()) {
                String message = "File with name " + filename + " already exists.";
                throw new Exception(message);
            }
            this.validatePermissionString(permissions);
            if (!isDirectory) {
                try {
                    createResult = file.createNewFile();
                }
                catch (IOException ex) {
                    throw new Exception(ex);
                }
            } else {
                createResult = file.mkdirs();
            }
            if (!createResult) {
                String message = "The creation of " + filename + " file has failed.";
                throw new Exception(message);
            }
            this.changePermissionsInternal(file, permissions, false);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }
}

