/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.ws.sva;

import com.vmware.sva.common.MemberSvaConfig;
import com.vmware.sva.common.NetworkInterface;
import com.vmware.sva.messaging.MessagingInterfaceImpl;
import com.vmware.sva.messaging.interfaces.SvaInterface;
import com.vmware.sva.messaging.ws.AbstractService;
import com.vmware.sva.messaging.ws.ConverterUtil;
import com.vmware.sva.messaging.ws.model.ExceptionMsg;
import com.vmware.sva.messaging.ws.model.IPv4Address;
import com.vmware.sva.messaging.ws.model.LoginFailed;
import com.vmware.sva.messaging.ws.model.LoginFailedMsg;
import com.vmware.sva.messaging.ws.model.NoPermission;
import com.vmware.sva.messaging.ws.model.NoPermissionMsg;
import com.vmware.sva.messaging.ws.model.PingResult;
import com.vmware.sva.messaging.ws.model.StorageClusterConfig;
import com.vmware.sva.messaging.ws.model.StorageEntityNetworkReconfig;
import com.vmware.sva.messaging.ws.model.SvaServerInfo;
import com.vmware.sva.messaging.ws.model.TaskRef;
import com.vmware.sva.messaging.ws.model.UserSession;
import com.vmware.sva.messaging.ws.sva.Exception;
import com.vmware.sva.messaging.ws.sva.LoginFailedException;
import com.vmware.sva.messaging.ws.sva.NoPermissionException;
import com.vmware.sva.messaging.ws.sva.SvaserviceSkeletonInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SvaserviceSkeleton
extends AbstractService
implements SvaserviceSkeletonInterface {
    private static final Log log = LogFactory.getLog(SvaserviceSkeleton.class);
    private SvaInterface sva;

    public SvaserviceSkeleton(MessagingInterfaceImpl messaging) {
        super(messaging, messaging.getSvaController());
    }

    public void setSvaInterface(SvaInterface sva) {
        this.sva = sva;
    }

    private SvaInterface getSasInterface() {
        if (this.sva == null) {
            this.sva = this.getMessagingInterfaceImpl().getSvaInterface();
        }
        return this.sva;
    }

    protected void checkUserSession() throws NoPermissionException {
        if (this.getUserSession() == null) {
            NoPermission np = new NoPermission();
            np.setMessage("Please login first.");
            NoPermissionMsg npmsg = new NoPermissionMsg();
            npmsg.setNoPermissionMsg(np);
            NoPermissionException npe = new NoPermissionException();
            npe.setFaultMessage(npmsg);
            throw npe;
        }
    }

    protected Exception convertException(java.lang.Exception e) {
        log.error("sva Exception: ", e);
        ExceptionMsg msg = new ExceptionMsg();
        com.vmware.sva.messaging.ws.model.Exception ex = new com.vmware.sva.messaging.ws.model.Exception();
        ex.setMessage(e.getMessage());
        msg.setExceptionMsg(ex);
        Exception exp = new Exception();
        exp.setFaultMessage(msg);
        return exp;
    }

    @Override
    public UserSession login(String username, String password) throws LoginFailedException {
        try {
            this.sva.authenticate(username, password);
            if (log.isInfoEnabled()) {
                log.info("SVA : login : username=" + username);
            }
        }
        catch (java.lang.Exception e) {
            log.error("SVA login failed: ", e);
            LoginFailed lf = new LoginFailed();
            lf.setMessage(e.getMessage());
            LoginFailedMsg lfmsg = new LoginFailedMsg();
            lfmsg.setLoginFailedMsg(lf);
            LoginFailedException lfe = new LoginFailedException();
            lfe.setFaultMessage(lfmsg);
            throw lfe;
        }
        UserSession user = new UserSession();
        user.setUsername(username);
        user.setSessionId(UUID.randomUUID().toString());
        this.setUserSession(user);
        return user;
    }

    @Override
    public PingResult ping() {
        if (this.getSasInterface() == null) {
            return null;
        }
        return (PingResult)ConverterUtil.convert(this.sva.ping(), null);
    }

    @Override
    public void reset(boolean force) throws Exception {
        try {
            this.sva.reset(force);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public TaskRef createStorageCluster(String taskId, StorageClusterConfig config) throws Exception, NoPermissionException {
        com.vmware.sva.common.TaskRef taskRef = null;
        this.checkUserSession();
        try {
            com.vmware.sva.common.StorageClusterConfig cfg = (com.vmware.sva.common.StorageClusterConfig)ConverterUtil.convert(config, null);
            if (log.isInfoEnabled()) {
                log.info("createStorageCluster - StorageClusterConfig:");
                NetworkInterface mgmt = cfg.getMgmtInterface();
                log.info("   mgmt address: " + mgmt.getIpAddress() + "/" + mgmt.getIpPrefix());
                if (cfg.getPseudoSvaAddress() != null) {
                    log.info("   getPseudoSvaAddress: " + cfg.getPseudoSvaAddress().getHostAddress());
                }
                List<MemberSvaConfig> members = cfg.getMembers();
                log.info("   MemberSvaConfig:");
                for (MemberSvaConfig member : members) {
                    log.info("      backend address: " + member.getBackendAddress().getHostAddress() + ", " + " mgmt address: " + member.getMgmtAddress().getHostAddress());
                }
            }
            taskRef = this.sva.createStorageCluster(UUID.fromString(taskId), cfg);
            if (log.isInfoEnabled()) {
                log.info("createStorageCluster task: " + taskRef.getTaskId());
            }
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(taskRef, null);
    }

    @Override
    public SvaServerInfo getSvaServerInfo() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            com.vmware.sva.common.SvaServerInfo si = this.sva.getSvaServerInfo();
            if (log.isInfoEnabled()) {
                log.info("getSvaServerInfo : " + si.getId());
                log.info("  gateway: " + si.getGateway());
                log.info("  ManagementInterface: " + si.getManagementInterface().getIpAddress().getHostAddress());
                log.info("  cluster Id: " + si.getStorageClusterId());
            }
            return (SvaServerInfo)ConverterUtil.convert(si, null);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String getSvaVersion() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            if (log.isInfoEnabled()) {
                log.info("sva.getSvaVersion:");
            }
            return this.sva.getSvaVersion();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void exitMaintenanceMode() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            if (log.isInfoEnabled()) {
                log.info("exitMaintenanceMode");
            }
            this.sva.exitMaintenanceMode();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void shutdownSvaServer(boolean maintenanceMode) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            if (log.isInfoEnabled()) {
                log.info("sva.shutdownSvaServer:");
            }
            this.sva.shutdownSvaServer(maintenanceMode);
        }
        catch (java.lang.Exception e) {
            log.error("sva.shutdownSvaServer failed: ", e);
            throw this.convertException(e);
        }
    }

    @Override
    public void logout() {
        super.removeCurrentWsSession();
    }

    @Override
    public void noop(boolean validateSession) throws NoPermissionException {
        if (validateSession) {
            this.checkUserSession();
        }
    }

    @Override
    public DataHandler getDiagnosticInfo(boolean includeDump) throws Exception, NoPermissionException {
        this.checkUserSession();
        InputStream in = null;
        try {
            in = this.sva.getDiagnosticInfo(includeDump);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        final InputStream fin = in;
        DataHandler dh = new DataHandler(new DataSource(){

            @Override
            public String getContentType() {
                return "application/x-zip-compressed";
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return fin;
            }

            @Override
            public String getName() {
                return "";
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
        return dh;
    }

    @Override
    public TaskRef reconfigureNetwork(com.vmware.sva.messaging.ws.model.NetworkInterface mgmtInterface, com.vmware.sva.messaging.ws.model.MemberSvaConfig[] members, StorageEntityNetworkReconfig[] storageEntities, IPv4Address pseudoSvaAddress) throws Exception, NoPermissionException {
        this.checkUserSession();
        com.vmware.sva.common.TaskRef taskRef = null;
        try {
            if (log.isInfoEnabled()) {
                log.info("reconfigureNetwork :");
                log.info("   Mgmt Address: " + mgmtInterface.getIpAddress().getIPAddress() + "/" + mgmtInterface.getIpPrefix());
                log.info("   Pseudo Sva Address: " + (pseudoSvaAddress != null ? pseudoSvaAddress.getIPAddress() : "<none>"));
                for (com.vmware.sva.messaging.ws.model.MemberSvaConfig member : members) {
                    log.info("   Member:");
                    log.info("      mgmt address: " + member.getMgmtAddress().getIPAddress());
                    log.info("      backend interface: " + member.getBackendInterface().getIpAddress().getIPAddress() + "/" + member.getBackendInterface().getIpPrefix());
                }
            }
            NetworkInterface cMgmtInterface = (NetworkInterface)ConverterUtil.convert(mgmtInterface, null);
            ArrayList<MemberSvaConfig> cMembers = new ArrayList<MemberSvaConfig>();
            for (com.vmware.sva.messaging.ws.model.MemberSvaConfig m : members) {
                MemberSvaConfig cm = (MemberSvaConfig)ConverterUtil.convert(m, null);
                cMembers.add(cm);
            }
            ArrayList<com.vmware.sva.common.StorageEntityNetworkReconfig> cStorageEntities = new ArrayList<com.vmware.sva.common.StorageEntityNetworkReconfig>();
            for (StorageEntityNetworkReconfig senr : storageEntities) {
                com.vmware.sva.common.StorageEntityNetworkReconfig cStorageEntity = (com.vmware.sva.common.StorageEntityNetworkReconfig)ConverterUtil.convert(senr, com.vmware.sva.common.StorageEntityNetworkReconfig.class);
                cStorageEntities.add(cStorageEntity);
            }
            InetAddress cPseudoSvaAddress = (InetAddress)ConverterUtil.convert(pseudoSvaAddress, null);
            taskRef = this.sva.reconfigureNetwork(cMgmtInterface, cPseudoSvaAddress, cMembers, cStorageEntities);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        TaskRef retTaskRef = (TaskRef)ConverterUtil.convert(taskRef, null);
        log.info("taskRef = " + (taskRef != null ? taskRef.getTaskId() : "null"));
        log.info("retTaskRef = " + (retTaskRef != null ? retTaskRef.getTaskId() : "null"));
        return retTaskRef;
    }

    @Override
    public String faultInsertion(String[] args) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            ArrayList<String> cArgs = new ArrayList<String>();
            for (String arg : args) {
                String cArg = (String)ConverterUtil.convert(arg, null);
                cArgs.add(cArg);
            }
            return this.sva.faultInsertion(cArgs);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String listConstants() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            return this.sva.listConstants();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String listDebug() throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            return this.sva.listDebug();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }
}

