/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.webservice;

import com.vmware.sva.messaging.jms.test.EasySSLProtocolSocketFactory;
import com.vmware.sva.webservice.PseudosvaWebServiceInterfaceImpl;
import com.vmware.sva.webservice.SasWebServiceInterfaceImpl;
import com.vmware.sva.webservice.SvaWebServiceInterfaceImpl;
import com.vmware.sva.webservice.interfaces.PseudosvaWebServiceInterface;
import com.vmware.sva.webservice.interfaces.SasWebServiceInterface;
import com.vmware.sva.webservice.interfaces.SvaWebServiceInterface;
import com.vmware.sva.webservice.interfaces.WebServiceInterface;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;

public class WebServiceInterfaceFactory {
    private static final long sizeThreshold = 100000L;
    private static SvaWebServiceInterface svaWSInterface = null;
    private static SasWebServiceInterface sasWSInterface = null;
    private static PseudosvaWebServiceInterface psvaWSInterface = null;

    public static WebServiceInterface getWSInterface(String type) throws Exception {
        if ("sva".equalsIgnoreCase(type)) {
            svaWSInterface = new SvaWebServiceInterfaceImpl();
            return svaWSInterface;
        }
        if ("sas".equalsIgnoreCase(type)) {
            if (sasWSInterface == null) {
                sasWSInterface = new SasWebServiceInterfaceImpl();
            }
            return sasWSInterface;
        }
        if ("pseudosva".equalsIgnoreCase(type)) {
            if (psvaWSInterface == null) {
                psvaWSInterface = new PseudosvaWebServiceInterfaceImpl();
            }
            return psvaWSInterface;
        }
        return null;
    }

    public static void updateStub(Stub stub, Integer socketTimeout, String port) {
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        if (params == null) {
            params = new HttpConnectionManagerParams();
            httpConnectionManager.setParams(params);
        }
        params.setMaxTotalConnections(100);
        params.setDefaultMaxConnectionsPerHost(20);
        HttpClient httpClient = new HttpClient(httpConnectionManager);
        ServiceClient serviceClient = stub._getServiceClient();
        Options opts = serviceClient.getOptions();
        opts.setManageSession(true);
        ConfigurationContext context = serviceClient.getServiceContext().getConfigurationContext();
        context.setProperty("CACHED_HTTP_CLIENT", httpClient);
        if (socketTimeout > 0) {
            context.setProperty("Cookie", "");
            context.setProperty("SO_TIMEOUT", socketTimeout);
            opts.setProperty("enableMTOM", "true");
            opts.setProperty("cacheAttachments", "true");
            opts.setProperty("attachmentDIR", ".");
            opts.setProperty("sizeThreshold", Long.toString(100000L));
        }
        if (serviceClient.getOptions().getTo().toString().contains("https")) {
            EasySSLProtocolSocketFactory sslFactory = new EasySSLProtocolSocketFactory();
            Protocol myhttps = new Protocol("https", sslFactory, (int)Integer.valueOf(port));
            opts.setProperty("CUSTOM_PROTOCOL_HANDLER", myhttps);
        }
    }
}

