/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.control.wka;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.control.wka.JoinGroupCommand;
import org.apache.axis2.clustering.control.wka.MemberJoinedCommand;
import org.apache.axis2.clustering.control.wka.MemberListCommand;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.clustering.tribes.WkaBasedMembershipScheme;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcMembershipRequestHandler
implements RpcCallback {
    private static Log log = LogFactory.getLog(RpcMembershipRequestHandler.class);
    private MembershipManager membershipManager;
    private WkaBasedMembershipScheme membershipScheme;

    public RpcMembershipRequestHandler(MembershipManager membershipManager, WkaBasedMembershipScheme membershipScheme) {
        this.membershipManager = membershipManager;
        this.membershipScheme = membershipScheme;
    }

    public Serializable replyRequest(Serializable msg, Member sender) {
        String domain = new String(sender.getDomain());
        if (log.isDebugEnabled()) {
            log.debug("Membership request received by RpcMembershipRequestHandler for domain " + domain);
            log.debug("local domain: " + new String(this.membershipManager.getDomain()));
        }
        if (msg instanceof JoinGroupCommand) {
            log.info("Received JOIN message from " + TribesUtil.getName(sender));
            this.membershipManager.memberAdded(sender);
            this.membershipScheme.processJoin(sender);
            MemberListCommand memListCmd = new MemberListCommand();
            memListCmd.setMembers(this.membershipManager.getMembers());
            if (log.isDebugEnabled()) {
                log.debug("Sent MEMBER_LIST to " + TribesUtil.getName(sender));
            }
            return memListCmd;
        }
        if (msg instanceof MemberJoinedCommand) {
            log.info("Received MEMBER_JOINED message from " + TribesUtil.getName(sender));
            MemberJoinedCommand command = (MemberJoinedCommand)msg;
            if (log.isDebugEnabled()) {
                log.debug(command);
            }
            try {
                command.setMembershipManager(this.membershipManager);
                command.execute(null);
            }
            catch (ClusteringFault e) {
                String errMsg = "Cannot handle MEMBER_JOINED notification";
                log.error(errMsg, e);
                throw new RemoteProcessException(errMsg, (Throwable)e);
            }
        } else if (msg instanceof MemberListCommand) {
            try {
                log.info("Received MEMBER_LIST message from " + TribesUtil.getName(sender));
                MemberListCommand command = (MemberListCommand)msg;
                command.setMembershipManager(this.membershipManager);
                command.execute(null);
                return "Processed MEMBER_LIST message";
            }
            catch (ClusteringFault e) {
                String errMsg = "Cannot handle MEMBER_LIST message from " + TribesUtil.getName(sender);
                log.error(errMsg, e);
                throw new RemoteProcessException(errMsg, (Throwable)e);
            }
        }
        return null;
    }

    public void leftOver(Serializable msg, Member member) {
    }
}

