/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.corba.deployer.CorbaConstants;
import org.apache.axis2.corba.exceptions.SchemaGeneratorException;
import org.apache.axis2.corba.idl.types.AbstractCollectionType;
import org.apache.axis2.corba.idl.types.ArrayType;
import org.apache.axis2.corba.idl.types.CompositeDataType;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.EnumType;
import org.apache.axis2.corba.idl.types.ExceptionType;
import org.apache.axis2.corba.idl.types.IDL;
import org.apache.axis2.corba.idl.types.Interface;
import org.apache.axis2.corba.idl.types.Member;
import org.apache.axis2.corba.idl.types.Operation;
import org.apache.axis2.corba.idl.types.PrimitiveDataType;
import org.apache.axis2.corba.idl.types.Typedef;
import org.apache.axis2.corba.idl.types.UnionType;
import org.apache.axis2.corba.receivers.CorbaUtil;
import org.apache.axis2.description.java2wsdl.DefaultNamespaceGenerator;
import org.apache.axis2.description.java2wsdl.NamespaceGenerator;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.utils.NamespaceMap;

public class SchemaGenerator
implements CorbaConstants {
    private static int prefixCount = 1;
    protected Map targetNamespacePrefixMap = new Hashtable();
    protected Map schemaMap = new Hashtable();
    protected XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
    private IDL idl;
    private String interfaceName;
    private TypeTable typeTable = new TypeTable();
    private String schemaTargetNameSpace;
    private String schema_namespace_prefix;
    private String attrFormDefault = null;
    private String elementFormDefault = null;
    private ArrayList excludeMethods = new ArrayList();
    private ArrayList extraClasses = null;
    private boolean useWSDLTypesNamespace = false;
    private Map pkg2nsmap = null;
    private NamespaceGenerator nsGen = null;
    private String targetNamespace = null;
    private ArrayList nonRpcMethods = new ArrayList();

    public NamespaceGenerator getNsGen() throws SchemaGeneratorException {
        if (this.nsGen == null) {
            this.nsGen = new DefaultNamespaceGenerator();
        }
        return this.nsGen;
    }

    public void setNsGen(NamespaceGenerator nsGen) {
        this.nsGen = nsGen;
    }

    public SchemaGenerator(IDL idl, String interfaceName, String schematargetNamespace, String schematargetNamespacePrefix) throws Exception {
        this.idl = idl;
        this.interfaceName = interfaceName;
        StringBuffer stringBuffer = SchemaGenerator.namespaceFromModuleName(interfaceName, this.getNsGen());
        if (stringBuffer.length() == 0) {
            stringBuffer.append("http://ws.apache.org/axis2");
        }
        this.targetNamespace = stringBuffer.toString();
        if (schematargetNamespace != null && schematargetNamespace.trim().length() != 0) {
            this.schemaTargetNameSpace = schematargetNamespace;
        } else {
            stringBuffer = SchemaGenerator.namespaceFromModuleName(interfaceName, this.getNsGen());
            if (stringBuffer.length() == 0) {
                stringBuffer.append("http://ws.apache.org/axis2");
            }
            stringBuffer.append("/xsd");
            this.schemaTargetNameSpace = stringBuffer.toString();
        }
        this.schema_namespace_prefix = schematargetNamespacePrefix != null && schematargetNamespacePrefix.trim().length() != 0 ? schematargetNamespacePrefix : "ns";
    }

    private static StringBuffer namespaceFromModuleName(String interfaceName, NamespaceGenerator nsGen) throws Exception {
        int i;
        String moduleName = null;
        if (interfaceName != null && (i = interfaceName.lastIndexOf("::")) > 0) {
            moduleName = interfaceName.substring(0, i);
        }
        if (moduleName == null) {
            return new StringBuffer();
        }
        return nsGen.namespaceFromPackageName(moduleName);
    }

    public Collection generateSchema() throws SchemaGeneratorException {
        Map interfaces = this.idl.getInterfaces();
        if (interfaces == null) {
            throw new SchemaGeneratorException("No interfaces defined");
        }
        if (this.interfaceName == null) {
            throw new SchemaGeneratorException("Interface name required");
        }
        Interface intf = (Interface)interfaces.get(this.interfaceName);
        if (intf == null) {
            throw new SchemaGeneratorException("Interface " + this.interfaceName + " does not exists");
        }
        Operation[] operations = intf.getOperations();
        HashMap<String, Operation> uniqueMethods = new HashMap<String, Operation>();
        XmlSchemaSequence sequence = null;
        ArrayList<String> processedExs = new ArrayList<String>();
        block0: for (int i = 0; i < operations.length; ++i) {
            DataType returnType;
            XmlSchemaComplexType methodSchemaType;
            Operation operation = operations[i];
            String operationName = operation.getName();
            if (this.excludeMethods.contains(operationName)) continue;
            if (uniqueMethods.get(operationName) != null) {
                throw new SchemaGeneratorException(" Sorry we don't support methods overloading !!!! ");
            }
            if (operation.hasRaises()) {
                List extypes = operation.getRaises();
                for (int j = 0; j < extypes.size(); ++j) {
                    ExceptionType extype = (ExceptionType)extypes.get(j);
                    if (processedExs.contains(extype.getName())) continue;
                    processedExs.add(extype.getName());
                    methodSchemaType = this.createSchemaTypeForMethodPart(extype.getName() + "Fault");
                    sequence = new XmlSchemaSequence();
                    this.generateSchemaForType(sequence, extype, extype.getName());
                    methodSchemaType.setParticle(sequence);
                }
            }
            uniqueMethods.put(operationName, operation);
            List paras = operation.getParams();
            if (paras != null && paras.size() > 0) {
                sequence = new XmlSchemaSequence();
                methodSchemaType = this.createSchemaTypeForMethodPart(operationName);
                methodSchemaType.setParticle(sequence);
            }
            ArrayList<Member> outparas = null;
            if (paras != null) {
                for (int j = 0; j < paras.size(); ++j) {
                    Member param = (Member)paras.get(j);
                    String parameterName = param.getName();
                    DataType paraType = param.getDataType();
                    if ("inout".equals(param.getMode())) {
                        if (outparas == null) {
                            outparas = new ArrayList<Member>();
                        }
                        outparas.add(param);
                    } else if ("out".equals(param.getMode())) {
                        if (outparas == null) {
                            outparas = new ArrayList();
                        }
                        outparas.add(param);
                        continue;
                    }
                    if (this.nonRpcMethods.contains(operationName)) {
                        this.generateSchemaForType(sequence, null, operationName);
                        break;
                    }
                    this.generateSchemaForType(sequence, paraType, parameterName);
                }
            }
            if (((returnType = operation.getReturnType()) == null || CorbaUtil.getQualifiedName(returnType).equals("void")) && outparas == null) continue;
            methodSchemaType = this.createSchemaTypeForMethodPart(operationName + "Response");
            sequence = new XmlSchemaSequence();
            methodSchemaType.setParticle(sequence);
            if (returnType != null && !CorbaUtil.getQualifiedName(returnType).equals("void")) {
                String returnName = "return";
                if (this.nonRpcMethods.contains(operationName)) {
                    this.generateSchemaForType(sequence, null, returnName);
                } else {
                    this.generateSchemaForType(sequence, returnType, returnName);
                }
            }
            if (outparas == null) continue;
            for (int j = 0; j < outparas.size(); ++j) {
                Member param = (Member)outparas.get(j);
                String parameterName = param.getName();
                DataType paraType = param.getDataType();
                if (this.nonRpcMethods.contains(operationName)) {
                    this.generateSchemaForType(sequence, null, operationName);
                    continue block0;
                }
                this.generateSchemaForType(sequence, paraType, parameterName);
            }
        }
        return this.schemaMap.values();
    }

    public static String getCorrectName(String wrongName) {
        if (wrongName.length() > 1) {
            return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH) + wrongName.substring(1, wrongName.length());
        }
        return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH);
    }

    private QName generateSchema(CompositeDataType dataType) throws SchemaGeneratorException {
        String name = CorbaUtil.getQualifiedName(dataType);
        QName schemaTypeName = this.typeTable.getComplexSchemaType(name);
        if (schemaTypeName == null) {
            String simpleName = this.getSimpleName(dataType);
            String packageName = this.getModuleName(dataType);
            String targetNameSpace = this.resolveSchemaNamespace(packageName);
            XmlSchema xmlSchema = this.getXmlSchema(targetNameSpace);
            String targetNamespacePrefix = (String)this.targetNamespacePrefixMap.get(targetNameSpace);
            schemaTypeName = new QName(targetNameSpace, simpleName, targetNamespacePrefix);
            if (dataType instanceof EnumType) {
                XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(xmlSchema);
                XmlSchemaSimpleTypeRestriction restriction = new XmlSchemaSimpleTypeRestriction();
                restriction.setBaseTypeName(this.typeTable.getSimpleSchemaTypeName("java.lang.String"));
                simpleType.setContent(restriction);
                simpleType.setName(simpleName);
                XmlSchemaObjectCollection facets = restriction.getFacets();
                EnumType enumType = (EnumType)dataType;
                List enumMembers = enumType.getEnumMembers();
                for (int i = 0; i < enumMembers.size(); ++i) {
                    facets.add(new XmlSchemaEnumerationFacet(enumMembers.get(i), false));
                }
                XmlSchemaElement eltOuter = new XmlSchemaElement();
                eltOuter.setName(simpleName);
                eltOuter.setQName(schemaTypeName);
                xmlSchema.getItems().add(eltOuter);
                xmlSchema.getElements().add(schemaTypeName, eltOuter);
                eltOuter.setSchemaTypeName(simpleType.getQName());
                xmlSchema.getItems().add(simpleType);
                xmlSchema.getSchemaTypes().add(schemaTypeName, simpleType);
                this.typeTable.addComplexSchema(name, eltOuter.getQName());
            } else if (dataType instanceof UnionType) {
                XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
                XmlSchemaChoice choice = new XmlSchemaChoice();
                XmlSchemaObjectCollection items = choice.getItems();
                UnionType unionType = (UnionType)dataType;
                Member[] members = unionType.getMembers();
                for (int i = 0; i < members.length; ++i) {
                    items.add(this.generateSchemaforFieldsandProperties(xmlSchema, members[i].getDataType(), members[i].getName(), true));
                }
                complexType.setParticle(choice);
                complexType.setName(simpleName);
                XmlSchemaElement eltOuter = new XmlSchemaElement();
                eltOuter.setName(simpleName);
                eltOuter.setQName(schemaTypeName);
                xmlSchema.getItems().add(eltOuter);
                xmlSchema.getElements().add(schemaTypeName, eltOuter);
                eltOuter.setSchemaTypeName(complexType.getQName());
                xmlSchema.getItems().add(complexType);
                xmlSchema.getSchemaTypes().add(schemaTypeName, complexType);
                this.typeTable.addComplexSchema(name, eltOuter.getQName());
            } else {
                XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
                XmlSchemaSequence sequence = new XmlSchemaSequence();
                XmlSchemaElement eltOuter = new XmlSchemaElement();
                eltOuter.setName(simpleName);
                eltOuter.setQName(schemaTypeName);
                complexType.setParticle(sequence);
                complexType.setName(simpleName);
                xmlSchema.getItems().add(eltOuter);
                xmlSchema.getElements().add(schemaTypeName, eltOuter);
                eltOuter.setSchemaTypeName(complexType.getQName());
                xmlSchema.getItems().add(complexType);
                xmlSchema.getSchemaTypes().add(schemaTypeName, complexType);
                this.typeTable.addComplexSchema(name, eltOuter.getQName());
                if (dataType instanceof Typedef) {
                    Typedef typedef = (Typedef)dataType;
                    DataType aliasType = typedef.getDataType();
                    sequence.getItems().add(this.generateSchemaforFieldsandProperties(xmlSchema, aliasType, "item", false));
                } else {
                    Member[] members = dataType.getMembers();
                    for (int i = 0; i < members.length; ++i) {
                        Member member = members[i];
                        String propertyName = member.getName();
                        DataType propertyType = member.getDataType();
                        sequence.getItems().add(this.generateSchemaforFieldsandProperties(xmlSchema, propertyType, propertyName, false));
                    }
                }
            }
        }
        return schemaTypeName;
    }

    private XmlSchemaElement generateSchemaforFieldsandProperties(XmlSchema xmlSchema, DataType type, String name, boolean forceNotNillable) throws SchemaGeneratorException {
        boolean isArryType = false;
        long maxOccurs = 0L;
        long minOccurs = 0L;
        if (type instanceof AbstractCollectionType) {
            AbstractCollectionType collectionType = (AbstractCollectionType)type;
            type = collectionType.getDataType();
            isArryType = true;
            int elementCount = collectionType.getElementCount();
            if (collectionType.isArray()) {
                minOccurs = maxOccurs = (long)elementCount;
            } else if (collectionType.isSequence()) {
                minOccurs = 0L;
                long l = maxOccurs = elementCount == 0 ? Long.MAX_VALUE : (long)elementCount;
            }
            if (type instanceof AbstractCollectionType) {
                AbstractCollectionType child = (AbstractCollectionType)type;
                Typedef typedef = new Typedef();
                typedef.setDataType(type);
                typedef.setModule(child.getElementModule());
                typedef.setName("_" + (child.getDepth() - 1) + "_" + child.getElementName());
                type = typedef;
            }
        }
        String propertyTypeName = CorbaUtil.getQualifiedName(type);
        if (isArryType && "byte".equals(propertyTypeName)) {
            propertyTypeName = "base64Binary";
        }
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(name);
        if (isArryType && !propertyTypeName.equals("base64Binary")) {
            elt1.setMaxOccurs(maxOccurs);
            elt1.setMinOccurs(minOccurs);
        }
        if (this.isNillable(type) && !forceNotNillable) {
            elt1.setNillable(true);
        }
        if (this.typeTable.isSimpleType(propertyTypeName)) {
            elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(propertyTypeName));
        } else if (type instanceof CompositeDataType) {
            this.generateSchema((CompositeDataType)type);
            elt1.setSchemaTypeName(this.typeTable.getComplexSchemaType(propertyTypeName));
            if (!((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(this.typeTable.getComplexSchemaType(propertyTypeName).getNamespaceURI())) {
                XmlSchemaImport importElement = new XmlSchemaImport();
                importElement.setNamespace(this.typeTable.getComplexSchemaType(propertyTypeName).getNamespaceURI());
                xmlSchema.getItems().add(importElement);
                ((NamespaceMap)xmlSchema.getNamespaceContext()).put(this.generatePrefix(), this.typeTable.getComplexSchemaType(propertyTypeName).getNamespaceURI());
            }
        } else {
            throw new SchemaGeneratorException("Unsupported type:" + type);
        }
        return elt1;
    }

    private boolean isNillable(DataType type) {
        PrimitiveDataType primitiveDataType;
        if (type instanceof CompositeDataType) {
            return true;
        }
        return type instanceof PrimitiveDataType && (primitiveDataType = (PrimitiveDataType)type).getTypeName().equals("java.lang.String");
    }

    private QName generateSchemaForType(XmlSchemaSequence sequence, DataType type, String partName) throws SchemaGeneratorException {
        QName schemaTypeName;
        boolean isArrayType = false;
        if (type != null) {
            isArrayType = type instanceof ArrayType;
        }
        if (isArrayType) {
            ArrayType arrayType = (ArrayType)type;
            type = arrayType.getDataType();
        }
        String classTypeName = type == null ? "java.lang.Object" : CorbaUtil.getQualifiedName(type);
        if (isArrayType && "byte".equals(classTypeName)) {
            classTypeName = "base64Binary";
            isArrayType = false;
        }
        if ("javax.activation.DataHandler".equals(classTypeName)) {
            classTypeName = "base64Binary";
        }
        if ((schemaTypeName = this.typeTable.getSimpleSchemaTypeName(classTypeName)) == null && type instanceof CompositeDataType) {
            schemaTypeName = this.generateSchema((CompositeDataType)type);
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
            String schemaNamespace = this.resolveSchemaNamespace(this.getModuleName(type));
            this.addImport(this.getXmlSchema(schemaNamespace), schemaTypeName);
        } else {
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
        }
        return schemaTypeName;
    }

    private void addContentToMethodSchemaType(XmlSchemaSequence sequence, QName schemaTypeName, String paraName, boolean isArray) {
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(paraName);
        elt1.setSchemaTypeName(schemaTypeName);
        sequence.getItems().add(elt1);
        if (isArray) {
            elt1.setMaxOccurs(Long.MAX_VALUE);
            elt1.setMinOccurs(1L);
        }
        elt1.setNillable(true);
    }

    private XmlSchemaComplexType createSchemaTypeForMethodPart(String localPartName) {
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        QName elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix);
        XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
        XmlSchemaElement globalElement = new XmlSchemaElement();
        globalElement.setSchemaType(complexType);
        globalElement.setName(localPartName);
        globalElement.setQName(elementName);
        xmlSchema.getItems().add(globalElement);
        xmlSchema.getElements().add(elementName, globalElement);
        this.typeTable.addComplexSchema(localPartName, elementName);
        return complexType;
    }

    private XmlSchema getXmlSchema(String targetNamespace) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(targetNamespace);
        if (xmlSchema == null) {
            String targetNamespacePrefix = targetNamespace.equals(this.schemaTargetNameSpace) && this.schema_namespace_prefix != null ? this.schema_namespace_prefix : this.generatePrefix();
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
            xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
            this.targetNamespacePrefixMap.put(targetNamespace, targetNamespacePrefix);
            this.schemaMap.put(targetNamespace, xmlSchema);
            NamespaceMap prefixmap = new NamespaceMap();
            prefixmap.put("xs", "http://www.w3.org/2001/XMLSchema");
            prefixmap.put(targetNamespacePrefix, targetNamespace);
            xmlSchema.setNamespaceContext(prefixmap);
        }
        return xmlSchema;
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    private String generatePrefix() {
        return "ax2" + prefixCount++;
    }

    public void setExcludeMethods(ArrayList excludeMethods) {
        if (excludeMethods == null) {
            excludeMethods = new ArrayList();
        }
        this.excludeMethods = excludeMethods;
    }

    public String getSchemaTargetNameSpace() {
        return this.schemaTargetNameSpace;
    }

    private void addImport(XmlSchema xmlSchema, QName schemaTypeName) {
        if (!((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(schemaTypeName.getNamespaceURI())) {
            XmlSchemaImport importElement = new XmlSchemaImport();
            importElement.setNamespace(schemaTypeName.getNamespaceURI());
            xmlSchema.getItems().add(importElement);
            ((NamespaceMap)xmlSchema.getNamespaceContext()).put(this.generatePrefix(), schemaTypeName.getNamespaceURI());
        }
    }

    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    private XmlSchemaForm getAttrFormDefaultSetting() {
        if ("unqualified".equals(this.getAttrFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    private XmlSchemaForm getElementFormDefaultSetting() {
        if ("unqualified".equals(this.getElementFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    public ArrayList getExtraClasses() {
        if (this.extraClasses == null) {
            this.extraClasses = new ArrayList();
        }
        return this.extraClasses;
    }

    public void setExtraClasses(ArrayList extraClasses) {
        this.extraClasses = extraClasses;
    }

    private String resolveSchemaNamespace(String packageName) throws SchemaGeneratorException {
        if (this.useWSDLTypesNamespace) {
            return (String)this.pkg2nsmap.get("all");
        }
        if (this.pkg2nsmap != null && !this.pkg2nsmap.isEmpty()) {
            if (this.pkg2nsmap.get(packageName) != null) {
                return (String)this.pkg2nsmap.get(packageName);
            }
            return this.getNsGen().schemaNamespaceFromPackageName(packageName).toString();
        }
        return this.getNsGen().schemaNamespaceFromPackageName(packageName).toString();
    }

    public boolean isUseWSDLTypesNamespace() {
        return this.useWSDLTypesNamespace;
    }

    public void setUseWSDLTypesNamespace(boolean useWSDLTypesNamespace) {
        this.useWSDLTypesNamespace = useWSDLTypesNamespace;
    }

    public Map getPkg2nsmap() {
        return this.pkg2nsmap;
    }

    public void setPkg2nsmap(Map pkg2nsmap) {
        this.pkg2nsmap = pkg2nsmap;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    protected String getSimpleName(DataType type) {
        if (type instanceof CompositeDataType) {
            CompositeDataType compositeType = (CompositeDataType)type;
            return compositeType.getName();
        }
        return CorbaUtil.getQualifiedName(type);
    }

    public void setNonRpcMethods(ArrayList nonRpcMethods) {
        if (nonRpcMethods != null) {
            this.nonRpcMethods = nonRpcMethods;
        }
    }

    private String getModuleName(DataType type) {
        if (type instanceof CompositeDataType) {
            CompositeDataType compositeType = (CompositeDataType)type;
            String module = compositeType.getModule();
            if ((module = module.replaceAll("::", ".")).endsWith(".")) {
                module = module.substring(0, module.length() - 1);
            }
            return module;
        }
        return "";
    }
}

