/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.JarFileClassLoader;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.deployment.util.ExcludeInfo;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.TempFileManager;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.description.java2wsdl.DocLitBareSchemaGenerator;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.ws.commons.schema.utils.NamespaceMap;

public class Utils {
    public static String defaultEncoding = new OutputStreamWriter(System.out).getEncoding();
    private static Log log = LogFactory.getLog(Utils.class);

    public static void addFlowHandlers(Flow flow, ClassLoader clsLoader) throws AxisFault {
        int count = flow.getHandlerCount();
        for (int j = 0; j < count; ++j) {
            HandlerDescription handlermd = flow.getHandler(j);
            final Class handlerClass = Utils.getHandlerClass(handlermd.getClassName(), clsLoader);
            try {
                Handler handler = (Handler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstantiationException, IllegalAccessException {
                        return handlerClass.newInstance();
                    }
                });
                handler.init(handlermd);
                handlermd.setHandler(handler);
                continue;
            }
            catch (PrivilegedActionException e) {
                throw AxisFault.makeFault(e);
            }
        }
    }

    public static boolean loadHandler(ClassLoader loader1, HandlerDescription desc) throws DeploymentException {
        String handlername = desc.getClassName();
        try {
            final Class handlerClass = Loader.loadClass(loader1, handlername);
            Package aPackage = (Package)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return handlerClass.getPackage();
                }
            });
            if (aPackage != null && aPackage.getName().equals("org.apache.axis2.engine")) {
                String name = handlerClass.getName();
                log.warn("Dispatcher " + name + " is now deprecated.");
                if (name.indexOf("InstanceDispatcher") != -1) {
                    log.warn("Please remove the entry for " + handlerClass.getName() + "from axis2.xml");
                } else {
                    log.warn("Please edit axis2.xml and replace with the same class in org.apache.axis2.dispatchers package");
                }
            }
            Handler handler = (Handler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstantiationException, IllegalAccessException {
                    return handlerClass.newInstance();
                }
            });
            handler.init(desc);
            desc.setHandler(handler);
        }
        catch (ClassNotFoundException e) {
            if (handlername.indexOf("jaxws") > 0) {
                log.warn("[JAXWS] - unable to load " + handlername);
                return false;
            }
            throw new DeploymentException(e);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public static URL[] getURLsForAllJars(URL url, File tmpDir) {
        IOException e2222;
        URL[] uRLArray;
        ZipInputStream zin;
        InputStream in;
        FileInputStream fin;
        block19: {
            ZipEntry entry;
            fin = null;
            in = null;
            zin = null;
            ArrayList<URL> array = new ArrayList<URL>();
            in = url.openStream();
            String fileName = url.getFile();
            int index = fileName.lastIndexOf(47);
            if (index != -1) {
                fileName = fileName.substring(index + 1);
            }
            final File f = Utils.createTempFile(fileName, in, tmpDir);
            fin = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(f);
                }
            });
            array.add(f.toURL());
            zin = new ZipInputStream(fin);
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName == null || !entryName.toLowerCase().startsWith("lib/") || !entryName.toLowerCase().endsWith(".jar")) continue;
                String suffix = entryName.substring(4);
                File f2 = Utils.createTempFile(suffix, zin, tmpDir);
                array.add(f2.toURL());
            }
            uRLArray = array.toArray(new URL[array.size()]);
            Object var14_14 = null;
            if (fin == null) break block19;
            try {
                fin.close();
            }
            catch (IOException e2222) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e2222) {
                // empty catch block
            }
        }
        if (zin != null) {
            try {
                zin.close();
            }
            catch (IOException e2222) {
                // empty catch block
            }
        }
        return uRLArray;
        catch (Exception e3) {
            try {
                throw new RuntimeException(e3);
            }
            catch (Throwable throwable) {
                block22: {
                    IOException e2222;
                    Object var14_15 = null;
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (zin == null) break block22;
                    try {
                        zin.close();
                    }
                    catch (IOException e2222) {}
                }
                throw throwable;
            }
        }
    }

    public static File createTempFile(String suffix, InputStream in, File tmpDir) throws IOException {
        int count;
        FileOutputStream out;
        File f;
        byte[] data = new byte[2048];
        final File f2 = f = TempFileManager.createTempFile("axis2", suffix);
        try {
            out = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(f2);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
        while ((count = in.read(data, 0, 2048)) != -1) {
            out.write(data, 0, count);
        }
        out.close();
        return f;
    }

    public static ClassLoader getClassLoader(ClassLoader parent, String path) throws DeploymentException {
        return Utils.getClassLoader(parent, new File(path));
    }

    public static ClassLoader getClassLoader(final ClassLoader parent, File file) throws DeploymentException {
        if (file == null) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(file.toURL());
            File libfiles = new File(file, "lib");
            if (!Utils.addFiles(urls, libfiles)) {
                libfiles = new File(file, "Lib");
                Utils.addFiles(urls, libfiles);
            }
            final URL[] urllist = new URL[urls.size()];
            for (int i = 0; i < urls.size(); ++i) {
                urllist[i] = (URL)urls.get(i);
            }
            URLClassLoader classLoader = (URLClassLoader)java.security.AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (Utils.useJarFileClassLoader()) {
                        return new JarFileClassLoader(urllist, parent);
                    }
                    return new URLClassLoader(urllist, parent);
                }
            });
            return classLoader;
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(e);
        }
    }

    private static boolean useJarFileClassLoader() {
        boolean useJarFileClassLoader = System.getProperty("org.apache.axis2.classloader.JarFileClassLoader") == null ? System.getProperty("os.name").startsWith("Windows") : Boolean.getBoolean("org.apache.axis2.classloader.JarFileClassLoader");
        return useJarFileClassLoader;
    }

    private static boolean addFiles(ArrayList urls, final File libfiles) throws MalformedURLException {
        Boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return libfiles.exists();
            }
        });
        if (exists.booleanValue()) {
            urls.add(libfiles.toURL());
            File[] jarfiles = (File[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return libfiles.listFiles();
                }
            });
            for (int i = 0; i < jarfiles.length; ++i) {
                File jarfile = jarfiles[i];
                if (!jarfile.getName().endsWith(".jar")) continue;
                urls.add(jarfile.toURL());
            }
        }
        return exists;
    }

    private static Class getHandlerClass(String className, ClassLoader loader1) throws AxisFault {
        Class handlerClass;
        try {
            handlerClass = Loader.loadClass(loader1, className);
        }
        catch (ClassNotFoundException e) {
            throw AxisFault.makeFault(e);
        }
        return handlerClass;
    }

    public static void fillAxisService(final AxisService axisService, AxisConfiguration axisConfig, ArrayList excludeOperations, ArrayList nonRpcMethods) throws Exception {
        String serviceClass;
        Parameter implInfoParam = axisService.getParameter("ServiceClass");
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        if (implInfoParam != null) {
            serviceClass = (String)implInfoParam.getValue();
        } else {
            implInfoParam = axisService.getParameter("ServiceObjectSupplier");
            if (implInfoParam != null) {
                String className = ((String)implInfoParam.getValue()).trim();
                final Class serviceObjectMaker = Loader.loadClass(serviceClassLoader, className);
                if (serviceObjectMaker.getModifiers() != 1) {
                    throw new AxisFault("Service class " + className + " must have public as access Modifier");
                }
                final Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        return serviceObjectMaker.getMethod("getServiceObject", AxisService.class);
                    }
                });
                Object obj = null;
                if (method != null) {
                    obj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws InstantiationException, IllegalAccessException, InvocationTargetException {
                            return method.invoke(serviceObjectMaker.newInstance(), axisService);
                        }
                    });
                }
                if (obj == null) {
                    log.warn("ServiceObjectSupplier implmentation Object could not be found");
                    throw new DeploymentException("ServiceClass or ServiceObjectSupplier implmentation Object could not be found");
                }
                serviceClass = obj.getClass().getName();
            } else {
                return;
            }
        }
        NamespaceMap map = new NamespaceMap();
        map.put("ns1", "http://org.apache.axis2/xsd");
        map.put("xs", "http://www.w3.org/2001/XMLSchema");
        axisService.setNamespaceMap(map);
        Parameter generateBare = axisService.getParameter("doclitBare");
        DefaultSchemaGenerator schemaGenerator = generateBare != null && "true".equals(generateBare.getValue()) ? new DocLitBareSchemaGenerator(serviceClassLoader, serviceClass.trim(), axisService.getSchemaTargetNamespace(), axisService.getSchemaTargetNamespacePrefix(), axisService) : new DefaultSchemaGenerator(serviceClassLoader, serviceClass.trim(), axisService.getSchemaTargetNamespace(), axisService.getSchemaTargetNamespacePrefix(), axisService);
        schemaGenerator.setExcludeMethods(excludeOperations);
        schemaGenerator.setNonRpcMethods(nonRpcMethods);
        if (!axisService.isElementFormDefault()) {
            schemaGenerator.setElementFormDefault("unqualified");
        }
        schemaGenerator.setPkg2nsmap(axisService.getP2nMap());
        Collection schemas = schemaGenerator.generateSchema();
        axisService.addSchema(schemas);
        axisService.setSchemaTargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
        axisService.setTypeTable(schemaGenerator.getTypeTable());
        if ("http://ws.apache.org/axis2".equals(axisService.getTargetNamespace())) {
            axisService.setTargetNamespace(schemaGenerator.getTargetNamespace());
        }
        Method[] method = schemaGenerator.getMethods();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (Method jmethod : method) {
            MessageReceiver mr;
            String opName = jmethod.getName();
            AxisOperation operation = axisService.getOperation(new QName(opName));
            if (operation == null) {
                operation = axisService.getOperation(new QName(jmethod.getName()));
            }
            if ((mr = axisService.getMessageReceiver(operation.getMessageExchangePattern())) == null) {
                mr = axisConfig.getMessageReceiver(operation.getMessageExchangePattern());
            }
            if (operation.getMessageReceiver() == null) {
                operation.setMessageReceiver(mr);
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
            if (operation.getSoapAction() != null) continue;
            operation.setSoapAction("urn:" + opName);
        }
    }

    public static AxisOperation getAxisOperationForJmethod(Method method) throws AxisFault {
        String action;
        AxisOperation operation = "void".equals(method.getReturnType().getName()) ? (method.getExceptionTypes().length > 0 ? AxisOperationFactory.getAxisOperation(11) : AxisOperationFactory.getAxisOperation(10)) : AxisOperationFactory.getAxisOperation(12);
        String opName = method.getName();
        operation.setName(new QName(opName));
        WebMethod methodAnnon = method.getAnnotation(WebMethod.class);
        if (methodAnnon != null && (action = methodAnnon.action()) != null && !"".equals(action)) {
            operation.setSoapAction(action);
        }
        return operation;
    }

    public static OMElement getParameter(String name, String value, boolean locked) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement parameter = fac.createOMElement("parameter", null);
        parameter.addAttribute("name", name, null);
        parameter.addAttribute("locked", Boolean.toString(locked), null);
        parameter.setText(value);
        return parameter;
    }

    public static void deployModuleServices(AxisModule module, ConfigurationContext configCtx) throws AxisFault {
        try {
            AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
            ArchiveReader archiveReader = new ArchiveReader();
            PhasesInfo phasesInfo = axisConfig.getPhasesInfo();
            final ClassLoader moduleClassLoader = module.getModuleClassLoader();
            ArrayList<String> services = new ArrayList<String>();
            final InputStream in = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return moduleClassLoader.getResourceAsStream("aars/aars.list");
                }
            });
            if (in != null) {
                try {
                    String string;
                    BufferedReader input = new BufferedReader((InputStreamReader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return new InputStreamReader(in);
                        }
                    }));
                    while ((string = input.readLine()) != null) {
                        String string2 = string.trim();
                        if (string2.length() <= 0 || string2.charAt(0) == '#') continue;
                        services.add(string2);
                    }
                    input.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (services.size() > 0) {
                for (Object e : services) {
                    final String servicename = (String)e;
                    if (servicename == null || "".equals(servicename)) continue;
                    InputStream fin = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return moduleClassLoader.getResourceAsStream("aars/" + servicename);
                        }
                    });
                    if (fin == null) {
                        throw new AxisFault("No service archive found : " + servicename);
                    }
                    File inputFile = Utils.createTempFile(servicename, fin, (File)axisConfig.getParameterValue("artifactsDIR"));
                    DeploymentFileData filedata = new DeploymentFileData(inputFile);
                    filedata.setClassLoader(false, moduleClassLoader, (File)axisConfig.getParameterValue("artifactsDIR"));
                    HashMap<String, AxisService> wsdlservice = archiveReader.processWSDLs(filedata);
                    if (wsdlservice != null && wsdlservice.size() > 0) {
                        for (AxisService service : wsdlservice.values()) {
                            Iterator<AxisOperation> operations = service.getOperations();
                            while (operations.hasNext()) {
                                AxisOperation axisOperation = operations.next();
                                phasesInfo.setOperationPhases(axisOperation);
                            }
                        }
                    }
                    AxisServiceGroup serviceGroup = new AxisServiceGroup(axisConfig);
                    serviceGroup.setServiceGroupClassLoader(filedata.getClassLoader());
                    ArrayList<AxisService> serviceList = archiveReader.processServiceGroup(filedata.getAbsolutePath(), filedata, serviceGroup, false, wsdlservice, configCtx);
                    Iterator<AxisService> i$ = serviceList.iterator();
                    while (i$.hasNext()) {
                        AxisService aServiceList;
                        AxisService axisService = aServiceList = i$.next();
                        Parameter moduleService = new Parameter();
                        moduleService.setValue("true");
                        moduleService.setName("moduleService");
                        axisService.addParameter(moduleService);
                        serviceGroup.addService(axisService);
                    }
                    axisConfig.addServiceGroup(serviceGroup);
                    fin.close();
                }
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public static String normalize(String uri) {
        int leadingSlashes;
        if ("".equals(uri)) {
            return uri;
        }
        for (leadingSlashes = 0; leadingSlashes < uri.length() && uri.charAt(leadingSlashes) == '/'; ++leadingSlashes) {
        }
        boolean isDir = uri.charAt(uri.length() - 1) == '/';
        StringTokenizer st = new StringTokenizer(uri, "/");
        LinkedList<String> clean = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("..".equals(token)) {
                if (!clean.isEmpty() && !"..".equals(clean.getLast())) {
                    clean.removeLast();
                    if (st.hasMoreTokens()) continue;
                    isDir = true;
                    continue;
                }
                clean.add("..");
                continue;
            }
            if (".".equals(token) || "".equals(token)) continue;
            clean.add(token);
        }
        StringBuffer sb = new StringBuffer();
        while (leadingSlashes-- > 0) {
            sb.append('/');
        }
        Iterator it = clean.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append('/');
        }
        if (isDir && sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    public static String getPath(String parent, String childPath) {
        String[] values;
        Stack<String> parentStack = new Stack<String>();
        Stack<String> childStack = new Stack<String>();
        if (parent != null && (values = parent.split("/")).length > 0) {
            for (String value : values) {
                parentStack.push(value);
            }
        }
        if ((values = childPath.split("/")).length > 0) {
            for (String value : values) {
                childStack.push(value);
            }
        }
        String filepath = "";
        while (!childStack.isEmpty()) {
            String value = (String)childStack.pop();
            if ("..".equals(value)) {
                parentStack.pop();
                continue;
            }
            if ("".equals(value)) continue;
            if ("".equals(filepath)) {
                filepath = value;
                continue;
            }
            filepath = value + "/" + filepath;
        }
        while (!parentStack.isEmpty()) {
            String value = (String)parentStack.pop();
            if ("".equals(value)) continue;
            filepath = value + "/" + filepath;
        }
        return filepath;
    }

    public static List findLibJars(URL url) {
        ArrayList<String> embedded_jars = new ArrayList<String>();
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(url.openStream());
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName == null || !entryName.startsWith("lib/") && !entryName.startsWith("Lib/") || !entryName.endsWith(".jar")) continue;
                embedded_jars.add(entryName);
            }
            zin.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return embedded_jars;
    }

    public static void addExcludeMethods(ArrayList excludeList) {
        excludeList.add("init");
        excludeList.add("setOperationContext");
        excludeList.add("startUp");
        excludeList.add("destroy");
        excludeList.add("shutDown");
    }

    public static DeploymentClassLoader createClassLoader(File serviceFile) throws MalformedURLException {
        ClassLoader contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return Utils.createDeploymentClassLoader(new URL[]{serviceFile.toURL()}, contextClassLoader, new ArrayList());
    }

    public static ClassLoader createClassLoader(ArrayList urls, ClassLoader serviceClassLoader, boolean extractJars, File tmpDir) {
        URL url = (URL)urls.get(0);
        if (extractJars) {
            try {
                URL[] urls1 = Utils.getURLsForAllJars(url, tmpDir);
                urls.remove(0);
                urls.addAll(0, Arrays.asList(urls1));
                URL[] urls2 = urls.toArray(new URL[urls.size()]);
                return Utils.createDeploymentClassLoader(urls2, serviceClassLoader, null);
            }
            catch (Exception e) {
                log.warn("Exception extracting jars into temporary directory : " + e.getMessage() + " : switching to alternate class loading mechanism");
                log.debug(e.getMessage(), e);
            }
        }
        List embedded_jars = Utils.findLibJars(url);
        URL[] urls2 = urls.toArray(new URL[urls.size()]);
        return Utils.createDeploymentClassLoader(urls2, serviceClassLoader, embedded_jars);
    }

    public static File toFile(URL url) throws UnsupportedEncodingException {
        String path = URLDecoder.decode(url.getPath(), defaultEncoding);
        return new File(path.replace('/', File.separatorChar).replace('|', ':'));
    }

    public static ClassLoader createClassLoader(URL[] urls, ClassLoader serviceClassLoader, boolean extractJars, File tmpDir) {
        if (extractJars) {
            try {
                URL[] urls1 = Utils.getURLsForAllJars(urls[0], tmpDir);
                return Utils.createDeploymentClassLoader(urls1, serviceClassLoader, null);
            }
            catch (Exception e) {
                log.warn("Exception extracting jars into temporary directory : " + e.getMessage() + " : switching to alternate class loading mechanism");
                log.debug(e.getMessage(), e);
            }
        }
        List embedded_jars = Utils.findLibJars(urls[0]);
        return Utils.createDeploymentClassLoader(urls, serviceClassLoader, embedded_jars);
    }

    private static DeploymentClassLoader createDeploymentClassLoader(final URL[] urls, final ClassLoader serviceClassLoader, final List embeddedJars) {
        return (DeploymentClassLoader)java.security.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new DeploymentClassLoader(urls, embeddedJars, serviceClassLoader);
            }
        });
    }

    public static void processBeanPropertyExclude(AxisService service) {
        Parameter excludeBeanProperty = service.getParameter("beanPropertyRules");
        if (excludeBeanProperty != null) {
            OMElement parameterElement = excludeBeanProperty.getParameterElement();
            Iterator bneasItr = parameterElement.getChildrenWithName(new QName("bean"));
            ExcludeInfo excludeInfo = new ExcludeInfo();
            while (bneasItr.hasNext()) {
                OMElement bean = (OMElement)bneasItr.next();
                String clazz = bean.getAttributeValue(new QName("class"));
                String excludePropertees = bean.getAttributeValue(new QName("excludeProperties"));
                String includeProperties = bean.getAttributeValue(new QName("includeProperties"));
                excludeInfo.putBeanInfo(clazz, new BeanExcludeInfo(excludePropertees, includeProperties));
            }
            service.setExcludeInfo(excludeInfo);
        }
    }

    public static String getShortFileName(String filename) {
        File file = new File(filename);
        return file.getName();
    }

    public static String getAnnotatedServiceName(Class serviceClass, WebService serviceAnnotation) {
        String serviceName = "";
        if (serviceAnnotation != null && serviceAnnotation.serviceName() != null) {
            serviceName = serviceAnnotation.serviceName();
        }
        if (serviceName.equals("")) {
            serviceName = serviceClass.getName();
            int firstChar = serviceName.lastIndexOf(46) + 1;
            if (firstChar > 0) {
                serviceName = serviceName.substring(firstChar);
            }
            serviceName = serviceName + "Service";
        }
        return serviceName;
    }

    public static void addEndpointsToService(AxisService axisService) throws AxisFault {
        String serviceName = axisService.getName();
        Iterator<String> transportInValues = null;
        if (axisService.isEnableAllTransports()) {
            AxisConfiguration axisConfiguration = axisService.getAxisConfiguration();
            if (axisConfiguration != null) {
                ArrayList<String> transports = new ArrayList<String>();
                Iterator<TransportInDescription> i$ = axisConfiguration.getTransportsIn().values().iterator();
                while (i$.hasNext()) {
                    TransportInDescription o;
                    TransportInDescription transportInDescription = o = i$.next();
                    transports.add(transportInDescription.getName());
                }
                transportInValues = transports.iterator();
            }
        } else {
            transportInValues = axisService.getExposedTransports().iterator();
        }
        HashMap bindingCache = new HashMap();
        if (transportInValues != null) {
            while (transportInValues.hasNext()) {
                String transportName = transportInValues.next();
                String protocol = transportName.substring(0, 1).toUpperCase() + transportName.substring(1, transportName.length()).toLowerCase();
                String soap11EndpointName = serviceName + protocol + "Soap11Endpoint";
                AxisEndpoint httpSoap11Endpoint = new AxisEndpoint();
                httpSoap11Endpoint.setName(soap11EndpointName);
                httpSoap11Endpoint.setParent(axisService);
                httpSoap11Endpoint.setTransportInDescription(transportName);
                Utils.populateSoap11Endpoint(axisService, httpSoap11Endpoint, bindingCache);
                axisService.addEndpoint(httpSoap11Endpoint.getName(), httpSoap11Endpoint);
                axisService.setEndpointName(soap11EndpointName);
                String soap12EndpointName = serviceName + protocol + "Soap12Endpoint";
                AxisEndpoint httpSoap12Endpoint = new AxisEndpoint();
                httpSoap12Endpoint.setName(soap12EndpointName);
                httpSoap12Endpoint.setParent(axisService);
                httpSoap12Endpoint.setTransportInDescription(transportName);
                Utils.populateSoap12Endpoint(axisService, httpSoap12Endpoint, bindingCache);
                axisService.addEndpoint(httpSoap12Endpoint.getName(), httpSoap12Endpoint);
                if (!"http".equals(transportName)) continue;
                String httpEndpointName = serviceName + protocol + "Endpoint";
                AxisEndpoint httpEndpoint = new AxisEndpoint();
                httpEndpoint.setName(httpEndpointName);
                httpEndpoint.setParent(axisService);
                httpEndpoint.setTransportInDescription(transportName);
                Utils.populateHttpEndpoint(axisService, httpEndpoint, bindingCache);
                axisService.addEndpoint(httpEndpoint.getName(), httpEndpoint);
            }
        }
    }

    public static void addEndpointsToService(AxisService axisService, AxisConfiguration axisConfiguration) throws AxisFault {
        String serviceName = axisService.getName();
        Iterator transportInValues = null;
        if (axisConfiguration != null) {
            ArrayList<String> transports = new ArrayList<String>();
            Iterator<TransportInDescription> i$ = axisConfiguration.getTransportsIn().values().iterator();
            while (i$.hasNext()) {
                TransportInDescription o;
                TransportInDescription transportInDescription = o = i$.next();
                transports.add(transportInDescription.getName());
            }
            transportInValues = transports.iterator();
        }
        HashMap bindingCache = new HashMap();
        if (transportInValues != null) {
            while (transportInValues.hasNext()) {
                String transportName = (String)transportInValues.next();
                String protocol = transportName.substring(0, 1).toUpperCase() + transportName.substring(1, transportName.length()).toLowerCase();
                boolean disableREST = false;
                Parameter disableRESTParameter = axisService.getParameter("disableREST");
                if (disableRESTParameter != null && JavaUtils.isTrueExplicitly(disableRESTParameter.getValue())) {
                    disableREST = true;
                }
                boolean disableSOAP11 = false;
                Parameter disableSOAP11Parameter = axisService.getParameter("disableSOAP11");
                if (disableSOAP11Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP11Parameter.getValue())) {
                    disableSOAP11 = true;
                }
                boolean disableSOAP12 = false;
                Parameter disableSOAP12Parameter = axisService.getParameter("disableSOAP12");
                if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP12Parameter.getValue())) {
                    disableSOAP12 = true;
                }
                if (!disableSOAP11) {
                    String soap11EndpointName = serviceName + protocol + "Soap11Endpoint";
                    AxisEndpoint httpSoap11Endpoint = new AxisEndpoint();
                    httpSoap11Endpoint.setName(soap11EndpointName);
                    httpSoap11Endpoint.setParent(axisService);
                    httpSoap11Endpoint.setTransportInDescription(transportName);
                    Utils.populateSoap11Endpoint(axisService, httpSoap11Endpoint, bindingCache);
                    axisService.addEndpoint(httpSoap11Endpoint.getName(), httpSoap11Endpoint);
                    axisService.setEndpointName(soap11EndpointName);
                }
                if (!disableSOAP12) {
                    String soap12EndpointName = serviceName + protocol + "Soap12Endpoint";
                    AxisEndpoint httpSoap12Endpoint = new AxisEndpoint();
                    httpSoap12Endpoint.setName(soap12EndpointName);
                    httpSoap12Endpoint.setParent(axisService);
                    httpSoap12Endpoint.setTransportInDescription(transportName);
                    Utils.populateSoap12Endpoint(axisService, httpSoap12Endpoint, bindingCache);
                    axisService.addEndpoint(httpSoap12Endpoint.getName(), httpSoap12Endpoint);
                }
                if (!"http".equals(transportName) && !"https".equals(transportName) || disableREST) continue;
                String httpEndpointName = serviceName + protocol + "Endpoint";
                AxisEndpoint httpEndpoint = new AxisEndpoint();
                httpEndpoint.setName(httpEndpointName);
                httpEndpoint.setParent(axisService);
                httpEndpoint.setTransportInDescription(transportName);
                Utils.populateHttpEndpoint(axisService, httpEndpoint, bindingCache);
                axisService.addEndpoint(httpEndpoint.getName(), httpEndpoint);
            }
        }
    }

    public static void addSoap11Endpoint(AxisService axisService, URL url) throws Exception {
        String protocol = url.getProtocol();
        protocol = protocol.substring(0, 1).toUpperCase() + protocol.substring(1, protocol.length()).toLowerCase();
        String serviceName = axisService.getName();
        String soap11EndpointName = serviceName + protocol + "Soap11Endpoint";
        AxisEndpoint httpSoap11Endpoint = new AxisEndpoint();
        httpSoap11Endpoint.setName(soap11EndpointName);
        httpSoap11Endpoint.setParent(axisService);
        httpSoap11Endpoint.setEndpointURL(url.toString());
        httpSoap11Endpoint.setTransportInDescription(url.getProtocol());
        Utils.populateSoap11Endpoint(axisService, httpSoap11Endpoint, null);
        axisService.addEndpoint(httpSoap11Endpoint.getName(), httpSoap11Endpoint);
        axisService.setEndpointName(soap11EndpointName);
    }

    public static void addSoap12Endpoint(AxisService axisService, URL url) throws Exception {
        String protocol = url.getProtocol();
        protocol = protocol.substring(0, 1).toUpperCase() + protocol.substring(1, protocol.length()).toLowerCase();
        String serviceName = axisService.getName();
        String soap12EndpointName = serviceName + protocol + "Soap12Endpoint";
        AxisEndpoint httpSoap12Endpoint = new AxisEndpoint();
        httpSoap12Endpoint.setName(soap12EndpointName);
        httpSoap12Endpoint.setParent(axisService);
        httpSoap12Endpoint.setEndpointURL(url.toString());
        httpSoap12Endpoint.setTransportInDescription(url.getProtocol());
        Utils.populateSoap12Endpoint(axisService, httpSoap12Endpoint, null);
        axisService.addEndpoint(httpSoap12Endpoint.getName(), httpSoap12Endpoint);
    }

    public static void addHttpEndpoint(AxisService axisService, URL url) {
        String serviceName = axisService.getName();
        String protocol = url.getProtocol();
        protocol = protocol.substring(0, 1).toUpperCase() + protocol.substring(1, protocol.length()).toLowerCase();
        String httpEndpointName = serviceName + protocol + "Endpoint";
        AxisEndpoint httpEndpoint = new AxisEndpoint();
        httpEndpoint.setName(httpEndpointName);
        httpEndpoint.setParent(axisService);
        httpEndpoint.setEndpointURL(url.toString());
        httpEndpoint.setTransportInDescription(url.getProtocol());
        Utils.populateHttpEndpoint(axisService, httpEndpoint, null);
        axisService.addEndpoint(httpEndpoint.getName(), httpEndpoint);
    }

    public static void processPolicyAttachments(Iterator attachmentElements, AxisService service) throws XMLStreamException, FactoryConfigurationError {
        HashMap attachmentsMap = new HashMap();
        while (attachmentElements.hasNext()) {
            OMElement attachmentElement = (OMElement)attachmentElements.next();
            OMElement appliesToElem = attachmentElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "AppliesTo"));
            ArrayList<PolicyComponent> policyComponents = new ArrayList<PolicyComponent>();
            Iterator policyElements = attachmentElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            while (policyElements.hasNext()) {
                Policy policy = PolicyUtil.getPolicyFromOMElement((OMElement)policyElements.next());
                policyComponents.add(policy);
            }
            Iterator policyRefElements = attachmentElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"));
            while (policyRefElements.hasNext()) {
                PolicyReference policyRef = PolicyUtil.getPolicyReferenceFromOMElement((OMElement)policyRefElements.next());
                policyComponents.add(policyRef);
            }
            Iterator policySubjects = appliesToElem.getChildrenWithName(new QName("policy-subject"));
            while (policySubjects.hasNext()) {
                OMElement policySubject = (OMElement)policySubjects.next();
                String identifier = policySubject.getAttributeValue(new QName("identifier"));
                ArrayList values = (ArrayList)attachmentsMap.get(identifier);
                if (values == null) {
                    values = new ArrayList();
                    attachmentsMap.put(identifier, values);
                }
                values.addAll(policyComponents);
            }
        }
        for (Object o : attachmentsMap.keySet()) {
            String identifier = (String)o;
            if (!identifier.startsWith("binding:soap")) continue;
            Utils.processSoapAttachments(identifier, (List)attachmentsMap.get(identifier), service);
        }
    }

    private static void populateSoap11Endpoint(AxisService axisService, AxisEndpoint axisEndpoint, HashMap bindingCache) {
        AxisBinding axisBinding;
        String serviceName = axisService.getName();
        String name = serviceName + "Soap11Binding";
        QName bindingName = new QName(name);
        AxisBinding axisBinding2 = axisBinding = bindingCache != null ? (AxisBinding)bindingCache.get(name) : null;
        if (axisBinding == null) {
            axisBinding = new AxisBinding();
            axisBinding.setName(bindingName);
            axisBinding.setType("http://schemas.xmlsoap.org/soap/http");
            axisBinding.setProperty("style", "document");
            axisBinding.setProperty("wsoap:version", "http://schemas.xmlsoap.org/soap/envelope/");
            Iterator<? extends AxisDescription> iterator = axisService.getChildren();
            while (iterator.hasNext()) {
                AxisOperation operation = (AxisOperation)iterator.next();
                AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
                axisBindingOperation.setName(operation.getName());
                axisBindingOperation.setAxisOperation(operation);
                String soapAction = operation.getSoapAction();
                if (soapAction != null) {
                    axisBindingOperation.setProperty("wsoap:action", soapAction);
                }
                axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
                Utils.populateBindingOperation(axisBinding, axisBindingOperation);
            }
            if (bindingCache != null) {
                bindingCache.put(name, axisBinding);
            }
        }
        axisBinding.setParent(axisEndpoint);
        axisEndpoint.setBinding(axisBinding);
    }

    private static void populateSoap12Endpoint(AxisService axisService, AxisEndpoint axisEndpoint, HashMap bindingCache) {
        AxisBinding axisBinding;
        String serviceName = axisService.getName();
        String name = serviceName + "Soap12Binding";
        QName bindingName = new QName(name);
        AxisBinding axisBinding2 = axisBinding = bindingCache != null ? (AxisBinding)bindingCache.get(name) : null;
        if (axisBinding == null) {
            axisBinding = new AxisBinding();
            axisBinding.setName(bindingName);
            axisBinding.setType("http://schemas.xmlsoap.org/soap/http");
            axisBinding.setProperty("style", "document");
            axisBinding.setProperty("wsoap:version", "http://www.w3.org/2003/05/soap-envelope");
            Iterator<? extends AxisDescription> iterator = axisService.getChildren();
            while (iterator.hasNext()) {
                AxisOperation operation = (AxisOperation)iterator.next();
                AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
                axisBindingOperation.setName(operation.getName());
                axisBindingOperation.setAxisOperation(operation);
                String soapAction = operation.getSoapAction();
                if (soapAction != null) {
                    axisBindingOperation.setProperty("wsoap:action", soapAction);
                }
                axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
                Utils.populateBindingOperation(axisBinding, axisBindingOperation);
            }
            if (bindingCache != null) {
                bindingCache.put(name, axisBinding);
            }
        }
        axisBinding.setParent(axisEndpoint);
        axisEndpoint.setBinding(axisBinding);
    }

    private static void populateHttpEndpoint(AxisService axisService, AxisEndpoint axisEndpoint, HashMap bindingCache) {
        AxisBinding axisBinding;
        String serviceName = axisService.getName();
        String name = serviceName + "HttpBinding";
        QName bindingName = new QName(name);
        AxisBinding axisBinding2 = axisBinding = bindingCache != null ? (AxisBinding)bindingCache.get(name) : null;
        if (axisBinding == null) {
            axisBinding = new AxisBinding();
            axisBinding.setName(bindingName);
            axisBinding.setType("http://www.w3.org/ns/wsdl/http");
            axisBinding.setProperty("whttp:method", "POST");
            Iterator<? extends AxisDescription> iterator = axisService.getChildren();
            while (iterator.hasNext()) {
                AxisOperation operation = (AxisOperation)iterator.next();
                AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
                QName operationQName = operation.getName();
                axisBindingOperation.setName(operationQName);
                axisBindingOperation.setAxisOperation(operation);
                String httpLocation = operationQName.getLocalPart();
                axisBindingOperation.setProperty("whttp:location", httpLocation);
                axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
                Utils.populateBindingOperation(axisBinding, axisBindingOperation);
            }
            if (bindingCache != null) {
                bindingCache.put(name, axisBinding);
            }
        }
        axisBinding.setParent(axisEndpoint);
        axisEndpoint.setBinding(axisBinding);
    }

    private static void populateBindingOperation(AxisBinding axisBinding, AxisBindingOperation axisBindingOperation) {
        AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
        if (WSDLUtil.isInputPresentForMEP(axisOperation.getMessageExchangePattern())) {
            AxisMessage axisInMessage = axisOperation.getMessage("In");
            AxisBindingMessage axisBindingInMessage = new AxisBindingMessage();
            axisBindingInMessage.setName(axisInMessage.getName());
            axisBindingInMessage.setDirection(axisInMessage.getDirection());
            axisBindingInMessage.setAxisMessage(axisInMessage);
            axisBindingInMessage.setParent(axisBindingOperation);
            axisBindingOperation.addChild("In", axisBindingInMessage);
        }
        if (WSDLUtil.isOutputPresentForMEP(axisOperation.getMessageExchangePattern())) {
            AxisMessage axisOutMessage = axisOperation.getMessage("Out");
            AxisBindingMessage axisBindingOutMessage = new AxisBindingMessage();
            axisBindingOutMessage.setName(axisOutMessage.getName());
            axisBindingOutMessage.setDirection(axisOutMessage.getDirection());
            axisBindingOutMessage.setAxisMessage(axisOutMessage);
            axisBindingOutMessage.setParent(axisBindingOperation);
            axisBindingOperation.addChild("Out", axisBindingOutMessage);
        }
        ArrayList<AxisMessage> faultMessagesList = axisOperation.getFaultMessages();
        Iterator<AxisMessage> i$ = faultMessagesList.iterator();
        while (i$.hasNext()) {
            AxisMessage aFaultMessagesList;
            AxisMessage axisFaultMessage = aFaultMessagesList = i$.next();
            AxisBindingMessage axisBindingFaultMessage = new AxisBindingMessage();
            axisBindingFaultMessage.setName(axisFaultMessage.getName());
            axisBindingFaultMessage.setFault(true);
            axisBindingFaultMessage.setAxisMessage(axisFaultMessage);
            axisBindingFaultMessage.setParent(axisBindingOperation);
            axisBindingOperation.addFault(axisBindingFaultMessage);
            axisBinding.addFault(axisBindingFaultMessage);
        }
        axisBindingOperation.setAxisOperation(axisOperation);
        axisBindingOperation.setParent(axisBinding);
    }

    private static void processSoapAttachments(String identifier, List policyComponents, AxisService service) {
        Map<String, AxisEndpoint> map = service.getEndpoints();
        String soapVersion = identifier.indexOf("soap12") > -1 ? "http://www.w3.org/2003/05/soap-envelope" : "http://schemas.xmlsoap.org/soap/envelope/";
        for (AxisEndpoint o : map.values()) {
            AxisEndpoint axisEndpoint = o;
            AxisBinding axisBinding = axisEndpoint.getBinding();
            String wsoap = (String)axisBinding.getProperty("wsoap:version");
            if (!soapVersion.equals(wsoap)) continue;
            String[] identifiers = identifier.split("/");
            int key = identifiers.length;
            if (key == 1) {
                axisBinding.getPolicySubject().attachPolicyComponents(policyComponents);
                break;
            }
            if (key != 2 && key != 3) break;
            String opName = identifiers[1];
            opName = opName.substring(opName.indexOf(":") + 1, opName.length());
            AxisBindingOperation bindingOperation = null;
            boolean found = false;
            Iterator<AxisBindingOperation> i = axisBinding.getChildren();
            while (i.hasNext()) {
                bindingOperation = i.next();
                if (!opName.equals(bindingOperation.getName().getLocalPart())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Invalid binding operation " + opName);
            }
            if (key == 2) {
                bindingOperation.getPolicySubject().attachPolicyComponents(policyComponents);
                break;
            }
            if ("in".equals(identifiers[2])) {
                AxisBindingMessage bindingInMessage = (AxisBindingMessage)bindingOperation.getChild("In");
                bindingInMessage.getPolicySubject().attachPolicyComponents(policyComponents);
                break;
            }
            if (!"out".equals(identifiers[2])) break;
            AxisBindingMessage bindingOutMessage = (AxisBindingMessage)bindingOperation.getChild("Out");
            bindingOutMessage.getPolicySubject().attachPolicyComponents(policyComponents);
            break;
        }
    }

    public static boolean isSoap11Binding(AxisBinding binding) {
        String v;
        String type = binding.getType();
        return ("http://schemas.xmlsoap.org/soap/http".equals(type) || "http://www.w3.org/ns/wsdl/soap".equals(type)) && "http://schemas.xmlsoap.org/soap/envelope/".equals(v = (String)binding.getProperty("wsoap:version"));
    }

    public static boolean isSoap12Binding(AxisBinding binding) {
        String v;
        String type = binding.getType();
        return ("http://schemas.xmlsoap.org/soap/http".equals(type) || "http://www.w3.org/ns/wsdl/soap".equals(type)) && "http://www.w3.org/2003/05/soap-envelope".equals(v = (String)binding.getProperty("wsoap:version"));
    }

    public static boolean isHttpBinding(AxisBinding binding) {
        String type = binding.getType();
        return "http://www.w3.org/ns/wsdl/http".equals(type);
    }

    public static AxisBinding getSoap11Binding(AxisService service) {
        for (AxisEndpoint o : service.getEndpoints().values()) {
            AxisEndpoint endpoint = o;
            AxisBinding binding = endpoint.getBinding();
            if (!Utils.isSoap11Binding(binding)) continue;
            return binding;
        }
        return null;
    }

    public static AxisBinding getSoap12Binding(AxisService service) {
        for (AxisEndpoint o : service.getEndpoints().values()) {
            AxisEndpoint endpoint = o;
            AxisBinding binding = endpoint.getBinding();
            if (!Utils.isSoap12Binding(binding)) continue;
            return binding;
        }
        return null;
    }

    public static AxisBinding getHttpBinding(AxisService service) {
        for (AxisEndpoint o : service.getEndpoints().values()) {
            AxisEndpoint endpoint = o;
            AxisBinding binding = endpoint.getBinding();
            if (!Utils.isHttpBinding(binding)) continue;
            return binding;
        }
        return null;
    }

    public static AxisBindingOperation getBindingOperation(AxisBinding binding, AxisOperation operation) {
        QName opName = operation.getName();
        Iterator<AxisBindingOperation> bindingOps = binding.getChildren();
        while (bindingOps.hasNext()) {
            AxisBindingOperation bindingOp = bindingOps.next();
            if (!opName.equals(bindingOp.getName())) continue;
            return bindingOp;
        }
        return null;
    }

    public static AxisBindingMessage getBindingMessage(AxisBindingOperation bindingOperation, AxisMessage message) {
        String msgName = message.getName();
        Iterator<? extends AxisDescription> bindingMessages = bindingOperation.getChildren();
        while (bindingMessages.hasNext()) {
            AxisBindingMessage bindingMessage = (AxisBindingMessage)bindingMessages.next();
            if (!msgName.equals(bindingMessage.getName())) continue;
            return bindingMessage;
        }
        return null;
    }
}

