/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description.java2wsdl;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.java2wsdl.DefaultNamespaceGenerator;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.description.java2wsdl.Java2WSDLUtils;
import org.apache.axis2.description.java2wsdl.NamespaceGenerator;
import org.apache.axis2.description.java2wsdl.SchemaGenerator;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.description.java2wsdl.bytecode.MethodTable;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Document;

public class DefaultSchemaGenerator
implements Java2WSDLConstants,
SchemaGenerator {
    private static final Log log = LogFactory.getLog(DefaultSchemaGenerator.class);
    public static final String NAME_SPACE_PREFIX = "ax2";
    private static int prefixCount = 1;
    protected Map targetNamespacePrefixMap = new Hashtable();
    protected Map schemaMap = new Hashtable();
    protected XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
    protected ClassLoader classLoader;
    protected String className;
    protected TypeTable typeTable = new TypeTable();
    protected Method[] methods;
    protected MethodTable methodTable;
    protected String schemaTargetNameSpace;
    protected String schema_namespace_prefix;
    protected String attrFormDefault = null;
    protected String elementFormDefault = null;
    protected ArrayList excludeMethods = new ArrayList();
    protected ArrayList extraClasses = null;
    protected boolean useWSDLTypesNamespace = false;
    protected Map pkg2nsmap = null;
    protected NamespaceGenerator nsGen = null;
    protected String targetNamespace = null;
    protected ArrayList nonRpcMethods = new ArrayList();
    protected Class serviceClass = null;
    protected AxisService service;
    protected String customSchemaLocation;
    protected String mappingFileLocation;
    protected boolean generateBaseException;
    protected boolean sortAttributes = true;
    protected boolean isGenerateWrappedArrayTypes = false;

    public NamespaceGenerator getNsGen() throws Exception {
        if (this.nsGen == null) {
            this.nsGen = new DefaultNamespaceGenerator();
        }
        return this.nsGen;
    }

    public void setNsGen(NamespaceGenerator nsGen) {
        this.nsGen = nsGen;
    }

    public DefaultSchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix, AxisService service) throws Exception {
        this.classLoader = loader;
        this.className = className;
        this.service = service;
        this.serviceClass = Class.forName(className, true, loader);
        this.methodTable = new MethodTable(this.serviceClass);
        this.targetNamespace = Java2WSDLUtils.targetNamespaceFromClassName(className, loader, this.getNsGen()).toString();
        this.schemaTargetNameSpace = schematargetNamespace != null && schematargetNamespace.trim().length() != 0 ? schematargetNamespace : Java2WSDLUtils.schemaNamespaceFromClassName(className, loader, this.getNsGen()).toString();
        this.schema_namespace_prefix = schematargetNamespacePrefix != null && schematargetNamespacePrefix.trim().length() != 0 ? schematargetNamespacePrefix : "ns";
        if (service != null) {
            Parameter generateWrappedArrayTypes;
            Parameter sortAtt = service.getParameter("SortAttributes");
            if (sortAtt != null && "false".equals(sortAtt.getValue())) {
                this.sortAttributes = false;
            }
            if ((generateWrappedArrayTypes = service.getParameter("generateWrappedArrayTypes")) != null && JavaUtils.isTrue(generateWrappedArrayTypes.getValue())) {
                this.isGenerateWrappedArrayTypes = true;
            }
        }
    }

    private void loadCustomSchemaFile() {
        if (this.customSchemaLocation != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                Document doc = documentBuilderFactory.newDocumentBuilder().parse(new File(this.customSchemaLocation));
                XmlSchema schema = this.xmlSchemaCollection.read(doc, null);
                this.schemaMap.put(schema.getTargetNamespace(), schema);
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadMappingFile() {
        block13: {
            if (this.mappingFileLocation != null) {
                String line;
                File file = new File(this.mappingFileLocation);
                BufferedReader input = null;
                input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                while ((line = input.readLine()) != null) {
                    String[] values;
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#' || (values = line.split("\\|")) == null || values.length <= 2) continue;
                    this.typeTable.addComplexSchema(values[0], new QName(values[1], values[2]));
                }
                Object var6_6 = null;
                try {
                    if (input != null) {
                        input.close();
                    }
                    break block13;
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                break block13;
                {
                    catch (IOException ex) {
                        ex.printStackTrace();
                        Object var6_7 = null;
                        try {
                            if (input != null) {
                                input.close();
                            }
                            break block13;
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
    }

    public Collection generateSchema() throws Exception {
        this.loadCustomSchemaFile();
        this.loadMappingFile();
        WebService webervice = this.serviceClass.getAnnotation(WebService.class);
        if (webervice != null) {
            String tns = webervice.targetNamespace();
            if (tns != null && !"".equals(tns)) {
                this.targetNamespace = tns;
                this.schemaTargetNameSpace = tns;
            }
            this.service.setName(Utils.getAnnotatedServiceName(this.serviceClass, webervice));
        }
        this.methods = this.processMethods(this.serviceClass.getDeclaredMethods());
        return this.schemaMap.values();
    }

    protected Method[] processMethods(Method[] declaredMethods) throws Exception {
        ArrayList<Method> list = new ArrayList<Method>();
        Arrays.sort(declaredMethods, new MathodComparator());
        LinkedHashMap<String, Method> uniqueMethods = new LinkedHashMap<String, Method>();
        XmlSchemaSequence sequence = null;
        for (int i = 0; i < declaredMethods.length; ++i) {
            XmlSchemaComplexType methodSchemaType;
            String methodName;
            Method jMethod = declaredMethods[i];
            WebMethod methodAnnon = jMethod.getAnnotation(WebMethod.class);
            if (methodAnnon != null && methodAnnon.exclude() || this.excludeMethods.contains(methodName = jMethod.getName())) continue;
            if (((HashMap)uniqueMethods).get(methodName) != null) {
                log.warn("We don't support method overloading. Ignoring [" + methodName + "]");
                continue;
            }
            if (!Modifier.isPublic(jMethod.getModifiers())) continue;
            boolean addToService = false;
            AxisOperation axisOperation = this.service.getOperation(new QName(methodName));
            if (axisOperation == null) {
                axisOperation = Utils.getAxisOperationForJmethod(jMethod);
                addToService = true;
            }
            list.add(jMethod);
            this.processException(jMethod, axisOperation);
            uniqueMethods.put(methodName, jMethod);
            Class<?>[] parameters = jMethod.getParameterTypes();
            String[] parameterNames = null;
            AxisMessage inMessage = axisOperation.getMessage("In");
            if (inMessage != null) {
                inMessage.setName(methodName + "Request");
            }
            if (parameters.length > 0) {
                parameterNames = this.methodTable.getParameterNames(methodName);
                sequence = new XmlSchemaSequence();
                methodSchemaType = this.createSchemaTypeForMethodPart(methodName);
                methodSchemaType.setParticle(sequence);
                inMessage.setElementQName(this.typeTable.getQNamefortheType(methodName));
                this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
            }
            Annotation[][] parameterAnnotation = jMethod.getParameterAnnotations();
            for (int j = 0; j < parameters.length; ++j) {
                Class<?> methodParameter = parameters[j];
                String parameterName = this.getParameterName(parameterAnnotation, j, parameterNames);
                if (this.nonRpcMethods.contains(jMethod.getName())) {
                    this.generateSchemaForType(sequence, null, jMethod.getName());
                    break;
                }
                this.generateSchemaForType(sequence, methodParameter, parameterName);
            }
            Class<?> returnType = jMethod.getReturnType();
            if (!"void".equals(jMethod.getReturnType().getName())) {
                String partQname = methodName + "Response";
                methodSchemaType = this.createSchemaTypeForMethodPart(partQname);
                sequence = new XmlSchemaSequence();
                methodSchemaType.setParticle(sequence);
                WebResult returnAnnon = jMethod.getAnnotation(WebResult.class);
                String returnName = "return";
                if (returnAnnon != null && (returnName = returnAnnon.name()) != null && !"".equals(returnName)) {
                    returnName = "return";
                }
                if (this.nonRpcMethods.contains(jMethod.getName())) {
                    this.generateSchemaForType(sequence, null, returnName);
                } else {
                    this.generateSchemaForType(sequence, returnType, returnName);
                }
                AxisMessage outMessage = axisOperation.getMessage("Out");
                outMessage.setElementQName(this.typeTable.getQNamefortheType(partQname));
                outMessage.setName(partQname);
                this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
            }
            if (!addToService) continue;
            this.service.addOperation(axisOperation);
        }
        return list.toArray(new Method[list.size()]);
    }

    protected void processException(Method jMethod, AxisOperation axisOperation) throws Exception {
        if (jMethod.getExceptionTypes().length > 0) {
            XmlSchemaSequence sequence;
            if (!this.generateBaseException) {
                if (this.typeTable.getComplexSchemaType(Exception.class.getName()) == null) {
                    sequence = new XmlSchemaSequence();
                    XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
                    QName elementName = new QName(this.schemaTargetNameSpace, "Exception", this.schema_namespace_prefix);
                    XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
                    complexType.setName("Exception");
                    xmlSchema.getItems().add(complexType);
                    xmlSchema.getElements().add(elementName, complexType);
                    this.typeTable.addComplexSchema(Exception.class.getName(), elementName);
                    QName schemaTypeName = TypeTable.ANY_TYPE;
                    this.addContentToMethodSchemaType(sequence, schemaTypeName, "Exception", false);
                    complexType.setParticle(sequence);
                }
                this.generateBaseException = true;
            }
            Class<?>[] extypes = jMethod.getExceptionTypes();
            for (int j = 0; j < extypes.length; ++j) {
                Class<?> extype = extypes[j];
                if (AxisFault.class.getName().equals(extype.getName())) continue;
                String partQname = extype.getSimpleName();
                XmlSchemaComplexType methodSchemaType = this.createSchemaTypeForFault(partQname);
                QName elementName = new QName(this.schemaTargetNameSpace, partQname, this.schema_namespace_prefix);
                sequence = new XmlSchemaSequence();
                if (Exception.class.getName().equals(extype.getName())) {
                    QName schemaTypeName = this.typeTable.getComplexSchemaType(Exception.class.getName());
                    this.addContentToMethodSchemaType(sequence, schemaTypeName, partQname, false);
                    methodSchemaType.setParticle(sequence);
                    this.typeTable.addComplexSchema(Exception.class.getPackage().getName(), methodSchemaType.getQName());
                    this.resolveSchemaNamespace(Exception.class.getPackage().getName());
                    this.addImport(this.getXmlSchema(this.schemaTargetNameSpace), schemaTypeName);
                } else {
                    this.generateSchemaForType(sequence, extype, extype.getSimpleName());
                    methodSchemaType.setParticle(sequence);
                }
                this.typeTable.addComplexSchema(partQname, elementName);
                if (AxisFault.class.getName().equals(extype.getName())) continue;
                AxisMessage faultMessage = new AxisMessage();
                faultMessage.setName(extype.getSimpleName());
                faultMessage.setElementQName(this.typeTable.getQNamefortheType(partQname));
                axisOperation.setFaultMessages(faultMessage);
            }
        }
    }

    protected QName generateSchema(Class javaType) throws Exception {
        String name = this.getClassName(javaType);
        QName schemaTypeName = this.typeTable.getComplexSchemaType(name);
        if (schemaTypeName == null) {
            String simpleName = javaType.getSimpleName();
            String packageName = this.getQualifiedName(javaType.getPackage());
            String targetNameSpace = this.resolveSchemaNamespace(packageName);
            XmlSchema xmlSchema = this.getXmlSchema(targetNameSpace);
            String targetNamespacePrefix = (String)this.targetNamespacePrefixMap.get(targetNameSpace);
            if (targetNamespacePrefix == null) {
                targetNamespacePrefix = this.generatePrefix();
                this.targetNamespacePrefixMap.put(targetNameSpace, targetNamespacePrefix);
            }
            XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            XmlSchemaComplexContentExtension complexExtension = new XmlSchemaComplexContentExtension();
            XmlSchemaElement eltOuter = new XmlSchemaElement();
            schemaTypeName = new QName(targetNameSpace, simpleName, targetNamespacePrefix);
            eltOuter.setName(simpleName);
            eltOuter.setQName(schemaTypeName);
            Class sup = javaType.getSuperclass();
            if (sup != null && "java.lang.Object".compareTo(sup.getName()) != 0 && this.getQualifiedName(sup.getPackage()).indexOf("org.apache.axis2") <= 0 && this.getQualifiedName(sup.getPackage()).indexOf("java.util") <= 0) {
                String tgtNamespacepfx;
                String tgtNamespace;
                String superClassName = sup.getName();
                String superclassname = sup.getSimpleName();
                QName qName = this.typeTable.getSimpleSchemaTypeName(superClassName);
                if (qName != null) {
                    tgtNamespace = qName.getNamespaceURI();
                    tgtNamespacepfx = qName.getPrefix();
                } else {
                    tgtNamespace = this.resolveSchemaNamespace(this.getQualifiedName(sup.getPackage()));
                    tgtNamespacepfx = (String)this.targetNamespacePrefixMap.get(tgtNamespace);
                    QName superClassQname = this.generateSchema(sup);
                    if (superClassQname != null) {
                        tgtNamespacepfx = superClassQname.getPrefix();
                        tgtNamespace = superClassQname.getNamespaceURI();
                    }
                }
                if (tgtNamespacepfx == null) {
                    tgtNamespacepfx = this.generatePrefix();
                    this.targetNamespacePrefixMap.put(tgtNamespace, tgtNamespacepfx);
                }
                if (!((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(tgtNamespace)) {
                    XmlSchemaImport importElement = new XmlSchemaImport();
                    importElement.setNamespace(tgtNamespace);
                    xmlSchema.getItems().add(importElement);
                    ((NamespaceMap)xmlSchema.getNamespaceContext()).put(this.generatePrefix(), tgtNamespace);
                }
                QName basetype = new QName(tgtNamespace, superclassname, tgtNamespacepfx);
                complexExtension.setBaseTypeName(basetype);
                complexExtension.setParticle(sequence);
                XmlSchemaComplexContent contentModel = new XmlSchemaComplexContent();
                contentModel.setContent(complexExtension);
                complexType.setContentModel(contentModel);
            } else {
                complexType.setParticle(sequence);
            }
            complexType.setName(simpleName);
            xmlSchema.getElements().add(schemaTypeName, eltOuter);
            eltOuter.setSchemaTypeName(complexType.getQName());
            xmlSchema.getItems().add(complexType);
            xmlSchema.getSchemaTypes().add(schemaTypeName, complexType);
            this.typeTable.addComplexSchema(name, eltOuter.getQName());
            this.typeTable.addComplexSchema(this.getQualifiedName(javaType.getPackage()), eltOuter.getQName());
            BeanExcludeInfo beanExcludeInfo = null;
            if (this.service.getExcludeInfo() != null) {
                beanExcludeInfo = this.service.getExcludeInfo().getBeanExcludeInfoForClass(this.getClassName(javaType));
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(javaType, javaType.getSuperclass());
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            PropertyDescriptor property = null;
            String propertyName = null;
            for (int i = 0; i < properties.length; ++i) {
                property = properties[i];
                propertyName = property.getName();
                if (property.getName().equals("class") || property.getPropertyType() == null || beanExcludeInfo != null && beanExcludeInfo.isExcludedProperty(propertyName)) continue;
                property.getPropertyType();
                this.generateSchemaforFieldsandProperties(xmlSchema, sequence, property.getPropertyType(), propertyName, property.getPropertyType().isArray());
            }
        }
        return schemaTypeName;
    }

    protected void generateSchemaforFieldsandProperties(XmlSchema xmlSchema, XmlSchemaSequence sequence, Class type, String name, boolean isArrayType) throws Exception {
        String propertyName;
        if (isArrayType) {
            propertyName = type.getComponentType().getName();
            if (type.getComponentType().isArray()) {
                Class<?> simpleType = type.getComponentType();
                String simpleTypeName = "";
                while (simpleType.isArray()) {
                    simpleTypeName = simpleTypeName + "ArrayOf";
                    simpleType = simpleType.getComponentType();
                }
                if (xmlSchema.getTypeByName(simpleTypeName = simpleTypeName + simpleType.getSimpleName()) == null) {
                    XmlSchemaComplexType xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
                    XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
                    xmlSchemaComplexType.setParticle(xmlSchemaSequence);
                    this.generateSchemaforFieldsandProperties(xmlSchema, xmlSchemaSequence, type.getComponentType(), "array", true);
                    xmlSchemaComplexType.setName(simpleTypeName);
                    xmlSchema.getItems().add(xmlSchemaComplexType);
                    xmlSchema.getSchemaTypes().add(new QName(xmlSchema.getTargetNamespace(), simpleTypeName), xmlSchemaComplexType);
                }
                if (this.isGenerateWrappedArrayTypes) {
                    XmlSchemaElement xmlSchemaElement = new XmlSchemaElement();
                    xmlSchemaElement.setName(name + "Wrapper");
                    xmlSchemaElement.setNillable(true);
                    sequence.getItems().add(xmlSchemaElement);
                    String complexTypeName = simpleTypeName + "Wrapper";
                    XmlSchemaComplexType xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
                    XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
                    xmlSchemaComplexType.setParticle(xmlSchemaSequence);
                    xmlSchemaComplexType.setName(complexTypeName);
                    xmlSchema.getItems().add(xmlSchemaComplexType);
                    xmlSchema.getSchemaTypes().add(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()), xmlSchemaComplexType);
                    this.addContentToMethodSchemaType(xmlSchemaSequence, new QName(xmlSchema.getTargetNamespace(), simpleTypeName), "array", true);
                    xmlSchemaElement.setSchemaType(xmlSchemaComplexType);
                    xmlSchemaElement.setSchemaTypeName(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()));
                } else {
                    this.addContentToMethodSchemaType(sequence, new QName(xmlSchema.getTargetNamespace(), simpleTypeName), name, true);
                }
                return;
            }
        } else {
            propertyName = type.getName();
        }
        if (isArrayType && "byte".equals(propertyName)) {
            propertyName = "base64Binary";
        }
        if (this.isDataHandler(type)) {
            propertyName = "base64Binary";
        }
        if (this.typeTable.isSimpleType(propertyName)) {
            if (this.isGenerateWrappedArrayTypes && isArrayType) {
                XmlSchemaElement xmlSchemaElement = new XmlSchemaElement();
                xmlSchemaElement.setName(name + "Wrapper");
                xmlSchemaElement.setNillable(true);
                sequence.getItems().add(xmlSchemaElement);
                String complexTypeName = this.typeTable.getSimpleSchemaTypeName(propertyName).getLocalPart() + "Wrapper";
                XmlSchemaComplexType xmlSchemaComplexType = null;
                if (xmlSchema.getTypeByName(complexTypeName) == null) {
                    xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
                    XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
                    xmlSchemaComplexType.setParticle(xmlSchemaSequence);
                    xmlSchemaComplexType.setName(complexTypeName);
                    xmlSchema.getItems().add(xmlSchemaComplexType);
                    xmlSchema.getSchemaTypes().add(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()), xmlSchemaComplexType);
                    this.addElementToSequence("array", this.typeTable.getSimpleSchemaTypeName(propertyName), xmlSchemaSequence, propertyName.equals("base64Binary"), isArrayType, type.isPrimitive());
                } else {
                    xmlSchemaComplexType = (XmlSchemaComplexType)xmlSchema.getTypeByName(complexTypeName);
                }
                xmlSchemaElement.setSchemaType(xmlSchemaComplexType);
                xmlSchemaElement.setSchemaTypeName(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()));
            } else {
                this.addElementToSequence(name, this.typeTable.getSimpleSchemaTypeName(propertyName), sequence, propertyName.equals("base64Binary"), isArrayType, type.isPrimitive());
            }
        } else {
            if (isArrayType) {
                this.generateSchema(type.getComponentType());
            } else {
                this.generateSchema(type);
            }
            if (this.isGenerateWrappedArrayTypes && isArrayType) {
                XmlSchemaElement xmlSchemaElement = new XmlSchemaElement();
                xmlSchemaElement.setName(name + "Wrapper");
                xmlSchemaElement.setNillable(true);
                sequence.getItems().add(xmlSchemaElement);
                String complexTypeName = this.typeTable.getSimpleSchemaTypeName(propertyName).getLocalPart() + "Wrapper";
                XmlSchemaComplexType xmlSchemaComplexType = null;
                if (xmlSchema.getTypeByName(complexTypeName) == null) {
                    xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
                    XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
                    xmlSchemaComplexType.setParticle(xmlSchemaSequence);
                    xmlSchemaComplexType.setName(complexTypeName);
                    xmlSchema.getItems().add(xmlSchemaComplexType);
                    xmlSchema.getSchemaTypes().add(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()), xmlSchemaComplexType);
                    this.addElementToSequence("array", this.typeTable.getSimpleSchemaTypeName(propertyName), xmlSchemaSequence, propertyName.equals("base64Binary"), isArrayType, type.isPrimitive());
                } else {
                    xmlSchemaComplexType = (XmlSchemaComplexType)xmlSchema.getTypeByName(complexTypeName);
                }
                xmlSchemaElement.setSchemaType(xmlSchemaComplexType);
                xmlSchemaElement.setSchemaTypeName(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()));
            } else {
                this.addElementToSequence(name, this.typeTable.getComplexSchemaType(propertyName), sequence, false, isArrayType, type.isPrimitive());
            }
            if (this.typeTable.getComplexSchemaType(propertyName) != null && !((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI())) {
                XmlSchemaImport importElement = new XmlSchemaImport();
                importElement.setNamespace(this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI());
                xmlSchema.getItems().add(importElement);
                ((NamespaceMap)xmlSchema.getNamespaceContext()).put(this.generatePrefix(), this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI());
            }
        }
    }

    private void addElementToSequence(String name, QName propertyQName, XmlSchemaSequence sequence, boolean isBase64Binary, boolean isArryType, boolean isPrimitive) {
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(name);
        elt1.setSchemaTypeName(propertyQName);
        sequence.getItems().add(elt1);
        if (isArryType && !isBase64Binary) {
            elt1.setMaxOccurs(Long.MAX_VALUE);
        }
        elt1.setMinOccurs(0L);
        if (!isPrimitive) {
            elt1.setNillable(true);
        }
    }

    private QName generateSchemaForType(XmlSchemaSequence sequence, Class type, String partName) throws Exception {
        QName schemaTypeName;
        boolean isArrayType = false;
        if (type != null) {
            isArrayType = type.isArray();
        }
        if (isArrayType) {
            if (type.getComponentType().isArray()) {
                Class<?> simpleType = type.getComponentType();
                String simpleTypeName = "";
                while (simpleType.isArray()) {
                    simpleTypeName = simpleTypeName + "ArrayOf";
                    simpleType = simpleType.getComponentType();
                }
                simpleTypeName = simpleTypeName + simpleType.getSimpleName();
                XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
                if (xmlSchema.getTypeByName(simpleTypeName) == null) {
                    XmlSchemaComplexType xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
                    XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
                    xmlSchemaComplexType.setParticle(xmlSchemaSequence);
                    this.generateSchemaForType(xmlSchemaSequence, type.getComponentType(), "array");
                    xmlSchemaComplexType.setName(simpleTypeName);
                    xmlSchema.getItems().add(xmlSchemaComplexType);
                    xmlSchema.getSchemaTypes().add(new QName(xmlSchema.getTargetNamespace(), simpleTypeName), xmlSchemaComplexType);
                }
                if (this.isGenerateWrappedArrayTypes) {
                    XmlSchemaElement xmlSchemaElement = new XmlSchemaElement();
                    xmlSchemaElement.setName(partName + "Wrapper");
                    xmlSchemaElement.setNillable(true);
                    sequence.getItems().add(xmlSchemaElement);
                    String complexTypeName = simpleTypeName + "Wrapper";
                    XmlSchemaComplexType xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
                    XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
                    xmlSchemaComplexType.setParticle(xmlSchemaSequence);
                    xmlSchemaComplexType.setName(complexTypeName);
                    xmlSchema.getItems().add(xmlSchemaComplexType);
                    xmlSchema.getSchemaTypes().add(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()), xmlSchemaComplexType);
                    this.addContentToMethodSchemaType(xmlSchemaSequence, new QName(xmlSchema.getTargetNamespace(), simpleTypeName), "array", true);
                    xmlSchemaElement.setSchemaType(xmlSchemaComplexType);
                    xmlSchemaElement.setSchemaTypeName(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()));
                    return new QName(xmlSchema.getTargetNamespace(), complexTypeName);
                }
                this.addContentToMethodSchemaType(sequence, new QName(xmlSchema.getTargetNamespace(), simpleTypeName), partName, true);
                return new QName(xmlSchema.getTargetNamespace(), simpleTypeName);
            }
            type = type.getComponentType();
        }
        if (AxisFault.class.getName().equals(type)) {
            return null;
        }
        String classTypeName = type == null ? "java.lang.Object" : type.getName();
        if (isArrayType && "byte".equals(classTypeName)) {
            classTypeName = "base64Binary";
            isArrayType = false;
        }
        if (this.isDataHandler(type)) {
            classTypeName = "base64Binary";
        }
        if ((schemaTypeName = this.typeTable.getSimpleSchemaTypeName(classTypeName)) == null) {
            schemaTypeName = this.generateSchema(type);
            if (this.isGenerateWrappedArrayTypes && isArrayType) {
                XmlSchemaElement xmlSchemaElement = new XmlSchemaElement();
                xmlSchemaElement.setName(partName + "Wrapper");
                xmlSchemaElement.setNillable(true);
                sequence.getItems().add(xmlSchemaElement);
                String complexTypeName = schemaTypeName.getLocalPart() + "Wrapper";
                XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
                XmlSchemaComplexType xmlSchemaComplexType = null;
                if (xmlSchema.getTypeByName(complexTypeName) == null) {
                    xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
                    XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
                    xmlSchemaComplexType.setParticle(xmlSchemaSequence);
                    xmlSchemaComplexType.setName(complexTypeName);
                    xmlSchema.getItems().add(xmlSchemaComplexType);
                    xmlSchema.getSchemaTypes().add(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()), xmlSchemaComplexType);
                    this.addContentToMethodSchemaType(xmlSchemaSequence, schemaTypeName, "array", isArrayType);
                } else {
                    xmlSchemaComplexType = (XmlSchemaComplexType)xmlSchema.getTypeByName(complexTypeName);
                }
                xmlSchemaElement.setSchemaType(xmlSchemaComplexType);
                xmlSchemaElement.setSchemaTypeName(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()));
            } else {
                this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
            }
            String schemaNamespace = this.resolveSchemaNamespace(this.getQualifiedName(type.getPackage()));
            this.addImport(this.getXmlSchema(schemaNamespace), schemaTypeName);
        } else if (this.isGenerateWrappedArrayTypes && isArrayType) {
            XmlSchemaElement xmlSchemaElement = new XmlSchemaElement();
            xmlSchemaElement.setName(partName + "Wrapper");
            xmlSchemaElement.setNillable(true);
            sequence.getItems().add(xmlSchemaElement);
            String complexTypeName = schemaTypeName.getLocalPart() + "Wrapper";
            XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
            XmlSchemaComplexType xmlSchemaComplexType = null;
            if (xmlSchema.getTypeByName(complexTypeName) == null) {
                xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
                XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
                xmlSchemaComplexType.setParticle(xmlSchemaSequence);
                xmlSchemaComplexType.setName(complexTypeName);
                xmlSchema.getItems().add(xmlSchemaComplexType);
                xmlSchema.getSchemaTypes().add(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()), xmlSchemaComplexType);
                this.addContentToMethodSchemaType(xmlSchemaSequence, schemaTypeName, "array", isArrayType);
            } else {
                xmlSchemaComplexType = (XmlSchemaComplexType)xmlSchema.getTypeByName(complexTypeName);
            }
            xmlSchemaElement.setSchemaType(xmlSchemaComplexType);
            xmlSchemaElement.setSchemaTypeName(new QName(this.schemaTargetNameSpace, xmlSchemaComplexType.getName()));
        } else {
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
        }
        this.addImport(this.getXmlSchema(this.schemaTargetNameSpace), schemaTypeName);
        return schemaTypeName;
    }

    protected boolean isDataHandler(Class clazz) {
        return clazz != null && DataHandler.class.isAssignableFrom(clazz);
    }

    protected void addContentToMethodSchemaType(XmlSchemaSequence sequence, QName schemaTypeName, String paraName, boolean isArray) {
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(paraName);
        elt1.setSchemaTypeName(schemaTypeName);
        if (sequence != null) {
            sequence.getItems().add(elt1);
        }
        if (isArray) {
            elt1.setMaxOccurs(Long.MAX_VALUE);
        }
        elt1.setMinOccurs(0L);
        if (!("int".equals(schemaTypeName.getLocalPart()) || "double".equals(schemaTypeName.getLocalPart()) || "long".equals(schemaTypeName.getLocalPart()) || "boolean".equals(schemaTypeName.getLocalPart()) || "short".equals(schemaTypeName.getLocalPart()) || "float".equals(schemaTypeName.getLocalPart()))) {
            elt1.setNillable(true);
        }
    }

    private XmlSchemaComplexType createSchemaTypeForMethodPart(String localPartName) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType complexType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix));
        if (complexType == null) {
            complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaElement globalElement = new XmlSchemaElement();
            globalElement.setSchemaType(complexType);
            globalElement.setName(localPartName);
            globalElement.setQName(elementName);
            xmlSchema.getItems().add(globalElement);
            xmlSchema.getElements().add(elementName, globalElement);
        }
        this.typeTable.addComplexSchema(localPartName, elementName);
        return complexType;
    }

    private XmlSchemaComplexType createSchemaTypeForFault(String localPartName) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType complexType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix));
        if (complexType == null) {
            complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaElement globalElement = new XmlSchemaElement();
            globalElement.setSchemaType(complexType);
            globalElement.setName(localPartName);
            globalElement.setQName(elementName);
            xmlSchema.getItems().add(globalElement);
            xmlSchema.getElements().add(elementName, globalElement);
        }
        return complexType;
    }

    protected XmlSchemaComplexType getComplexTypeForElement(XmlSchema xmlSchema, QName name) {
        Iterator iterator = xmlSchema.getItems().getIterator();
        while (iterator.hasNext()) {
            XmlSchemaObject object = (XmlSchemaObject)iterator.next();
            if (!(object instanceof XmlSchemaElement) || !((XmlSchemaElement)object).getQName().equals(name)) continue;
            return (XmlSchemaComplexType)((XmlSchemaElement)object).getSchemaType();
        }
        return null;
    }

    protected XmlSchema getXmlSchema(String targetNamespace) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(targetNamespace);
        if (xmlSchema == null) {
            String targetNamespacePrefix = targetNamespace.equals(this.schemaTargetNameSpace) && this.schema_namespace_prefix != null ? this.schema_namespace_prefix : this.generatePrefix();
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
            xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
            this.targetNamespacePrefixMap.put(targetNamespace, targetNamespacePrefix);
            this.schemaMap.put(targetNamespace, xmlSchema);
            NamespaceMap prefixmap = new NamespaceMap();
            prefixmap.put("xs", "http://www.w3.org/2001/XMLSchema");
            prefixmap.put(targetNamespacePrefix, targetNamespace);
            xmlSchema.setNamespaceContext(prefixmap);
        }
        return xmlSchema;
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    protected String generatePrefix() {
        return NAME_SPACE_PREFIX + prefixCount++;
    }

    public void setExcludeMethods(ArrayList excludeMethods) {
        if (excludeMethods == null) {
            excludeMethods = new ArrayList();
        }
        this.excludeMethods = excludeMethods;
    }

    public String getSchemaTargetNameSpace() {
        return this.schemaTargetNameSpace;
    }

    protected void addImport(XmlSchema xmlSchema, QName schemaTypeName) {
        NamespacePrefixList map = xmlSchema.getNamespaceContext();
        if (map == null || map instanceof NamespaceMap && ((NamespaceMap)map).values() == null || schemaTypeName == null) {
            return;
        }
        if (map instanceof NamespaceMap && !((NamespaceMap)map).values().contains(schemaTypeName.getNamespaceURI())) {
            XmlSchemaImport importElement = new XmlSchemaImport();
            importElement.setNamespace(schemaTypeName.getNamespaceURI());
            xmlSchema.getItems().add(importElement);
            ((NamespaceMap)xmlSchema.getNamespaceContext()).put(this.generatePrefix(), schemaTypeName.getNamespaceURI());
        }
    }

    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    protected XmlSchemaForm getAttrFormDefaultSetting() {
        if ("unqualified".equals(this.getAttrFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    protected XmlSchemaForm getElementFormDefaultSetting() {
        if ("unqualified".equals(this.getElementFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    public ArrayList getExtraClasses() {
        if (this.extraClasses == null) {
            this.extraClasses = new ArrayList();
        }
        return this.extraClasses;
    }

    public void setExtraClasses(ArrayList extraClasses) {
        this.extraClasses = extraClasses;
    }

    protected String resolveSchemaNamespace(String packageName) throws Exception {
        if (this.useWSDLTypesNamespace) {
            return (String)this.pkg2nsmap.get("all");
        }
        if (this.pkg2nsmap != null && !this.pkg2nsmap.isEmpty()) {
            if (this.pkg2nsmap.get(packageName) != null) {
                return (String)this.pkg2nsmap.get(packageName);
            }
            return this.getNsGen().schemaNamespaceFromPackageName(packageName).toString();
        }
        return this.getNsGen().schemaNamespaceFromPackageName(packageName).toString();
    }

    public boolean isUseWSDLTypesNamespace() {
        return this.useWSDLTypesNamespace;
    }

    public void setUseWSDLTypesNamespace(boolean useWSDLTypesNamespace) {
        this.useWSDLTypesNamespace = useWSDLTypesNamespace;
    }

    public Map getPkg2nsmap() {
        return this.pkg2nsmap;
    }

    public void setPkg2nsmap(Map pkg2nsmap) {
        this.pkg2nsmap = pkg2nsmap;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    protected String getClassName(Class type) {
        String name = type.getName();
        if (name.indexOf("$") > 0) {
            name = name.replace('$', '_');
        }
        return name;
    }

    protected String getQualifiedName(Package packagez) {
        if (packagez != null) {
            return packagez.getName();
        }
        return "";
    }

    public void setNonRpcMethods(ArrayList nonRpcMethods) {
        if (nonRpcMethods != null) {
            this.nonRpcMethods = nonRpcMethods;
        }
    }

    public void setAxisService(AxisService service) {
        this.service = service;
    }

    public String getCustomSchemaLocation() {
        return this.customSchemaLocation;
    }

    public void setCustomSchemaLocation(String customSchemaLocation) {
        this.customSchemaLocation = customSchemaLocation;
    }

    public String getMappingFileLocation() {
        return this.mappingFileLocation;
    }

    public void setMappingFileLocation(String mappingFileLocation) {
        this.mappingFileLocation = mappingFileLocation;
    }

    protected String getParameterName(Annotation[][] parameterAnnotation, int j, String[] parameterNames) {
        WebParam para;
        Annotation[] tempAnnon;
        String parameterName = null;
        if (parameterAnnotation.length > 0 && (tempAnnon = parameterAnnotation[j]).length > 0 && (para = (WebParam)tempAnnon[0]) != null) {
            parameterName = para.name();
        }
        if (parameterName == null || "".equals(parameterName)) {
            if (parameterNames != null && parameterNames.length > j) {
                parameterName = parameterNames[j];
            }
            if (parameterName == null || "".equals(parameterName)) {
                parameterName = "args" + j;
            }
        }
        return parameterName;
    }

    public class PropertyComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            PropertyDescriptor propertyDescriptor1 = (PropertyDescriptor)o1;
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)o2;
            Object[] values = new String[]{propertyDescriptor1.getName(), propertyDescriptor2.getName()};
            Arrays.sort(values);
            if (((String)values[0]).equals(propertyDescriptor1.getName())) {
                return 0;
            }
            return 1;
        }
    }

    public class MathodComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Method method1 = (Method)o1;
            Method method2 = (Method)o2;
            Object[] values = new String[]{method1.getName(), method2.getName()};
            Arrays.sort(values);
            if (((String)values[0]).equals(method1.getName())) {
                return 1;
            }
            return 0;
        }
    }
}

