/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerInvokerUtils {
    private static Log log = LogFactory.getLog(HandlerInvokerUtils.class);

    public static boolean invokeInboundHandlers(MEPContext mepMessageCtx, List<Handler> handlers, HandlerChainProcessor.MEP mep, boolean isOneWay) {
        if (handlers == null || handlers.isEmpty()) {
            return true;
        }
        String bindingProto = null;
        if (mep.equals((Object)HandlerChainProcessor.MEP.REQUEST)) {
            bindingProto = mepMessageCtx.getEndpointDesc().getBindingType();
        } else {
            bindingProto = mepMessageCtx.getEndpointDesc().getClientBindingID();
            ArrayList<QName> understood = new ArrayList<QName>();
            for (Handler handler : handlers) {
                Set<QName> headers;
                if (!(handler instanceof SOAPHandler)) continue;
                SOAPHandler soapHandler = (SOAPHandler)handler;
                if (log.isDebugEnabled()) {
                    log.debug("Client side: Invoking getHeader() on SOAPHandler: " + soapHandler);
                }
                if ((headers = soapHandler.getHeaders()) == null) continue;
                for (QName header : headers) {
                    if (understood.contains(header)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Adding Header QName" + header + " to uderstoodHeaderQName List");
                    }
                    understood.add(header);
                }
            }
        }
        Protocol proto = Protocol.getProtocolForBinding(bindingProto);
        HandlerChainProcessor processor = new HandlerChainProcessor(handlers, proto);
        boolean success = true;
        try {
            if (mepMessageCtx.getMessageObject().isFault()) {
                processor.processFault(mepMessageCtx, HandlerChainProcessor.Direction.IN);
            } else {
                success = processor.processChain(mepMessageCtx, HandlerChainProcessor.Direction.IN, mep, !isOneWay);
            }
        }
        catch (RuntimeException re) {
            HandlerChainProcessor.convertToFaultMessage(mepMessageCtx, re, proto);
            mepMessageCtx.setApplicationAccessLocked(true);
            return false;
        }
        if (!success && mep.equals((Object)HandlerChainProcessor.MEP.REQUEST)) {
            mepMessageCtx.setApplicationAccessLocked(true);
            return false;
        }
        mepMessageCtx.setApplicationAccessLocked(true);
        return true;
    }

    public static boolean invokeOutboundHandlers(MEPContext mepMessageCtx, List<Handler> handlers, HandlerChainProcessor.MEP mep, boolean isOneWay) {
        if (handlers == null || handlers.isEmpty()) {
            return true;
        }
        String bindingProto = null;
        bindingProto = mep.equals((Object)HandlerChainProcessor.MEP.REQUEST) ? mepMessageCtx.getEndpointDesc().getClientBindingID() : mepMessageCtx.getEndpointDesc().getBindingType();
        Protocol proto = Protocol.getProtocolForBinding(bindingProto);
        HandlerChainProcessor processor = new HandlerChainProcessor(handlers, proto);
        boolean success = true;
        try {
            if (mepMessageCtx.getMessageObject().isFault()) {
                processor.processFault(mepMessageCtx, HandlerChainProcessor.Direction.OUT);
            } else {
                success = processor.processChain(mepMessageCtx, HandlerChainProcessor.Direction.OUT, mep, !isOneWay);
            }
        }
        catch (RuntimeException re) {
            HandlerChainProcessor.convertToFaultMessage(mepMessageCtx, re, proto);
            if (mepMessageCtx.getRequestMessageContext() != null) {
                mepMessageCtx.getRequestMessageContext().setCausedByException(new AxisFault(re.getMessage(), re));
            }
            if (mepMessageCtx.getResponseMessageContext() != null) {
                mepMessageCtx.getResponseMessageContext().setCausedByException(new AxisFault(re.getMessage(), re));
            }
            return false;
        }
        return success || !mep.equals((Object)HandlerChainProcessor.MEP.REQUEST);
    }
}

