/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.datasource.jaxb.JAXBCustomBuilder;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.MessageContextListener;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.marshaller.impl.alt.UnmarshalInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnmarshalMessageContextListener
implements MessageContextListener {
    private static final Log log = LogFactory.getLog(UnmarshalMessageContextListener.class);

    public static void create(ServiceContext sc) {
        if (sc == null || sc.getAxisService() == null || sc.getAxisService().hasMessageContextListener(UnmarshalMessageContextListener.class)) {
            return;
        }
        UnmarshalMessageContextListener listener = new UnmarshalMessageContextListener();
        sc.getAxisService().addMessageContextListener(listener);
    }

    private UnmarshalMessageContextListener() {
    }

    private void installJAXBCustomBuilder(ServiceContext sc, MessageContext mc) {
        SOAPEnvelope envelope;
        if (log.isDebugEnabled()) {
            log.debug("attachEvent for sc= " + sc.getName() + "and  mc=" + mc.getLogCorrelationID());
        }
        if ((envelope = mc.getEnvelope()) == null) {
            return;
        }
        if (!(envelope.getBuilder() instanceof StAXOMBuilder)) {
            return;
        }
        AxisOperation axisOp = mc.getAxisOperation();
        if (axisOp == null) {
            return;
        }
        Parameter parameterInfo = axisOp.getParameter("org.apache.axis2.jaxws.marshaller.impl.alt.UnmarshalInfo");
        if (parameterInfo == null) {
            return;
        }
        UnmarshalInfo info = (UnmarshalInfo)parameterInfo.getValue();
        if (info == null) {
            return;
        }
        JAXBDSContext jaxbDSC = new JAXBDSContext(info.getPackages(), info.getPackagesKey());
        jaxbDSC.setMessageContext(mc);
        JAXBCustomBuilder jcb = new JAXBCustomBuilder(jaxbDSC);
        ((StAXOMBuilder)envelope.getBuilder()).registerCustomBuilderForPayload(jcb);
        if (log.isDebugEnabled()) {
            log.debug("Registering JAXBCustomBuilder: " + jcb + " for AxisOperation: " + axisOp.getName());
        }
    }

    public void attachEnvelopeEvent(MessageContext mc) {
        if (mc.getServiceContext() != null) {
            this.installJAXBCustomBuilder(mc.getServiceContext(), mc);
        }
    }

    public void attachServiceContextEvent(ServiceContext sc, MessageContext mc) {
        if (mc.getEnvelope() != null) {
            this.installJAXBCustomBuilder(sc, mc);
        }
    }
}

