/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrettyPrinter {
    private static final Log log = LogFactory.getLog(PrettyPrinter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prettify(File file) {
        String property = System.getProperty("axis2.jalopy");
        if (property == null) return;
        if (!JavaUtils.isTrueExplicitly(property)) {
            return;
        }
        PrintStream backupOutputStream = System.out;
        PrintStream backupErrorStream = System.err;
        System.setOut(new PrintStream(new ByteArrayOutputStream()));
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
        try {
            try {
                Class clazzConfigurator = Loader.loadClass("org.apache.log4j.PropertyConfigurator");
                Method configure = clazzConfigurator.getMethod("configure", Properties.class);
                Properties properties = new Properties();
                properties.setProperty("log4j.logger.de.hunsicker.jalopy.io", System.getProperty("log4j.logger.de.hunsicker.jalopy.io", "FATAL"));
                configure.invoke(null, properties);
                Class clazz = Loader.loadClass("de.hunsicker.jalopy.Jalopy");
                Object prettifier = clazz.newInstance();
                Method input = clazz.getMethod("setInput", File.class);
                input.invoke(prettifier, file);
                Method output = clazz.getMethod("setOutput", File.class);
                output.invoke(prettifier, file);
                Class clazz2 = Loader.loadClass("de.hunsicker.jalopy.storage.Convention");
                Method instance = clazz2.getMethod("getInstance", new Class[0]);
                Object settings = instance.invoke(null, new Object[0]);
                Class clazz3 = Loader.loadClass("de.hunsicker.jalopy.storage.ConventionKeys");
                Field field = clazz3.getField("COMMENT_FORMAT_MULTI_LINE");
                Object key = field.get(null);
                Method put = clazz2.getMethod("put", key.getClass(), String.class);
                put.invoke(settings, key, "true");
                Method format = clazz.getMethod("format", new Class[0]);
                format.invoke(prettifier, new Object[0]);
                log.debug("Pretty printed file : " + file);
            }
            catch (ClassNotFoundException e) {
                log.debug("Jalopy/Log4j not found - unable to pretty print " + file);
                Object var20_23 = null;
                System.setOut(backupOutputStream);
                System.setErr(backupErrorStream);
                return;
            }
            catch (Exception e) {
                log.warn("Exception occurred while trying to pretty print file " + file, e);
                Object var20_24 = null;
                System.setOut(backupOutputStream);
                System.setErr(backupErrorStream);
                return;
            }
            catch (Throwable t) {
                log.debug("Exception occurred while trying to pretty print file " + file, t);
                Object var20_25 = null;
                System.setOut(backupOutputStream);
                System.setErr(backupErrorStream);
                return;
            }
            Object var20_22 = null;
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            System.setOut(backupOutputStream);
            System.setErr(backupErrorStream);
            throw throwable;
        }
        System.setOut(backupOutputStream);
        System.setErr(backupErrorStream);
    }
}

