/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    private MouseWheelListener mouseScrollListener;
    private PropertyChangeListener vsbPropertyChangeListener;
    private PropertyChangeListener hsbPropertyChangeListener;
    private Handler handler;
    private boolean setValueCalled = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("scrollUp"));
        lazyActionMap.put(new Actions("scrollDown"));
        lazyActionMap.put(new Actions("scrollHome"));
        lazyActionMap.put(new Actions("scrollEnd"));
        lazyActionMap.put(new Actions("unitScrollUp"));
        lazyActionMap.put(new Actions("unitScrollDown"));
        lazyActionMap.put(new Actions("scrollLeft"));
        lazyActionMap.put(new Actions("scrollRight"));
        lazyActionMap.put(new Actions("unitScrollRight"));
        lazyActionMap.put(new Actions("unitScrollLeft"));
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border border = jScrollPane.getViewportBorder();
        if (border == null || border instanceof UIResource) {
            border = UIManager.getBorder("ScrollPane.viewportBorder");
            jScrollPane.setViewportBorder(border);
        }
        LookAndFeel.installProperty(jScrollPane, "opaque", Boolean.TRUE);
    }

    protected void installListeners(JScrollPane jScrollPane) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.vsbPropertyChangeListener = this.createVSBPropertyChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.hsbPropertyChangeListener = this.createHSBPropertyChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.addChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().addChangeListener(this.vsbChangeListener);
            jScrollBar.addPropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().addChangeListener(this.hsbChangeListener);
            jScrollBar2.addPropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
        this.mouseScrollListener = this.createMouseWheelListener();
        this.scrollpane.addMouseWheelListener(this.mouseScrollListener);
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, inputMap);
        LazyActionMap.installLazyActionMap(jScrollPane, BasicScrollPaneUI.class, "ScrollPane.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)DefaultLookup.get(this.scrollpane, this, "ScrollPane.ancestorInputMap");
            if (this.scrollpane.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)DefaultLookup.get(this.scrollpane, this, "ScrollPane.ancestorInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.scrollpane = (JScrollPane)jComponent;
        this.installDefaults(this.scrollpane);
        this.installListeners(this.scrollpane);
        this.installKeyboardActions(this.scrollpane);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        LookAndFeel.uninstallBorder(this.scrollpane);
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallListeners(JComponent jComponent) {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().removeChangeListener(this.vsbChangeListener);
            jScrollBar.removePropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().removeChangeListener(this.hsbChangeListener);
            jScrollBar2.removePropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        if (this.mouseScrollListener != null) {
            this.scrollpane.removeMouseWheelListener(this.mouseScrollListener);
        }
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
        this.mouseScrollListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
        SwingUtilities.replaceUIActionMap(jScrollPane, null);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, null);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(this.scrollpane);
        this.uninstallListeners(this.scrollpane);
        this.uninstallKeyboardActions(this.scrollpane);
        this.scrollpane = null;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        JViewport jViewport2 = this.scrollpane.getRowHeader();
        JViewport jViewport3 = this.scrollpane.getColumnHeader();
        boolean bl = this.scrollpane.getComponentOrientation().isLeftToRight();
        if (jViewport != null) {
            int n;
            int n2;
            int n3;
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            Point point = jViewport.getViewPosition();
            if (jScrollBar != null) {
                n3 = dimension.height;
                n2 = dimension2.height;
                n = Math.max(0, Math.min(point.y, n2 - n3));
                jScrollBar.setValues(n, n3, 0, n2);
            }
            if (jScrollBar2 != null) {
                n3 = dimension.width;
                n2 = dimension2.width;
                if (bl) {
                    n = Math.max(0, Math.min(point.x, n2 - n3));
                } else {
                    int n4 = jScrollBar2.getValue();
                    if (this.setValueCalled && n2 - n4 == point.x) {
                        n = Math.max(0, Math.min(n2 - n3, n4));
                        if (n3 != 0) {
                            this.setValueCalled = false;
                        }
                    } else if (n3 > n2) {
                        point.x = n2 - n3;
                        jViewport.setViewPosition(point);
                        n = 0;
                    } else {
                        n = Math.max(0, Math.min(n2 - n3, n2 - n3 - point.x));
                    }
                }
                jScrollBar2.setValues(n, n3, 0, n2);
            }
            if (jViewport2 != null) {
                Point point2 = jViewport2.getViewPosition();
                point2.y = jViewport.getViewPosition().y;
                point2.x = 0;
                jViewport2.setViewPosition(point2);
            }
            if (jViewport3 != null) {
                Point point3 = jViewport3.getViewPosition();
                point3.x = bl ? jViewport.getViewPosition().x : Math.max(0, jViewport.getViewPosition().x);
                point3.y = 0;
                jViewport3.setViewPosition(point3);
            }
        }
    }

    public int getBaseline(JComponent jComponent, int n, int n2) {
        int n3;
        Object object;
        Component component;
        JViewport jViewport = this.scrollpane.getViewport();
        Insets insets = this.scrollpane.getInsets();
        int n4 = insets.top;
        n2 = n2 - insets.top - insets.bottom;
        n = n - insets.left - insets.right;
        JViewport jViewport2 = this.scrollpane.getColumnHeader();
        if (jViewport2 != null && jViewport2.isVisible()) {
            component = jViewport2.getView();
            if (component != null && component.isVisible()) {
                object = component.getPreferredSize();
                n3 = component.getBaseline(((Dimension)object).width, ((Dimension)object).height);
                if (n3 >= 0) {
                    return n4 + n3;
                }
            }
            object = jViewport2.getPreferredSize();
            n2 -= ((Dimension)object).height;
            n4 += ((Dimension)object).height;
        }
        Component component2 = component = jViewport == null ? null : jViewport.getView();
        if (component != null && component.isVisible() && component.getBaselineResizeBehavior() == Component.BaselineResizeBehavior.CONSTANT_ASCENT) {
            object = this.scrollpane.getViewportBorder();
            if (object != null) {
                Insets insets2 = object.getBorderInsets(this.scrollpane);
                n4 += insets2.top;
                n2 = n2 - insets2.top - insets2.bottom;
                n = n - insets2.left - insets2.right;
            }
            if (component.getWidth() > 0 && component.getHeight() > 0) {
                Dimension dimension = component.getMinimumSize();
                n = Math.max(dimension.width, component.getWidth());
                n2 = Math.max(dimension.height, component.getHeight());
            }
            if (n > 0 && n2 > 0 && (n3 = component.getBaseline(n, n2)) > 0) {
                return n4 + n3;
            }
        }
        return -1;
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    protected ChangeListener createViewportChangeListener() {
        return this.getHandler();
    }

    private PropertyChangeListener createHSBPropertyChangeListener() {
        return this.getHandler();
    }

    protected ChangeListener createHSBChangeListener() {
        return this.getHandler();
    }

    private PropertyChangeListener createVSBPropertyChangeListener() {
        return this.getHandler();
    }

    protected ChangeListener createVSBChangeListener() {
        return this.getHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return this.getHandler();
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jViewport2 != null) {
            int n;
            int n2;
            Point point = jViewport2.getViewPosition();
            point.x = this.scrollpane.getComponentOrientation().isLeftToRight() ? Math.max(point.x, 0) : ((n2 = jViewport2.getExtentSize().width) > (n = jViewport2.getViewSize().width) ? n - n2 : Math.max(0, Math.min(n - n2, point.x)));
            point.y = Math.max(point.y, 0);
            jViewport2.setViewPosition(point);
            jViewport2.addChangeListener(this.viewportChangeListener);
        }
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = jViewport2 != null ? jViewport2.getViewPosition().y : 0;
            jViewport.setViewPosition(point);
        }
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = jViewport2 == null ? 0 : (this.scrollpane.getComponentOrientation().isLeftToRight() ? jViewport2.getViewPosition().x : Math.max(0, jViewport2.getViewPosition().x));
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "COLUMN_HEADER");
        }
    }

    private void updateHorizontalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.hsbChangeListener, this.hsbPropertyChangeListener);
    }

    private void updateVerticalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.vsbChangeListener, this.vsbPropertyChangeListener);
    }

    private void updateScrollBar(PropertyChangeEvent propertyChangeEvent, ChangeListener changeListener, PropertyChangeListener propertyChangeListener) {
        JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
        if (jScrollBar != null) {
            if (changeListener != null) {
                jScrollBar.getModel().removeChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.removePropertyChangeListener(propertyChangeListener);
            }
        }
        if ((jScrollBar = (JScrollBar)propertyChangeEvent.getNewValue()) != null) {
            if (changeListener != null) {
                jScrollBar.getModel().addChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private static class Actions
    extends UIAction {
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_HOME = "scrollHome";
        private static final String SCROLL_END = "scrollEnd";
        private static final String UNIT_SCROLL_UP = "unitScrollUp";
        private static final String UNIT_SCROLL_DOWN = "unitScrollDown";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String UNIT_SCROLL_LEFT = "unitScrollLeft";
        private static final String UNIT_SCROLL_RIGHT = "unitScrollRight";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            boolean bl = jScrollPane.getComponentOrientation().isLeftToRight();
            String string = this.getName();
            if (string == SCROLL_UP) {
                this.scroll(jScrollPane, 1, -1, true);
            } else if (string == SCROLL_DOWN) {
                this.scroll(jScrollPane, 1, 1, true);
            } else if (string == SCROLL_HOME) {
                this.scrollHome(jScrollPane);
            } else if (string == SCROLL_END) {
                this.scrollEnd(jScrollPane);
            } else if (string == UNIT_SCROLL_UP) {
                this.scroll(jScrollPane, 1, -1, false);
            } else if (string == UNIT_SCROLL_DOWN) {
                this.scroll(jScrollPane, 1, 1, false);
            } else if (string == SCROLL_LEFT) {
                this.scroll(jScrollPane, 0, bl ? -1 : 1, true);
            } else if (string == SCROLL_RIGHT) {
                this.scroll(jScrollPane, 0, bl ? 1 : -1, true);
            } else if (string == UNIT_SCROLL_LEFT) {
                this.scroll(jScrollPane, 0, bl ? -1 : 1, false);
            } else if (string == UNIT_SCROLL_RIGHT) {
                this.scroll(jScrollPane, 0, bl ? 1 : -1, false);
            }
        }

        private void scrollEnd(JScrollPane jScrollPane) {
            Component component;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Rectangle rectangle2 = component.getBounds();
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, rectangle2.height - rectangle.height));
                } else {
                    jViewport.setViewPosition(new Point(0, rectangle2.height - rectangle.height));
                }
            }
        }

        private void scrollHome(JScrollPane jScrollPane) {
            Component component;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(0, 0));
                } else {
                    Rectangle rectangle = jViewport.getViewRect();
                    Rectangle rectangle2 = component.getBounds();
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, 0));
                }
            }
        }

        private void scroll(JScrollPane jScrollPane, int n, int n2, boolean bl) {
            Component component;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = component.getSize();
                int n3 = component instanceof Scrollable ? (bl ? ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, n, n2) : ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, n, n2)) : (bl ? (n == 1 ? rectangle.height : rectangle.width) : 10);
                if (n == 1) {
                    rectangle.y += n3 * n2;
                    if (rectangle.y + rectangle.height > dimension.height) {
                        rectangle.y = Math.max(0, dimension.height - rectangle.height);
                    } else if (rectangle.y < 0) {
                        rectangle.y = 0;
                    }
                } else if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += n3 * n2;
                    if (rectangle.x + rectangle.width > dimension.width) {
                        rectangle.x = Math.max(0, dimension.width - rectangle.width);
                    } else if (rectangle.x < 0) {
                        rectangle.x = 0;
                    }
                } else {
                    rectangle.x -= n3 * n2;
                    rectangle.x = rectangle.width > dimension.width ? dimension.width - rectangle.width : Math.max(0, Math.min(dimension.width - rectangle.width, rectangle.x));
                }
                jViewport.setViewPosition(rectangle.getLocation());
            }
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.getHandler().stateChanged(changeEvent);
        }
    }

    class Handler
    implements ChangeListener,
    PropertyChangeListener,
    MouseWheelListener {
        Handler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (BasicScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getWheelRotation() != 0) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                int n2 = 1;
                if (jScrollBar == null || !jScrollBar.isVisible()) {
                    jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (jScrollBar == null || !jScrollBar.isVisible()) {
                        return;
                    }
                    n2 = 0;
                }
                mouseWheelEvent.consume();
                if (mouseWheelEvent.getScrollType() == 0) {
                    JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
                    if (jViewport == null) {
                        return;
                    }
                    Component component = jViewport.getView();
                    int n3 = Math.abs(mouseWheelEvent.getUnitsToScroll());
                    boolean bl = Math.abs(mouseWheelEvent.getWheelRotation()) == 1;
                    Object object = jScrollBar.getClientProperty("JScrollBar.fastWheelScrolling");
                    if (Boolean.TRUE == object && component instanceof Scrollable) {
                        int n4;
                        Scrollable scrollable = (Scrollable)((Object)component);
                        Rectangle rectangle = jViewport.getViewRect();
                        int n5 = rectangle.x;
                        boolean bl2 = component.getComponentOrientation().isLeftToRight();
                        int n6 = jScrollBar.getMinimum();
                        int n7 = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent();
                        if (bl) {
                            n4 = scrollable.getScrollableBlockIncrement(rectangle, n2, n);
                            if (n < 0) {
                                n6 = Math.max(n6, jScrollBar.getValue() - n4);
                            } else {
                                n7 = Math.min(n7, jScrollBar.getValue() + n4);
                            }
                        }
                        for (n4 = 0; n4 < n3; ++n4) {
                            int n8 = scrollable.getScrollableUnitIncrement(rectangle, n2, n);
                            if (n2 == 1) {
                                if (n < 0) {
                                    rectangle.y -= n8;
                                    if (rectangle.y > n6) continue;
                                    rectangle.y = n6;
                                    break;
                                }
                                rectangle.y += n8;
                                if (rectangle.y < n7) continue;
                                rectangle.y = n7;
                                break;
                            }
                            if (bl2 && n < 0 || !bl2 && n > 0) {
                                rectangle.x -= n8;
                                if (!bl2 || rectangle.x >= n6) continue;
                                rectangle.x = n6;
                                break;
                            }
                            if (bl2 && n > 0 || !bl2 && n < 0) {
                                rectangle.x += n8;
                                if (!bl2 || rectangle.x <= n7) continue;
                                rectangle.x = n7;
                                break;
                            }
                            assert (false) : "Non-sensical ComponentOrientation / scroll direction";
                        }
                        if (n2 == 1) {
                            jScrollBar.setValue(rectangle.y);
                        } else if (bl2) {
                            jScrollBar.setValue(rectangle.x);
                        } else {
                            n4 = jScrollBar.getValue() - (rectangle.x - n5);
                            if (n4 < n6) {
                                n4 = n6;
                            } else if (n4 > n7) {
                                n4 = n7;
                            }
                            jScrollBar.setValue(n4);
                        }
                    } else {
                        BasicScrollBarUI.scrollByUnits(jScrollBar, n, n3, bl);
                    }
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    BasicScrollBarUI.scrollByBlock(jScrollBar, n);
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                if (changeEvent.getSource() == jViewport) {
                    this.viewportStateChanged(changeEvent);
                } else {
                    JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (jScrollBar != null && changeEvent.getSource() == jScrollBar.getModel()) {
                        this.hsbStateChanged(jViewport, changeEvent);
                    } else {
                        JScrollBar jScrollBar2 = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                        if (jScrollBar2 != null && changeEvent.getSource() == jScrollBar2.getModel()) {
                            this.vsbStateChanged(jViewport, changeEvent);
                        }
                    }
                }
            }
        }

        private void vsbStateChanged(JViewport jViewport, ChangeEvent changeEvent) {
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
            Point point = jViewport.getViewPosition();
            point.y = boundedRangeModel.getValue();
            jViewport.setViewPosition(point);
        }

        private void hsbStateChanged(JViewport jViewport, ChangeEvent changeEvent) {
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
            Point point = jViewport.getViewPosition();
            int n = boundedRangeModel.getValue();
            if (BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                point.x = n;
            } else {
                int n2 = jViewport.getViewSize().width;
                int n3 = jViewport.getExtentSize().width;
                int n4 = point.x;
                point.x = n2 - n3 - n;
                if (n3 == 0 && n != 0 && n4 == n2) {
                    BasicScrollPaneUI.this.setValueCalled = true;
                } else if (n3 != 0 && n4 < 0 && point.x == 0) {
                    point.x += n;
                }
            }
            jViewport.setViewPosition(point);
        }

        private void viewportStateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicScrollPaneUI.this.scrollpane) {
                this.scrollPanePropertyChange(propertyChangeEvent);
            } else {
                this.sbPropertyChange(propertyChangeEvent);
            }
        }

        private void scrollPanePropertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "verticalScrollBarDisplayPolicy") {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string == "horizontalScrollBarDisplayPolicy") {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string == "viewport") {
                BasicScrollPaneUI.this.updateViewport(propertyChangeEvent);
            } else if (string == "rowHeader") {
                BasicScrollPaneUI.this.updateRowHeader(propertyChangeEvent);
            } else if (string == "columnHeader") {
                BasicScrollPaneUI.this.updateColumnHeader(propertyChangeEvent);
            } else if (string == "verticalScrollBar") {
                BasicScrollPaneUI.this.updateVerticalScrollBar(propertyChangeEvent);
            } else if (string == "horizontalScrollBar") {
                BasicScrollPaneUI.this.updateHorizontalScrollBar(propertyChangeEvent);
            } else if (string == "componentOrientation") {
                BasicScrollPaneUI.this.scrollpane.revalidate();
                BasicScrollPaneUI.this.scrollpane.repaint();
            }
        }

        private void sbPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if ("model" == string) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                ChangeListener changeListener = null;
                if (object == jScrollBar) {
                    changeListener = BasicScrollPaneUI.this.vsbChangeListener;
                } else if (object == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    changeListener = BasicScrollPaneUI.this.hsbChangeListener;
                }
                if (changeListener != null) {
                    if (boundedRangeModel != null) {
                        boundedRangeModel.removeChangeListener(changeListener);
                    }
                    if (jScrollBar.getModel() != null) {
                        jScrollBar.getModel().addChangeListener(changeListener);
                    }
                }
            } else if ("componentOrientation" == string && object == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
                Point point = jViewport.getViewPosition();
                point.x = BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? jScrollBar.getValue() : jViewport.getViewSize().width - jViewport.getExtentSize().width - jScrollBar.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            BasicScrollPaneUI.this.getHandler().mouseWheelMoved(mouseWheelEvent);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicScrollPaneUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.getHandler().stateChanged(changeEvent);
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.getHandler().stateChanged(changeEvent);
        }
    }
}

