/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractExport;
import com.vmware.sva.common.AbstractUniqueObject;
import com.vmware.sva.common.NetworkInterface;
import com.vmware.sva.common.StorageEntityState;
import java.util.List;
import java.util.UUID;

public abstract class AbstractStorageEntity
extends AbstractUniqueObject {
    private NetworkInterface accessInterface;
    private List<? extends AbstractExport> exports;
    private UUID exportMemberSvaId;
    private boolean exported;
    private StorageEntityState state;
    private static final long serialVersionUID = 1L;

    public AbstractStorageEntity() {
    }

    public AbstractStorageEntity(UUID id, String name, NetworkInterface accessInterface, List<? extends AbstractExport> exports, UUID exportMemberSvaId, boolean exported, StorageEntityState state) {
        super(id, name);
        this.accessInterface = accessInterface;
        this.exports = exports;
        this.exportMemberSvaId = exportMemberSvaId;
        this.exported = exported;
        this.state = state;
    }

    public NetworkInterface getAccessInterface() {
        return this.accessInterface;
    }

    public List<? extends AbstractExport> getExports() {
        return this.exports;
    }

    public UUID getExportMemberSvaId() {
        return this.exportMemberSvaId;
    }

    public void setExportMemberSvaId(UUID exportMemberSvaId) {
        this.exportMemberSvaId = exportMemberSvaId;
    }

    public boolean isExported() {
        return this.exported;
    }

    public StorageEntityState getState() {
        return this.state;
    }

    public String toString() {
        String outMsgTmpl = "[%s: {name: %s; id: %s; accessInterface: %s; exports[%d] = {%s}; exportMemberSvaId: %s; exported: %s; state: %s}";
        String outMsg = String.format(outMsgTmpl, this.getClass().getName(), this.getName(), this.getId().toString(), this.accessInterface != null ? this.accessInterface.toString() : "null", this.exports != null ? this.exports.size() : 0, this.exports != null ? this.exports.toString() : "null", this.exportMemberSvaId != null ? this.exportMemberSvaId.toString() : "null", Boolean.toString(this.exported), this.state != null ? this.state.toString() : "null");
        return outMsg;
    }
}

