/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractSerializable;
import com.vmware.sva.common.SvaConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.concurrent.Callable;

public final class ClientOverrideHostRmiClientSocketFactory
extends AbstractSerializable
implements RMIClientSocketFactory {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<String> threadSpecifiedHost = new ThreadLocal();
    private transient String overrideHost;

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        int timeout = SvaConstants.DEFAULT_RMI_CONNECTION_TIMEOUT;
        Socket socket = new Socket();
        socket.setSoTimeout(timeout);
        socket.setSoLinger(false, 0);
        socket.connect(new InetSocketAddress(this.overrideHost != null ? this.overrideHost : host, port), timeout);
        return socket;
    }

    public boolean equals(Object object) {
        return object instanceof ClientOverrideHostRmiClientSocketFactory && ClientOverrideHostRmiClientSocketFactory.safeEquals(this.overrideHost, ((ClientOverrideHostRmiClientSocketFactory)object).overrideHost);
    }

    private static boolean safeEquals(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    public int hashCode() {
        return 0x2B ^ (this.overrideHost == null ? 0 : this.overrideHost.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callWithHost(String host, Callable<T> callable) throws Exception {
        if (host == null) {
            throw new NullPointerException();
        }
        threadSpecifiedHost.set(host);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            threadSpecifiedHost.set(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.overrideHost = threadSpecifiedHost.get();
    }
}

