/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractSerializable;
import com.vmware.sva.common.SvaUtilities;
import java.io.File;

public class LogicalVolume
extends AbstractSerializable {
    private final String name;
    private String uuid;
    private long size;
    private final String volumeGroupName;
    private long majorNumber;
    private long minorNumber;
    private static final long serialVersionUID = 1L;

    public LogicalVolume(String volumeGroupName, String name) throws Exception {
        this.volumeGroupName = volumeGroupName;
        this.name = name;
        String[] attributes = new String[]{"uuid", "size", "kernel_major", "kernel_minor"};
        StringBuilder sb = new StringBuilder();
        for (String a : attributes) {
            sb.append(a + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        String options = this.getLogicalVolumeAttribute(sb.toString()).replaceAll("\\b\\s{2,}\\b", " ");
        String[] values = options.split(" ");
        if (values.length != attributes.length) {
            throw new Exception("Unable to construct a LogicalVolume object");
        }
        this.uuid = values[0];
        this.size = Long.valueOf(values[1]) / 1024L;
        this.majorNumber = Long.valueOf(values[2]);
        this.minorNumber = Long.valueOf(values[3]);
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public long getSize() {
        return this.size;
    }

    public String getVolumeGroupName() {
        return this.volumeGroupName;
    }

    public long getMajorNumber() {
        return this.majorNumber;
    }

    public long getMinorNumber() {
        return this.minorNumber;
    }

    public String getDeviceNumber() {
        return this.majorNumber + ":" + this.minorNumber;
    }

    public String getDeviceName() {
        return LogicalVolume.formatDeviceName(this.volumeGroupName, this.name);
    }

    public long getCurrentSize() throws Exception {
        String sizeStr = this.getLogicalVolumeAttribute("size");
        return Long.valueOf(sizeStr) / 1024L;
    }

    public static String formatDeviceName(String volumeGroupName, String logicalVolumeName) {
        return "/dev/" + volumeGroupName + "/" + logicalVolumeName;
    }

    public static String exists(String volumeGroupName, String logicalVolumeName) {
        String deviceName = LogicalVolume.formatDeviceName(volumeGroupName, logicalVolumeName);
        return new File(deviceName).exists() ? deviceName : null;
    }

    private String getLogicalVolumeAttribute(String attribute) throws Exception {
        return SvaUtilities.getLvmAttribute("/sbin/lvs", LogicalVolume.formatDeviceName(this.volumeGroupName, this.name), attribute);
    }
}

