/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractSerializable;
import java.net.InetAddress;

public class NfsAccessControl
extends AbstractSerializable {
    private static final long serialVersionUID = 1L;
    private InetAddress ipAddress;
    private boolean readWriteAccess;

    public NfsAccessControl() {
    }

    public NfsAccessControl(InetAddress ipAddress, boolean readWriteAccess) {
        this.ipAddress = ipAddress;
        this.readWriteAccess = readWriteAccess;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public boolean isReadWriteAccess() {
        return this.readWriteAccess;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setReadWriteAccess(boolean readWriteAccess) {
        this.readWriteAccess = readWriteAccess;
    }

    public boolean equals(Object other) {
        boolean result = false;
        InetAddress thisIP = this.ipAddress;
        if (other instanceof NfsAccessControl && thisIP != null) {
            NfsAccessControl that = (NfsAccessControl)other;
            InetAddress ia = that.getIpAddress();
            result = that.canEqual(this) && ia != null && ia.getHostAddress().equalsIgnoreCase(thisIP.getHostAddress());
        }
        return result;
    }

    public int hashCode() {
        return 41 * super.hashCode() + (this.ipAddress == null ? 1 : this.ipAddress.hashCode());
    }

    public boolean canEqual(Object other) {
        return other instanceof NfsAccessControl;
    }

    public String toString() {
        return "IP=" + this.ipAddress.getHostAddress() + " Access=" + (this.readWriteAccess ? "rw" : "ro");
    }
}

