/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PseudoSVAPathUtil {
    private static final String PSEUDOSVAINSTALL = "defaultPseudoSVAInstallPath";
    private static String configFile = "";
    private static final String PSEUDOSVALOG = "defaultLogPath";
    private static final Logger LOGGER = Logger.getLogger(PseudoSVAPathUtil.class.getName());

    private static String readPsvaPath(String tag) throws Exception {
        NodeList nl;
        if (configFile.isEmpty()) {
            throw new Exception("ConfigFile needs to be set");
        }
        File file = new File(configFile);
        String path = null;
        if (file.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(configFile);
            Element docElement = doc.getDocumentElement();
            nl = docElement.getElementsByTagName(tag);
            if (nl == null || nl.getLength() == 0) {
                throw new Exception("Element " + tag + " is absent in " + configFile + " file.");
            }
        } else {
            throw new Exception("File " + configFile + " not found.");
        }
        Node n = nl.item(0);
        path = n.getFirstChild().getTextContent();
        path = path.replace("\\", "/");
        path = path.replaceAll("/+", "/");
        if (path.lastIndexOf("/") == path.length() - 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static void setPsvaConfigPath(String filename) throws Exception {
        File file = new File(filename = filename.replace("\\", "/"));
        if (file.exists()) {
            configFile = filename;
        } else {
            ClassLoader cl = PseudoSVAPathUtil.class.getClassLoader();
            try {
                String path;
                URL url = cl.getResource("vmconfig-sva.xml");
                if (url != null && (path = new URI(url.toString()).getPath()) != null) {
                    configFile = path;
                }
            }
            catch (Exception ex) {
                LOGGER.warning("Could not find vmconfig-sva.xml resource file.");
            }
        }
        if (configFile == null || configFile.isEmpty()) {
            throw new Exception("Unable to find pseudo SVA configuration file. It has to be passed as a command line parameter or file vmconfig-sva.xml has to be present in the class path.");
        }
    }

    public static String getPsvaInstallPath() throws Exception {
        return PseudoSVAPathUtil.readPsvaPath(PSEUDOSVAINSTALL);
    }

    public static String getPseudoSvaLogPath() throws Exception {
        return PseudoSVAPathUtil.readPsvaPath(PSEUDOSVALOG);
    }
}

