/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.SerialFields;
import com.vmware.sva.common.SerialGenerationInfo;
import com.vmware.sva.common.SerialMinorVersionUtils;
import com.vmware.sva.common.SimpleSerialGenerationInfo;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;

public enum SerialGeneration {
    TEST_1("test 1"),
    TEST_2("test 2"),
    TEST_3("test 3"),
    VERSION_1("1.0.0.1"),
    VERSION_1_0_BETA_2("1.0.0.2"),
    VERSION_1_0_RC("1.0.0.3"),
    VERSION_1_5("1.5.0.0"),
    VERSION_5_1_FC("5.1.0.0");

    private static final SerialGeneration[] values;
    private static SerialGenerationInfo info;
    private final String versionString;

    private SerialGeneration(String versionString) {
        this.versionString = versionString;
    }

    public static SerialGeneration get(int ordinal) {
        try {
            return values[ordinal];
        }
        catch (IndexOutOfBoundsException e) {
            if (ordinal >= values.length) {
                throw new IndexOutOfBoundsException("Attempt to refer to a future serial generation (" + ordinal + ") -- perhaps a downgrade is being attempted?");
            }
            throw new IndexOutOfBoundsException("Ordinal value is out of bounds: " + ordinal);
        }
    }

    public static SerialGeneration getLatest() {
        return values[values.length - 1];
    }

    public static SerialGeneration getCurrent() {
        return SerialGeneration.getSerialGenerationInfo().getCurrentGeneration();
    }

    public static synchronized void setSerialGenerationInfo(SerialGenerationInfo info) {
        if (info == null) {
            throw new NullPointerException("The info argument must not be null");
        }
        SerialGeneration.info = info;
    }

    static synchronized SerialGenerationInfo getSerialGenerationInfo() {
        return info;
    }

    public static void writeCurrent(ObjectOutputStream out) throws IOException {
        out.writeInt(SerialGeneration.getCurrent().ordinal());
    }

    public static SerialGeneration read(ObjectInputStream in) throws IOException {
        int ordinal = in.readInt();
        try {
            return SerialGeneration.get(ordinal);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getVersionString() {
        return this.versionString;
    }

    public short getSerialMinorVersion(Class<?> cl) {
        return SerialGeneration.getSerialGenerationInfo().getSerialMinorVersion(cl, this);
    }

    public SerialFields setDefaultFields(Object object, Class<?> cl, ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (object == null) {
            throw new NullPointerException("The object argument must not be null");
        }
        if (cl == null) {
            throw new NullPointerException("The cl argument must not be null");
        }
        if (!cl.isInstance(object)) {
            throw new InvalidClassException("The object is not an instance of " + cl.getName() + ": " + object);
        }
        if (this != SerialGeneration.getCurrent()) {
            short streamSerialMinorVersion;
            short currentSerialMinorVersion;
            try {
                currentSerialMinorVersion = SerialMinorVersionUtils.getSerialMinorVersion(cl);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidClassException(e.getMessage());
            }
            try {
                streamSerialMinorVersion = this.getSerialMinorVersion(cl);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidClassException(e.getMessage());
            }
            if (streamSerialMinorVersion != currentSerialMinorVersion) {
                ObjectInputStream.GetField getField = in.readFields();
                SerialGeneration.setFields(object, getField);
                return new SerialFields(streamSerialMinorVersion, getField);
            }
        }
        in.defaultReadObject();
        return null;
    }

    private static void setFields(Object object, ObjectInputStream.GetField getField) throws IOException {
        ObjectStreamClass classDesc = getField.getObjectStreamClass();
        for (ObjectStreamField field : classDesc.getFields()) {
            SerialGeneration.setField(object, field, getField);
        }
    }

    private static void setField(Object object, ObjectStreamField streamField, ObjectInputStream.GetField getField) throws IOException {
        Field objField;
        String name = streamField.getName();
        try {
            objField = object.getClass().getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return;
        }
        objField.setAccessible(true);
        Class<?> objFieldType = objField.getType();
        Class<?> streamFieldType = streamField.getType();
        if (objFieldType != streamFieldType) {
            if (objFieldType.isPrimitive() || streamFieldType.isPrimitive()) {
                return;
            }
            Object value = getField.get(name, null);
            if (value != null && !objFieldType.isAssignableFrom(value.getClass())) {
                return;
            }
        }
        char typeCode = streamField.getTypeCode();
        try {
            switch (typeCode) {
                case 'B': {
                    objField.setByte(object, getField.get(name, (byte)0));
                    break;
                }
                case 'C': {
                    objField.setChar(object, getField.get(name, '\u0000'));
                    break;
                }
                case 'D': {
                    objField.setDouble(object, getField.get(name, 0.0));
                    break;
                }
                case 'F': {
                    objField.setFloat(object, getField.get(name, 0.0f));
                    break;
                }
                case 'I': {
                    objField.setInt(object, getField.get(name, 0));
                    break;
                }
                case 'J': {
                    objField.setLong(object, getField.get(name, 0L));
                    break;
                }
                case 'L': 
                case '[': {
                    objField.set(object, getField.get(name, null));
                    break;
                }
                case 'S': {
                    objField.setShort(object, getField.get(name, (short)0));
                    break;
                }
                case 'Z': {
                    objField.setBoolean(object, getField.get(name, false));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type code: " + typeCode));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        values = SerialGeneration.values();
        info = new SimpleSerialGenerationInfo();
    }
}

