/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SubnetServerSocket
extends ServerSocket {
    private static final Logger LOGGER = Logger.getLogger(SubnetServerSocket.class.getName());

    public SubnetServerSocket(int port) throws IOException {
        super(port);
    }

    @Override
    public Socket accept() throws IOException {
        Socket s = new Socket();
        this.implAccept(s);
        if (!SubnetServerSocket.isSameSubnetSocket(s)) {
            String errorMessage = "The RMI request must come from the same network. The local interface IP was " + s.getLocalAddress() + ", the remote interface IP was " + s.getInetAddress() + ".";
            LOGGER.log(Level.WARNING, errorMessage);
            throw new IOException(errorMessage);
        }
        return s;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private static boolean isSameSubnetSocket(Socket s) throws SocketException {
        InetAddress localIP;
        if (!s.isConnected()) {
            throw new IllegalArgumentException("The socket is not connected.");
        }
        InetAddress remoteIP = s.getInetAddress();
        if (remoteIP.equals(localIP = s.getLocalAddress())) {
            return true;
        }
        if (!(remoteIP instanceof Inet4Address) || !(localIP instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only Internet Protocol version 4 is supported.");
        }
        if (localIP.getAddress()[0] == 127) {
            return true;
        }
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        if (networkInterfaces == null) {
            return true;
        }
        boolean foundMatchingIP = false;
        block0: while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                short networkPrefix;
                InetAddress localInterfaceIP = interfaceAddress.getAddress();
                if (!(localInterfaceIP instanceof Inet4Address) || !SubnetServerSocket.isSameSubnet((Inet4Address)remoteIP, (Inet4Address)localInterfaceIP, networkPrefix = interfaceAddress.getNetworkPrefixLength())) continue;
                foundMatchingIP = true;
                continue block0;
            }
        }
        return foundMatchingIP;
    }

    private static boolean isSameSubnet(Inet4Address ip1, Inet4Address ip2, short networkPrefix) {
        byte[] ip1Bytes = ip1.getAddress();
        byte[] ip2Bytes = ip2.getAddress();
        int ip1Int = 0;
        int ip2Int = 0;
        for (int i = 0; i < 4; ++i) {
            ip1Int <<= 8;
            ip2Int <<= 8;
            ip1Int |= ip1Bytes[i] & 0xFF;
            ip2Int |= ip2Bytes[i] & 0xFF;
        }
        int mask = -1 << 32 - networkPrefix;
        return (ip1Int & mask ^ ip2Int & mask) == 0;
    }
}

