/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.FileSystemType;
import com.vmware.sva.common.PseudoSVAPathUtil;
import com.vmware.sva.common.RaidType;
import com.vmware.sva.common.SvaUtilities;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SvaConstants {
    public static final String LINUX = "linux";
    public static final String WINDOWS = "windows";
    private static final Logger LOGGER = Logger.getLogger(SvaConstants.class.getName());
    public static final String IS_PSEUDO_SVA_SYS_PROPERTY = "isPseudoSVA";
    public static final boolean IS_PSEUDO_SVA = SvaConstants.isPseudoSVA();
    public static final String ENABLE_SUBNET_FILTER_SVA_PROPERTY = "enableSubnetFilter";
    private static final String VCS_EXECUTE_CMD_MAX_OUTPUT_SIZE_PROP_NAME = "vcsExecuteMaxOutputSize";
    private static final long DEFAULT_VCS_EXECUTE_CMD_MAX_OUTPUT_SIZE = 0xA00000L;
    public static final String ZK_ENABLE_SUBNET_FILTER_SYS_PROPERTY = "enableZKSubnetFilter";
    public static final String DEFAULT_LOGGING_PATH_SYS_PROPERTY = "defaultLoggingPath";
    public static final String SvaLinuxDefaultConfigPath = "/etc/sva";
    public static final String SvaLinuxDefaultLogPath = "/var/log/sva";
    public static final String SvaConfigPath = SvaConstants.getSvaConfigPath();
    public static final String SvaLogPath = SvaConstants.getSvaLogPath();
    public static final String SvaProperties = SvaConstants.getenv("SVA_PROPERTIES", null);
    public static final String SvaServerNamePath = SvaConfigPath + "/sva.serverName";
    public static final String SvaPropertiesPath = SvaConfigPath + "/sva.properties";
    public static final String SvaLinuxCrashDirPath = "/var/crash";
    public static final String ETC_ISSUE = "/etc/issue";
    public static final String SVA_CLUSTER_IP = SvaConfigPath + "/cluster.ip";
    public static final boolean ENABLE_SUBNET_FILTER = SvaConstants.enableSubnetFilter();
    public static final String PSEUDOSVA_VERSIONFILE = SvaConfigPath + "/conf/vcs.version";
    public static final String PSEUDOSVA_METADATA_FILE = SvaConstants.getprop("psva.metadata.file", SvaConfigPath + "/.pseudosvametadata");
    public static final String SVAPASSWD = SvaConstants.getprop("sva.pass", "svapass");
    public static final String SVAADMIN = SvaConstants.getprop("sva.user", "svaadmin");
    public static final String LogPath = SvaConstants.getprop("log.file", SvaLogPath);
    public static final String LogServer = SvaConstants.getprop("log.server", "");
    public static final int LogServerPort = SvaConstants.getprop("log.server.port", 58765);
    public static final String LogServerFormat = SvaConstants.getprop("log.server.format", "xml");
    public static final String LOG4J_FILE_PATH = SvaConstants.getprop("log4j.file", SvaConfigPath + "/sva-log4j.properties");
    public static final long LOG4J_REFRESH_RATE = 15000L;
    public static final boolean DISABLE_DATABASE_VALIDATION = SvaConstants.getprop("database.disable_validation", false);
    public static final long BYTES_PER_BLOCK = 512L;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static final long ONE_PB = 0x4000000000000L;
    public static final long ONE_EB = 0x1000000000000000L;
    public static final String SasDefaultsTablePath = SvaConfigPath + "/sasDefaultTable.properties";
    public static final int PARAM_TABLE_MAX_ENTRIES = 20;
    public static final int PARAM_TABLE_ENTRY_MAX_SIZE_KB = 1;
    public static final int PARAM_TABLE_ENTRY_MAX_KEY_SIZE = 64;
    public static final int MAX_LOG_FILE_SIZE = SvaConstants.getprop("log.maxFileKBs", 0xA00000);
    public static final int MAX_LOG_FILES = SvaConstants.getprop("log.maxFiles", 4);
    public static final Level logLevel = SvaConstants.getprop("log.level", Level.INFO);
    public static final UUID ZeroUUID;
    public static final UUID DefaultUUID;
    public static final UUID DOMAIN_MESSAGE_UUID;
    public static final UUID BROADCAST_UUID;
    public static final int SVA_VIRTUAL_MEMORY_LIMIT_MB;
    public static final boolean USE_XSTREAM;
    public static final String CASSINI_RAID_METADATA_VERSION;
    public static final boolean CASSINI_RAID_INITIAL_SYNC;
    public static final RaidType CASSINI_RAID_TYPE;
    public static final FileSystemType CASSINI_FS_TYPE;
    public static final long CASSINI_FS_BLOCK_SIZE;
    public static final long CASSINI_FS_STRIPE_WIDTH;
    public static final long ZK_GENERATION_UPDATE_FREQUENCY;
    public static final long ZK_MASTER_UPDATE_FREQUENCY;
    public static final long MAX_ZK_TRANSACTION_LOG_LENGTH;
    public static final String SVA_ZK_PROPERTIES_FILE;
    public static final String ZK_CONF_FILE;
    public static final String ZK_DATA_DIRECTORY;
    public static final String ZK_MYID_FILE;
    public static final String ZK_CACHE_DIRECTORY;
    public static final String ZKMGMTSERVER_NAME = "ZkMgmtServer";
    public static final int ZK_CLIENT_PORT;
    public static final int ZK_SNAP_COUNT;
    public static final int ZK_MAX_CLIENT_CNXNS;
    public static final int ZK_INIT_LIMIT;
    public static final int ZK_TICKTIME;
    public static final int ZK_SYNC_LIMIT;
    public static final int ZK_PEER_PORT;
    public static final int ZK_ELECTION_PORT;
    public static final int ZK_MAX_SNAPSHOT_FILES;
    public static final int ZK_PURGE_FREQUENCY;
    public static final int ZK_CLIENT_SESSION_TIMEOUT;
    public static final int ZK_CLIENT_OFFLINE_TIMEOUT;
    public static final int ZK_OLD_SESSION_EXPIRE_EXTRA_RETRIES;
    public static final String ZK_PSEUDO_SVA_ONLINE_PATH = "/PseudoSvaOnline";
    public static final String SVARMISERVICE_NAME = "SvaRmiService";
    public static final UUID MESSAGE_SERVICE_ID;
    public static final String MESSAGE_SERVICE_NAME = "Message Service";
    public static final int HTTPS_PORT;
    public static final int PSVA_HTTPS_PORT;
    public static final UUID VOLUME_GROUP_MANAGER_BLC_ID;
    public static final String IFCFG_FILE_DIR;
    public static final String IFCFG_FILE_PREFIX;
    public static final long INTERFACE_MTU;
    public static final String FRONT_END_INTERFACE;
    public static final String BACK_END_INTERFACE;
    public static final int BACK_END_MTU;
    public static final long TASK_DEFAULT_TIME_TO_EXPIRE;
    public static final String SAS_MGMT_EVENT_LOG_PATH;
    public static final String SAS_DEFAULT_RAID_TYPE_KEY = "sas.storageEntity.volume.type";
    public static final String SAS_DEFAULT_RAID_TYPE = "RAID1";
    public static final String SAS_DEFAULT_DISK_COUNT_KEY = "sas.storageEntity.volume.diskCount";
    public static final String SAS_DEFAULT_DISK_COUNT = "2";
    public static final String SAS_DEFAULT_VOLUME_SIZE_KEY = "sas.storageEntity.volume.size";
    public static final String SAS_DEFAULT_VOLUME_SIZE = "100000";
    public static final int FT_MAX_GET_DB_CONTENT_RETRIES;
    public static final int FT_MAX_GET_DB_CONTENT_DELAY;
    public static final String SVA_SUPPORT_DIR = "/support";
    public static final String PSVA_SUPPORT_DIR;
    public static final String PSVALOGBUNDLE_NAME;
    public static final String STORAGE_CLUSTER_BUNDLE_FORMAT = "storage-cluster-%s-support-bundle-%s.zip";
    public static final int SVA_COPY_SERVER_PORT = 2376;
    public static final int COPY_FILE_TOTAL_WAIT = 120000;
    public static final int COPY_FILE_WATCHDOG_CHECK_FREQ = 5000;
    public static final long WAIT_FOR_DISKS_CREATE_WAIT_TIME;
    public static final long WAIT_FOR_FAIL_BACK_TIME;
    public static final long SET_DISK_ONLINE_WAIT_TIME_INITIAL;
    public static final long SET_DISK_ONLINE_WAIT_TIME_SUBSEQUENT;
    public static final long RESIZE_MEMBER_DISK_WAIT_TIME;
    public static final long RESOURCE_COORDINATOR_ID_LOOKUP_WAIT_TIME;
    public static final String RESOURCE_COORDINATOR_BLC_UUID_NAME = "ResourceCoordinatorBlcId";
    public static final long SYNC_DELTA_IN_CHUNKS;
    public static final String SVA_DOMAIN_NAME = "SVADomain";
    public static final String SAS_DOMAIN_NAME = "SASDomain";
    public static final String SC_DOMAIN_NAME = "StorageClusterDomain";
    public static final String MEMBER_DOMAIN_NAME = "MemberDomain";
    public static final String PSEUDOSVA_DOMAIN_NAME = "PseudoSvaDomain";
    public static final UUID PSEUDOSVA_DOMAIN_ID;
    public static final UUID SVA_DOMAIN_ID;
    public static final String DEFAULT_VOLUME_GROUP = "SVAVolGroup00";
    public static final long PLATFORM_COMMAND_TIMEOUT;
    public static final long PLATFORM_CREATE_DPFILTER_COMMAND_TIMEOUT;
    public static final int MEMBER_CREATE_DPFILTER_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_EXPORTFS_COMMAND_TIMEOUT;
    public static final long PLATFORM_ISCSI_COMMAND_TIMEOUT;
    public static final long PLATFORM_PVRESIZE_COMMAND_TIMEOUT;
    public static final int VOLUME_GROUP_RESIZE_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_LVCREATE_COMMAND_TIMEOUT;
    public static final int MEMBER_CREATELV_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_MKFS_COMMAND_TIMEOUT;
    public static final int MEMBER_CREATEFS_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_RESIZEFS_COMMAND_TIMEOUT;
    public static final int MEMBER_RESIZEFS_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_TUNE2FS_COMMAND_TIMEOUT;
    public static final long PLATFORM_MOUNT_COMMAND_TIMEOUT;
    public static final int PLATFORM_MOUNT_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_FSCK_COMMAND_TIMEOUT;
    public static final int PLATFORM_FSCK_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_LONG_FSCK_COMMAND_TIMEOUT;
    public static final int PLATFORM_LONG_FSCK_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_UMOUNT_TIMEOUT;
    public static final int PLATFORM_UMOUNT_WATCHDOG_TIMEOUT;
    public static final long PLATFORM_SVA_SUPPORT_TIMEOUT;
    public static final int SVA_SUPPORT_WATCHDOG_TIMEOUT;
    public static final long SVA_MGMT_CLIENT_SERVICE_TIMEOUT;
    public static final long PLATFORM_NASPLUGIND_START_TIMEOUT;
    public static final String PLATFORM_LVM_LOWER_HALF;
    public static final String PLATFORM_LVM_UPPER_HALF;
    public static final String SHUTDOWN_FLUSH_BLOCKDEVS;
    public static final long PLATFORM_RAID_SYNC_SPEED_MIN;
    public static final long PLATFORM_RAID_SYNC_SPEED_MAX;
    public static final String PLATFORM_RAID_SYNC_FG_RATIO_MAX;
    public static final String PLATFORM_RAID_SYNC_FG_RATIO_MIN;
    public static final int PLATFORM_RAID_BITMAP_CHUNK_SIZE;
    public static final long PLATFORM_SERVICE_ACTION_RETRIES;
    public static final long PLATFORM_SERVICE_ACTION_RETRY_DELAY;
    public static final long MKFS_DIRTY_BACKGROUND_RATIO_LOW;
    public static final long MKFS_DIRTY_RATIO_LOW;
    public static final long MKFS_NR_REQUESTS_LOW;
    public static final long MKFS_ISCSI_NR_REQUESTS_LOW;
    public static final long MKFS_DIRTY_BACKGROUND_RATIO;
    public static final long MKFS_DIRTY_RATIO;
    public static final long MKFS_NR_REQUESTS;
    public static final long SVA_TARGET_ID;
    public static final long SVA_TARGET_LUN;
    public static final String SVA_LUN_ZERO_DEVICE;
    public static final String SVA_LUN_ZERO_NAME;
    public static final long SVA_SESSION_ID;
    public static final String ISCSI_NAME_PREFIX = "iqn.2010-06.com.vmware:sva";
    public static final String INITIATOR_NAME_PATH = "/etc/iscsi/initiatorname.iscsi";
    public static final String PSEUDO_SVA_CONFIG_FILE_RESOURCE_NAME = "vmconfig-sva.xml";
    public static final String PSEUDO_SVA_DESTROY_PROPERTY_NAME = "pseudosva.destroy";
    public static final long ISCSI_SESSION_NOOP_OUT_INTERVAL;
    public static final long ISCSI_SESSION_NOOP_OUT_TIMEOUT;
    public static final long ISCSI_SESSION_QUEUE_DEPTH;
    public static final long ISCSI_SESSION_REPLACEMENT_TIMEOUT;
    public static final long ISCSI_FIND_ISCSI_DEVICE_RETRIES;
    public static final int SCST_MAX_DISK_NAME = 16;
    public static final String RESOLV_CONF_FILE = "/etc/resolv.conf";
    public static final String ExportBaseDir;
    public static final long MAX_MGMT_ADDR_RETRIES;
    public static final long MGMT_ADDR_RETRY_DELAY;
    public static final int DPE_MAX_EVENTS;
    public static final int BLC_EDGE_WATCHDOG_INTERVAL;
    public static final int CREATE_STORAGE_CLUSTER_EDGE_WATCHDOG_INTERVAL;
    public static final int RECONFIG_NET_BLC_EDGE_INTERVAL;
    public static final int RECONFIG_NET_ZKONLINE_TIMEOUT;
    public static final long MEMBER_VOLUME_SYNC_UPDATE_FREQ;
    public static final String SYSTEM_WATCHDOG_NAME = "SVA SYSTEM WATCHDOG";
    public static final int SYSTEM_WATCHDOG_KEEP_ALIVE_TIME;
    public static final int SYSTEM_WATCHDOG_KEEP_ALIVE_TICKS;
    public static final int SYSTEM_WATCHDOG_INTERVAL;
    public static final int SYSTEM_WATCHDOG_SLACK;
    public static final int RMI_REGISTRY_PORT;
    public static final int DEFAULT_RMI_CONNECTION_TIMEOUT;
    public static final String FILE_SYSTEM_MONITOR_CONFIG_FILE;
    public static final long DEFAULT_FS_MONITOR_PERIOD = 60000L;
    public static final long FS_CLEANUP_SCRIPT_TIMEOUT;
    public static final int FS_CLEANUP_WATCHDOG_TIMEOUT;
    public static final long CREATE_STORAGE_CLUSTER_TASK_ROLLBACK_TIMEOUT = 120000L;
    public static final long CYCLIC_REBOOT_TIMESPAN_SECONDS;
    public static final int CYCLIC_REBOOT_MAX_COUNT;
    public static final int CRASH_DUMP_AGE_CAUSED_REBOOT = 5;
    public static final int SECONDARY_MEMBER_ZK_ID = -1;
    public static final int MINIMUM_MEMBERS;
    public static final int MAXIMUM_MEMBERS;
    public static final boolean USE_SECONDARY_MEMBERS;
    public static final int MINIMUM_PRIMARY_MEMBERS;
    public static final int MAXIMUM_PRIMARY_MEMBERS;
    public static final long DATABASE_IS_CORRUPT = -1L;
    private static final String ENABLE_SYSTEM_WATCHDOG_PROP_NAME = "sva.enable_system_watchdog";
    public static final boolean ENABLE_SYSTEM_WATCHDOG;
    public static boolean DESTROY_BEFORE_RESTART;
    public static String DB_CREATE_DONE_FILE;
    private static Map<String, String> svaProps;
    private static Properties properties;

    public static void createPath(String path) throws IOException {
        File f = new File(path);
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Problem creating path: " + path);
        }
    }

    public static void deletePath(String path) throws IOException {
        File f = new File(path);
        if (f.exists() && !f.delete()) {
            throw new IOException("Problem deleting path: " + path);
        }
    }

    private static String getenv(String envname, String defaultValue) {
        Map<String, String> env = System.getenv();
        return env.containsKey(envname) ? env.get(envname) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadProperties() {
        if (properties == null) {
            String error = "Failure when reading SVA properties: ";
            properties = new Properties();
            FileReader in = null;
            try {
                in = new FileReader(SvaPropertiesPath);
                properties.load(in);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, error + e.getMessage(), e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            try {
                if (SvaProperties != null) {
                    properties.load(new StringReader(SvaProperties));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, error + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getprop(String name, String defaultValue, boolean save) {
        SvaConstants.loadProperties();
        if (!properties.containsKey(name)) {
            properties.setProperty(name, defaultValue);
            if (save) {
                FileWriter out = null;
                try {
                    out = new FileWriter(SvaPropertiesPath);
                    properties.store(out, null);
                    out.close();
                    out = null;
                }
                catch (IOException e) {
                    System.err.println("Failed to update sva properties: " + e);
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        String value = properties.getProperty(name);
        if (svaProps == null) {
            svaProps = new HashMap<String, String>();
        }
        svaProps.put(name, value);
        return value;
    }

    private static String getprop(String name, String defaultValue) {
        return SvaConstants.getprop(name, defaultValue, false);
    }

    private static Integer getprop(String name, int defaultValue) {
        return Integer.parseInt(SvaConstants.getprop(name, String.valueOf(defaultValue)));
    }

    private static double getprop(String name, double defaultValue) {
        return Double.parseDouble(SvaConstants.getprop(name, String.valueOf(defaultValue)));
    }

    @SuppressWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Keep method for future use")
    private static long getprop(String name, long defaultValue) {
        return Long.parseLong(SvaConstants.getprop(name, String.valueOf(defaultValue)));
    }

    private static Boolean getprop(String name, boolean defaultValue) {
        return Boolean.parseBoolean(SvaConstants.getprop(name, String.valueOf(defaultValue)));
    }

    private static UUID getprop(String name, UUID defaultValue, boolean save) {
        return UUID.fromString(SvaConstants.getprop(name, defaultValue.toString(), save));
    }

    private static UUID getprop(String name, UUID defaultValue) {
        return UUID.fromString(SvaConstants.getprop(name, defaultValue.toString()));
    }

    private static Level getprop(String name, Level defaultValue) {
        return Level.parse(SvaConstants.getprop(name, defaultValue.toString()));
    }

    public static String getOsName() {
        String name = System.getProperty("os.name");
        String msg = "Unable to determine OS name";
        if (name == null) {
            String fsep = System.getProperty("file.separator");
            if (fsep != null && fsep.equals("\\")) {
                name = WINDOWS;
            } else if (fsep != null && fsep.equals("/")) {
                name = LINUX;
            }
        } else if (name.toLowerCase(Locale.ENGLISH).contains(WINDOWS)) {
            name = WINDOWS;
        } else if (name.toLowerCase(Locale.ENGLISH).contains(LINUX)) {
            name = LINUX;
        } else {
            msg = "OS not supported: " + name;
            name = null;
        }
        if (name == null) {
            throw new IllegalArgumentException(msg);
        }
        return name;
    }

    private static String getSvaConfigPath() {
        String confPath = SvaConstants.getenv("SVA_CONFIG_PATH", "");
        if (confPath.isEmpty()) {
            if (IS_PSEUDO_SVA) {
                try {
                    confPath = PseudoSVAPathUtil.getPsvaInstallPath();
                }
                catch (Exception ex) {
                    String errorMessage = "Unable to retrieve SVA Config Path from the configuration file. It must always be present for PseudoSVA.";
                    LOGGER.log(Level.SEVERE, errorMessage, ex);
                    throw new RuntimeException(errorMessage);
                }
            } else {
                String os = SvaConstants.getOsName();
                if (os.contains(LINUX)) {
                    confPath = SvaLinuxDefaultConfigPath;
                } else {
                    throw new RuntimeException("The SVA Configuration path must be set.");
                }
            }
        }
        if (confPath == null || confPath.isEmpty()) {
            throw new RuntimeException("SVA configuration path must be set.");
        }
        return confPath;
    }

    private static String getSvaLogPath() {
        String logPath = SvaConstants.getenv("SVA_LOG_PATH", "");
        if (logPath.isEmpty()) {
            if (IS_PSEUDO_SVA) {
                try {
                    logPath = PseudoSVAPathUtil.getPseudoSvaLogPath();
                }
                catch (Exception ex) {
                    String errorMessage = "Unable to retrieve SVA Log Path from the configuration file. It must always be present for PseudoSVA.";
                    LOGGER.log(Level.SEVERE, errorMessage, ex);
                    throw new RuntimeException(errorMessage);
                }
            } else {
                String os = SvaConstants.getOsName();
                if (os.contains(LINUX)) {
                    logPath = SvaLinuxDefaultLogPath;
                } else {
                    throw new RuntimeException("The SVA Configuration path must be set.");
                }
            }
        }
        if (logPath == null || logPath.isEmpty()) {
            throw new RuntimeException("SVA log path must be set.");
        }
        System.setProperty(DEFAULT_LOGGING_PATH_SYS_PROPERTY, logPath);
        return logPath;
    }

    public static String getZkConfFile() {
        String prefix = "";
        if (IS_PSEUDO_SVA) {
            prefix = SvaConfigPath;
        }
        return SvaConstants.getprop("zk.confFile", prefix + "/etc/zookeeper/zoo.cfg");
    }

    public static String getZkDataDir() {
        String prefix = "";
        if (IS_PSEUDO_SVA) {
            prefix = SvaConfigPath;
        }
        return SvaConstants.getprop("zk.dataDirectory", prefix + "/var/zookeeper");
    }

    private static boolean isPseudoSVA() {
        return Boolean.getBoolean(IS_PSEUDO_SVA_SYS_PROPERTY);
    }

    private static boolean enableSubnetFilter() {
        boolean enable = SvaConstants.getprop(ENABLE_SUBNET_FILTER_SVA_PROPERTY, true);
        System.setProperty(ZK_ENABLE_SUBNET_FILTER_SYS_PROPERTY, Boolean.toString(enable));
        return enable;
    }

    public static long getVcsExecuteMaxOutputSize() {
        long size = SvaConstants.getprop(VCS_EXECUTE_CMD_MAX_OUTPUT_SIZE_PROP_NAME, 0xA00000L);
        return size;
    }

    public static void setVcsExecuteMaxOutputSize(long size) throws Exception {
        SvaConstants.setProp(VCS_EXECUTE_CMD_MAX_OUTPUT_SIZE_PROP_NAME, String.valueOf(size));
    }

    public static void setProp(String name, String value) throws Exception {
        SvaConstants.loadProperties();
        properties.setProperty(name, value);
        SvaConstants.setCachedProperty(name, value);
        SvaConstants.saveProperties();
    }

    private static void setCachedProperty(String name, String value) {
        if (name.endsWith(PSEUDO_SVA_DESTROY_PROPERTY_NAME)) {
            DESTROY_BEFORE_RESTART = Boolean.getBoolean(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveProperties() {
        FileWriter out = null;
        try {
            out = new FileWriter(SvaPropertiesPath);
            properties.store(out, null);
            out.close();
            out = null;
        }
        catch (IOException e) {
            System.err.println("Failed to update Debug properties: " + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String listProperties() {
        return SvaUtilities.listProperties(svaProps, "VSA Properties settable via " + SvaPropertiesPath);
    }

    private static boolean getSystemWatchdogEnabled() {
        if (SvaConstants.isPseudoSVA()) {
            return false;
        }
        return SvaConstants.getprop(ENABLE_SYSTEM_WATCHDOG_PROP_NAME, true);
    }

    static {
        DefaultUUID = ZeroUUID = new UUID(0L, 0L);
        DOMAIN_MESSAGE_UUID = new UUID(0L, 1L);
        BROADCAST_UUID = new UUID(0L, 2L);
        SVA_VIRTUAL_MEMORY_LIMIT_MB = SvaConstants.getprop("sva.virtual_memory_limit_mb", -1);
        USE_XSTREAM = SvaConstants.getprop("use.xstream", false);
        CASSINI_RAID_METADATA_VERSION = SvaConstants.getprop("cassini.raid.metadata.version", "1.0");
        CASSINI_RAID_INITIAL_SYNC = SvaConstants.getprop("cassini.raid.initial.sync", false);
        CASSINI_RAID_TYPE = RaidType.parseRaid(SvaConstants.getprop("cassini.raidType", SAS_DEFAULT_RAID_TYPE));
        CASSINI_FS_TYPE = FileSystemType.parseType(SvaConstants.getprop("cassini.fs.type", FileSystemType.EXT4.toString()));
        CASSINI_FS_BLOCK_SIZE = SvaConstants.getprop("cassini.fs.blockSize", 4096L);
        CASSINI_FS_STRIPE_WIDTH = SvaConstants.getprop("cassini.fs.stripeWidth", 256).intValue();
        ZK_GENERATION_UPDATE_FREQUENCY = SvaConstants.getprop("zk.generationUpdateFrequency", 10).intValue();
        ZK_MASTER_UPDATE_FREQUENCY = SvaConstants.getprop("zk.MasterUpdateFrequency", 10).intValue();
        MAX_ZK_TRANSACTION_LOG_LENGTH = SvaConstants.getprop("zk.maxTransactionLogLength", 100).intValue();
        SVA_ZK_PROPERTIES_FILE = SvaConstants.getprop("zk.propFile", SvaConfigPath + "/zkCfg.properties");
        ZK_CONF_FILE = SvaConstants.getZkConfFile();
        ZK_DATA_DIRECTORY = SvaConstants.getZkDataDir();
        ZK_MYID_FILE = SvaConstants.getprop("zk.myidFile", ZK_DATA_DIRECTORY + "/myid");
        ZK_CACHE_DIRECTORY = SvaConstants.getprop("zk.cacheDir", ZK_DATA_DIRECTORY + "/version-2");
        ZK_CLIENT_PORT = SvaConstants.getprop("zk.clientPort", 4330);
        ZK_SNAP_COUNT = SvaConstants.getprop("zk.snapCount", 10000);
        ZK_MAX_CLIENT_CNXNS = SvaConstants.getprop("zk.maxClientCnxns", 32);
        ZK_INIT_LIMIT = SvaConstants.getprop("zk.initLimit", 5);
        ZK_TICKTIME = SvaConstants.getprop("zk.tickTime", 2000);
        ZK_SYNC_LIMIT = SvaConstants.getprop("zk.syncLimit", 2);
        ZK_PEER_PORT = SvaConstants.getprop("zk.peerPort", 4331);
        ZK_ELECTION_PORT = SvaConstants.getprop("zk.electionPort", 4332);
        ZK_MAX_SNAPSHOT_FILES = SvaConstants.getprop("zk.maxSnapshots", 3);
        ZK_PURGE_FREQUENCY = SvaConstants.getprop("zk.purgeFrequency", 60);
        ZK_CLIENT_SESSION_TIMEOUT = SvaConstants.getprop("zk.clientSessionTimeout", 15000);
        ZK_CLIENT_OFFLINE_TIMEOUT = SvaConstants.getprop("zk.clientOfflineTimeout", 10000);
        ZK_OLD_SESSION_EXPIRE_EXTRA_RETRIES = SvaConstants.getprop("zk.oldSessionExpireExtraRetries", 2);
        MESSAGE_SERVICE_ID = SvaConstants.getprop("id.messageService", UUID.fromString("507fdeaf-1f55-4ddb-ba28-fe03240a9013"));
        HTTPS_PORT = SvaConstants.getprop("https.port", 8443);
        PSVA_HTTPS_PORT = SvaConstants.getprop("psva.https.port", 4336);
        VOLUME_GROUP_MANAGER_BLC_ID = UUID.fromString("bc71e134-131e-4e94-a071-f8c1c58c2afe");
        IFCFG_FILE_DIR = SvaConstants.getprop("platform.ifconfFileDir", "/etc/sysconfig/network");
        IFCFG_FILE_PREFIX = IFCFG_FILE_DIR + "/ifcfg-";
        INTERFACE_MTU = SvaConstants.getprop("platform.interface.MTU", 1500).intValue();
        FRONT_END_INTERFACE = SvaConstants.getprop("net.frontend", "eth0");
        BACK_END_INTERFACE = SvaConstants.getprop("net.backend", "eth1");
        BACK_END_MTU = SvaConstants.getprop("net.backend.mtu", 1500);
        TASK_DEFAULT_TIME_TO_EXPIRE = SvaConstants.getprop("sas.taskDefaultTimeToExpire", 1800000).intValue();
        SAS_MGMT_EVENT_LOG_PATH = SvaConstants.getprop("sas.event.log.path", LogPath + "/management-event.xml");
        FT_MAX_GET_DB_CONTENT_RETRIES = SvaConstants.getprop("ft.MaxGetDbContentRetries", 3);
        FT_MAX_GET_DB_CONTENT_DELAY = SvaConstants.getprop("ft.MaxGetDbContentDelay", 20000);
        PSVA_SUPPORT_DIR = SvaLogPath;
        PSVALOGBUNDLE_NAME = PSVA_SUPPORT_DIR + "/vmvcs.zip";
        WAIT_FOR_DISKS_CREATE_WAIT_TIME = SvaConstants.getprop("sc.createDiskTimeToExpire", 60000).intValue();
        WAIT_FOR_FAIL_BACK_TIME = SvaConstants.getprop("sc.waitForFailBack", 120000).intValue();
        SET_DISK_ONLINE_WAIT_TIME_INITIAL = SvaConstants.getprop("sc.setDiskOnlineTimeToExpireInitial", 10000).intValue();
        SET_DISK_ONLINE_WAIT_TIME_SUBSEQUENT = SvaConstants.getprop("sc.setDiskOnlineTimeToExpireSubsequent", 60000).intValue();
        RESIZE_MEMBER_DISK_WAIT_TIME = SvaConstants.getprop("sc.resizeMemberDiskWaitTime", 240000).intValue();
        RESOURCE_COORDINATOR_ID_LOOKUP_WAIT_TIME = SvaConstants.getprop("sc.resourceCoordinatorIdLookupWaitTime", 10000).intValue();
        SYNC_DELTA_IN_CHUNKS = SvaConstants.getprop("sc.syncDeltaInChunks", 1024).intValue();
        PSEUDOSVA_DOMAIN_ID = SvaConstants.getprop("id.pseudosvaDomain", UUID.randomUUID(), true);
        SVA_DOMAIN_ID = SvaConstants.getprop("id.svaDomain", UUID.randomUUID(), true);
        PLATFORM_COMMAND_TIMEOUT = SvaConstants.getprop("platform.commandTimeout", 15000).intValue();
        PLATFORM_CREATE_DPFILTER_COMMAND_TIMEOUT = SvaConstants.getprop("platform.createDpFilterCommandTimeout", 30000).intValue();
        MEMBER_CREATE_DPFILTER_WATCHDOG_TIMEOUT = SvaConstants.getprop("member.createDpFilterWatchdogTimeout", (int)(PLATFORM_CREATE_DPFILTER_COMMAND_TIMEOUT + 1000L) / 1000);
        PLATFORM_EXPORTFS_COMMAND_TIMEOUT = SvaConstants.getprop("platform.exportfsCommandTimeout", 20000).intValue();
        PLATFORM_ISCSI_COMMAND_TIMEOUT = SvaConstants.getprop("platform.iscsiCommandTimeout", 25000).intValue();
        PLATFORM_PVRESIZE_COMMAND_TIMEOUT = SvaConstants.getprop("platform.pvresizeCommandTimeout", 60000).intValue();
        VOLUME_GROUP_RESIZE_WATCHDOG_TIMEOUT = SvaConstants.getprop("volumeGroup.resizeWatchdogTimeout", (int)(PLATFORM_PVRESIZE_COMMAND_TIMEOUT + 1000L) / 1000);
        PLATFORM_LVCREATE_COMMAND_TIMEOUT = SvaConstants.getprop("platform.lvcreateCommandTimeout", 30000).intValue();
        MEMBER_CREATELV_WATCHDOG_TIMEOUT = SvaConstants.getprop("member.createlvWatchdogTimeout", (int)(PLATFORM_LVCREATE_COMMAND_TIMEOUT + 1000L) / 1000);
        PLATFORM_MKFS_COMMAND_TIMEOUT = SvaConstants.getprop("platform.mkfsCommandTimeout", 300000).intValue();
        MEMBER_CREATEFS_WATCHDOG_TIMEOUT = SvaConstants.getprop("member.createfsWatchdogTimeout", (int)(PLATFORM_MKFS_COMMAND_TIMEOUT + 1000L) / 1000);
        PLATFORM_RESIZEFS_COMMAND_TIMEOUT = SvaConstants.getprop("platform.resizefsCommandTimeout", 0x6DDD00).intValue();
        MEMBER_RESIZEFS_WATCHDOG_TIMEOUT = SvaConstants.getprop("member.resizefsWatchdogTimeout", (int)(PLATFORM_RESIZEFS_COMMAND_TIMEOUT + 1000L) / 1000);
        PLATFORM_TUNE2FS_COMMAND_TIMEOUT = SvaConstants.getprop("platform.command.tune2fs.timeout", 40000).intValue();
        PLATFORM_MOUNT_COMMAND_TIMEOUT = SvaConstants.getprop("platform.mountCommandTimeout", 40000).intValue();
        PLATFORM_MOUNT_WATCHDOG_TIMEOUT = SvaConstants.getprop("platform.mountWatchdogTimeout", (int)(PLATFORM_MOUNT_COMMAND_TIMEOUT / 1000L) + 10);
        PLATFORM_FSCK_COMMAND_TIMEOUT = SvaConstants.getprop("platform.fsckCommandTimeout", 300000).intValue();
        PLATFORM_FSCK_WATCHDOG_TIMEOUT = SvaConstants.getprop("platform.fsckWatchdogTimeout", (int)(PLATFORM_FSCK_COMMAND_TIMEOUT / 1000L) + 10);
        PLATFORM_LONG_FSCK_COMMAND_TIMEOUT = SvaConstants.getprop("platform.longFsckCommandTimeout", 3600000).intValue();
        PLATFORM_LONG_FSCK_WATCHDOG_TIMEOUT = SvaConstants.getprop("platform.longFsckWatchdogTimeout", (int)(PLATFORM_LONG_FSCK_COMMAND_TIMEOUT / 1000L) + 10);
        PLATFORM_UMOUNT_TIMEOUT = SvaConstants.getprop("platform.umountTimeout", 30000).intValue();
        PLATFORM_UMOUNT_WATCHDOG_TIMEOUT = SvaConstants.getprop("platform.umountWatchdogTimeout", (int)(PLATFORM_UMOUNT_TIMEOUT / 1000L) + 10);
        PLATFORM_SVA_SUPPORT_TIMEOUT = SvaConstants.getprop("platform.svaSupportTimeout", 180000).intValue();
        SVA_SUPPORT_WATCHDOG_TIMEOUT = SvaConstants.getprop("member.supportWatchdogTimeout", (int)(PLATFORM_SVA_SUPPORT_TIMEOUT + 1000L) / 1000);
        SVA_MGMT_CLIENT_SERVICE_TIMEOUT = SvaConstants.getprop("sva.ManagementClientService.requestTimeout", 60000).intValue();
        PLATFORM_NASPLUGIND_START_TIMEOUT = SvaConstants.getprop("platform.nasplugindStartTimeout", 20000).intValue();
        PLATFORM_LVM_LOWER_HALF = SvaConstants.getprop("platform.lvm.lowerHalf", "/dev/sdc /dev/sdd /dev/sde /dev/sdf /dev/sdg /dev/sdh /dev/sdi /dev/sdj");
        PLATFORM_LVM_UPPER_HALF = SvaConstants.getprop("platform.lvm.upperHalf", "/dev/sdk /dev/sdl /dev/sdm /dev/sdn /dev/sdo /dev/sdp /dev/sdq /dev/sdr");
        SHUTDOWN_FLUSH_BLOCKDEVS = SvaConstants.getprop("shutdown.flushdevs", "/dev/sda3 /dev/sdb2");
        PLATFORM_RAID_SYNC_SPEED_MIN = SvaConstants.getprop("platform.raid.sync_speed_min", 20000).intValue();
        PLATFORM_RAID_SYNC_SPEED_MAX = SvaConstants.getprop("platform.raid.sync_speed_max", 2000000).intValue();
        PLATFORM_RAID_SYNC_FG_RATIO_MAX = Integer.toString((int)(SvaConstants.getprop("platform.raid.sync_fg_ratio_max", 99.9) * 10.0));
        PLATFORM_RAID_SYNC_FG_RATIO_MIN = Integer.toString((int)(SvaConstants.getprop("platform.raid.sync_fg_ratio_min", 85.0) * 10.0));
        PLATFORM_RAID_BITMAP_CHUNK_SIZE = SvaConstants.getprop("platform.raid.bitmap_chunk_size", 65536);
        PLATFORM_SERVICE_ACTION_RETRIES = SvaConstants.getprop("platform.service.action.retries", 4).intValue();
        PLATFORM_SERVICE_ACTION_RETRY_DELAY = SvaConstants.getprop("platform.service.action.retry.delay", 5000).intValue();
        MKFS_DIRTY_BACKGROUND_RATIO_LOW = SvaConstants.getprop("mkfs.dirty_background_ratio.low", 5).intValue();
        MKFS_DIRTY_RATIO_LOW = SvaConstants.getprop("mkfs.dirty_ratio.low", 5).intValue();
        MKFS_NR_REQUESTS_LOW = SvaConstants.getprop("mkfs.nr_requests.low", 4).intValue();
        MKFS_ISCSI_NR_REQUESTS_LOW = SvaConstants.getprop("mkfs.iscsi.nr_requests.low", 8).intValue();
        MKFS_DIRTY_BACKGROUND_RATIO = SvaConstants.getprop("mkfs.dirty_background_ratio", 10).intValue();
        MKFS_DIRTY_RATIO = SvaConstants.getprop("mkfs.dirty_ratio", 40).intValue();
        MKFS_NR_REQUESTS = SvaConstants.getprop("mkfs.nr_requests", 128).intValue();
        SVA_TARGET_ID = SvaConstants.getprop("iscsi.target.id", 1).intValue();
        SVA_TARGET_LUN = SvaConstants.getprop("iscsi.target.lun", 1).intValue();
        SVA_LUN_ZERO_DEVICE = SvaConstants.getprop("iscsi.target.lunZeroDevice", "/dev/loop0");
        SVA_LUN_ZERO_NAME = SvaConstants.getprop("iscsi.target.lunZeroName", "svaraiddiskLUNZ");
        SVA_SESSION_ID = SvaConstants.getprop("iscsi.initiator.sessionId", 1).intValue();
        ISCSI_SESSION_NOOP_OUT_INTERVAL = SvaConstants.getprop("iscsi.initiator.session.noop_out_interval", 4).intValue();
        ISCSI_SESSION_NOOP_OUT_TIMEOUT = SvaConstants.getprop("iscsi.initiator.session.noop_out_timeout", 4).intValue();
        ISCSI_SESSION_QUEUE_DEPTH = SvaConstants.getprop("iscsi.initiator.session.queue_depth", 64).intValue();
        ISCSI_SESSION_REPLACEMENT_TIMEOUT = SvaConstants.getprop("iscsi.initiator.session.replacement_timeout", 5).intValue();
        ISCSI_FIND_ISCSI_DEVICE_RETRIES = SvaConstants.getprop("iscsi.initiator.find_device_retries", 5).intValue();
        ExportBaseDir = SvaConstants.getprop("export.baseDir", "/exports");
        MAX_MGMT_ADDR_RETRIES = SvaConstants.getprop("sas.maxMgmtAddrRetries", 5).intValue();
        MGMT_ADDR_RETRY_DELAY = SvaConstants.getprop("sas.mgmtAddrRetryDelay", 3000).intValue();
        DPE_MAX_EVENTS = SvaConstants.getprop("dpe.max.events", 10);
        BLC_EDGE_WATCHDOG_INTERVAL = SvaConstants.getprop("blc_edge_watchdog.interval", 30);
        CREATE_STORAGE_CLUSTER_EDGE_WATCHDOG_INTERVAL = SvaConstants.getprop("blc_edge_watchdog.create_storage_cluster.interval", 60);
        RECONFIG_NET_BLC_EDGE_INTERVAL = SvaConstants.getprop("blc_edge_watchdog.reconfig_net_task.interval", BLC_EDGE_WATCHDOG_INTERVAL + 30);
        RECONFIG_NET_ZKONLINE_TIMEOUT = SvaConstants.getprop("reconfig_net_task.zkonline.timeout", 60000);
        MEMBER_VOLUME_SYNC_UPDATE_FREQ = SvaConstants.getprop("member.volume_sync_update_freq_ms", 60000).intValue();
        SYSTEM_WATCHDOG_KEEP_ALIVE_TIME = SvaConstants.getprop("system_watchdog.keep_alive_time", 10);
        SYSTEM_WATCHDOG_KEEP_ALIVE_TICKS = SvaConstants.getprop("system_watchdog.keep_alive_ticks", 3);
        SYSTEM_WATCHDOG_INTERVAL = SvaConstants.getprop("system_watchdog.interval", SYSTEM_WATCHDOG_KEEP_ALIVE_TIME * SYSTEM_WATCHDOG_KEEP_ALIVE_TICKS);
        SYSTEM_WATCHDOG_SLACK = SvaConstants.getprop("system_watchdog.slack", 5);
        RMI_REGISTRY_PORT = SvaConstants.getprop("rmi.registry.port", 4333);
        DEFAULT_RMI_CONNECTION_TIMEOUT = (BLC_EDGE_WATCHDOG_INTERVAL - 5) * 1000;
        FILE_SYSTEM_MONITOR_CONFIG_FILE = SvaConfigPath + "/FsMonitor.xml";
        FS_CLEANUP_SCRIPT_TIMEOUT = SvaConstants.getprop("filesystem.cleanupTimeout", 3600000).intValue();
        FS_CLEANUP_WATCHDOG_TIMEOUT = SvaConstants.getprop("filesystem.cleanupWatchdogTimeout", (int)(FS_CLEANUP_SCRIPT_TIMEOUT + 1000L) / 1000);
        CYCLIC_REBOOT_TIMESPAN_SECONDS = SvaConstants.getprop("sva.cyclicRebootCheck.timespan", 1200).intValue();
        CYCLIC_REBOOT_MAX_COUNT = SvaConstants.getprop("sva.cyclicRebootCheck.maxCount", 5);
        MINIMUM_MEMBERS = SvaConstants.getprop("sva.minimumMembers", 2);
        MAXIMUM_MEMBERS = SvaConstants.getprop("sva.maximumMembers", 3);
        USE_SECONDARY_MEMBERS = SvaConstants.getprop("sva.useSecondaryMembers", false);
        MINIMUM_PRIMARY_MEMBERS = SvaConstants.getprop("sva.minimumPrimaryMembers", 3);
        MAXIMUM_PRIMARY_MEMBERS = SvaConstants.getprop("sva.maximumPrimaryMembers", 3);
        ENABLE_SYSTEM_WATCHDOG = SvaConstants.getSystemWatchdogEnabled();
        DESTROY_BEFORE_RESTART = SvaConstants.getprop(PSEUDO_SVA_DESTROY_PROPERTY_NAME, false);
        DB_CREATE_DONE_FILE = ".vmwarevsa";
        properties = null;
    }
}

