/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractUniqueObject;
import com.vmware.sva.common.NetworkInterface;
import com.vmware.sva.common.SerialFields;
import com.vmware.sva.common.SerialMinorVersion;
import com.vmware.sva.common.StoragePool;
import com.vmware.sva.common.SvaUtilities;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.UUID;

@SerialMinorVersion(value=2)
public class SvaServerInfo
extends AbstractUniqueObject {
    private UUID storageClusterID;
    private boolean primaryMember;
    private boolean maintenanceMode;
    private NetworkInterface managementInterface;
    private NetworkInterface internalInterface;
    private String[] dnsServers;
    private String domainName;
    private String gateway;
    private StoragePool[] storagePools;
    private long totalStorage;
    private long usedStorage;
    private long freeStorage;
    private static final long serialVersionUID = 1L;

    public SvaServerInfo(UUID id, String name, UUID theStorageClusterID, boolean primaryMember, boolean inMaintenanceMode, NetworkInterface theManagementInterface, NetworkInterface theInternalInterface, String[] theDnsServers, String theDomainName, String theGateway, StoragePool[] theStoragePools, long curTotalStorage, long curUsedStorage, long curFreeStorage) {
        super(id, name);
        this.storageClusterID = theStorageClusterID;
        this.primaryMember = primaryMember;
        this.maintenanceMode = inMaintenanceMode;
        this.managementInterface = theManagementInterface;
        this.internalInterface = theInternalInterface;
        this.dnsServers = SvaUtilities.copyArray(theDnsServers);
        this.domainName = theDomainName;
        this.gateway = theGateway;
        this.storagePools = SvaUtilities.copyArray(theStoragePools);
        this.totalStorage = curTotalStorage;
        this.usedStorage = curUsedStorage;
        this.freeStorage = curFreeStorage;
    }

    public SvaServerInfo(SvaServerInfo svaServerInfo) {
        this(svaServerInfo.getId(), svaServerInfo.getName(), svaServerInfo.getStorageClusterId(), svaServerInfo.isPrimaryMember(), svaServerInfo.isMaintenanceMode(), svaServerInfo.getManagementInterface(), svaServerInfo.getInternalInterface(), svaServerInfo.getDnsServers(), svaServerInfo.getDomainName(), svaServerInfo.getGateway(), svaServerInfo.getStoragePools(), svaServerInfo.getTotalStorage(), svaServerInfo.getUsedStorage(), svaServerInfo.getFreeStorage());
    }

    public SvaServerInfo(UUID id, String name) {
        super(id, name);
    }

    public UUID getStorageClusterId() {
        return this.storageClusterID;
    }

    public boolean isPrimaryMember() {
        return this.primaryMember;
    }

    public boolean isMaintenanceMode() {
        return this.maintenanceMode;
    }

    public NetworkInterface getManagementInterface() {
        return this.managementInterface;
    }

    public NetworkInterface getInternalInterface() {
        return this.internalInterface;
    }

    public String[] getDnsServers() {
        return SvaUtilities.copyArray(this.dnsServers);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getGateway() {
        return this.gateway;
    }

    public StoragePool[] getStoragePools() {
        return SvaUtilities.copyArray(this.storagePools);
    }

    public long getTotalStorage() {
        return this.totalStorage;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public long getFreeStorage() {
        return this.freeStorage;
    }

    public void setMaintenanceMode(boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, InvalidClassException {
        SerialFields fields = this.getSerialGeneration().setDefaultFields(this, SvaServerInfo.class, in);
        if (fields != null) {
            switch (fields.getSerialMinorVersion()) {
                case 1: {
                    this.primaryMember = true;
                    break;
                }
                default: {
                    throw new InvalidClassException("Unknown serial minor version " + fields.getSerialMinorVersion() + " for class " + SvaServerInfo.class.getName());
                }
            }
        }
    }
}

