/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.pseudosvadomain;

import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.bld.persistent.AbstractPersistentBld;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.util.PseudoSvaUtility;
import com.vmware.sva.pseudosvadomain.PseudoSvaDefaultBlc;
import com.vmware.sva.pseudosvadomain.PseudoSvaManagementClientService;
import java.util.logging.Level;

public class PseudoSvaDomain
extends AbstractPersistentBld {
    private int tries = 3;
    private int startDelayMS = 200;
    private PseudoSvaManagementClientService mgmtClientService;
    private static final long serialVersionUID = 1L;

    public PseudoSvaDomain() throws Exception {
        super(SvaConstants.PSEUDOSVA_DOMAIN_ID, "PseudoSvaDomain");
        if (!this.isInitialized()) {
            this.setDefaultBlc((AbstractBusinessLogicComponent)new PseudoSvaDefaultBlc());
        }
        this.mgmtClientService = new PseudoSvaManagementClientService((BusinessLogicDomainServiceAPI)this);
    }

    public boolean startDomain() {
        StringBuilder sb = new StringBuilder("SVA Version Info:\n");
        String str = System.getProperty("os.name") == null ? (SvaConstants.getOsName() == null ? "Unknown" : SvaConstants.getOsName()) : System.getProperty("os.name");
        sb.append("OS: " + str);
        str = System.getProperty("os.version");
        if (str != null) {
            sb.append(" " + str);
        }
        if ((str = System.getProperty("os.arch")) != null) {
            sb.append("\nArch: " + str);
        }
        try {
            str = PseudoSvaUtility.getPseudoSvaVersion();
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed to read SVA Version ", e);
            str = "Unknown";
        }
        sb.append("\nSVA Version: " + str);
        this.log(Level.INFO, sb.toString());
        if (super.startDomain()) {
            this.mgmtClientService.enableReceiving();
            return true;
        }
        return false;
    }

    public PseudoSvaManagementClientService getMgmtClientService() {
        return this.mgmtClientService;
    }
}

