/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.database.AbstractDbTable;
import com.vmware.sva.database.VersionDbTable;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.logging.Level;

public class SharedObjectDbTable
extends AbstractDbTable {
    private static final String DB_TABLE_NAME = "SHARED_OBJECT_TABLE";
    private static final String DB_TABLE_COLUMNS = SvaConstants.USE_XSTREAM ? "(name VARCHAR(255), data LONG VARCHAR)" : "(name VARCHAR(255), data BLOB)";

    public SharedObjectDbTable(Connection connection) throws SQLException, BldException {
        super(connection, DB_TABLE_NAME, DB_TABLE_COLUMNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        this.log(Level.FINE, "Validating database table " + this.tableName);
        try {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery("SELECT * FROM \"" + this.tableName + "\"");
                HashSet<String> keySet = new HashSet<String>();
                while (rs.next()) {
                    String key = rs.getString("name");
                    if (keySet.contains(key)) {
                        throw new Exception("Duplicate key \"" + key + "\" found in " + this.tableName);
                    }
                    keySet.add(key);
                    if (SvaConstants.USE_XSTREAM) {
                        BldSerialization.xmlToObject(rs.getString("data"));
                    } else {
                        BldSerialization.bytesToObject(rs.getBytes("data"));
                    }
                    this.log(Level.FINE, "Shared object \"" + key + "\" is valid");
                }
            }
            finally {
                statement.close();
            }
            this.log(Level.FINE, "Database table " + this.tableName + " is valid");
            return true;
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to validate table " + this.tableName, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable getSharedObject(String key) throws Exception {
        try {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery("SELECT data FROM \"" + this.tableName + "\" WHERE name = '" + key + "'");
                if (!rs.next()) {
                    Serializable serializable = null;
                    return serializable;
                }
                Serializable obj = null;
                obj = SvaConstants.USE_XSTREAM ? (Serializable)BldSerialization.xmlToObject(rs.getString("data")) : (Serializable)BldSerialization.bytesToObject(rs.getBytes("data"));
                if (rs.next()) {
                    this.log(Level.SEVERE, "Multiple records found for DB object");
                }
                Serializable serializable = obj;
                return serializable;
            }
            finally {
                statement.close();
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Exception while getting DB object. (key: " + key + ")", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(String key, Serializable obj) throws Exception {
        Statement pstmt = null;
        try {
            if (this.getCount(key) == 0L) {
                pstmt = this.connection.prepareStatement("INSERT INTO \"" + this.tableName + "\" VALUES(?,?)");
                pstmt.setString(1, key);
                this.setPstmtArg((PreparedStatement)pstmt, 2, obj);
            } else {
                pstmt = this.connection.prepareStatement("UPDATE \"" + this.tableName + "\" SET data = ? WHERE name = ?");
                this.setPstmtArg((PreparedStatement)pstmt, 1, obj);
                pstmt.setString(2, key);
            }
            pstmt.execute();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(String key) throws SQLException, BldException {
        if (this.getCount(key) == 0L) {
            this.log(Level.SEVERE, "Attempt to delete a database object that does not exist");
        } else {
            PreparedStatement pstmt = this.connection.prepareStatement("DELETE FROM \"" + this.tableName + "\" WHERE name = ?");
            try {
                pstmt.setString(1, key);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
        }
    }

    @Override
    public void upgrade(VersionDbTable versionTable) throws Exception {
        this.upgradeColumn("data");
    }
}

