/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.faultinsertion;

import com.vmware.sva.faultinsertion.FaultInsertion;
import com.vmware.sva.util.LoggerAdapter;
import com.vmware.sva.util.SystemUtils;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFault {
    protected final String name;
    protected static final String NAME_OPTION = "-name";
    protected final AtomicInteger repeat = new AtomicInteger(0);
    protected final int initialRepeat;
    protected static final int DEFAULT_REPEAT_COUNT = 0;
    protected static final String REPEAT_OPTION = "-repeat";
    protected final AtomicInteger skip = new AtomicInteger(0);
    protected final int initialSkip;
    protected static final int DEFAULT_SKIP_COUNT = 0;
    protected static final String SKIP_OPTION = "-skip";
    protected volatile int delay = 0;
    protected final int initialDelay;
    protected static final int DEFAULT_DELAY = 0;
    protected static final String DELAY_OPTION = "-delay";
    protected volatile boolean reboot = false;
    protected final boolean initialReboot;
    protected static final boolean DEFAULT_REBOOT = false;
    protected static final String REBOOT_OPTION = "-reboot";
    protected static final String NOREBOOT_OPTION = "-noreboot";
    protected static final String ATTRIBUTE_SEPARATOR = " ";
    protected static final Logger logger = Logger.getLogger(FaultInsertion.class.getName());

    public AbstractFault(String name, List<String> attribs) {
        AbstractFault.checkNotNull(name, "name");
        this.name = name;
        try {
            this.set(attribs);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem setting initial attributes", e);
        }
        this.initialRepeat = this.repeat.get();
        this.initialSkip = this.skip.get();
        this.initialDelay = this.delay;
        this.initialReboot = this.reboot;
    }

    protected String getName() {
        return this.name;
    }

    protected int getRepeat() {
        return this.repeat.get();
    }

    protected void setRepeat(int repeatCount) {
        this.repeat.set(repeatCount >= 0 ? repeatCount : 0);
    }

    private int decrementRepeat() {
        int result = this.repeat.decrementAndGet();
        if (result < 0) {
            this.repeat.set(0);
        }
        return result;
    }

    protected int getSkip() {
        return this.skip.get();
    }

    protected void setSkip(int skipCount) {
        this.skip.set(skipCount >= 0 ? skipCount : 0);
    }

    private int decrementSkip() {
        int result = this.skip.decrementAndGet();
        if (result < 0) {
            this.skip.set(0);
        }
        return result;
    }

    protected int getDelay() {
        return this.delay;
    }

    protected void setDelay(int delayInSeconds) {
        this.delay = delayInSeconds >= 0 ? delayInSeconds : 0;
    }

    protected boolean isReboot() {
        return this.reboot;
    }

    protected void setReboot(boolean rebootFlag) {
        this.reboot = rebootFlag;
    }

    protected boolean checkTrigger() {
        int getSkip = this.decrementSkip();
        if (getSkip >= 0) {
            logger.log(Level.INFO, this.name + " skip count decremented to " + getSkip + ". Skipping this fault.");
            return false;
        }
        int repeatCount = this.decrementRepeat();
        if (repeatCount >= 0) {
            logger.log(Level.INFO, this.name + " repeat count decremented to " + repeatCount);
            return true;
        }
        return false;
    }

    protected void doFault() throws Exception {
        int delay = this.getDelay();
        if (delay > 0) {
            logger.log(Level.INFO, this.name + " asked to delay " + delay + " seconds");
            try {
                Thread.sleep((long)delay * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isReboot()) {
            logger.log(Level.INFO, this.name + " requested reboot");
            SystemUtils.reboot(true, null, new LoggerAdapter(logger));
        }
        throw new Exception("Fault Insertion: " + this.name + " fault triggered!");
    }

    protected static void checkNotNull(Object value, String varName) {
        if (value == null) {
            throw new NullPointerException("The " + varName + " must not be null");
        }
    }

    public void clear() {
        this.repeat.set(0);
        this.skip.set(0);
        this.delay = 0;
        this.reboot = false;
    }

    public String list() {
        return this.toString() + ATTRIBUTE_SEPARATOR + NAME_OPTION + ATTRIBUTE_SEPARATOR + this.name;
    }

    public void reset() {
        this.repeat.set(this.initialRepeat);
        this.skip.set(this.initialSkip);
        this.delay = this.initialDelay;
        this.reboot = this.initialReboot;
    }

    public void set(List<String> attribs) throws Exception {
        boolean myReboot = this.reboot;
        int myRepeat = -1;
        int mySkip = -1;
        int myDelay = -1;
        ListIterator<String> it = attribs.listIterator();
        while (it.hasNext()) {
            String element = it.next();
            if (element.equalsIgnoreCase(REPEAT_OPTION)) {
                if (it.hasNext()) {
                    try {
                        element = it.next();
                        myRepeat = Integer.parseInt(element);
                        if (myRepeat >= 0) continue;
                        throw new Exception("Repeat value must be zero or a positive integer.");
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Invalid repeat value '" + element + "'");
                    }
                }
                throw new Exception("No repeat value provided.");
            }
            if (element.equalsIgnoreCase(SKIP_OPTION)) {
                if (it.hasNext()) {
                    try {
                        element = it.next();
                        mySkip = Integer.parseInt(element);
                        if (mySkip >= 0) continue;
                        throw new Exception("Skip value must be zero or a positive integer.");
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Invalid skip value '" + element + "'");
                    }
                }
                throw new Exception("No skip value provided.");
            }
            if (element.equalsIgnoreCase(DELAY_OPTION)) {
                if (it.hasNext()) {
                    try {
                        element = it.next();
                        myDelay = Integer.parseInt(element);
                        if (myDelay >= 0) continue;
                        throw new Exception("Delay value must be zero or a positive integer.");
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Invalid delay value '" + element + "'");
                    }
                }
                throw new Exception("No delay value provided.");
            }
            if (element.equalsIgnoreCase(REBOOT_OPTION)) {
                myReboot = true;
                continue;
            }
            if (element.equalsIgnoreCase(NOREBOOT_OPTION)) {
                myReboot = false;
                continue;
            }
            throw new Exception("Unknown option '" + element + "'");
        }
        if (myRepeat != -1) {
            this.setRepeat(myRepeat);
        }
        if (mySkip != -1) {
            this.setSkip(mySkip);
        }
        if (myDelay != -1) {
            this.setDelay(myDelay);
        }
        this.setReboot(myReboot);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-repeat " + this.repeat.get());
        sb.append(" -skip " + this.skip.get());
        sb.append(" -delay " + this.delay);
        if (this.reboot) {
            sb.append(" -reboot");
        } else {
            sb.append(" -noreboot");
        }
        return sb.toString();
    }
}

