/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.blcevents;

import com.vmware.sva.common.AbstractSerializable;
import com.vmware.sva.common.SvaConstants;
import java.util.UUID;

public final class BlcEventAddressInfo
extends AbstractSerializable {
    private static final long serialVersionUID = 1L;
    private UUID sourceBld;
    private UUID sourceBlc;
    private UUID destinationBld;
    private UUID destinationBlc;

    public BlcEventAddressInfo(UUID sourceBld, UUID sourceBlc, UUID destinationBld, UUID destinationBlc) {
        this.sourceBld = sourceBld;
        this.sourceBlc = sourceBlc;
        this.destinationBld = destinationBld;
        this.destinationBlc = destinationBlc;
        this.validate();
    }

    private void validate() {
        assert (this.sourceBld.compareTo(SvaConstants.BROADCAST_UUID) != 0);
        assert (this.sourceBlc.compareTo(SvaConstants.BROADCAST_UUID) != 0);
        assert (this.destinationBld.compareTo(SvaConstants.DOMAIN_MESSAGE_UUID) != 0);
        assert (this.destinationBlc.compareTo(SvaConstants.DOMAIN_MESSAGE_UUID) != 0);
    }

    public BlcEventAddressInfo constructResponseAddress() {
        assert (this.sourceBld.compareTo(SvaConstants.DOMAIN_MESSAGE_UUID) != 0);
        assert (this.destinationBld.compareTo(SvaConstants.BROADCAST_UUID) != 0);
        return new BlcEventAddressInfo(this.destinationBld, this.destinationBlc, this.sourceBld, this.sourceBlc);
    }

    public UUID getSourceBld() {
        return this.sourceBld;
    }

    public UUID getSourceBlc() {
        return this.sourceBlc;
    }

    public UUID getDestinationBld() {
        return this.destinationBld;
    }

    public UUID getDestinationBlc() {
        return this.destinationBlc;
    }
}

