/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SvaLogFormatter
extends Formatter {
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String lineSeparator = System.getProperty("line.separator");
    private final Date date = new Date();
    private SimpleDateFormat formatter = null;

    @Override
    public synchronized String format(LogRecord record) {
        Object[] parameters;
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatDate(record.getMillis()));
        sb.append(" ");
        sb.append(record.getLevel().getLocalizedName());
        sb.append(" - ");
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
        }
        if ((parameters = record.getParameters()) != null && parameters.length > 0) {
            for (Object object : parameters) {
                if (!(object instanceof UUID)) continue;
                sb.append(" params: [");
                sb.append(object);
                sb.append("]");
                break;
            }
        }
        sb.append(" - ");
        sb.append(record.getMessage());
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    private String formatDate(long milliseconds) {
        if (this.formatter == null) {
            this.formatter = new SimpleDateFormat(dateFormat);
        }
        this.date.setTime(milliseconds);
        return this.formatter.format(this.date);
    }
}

