/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.util;

import com.vmware.sva.common.SerialGeneration;
import com.vmware.sva.common.VersionedSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

@VersionedSerializable
public class BiDirectionalMap<K, V>
extends HashMap<K, V> {
    private final HashMap<V, K> valueKeyMap;
    private transient SerialGeneration serialGeneration = SerialGeneration.getCurrent();
    private static final long serialVersionUID = 1L;

    public BiDirectionalMap() {
        this.valueKeyMap = new HashMap();
    }

    public BiDirectionalMap(int initialCapacity) {
        super(initialCapacity);
        this.valueKeyMap = new HashMap(initialCapacity);
    }

    public BiDirectionalMap(int initialCapacity, int loadFactor) {
        super(initialCapacity, loadFactor);
        this.valueKeyMap = new HashMap(initialCapacity, loadFactor);
    }

    public BiDirectionalMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        super.putAll(map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.valueKeyMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public V put(K key, V value) {
        V oldValue = super.put(key, value);
        this.valueKeyMap.put(value, key);
        return oldValue;
    }

    public K getKey(V value) {
        return this.valueKeyMap.get(value);
    }

    @Override
    public void clear() {
        super.clear();
        this.valueKeyMap.clear();
    }

    @Override
    public V remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            this.valueKeyMap.remove(value);
        }
        return value;
    }

    public K removeValue(Object value) {
        K key = this.valueKeyMap.remove(value);
        if (key != null) {
            super.remove(key);
        }
        return key;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueKeyMap.containsValue(value);
    }

    protected SerialGeneration getSerialGeneration() {
        return this.serialGeneration;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerialGeneration.writeCurrent((ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.serialGeneration = SerialGeneration.read((ObjectInputStream)in);
    }
}

