/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkservice;

import com.vmware.sva.bld.AbstractBldEvent;
import com.vmware.sva.bld.BldEventWatcher;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.common.SvaVersion;
import com.vmware.sva.zkservice.BldReplicaEvent;
import com.vmware.sva.zkservice.BldSvaVersionChangeEvent;
import com.vmware.sva.zkservice.ZkClient;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZkUpgradeClient
implements BldEventWatcher {
    private static final UUID UPGRADE_DOMAIN_ID = UUID.fromString("d5ebceab-4cd7-4dee-81e1-c436a634a362");
    private static final String UPGRADE_DOMAIN_NAME = "Upgrade ZooKeeper Data";
    private static final Logger logger = Logger.getLogger(ZkUpgradeClient.class.getName());
    private final ZkClient zk;
    private CompletionHandler completionHandler;
    private boolean master = false;

    public static void maybeUpgrade(CompletionHandler completionHandler, boolean primaryMember, List<String> zkServerAddresses) {
        if (completionHandler == null) {
            throw new NullPointerException("The completionHandler must not be null");
        }
        new ZkUpgradeClient(completionHandler, primaryMember, zkServerAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZkUpgradeClient(CompletionHandler completionHandler, boolean primaryMember, List<String> zkServerAddresses) {
        this.zk = primaryMember ? new ZkClient(SvaConstants.SVA_DOMAIN_ID, UPGRADE_DOMAIN_ID, UPGRADE_DOMAIN_NAME) : new ZkClient(SvaConstants.SVA_DOMAIN_ID, UPGRADE_DOMAIN_ID, UPGRADE_DOMAIN_NAME, zkServerAddresses);
        try {
            ZkClient zkClient = this.zk;
            synchronized (zkClient) {
                this.completionHandler = completionHandler;
                this.zk.registerReplicaOnline(this);
            }
        }
        catch (Throwable e) {
            try {
                this.zk.close();
            }
            catch (InterruptedException ie) {
                assert (false) : "Unable to close ZooKeeper client: " + ie;
                logger.log(Level.SEVERE, "Unable to close ZooKeeper client", ie);
            }
            logger.log(Level.SEVERE, "Unexpected exception", e);
            completionHandler.completed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBldEvent(AbstractBldEvent event) {
        ZkClient zkClient = this.zk;
        synchronized (zkClient) {
            if (this.completionHandler == null) {
                return;
            }
            try {
                if (event instanceof BldReplicaEvent) {
                    this.handleBldReplicaEvent((BldReplicaEvent)event);
                } else if (event instanceof BldSvaVersionChangeEvent) {
                    this.handleBldSvaVersionChangeEvent();
                } else {
                    logger.log(Level.SEVERE, "Unexpected BldEvent: " + event);
                }
            }
            catch (Throwable e) {
                this.completed(e);
            }
        }
    }

    private void handleBldReplicaEvent(BldReplicaEvent event) throws Exception {
        assert (Thread.holdsLock(this.zk));
        logger.log(Level.FINE, "handleBldReplicaEvent online: " + event.getOnline() + ", master: " + event.getMaster());
        if (event.getOnline()) {
            this.master = event.getMaster();
            String zkVersion = this.zk.getSvaVersion(this);
            if (this.svaVersionUpToDate(zkVersion) && !SvaDebug.FORCE_UPGRADE) {
                logger.log(Level.INFO, "Version up to date: " + zkVersion);
                this.completed(null);
            } else {
                logger.log(Level.INFO, "Version is out of date: " + zkVersion);
                if (!this.master) {
                    logger.log(Level.INFO, "Waiting for master to perform upgrade");
                } else {
                    logger.log(Level.INFO, "Performing upgrade");
                    new UpgradeZkDataThread().start();
                }
            }
        }
    }

    private void handleBldSvaVersionChangeEvent() throws Exception {
        assert (Thread.holdsLock(this.zk));
        String zkVersion = this.zk.getSvaVersion();
        if (this.completionHandler == null) {
            return;
        }
        if (this.svaVersionUpToDate(zkVersion)) {
            logger.log(Level.INFO, "Version has been updated: " + zkVersion);
            this.completed(null);
        }
    }

    private boolean svaVersionUpToDate(String zkVersion) throws Exception {
        String currentVersion = SvaVersion.getVersion();
        int compare = SvaVersion.compareVersions((String)zkVersion, (String)currentVersion);
        if (compare == 0) {
            return true;
        }
        if (compare < 0) {
            return false;
        }
        String message = "Attempt to downgrade ZooKeeper data from version " + zkVersion + " to version " + currentVersion + " -- node may need to be replaced";
        logger.log(Level.SEVERE, message);
        throw new Exception(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completed(Throwable exception) {
        ZkClient zkClient = this.zk;
        synchronized (zkClient) {
            if (this.completionHandler != null) {
                CompletionHandler ch;
                block7: {
                    ch = this.completionHandler;
                    this.completionHandler = null;
                    try {
                        this.zk.close();
                    }
                    catch (Exception e) {
                        if (exception != null) break block7;
                        exception = e;
                    }
                }
                if (exception != null) {
                    logger.log(Level.SEVERE, "Unexpected exception", exception);
                }
                ch.completed(exception);
            }
        }
    }

    private class UpgradeZkDataThread
    extends Thread {
        UpgradeZkDataThread() {
            super(ZkUpgradeClient.UPGRADE_DOMAIN_NAME);
        }

        @Override
        public void run() {
            try {
                ZkUpgradeClient.this.zk.upgrade();
                ZkUpgradeClient.this.completed(null);
            }
            catch (Throwable e) {
                ZkUpgradeClient.this.completed(e);
            }
        }
    }

    public static interface CompletionHandler {
        public void completed(Throwable var1);
    }
}

