/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkservice;

import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.zkservice.SeqZnode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperWrapper {
    private final ZooKeeper zk;
    private final Object waiter;
    private long notifyCnt;
    private boolean retryOnConnectionLoss;
    protected static final Logger logger = Logger.getLogger(ZooKeeperWrapper.class.getName());

    public ZooKeeperWrapper(String connectString, int sessionTimeout, Watcher watcher, boolean retryOnConnectionLoss, Object waiter) throws IOException {
        this.retryOnConnectionLoss = retryOnConnectionLoss;
        this.zk = new ZooKeeper(connectString, sessionTimeout, watcher);
        this.waiter = waiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        assert (Thread.holdsLock(this.waiter));
        try {
            this.zk.close();
        }
        finally {
            this.stop();
        }
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        assert (Thread.holdsLock(this.waiter));
        this.zk.sync(path, cb, ctx);
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        assert (Thread.holdsLock(this.waiter));
        List l = null;
        int retryCnt = 1;
        logger.log(Level.FINE, "Received request: getChildren " + path);
        while (true) {
            long cnt = this.getNotifyCount();
            try {
                l = this.zk.getChildren(path, watch);
            }
            catch (KeeperException ke) {
                if (ke.code() == KeeperException.Code.CONNECTIONLOSS) {
                    if (!this.waitForOnline(cnt)) {
                        throw ke;
                    }
                    logger.log(Level.INFO, "Retrying getChildren " + path + "attempt " + ++retryCnt);
                    continue;
                }
                throw ke;
            }
            break;
        }
        logger.log(Level.FINE, "Exiting: getChildren " + path);
        return l;
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        assert (Thread.holdsLock(this.waiter));
        Stat stat = null;
        int retryCnt = 1;
        logger.log(Level.FINE, "Received request: exists " + path);
        while (true) {
            long cnt = this.getNotifyCount();
            try {
                stat = this.zk.exists(path, watch);
            }
            catch (KeeperException ke) {
                if (ke.code() == KeeperException.Code.CONNECTIONLOSS) {
                    if (!this.waitForOnline(cnt)) {
                        throw ke;
                    }
                    logger.log(Level.INFO, "Retrying exists " + path + "attempt " + ++retryCnt);
                    continue;
                }
                throw ke;
            }
            break;
        }
        logger.log(Level.FINE, "Exiting: exists " + path);
        return stat;
    }

    public byte[] getData(boolean isZnodeSequential, String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        assert (Thread.holdsLock(this.waiter));
        return this.getData(isZnodeSequential, path, watch, null, stat, new SeqZnode());
    }

    private byte[] getData(boolean isZnodeSequential, String path, boolean watch, Watcher watcher, Stat stat, SeqZnode zOut) throws KeeperException, InterruptedException {
        logger.log(Level.FINE, "Received request: getData " + path);
        byte[] dataBytes = null;
        int retryCnt = 1;
        while (true) {
            long cnt = this.getNotifyCount();
            try {
                SeqZnode z;
                dataBytes = watcher != null ? this.zk.getData(path, watcher, stat) : this.zk.getData(path, watch, stat);
                if (!isZnodeSequential) break;
                try {
                    z = (SeqZnode)((Object)BldSerialization.bytesToObject(dataBytes));
                    if (zOut != null) {
                        zOut.setZnodeID(z.getZnodeID());
                    }
                }
                catch (Exception e) {
                    throw new InterruptedException("Unable to deserialize data" + e.getMessage());
                }
                logger.log(Level.INFO, "For " + path + " Stripping UUID " + z.getZnodeID());
                dataBytes = z.getData();
            }
            catch (KeeperException ke) {
                if (ke.code() == KeeperException.Code.CONNECTIONLOSS) {
                    if (!this.waitForOnline(cnt)) {
                        throw ke;
                    }
                    logger.log(Level.INFO, "Retrying getData " + path + "attempt " + ++retryCnt);
                    continue;
                }
                throw ke;
            }
            break;
        }
        logger.log(Level.FINE, "Exiting: getData " + path);
        return dataBytes;
    }

    public byte[] getData(boolean isZnodeSequential, String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        assert (Thread.holdsLock(this.waiter));
        return this.getData(isZnodeSequential, path, true, watcher, stat, new SeqZnode());
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        assert (Thread.holdsLock(this.waiter));
        String seqPath = null;
        int retryCnt = 1;
        SeqZnode z = new SeqZnode();
        byte[] dataBytes = data;
        if (createMode.isSequential()) {
            z = new SeqZnode(data);
            try {
                dataBytes = BldSerialization.objectToBytes((Object)z);
            }
            catch (Exception e) {
                throw new InterruptedException("Unable to serialize data " + e.getMessage());
            }
            logger.log(Level.FINE, "Prepending UUID " + z.getZnodeID() + " to " + path);
        }
        logger.log(Level.FINE, "Received request: create " + path);
        while (true) {
            long cnt = this.getNotifyCount();
            try {
                seqPath = this.zk.create(path, dataBytes, acl, createMode);
            }
            catch (KeeperException ke) {
                if (ke.code() == KeeperException.Code.CONNECTIONLOSS) {
                    if (this.waitForOnline(cnt)) {
                        seqPath = this.getPathifPresent(createMode.isSequential(), path, z.getZnodeID());
                        if (seqPath != null) break;
                        logger.log(Level.INFO, "Retrying create " + path + " attempt " + ++retryCnt);
                        continue;
                    }
                    throw ke;
                }
                throw ke;
            }
            break;
        }
        logger.log(Level.FINE, "Exiting: create " + path);
        return seqPath;
    }

    public void delete(String path, int version) throws InterruptedException, KeeperException {
        assert (Thread.holdsLock(this.waiter));
        boolean retrying = false;
        int retryCnt = 1;
        logger.log(Level.FINE, "Received request: delete " + path);
        while (true) {
            long cnt = this.getNotifyCount();
            try {
                this.zk.delete(path, version);
            }
            catch (KeeperException ke) {
                if (ke.code() == KeeperException.Code.NONODE && retrying) {
                    logger.log(Level.INFO, "znode deleted in previous attempt " + path);
                    break;
                }
                if (ke.code() == KeeperException.Code.CONNECTIONLOSS) {
                    if (!this.waitForOnline(cnt)) {
                        throw ke;
                    }
                    retrying = true;
                    logger.log(Level.FINE, "Received request: delete " + path + " attempt " + ++retryCnt);
                    continue;
                }
                throw ke;
            }
            break;
        }
        logger.log(Level.FINE, "Exiting: delete " + path);
    }

    public long getSessionId() {
        assert (Thread.holdsLock(this.waiter));
        return this.zk.getSessionId();
    }

    public Stat setData(boolean isZnodeSequential, String path, byte[] data, int version) throws KeeperException, InterruptedException {
        assert (Thread.holdsLock(this.waiter));
        Stat stat = null;
        int retryCnt = 1;
        logger.log(Level.FINE, "Received request: setData " + path);
        while (true) {
            byte[] dataBytes = data;
            if (isZnodeSequential) {
                SeqZnode z = new SeqZnode(data);
                try {
                    dataBytes = BldSerialization.objectToBytes((Object)z);
                }
                catch (IOException e) {
                    throw new InterruptedException("Unable to serialize data " + e.getMessage());
                }
            }
            long cnt = this.getNotifyCount();
            try {
                stat = this.zk.setData(path, dataBytes, version);
            }
            catch (KeeperException ke) {
                if (ke.code() == KeeperException.Code.CONNECTIONLOSS) {
                    if (!this.waitForOnline(cnt)) {
                        throw ke;
                    }
                    logger.log(Level.FINE, "Received request: setData " + path + " attempt " + ++retryCnt);
                    continue;
                }
                throw ke;
            }
            break;
        }
        logger.log(Level.FINE, "Exiting: setData " + path);
        return stat;
    }

    public boolean upgrade(String path) throws ClassNotFoundException, IOException, InterruptedException, KeeperException {
        assert (Thread.holdsLock(this.waiter));
        logger.log(Level.FINE, "Received request: upgrade " + path);
        byte[] data = this.getData(false, path, false, null);
        boolean result = false;
        if (data != null && data.length > 0) {
            Object object = BldSerialization.bytesToObject(data);
            if (object instanceof SeqZnode) {
                SeqZnode seqZnode = (SeqZnode)((Object)object);
                Object innerObject = BldSerialization.bytesToObject(seqZnode.getData());
                object = new SeqZnode(BldSerialization.objectToBytes(innerObject));
            }
            byte[] newData = BldSerialization.objectToBytes(object);
            if (SvaDebug.FORCE_UPGRADE || !Arrays.equals(data, newData)) {
                this.setData(false, path, newData, -1);
                result = true;
            }
        }
        logger.log(Level.FINE, "Exiting upgrade " + path + ": " + result);
        return result;
    }

    private boolean waitForOnline(long oldNotifyCnt) throws InterruptedException {
        logger.log(Level.INFO, "About to wait with " + oldNotifyCnt + " getNotifyCount=" + this.getNotifyCount());
        while (this.retryOnConnectionLoss && this.getNotifyCount() == oldNotifyCnt) {
            this.waiter.wait();
        }
        logger.log(Level.INFO, "Leaving with " + this.getNotifyCount() + " retry? " + this.retryOnConnectionLoss);
        return this.retryOnConnectionLoss;
    }

    private long getNotifyCount() {
        return this.notifyCnt;
    }

    public void wakeup() {
        assert (Thread.holdsLock(this.waiter));
        ++this.notifyCnt;
        this.waiter.notifyAll();
        logger.log(Level.INFO, "exiting  wakeup getNotifyCount = " + this.getNotifyCount());
    }

    public void stop() {
        assert (Thread.holdsLock(this.waiter));
        this.retryOnConnectionLoss = false;
        this.wakeup();
    }

    private String getPathifPresent(boolean sequential, String path, UUID znodeID) throws KeeperException, InterruptedException {
        logger.log(Level.INFO, "Checking for " + path);
        String retStr = null;
        this.sync("/", null, null);
        if (sequential) {
            int lastSlash = path.lastIndexOf("/");
            String parentZnode = path;
            if (lastSlash > 0) {
                parentZnode = path.substring(0, lastSlash);
            }
            List<String> children = this.getChildren(parentZnode, false);
            Collections.sort(children, Collections.reverseOrder());
            for (String child : children) {
                Stat stat = new Stat();
                String childZnode = parentZnode + "/" + child;
                SeqZnode z = new SeqZnode();
                byte[] dataBytes = this.getData(sequential, childZnode, false, null, stat, z);
                logger.log(Level.INFO, "Checking for child : " + childZnode + " need " + znodeID + " got" + z.getZnodeID());
                if (dataBytes == null || z == null || !z.getZnodeID().equals(znodeID)) continue;
                logger.log(Level.INFO, "UUID matched for child : " + childZnode);
                retStr = childZnode;
                break;
            }
        } else if (this.exists(path, false) != null) {
            logger.log(Level.INFO, "Matched child : " + path);
            retStr = path;
        }
        return retStr;
    }
}

