/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.ws;

import com.vmware.sva.messaging.ws.model.IPv4Address;
import com.vmware.sva.messaging.ws.model.NetConfigProtocol;
import com.vmware.sva.messaging.ws.model.PingResult;
import com.vmware.sva.messaging.ws.model.Volume;
import com.vmware.sva.messaging.ws.model.exceptions.SvaNotMemberOfClusterException;
import com.vmware.sva.messaging.ws.model.mgmtevents.MemberOnlineEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConverterUtil {
    private static final Log log = LogFactory.getLog(ConverterUtil.class);
    private static final String commonPackagePrefix = "com.vmware.sva.common";
    private static final String modelPackagePrefix = "com.vmware.sva.messaging.ws.model";
    private static final String commonPackageArrayPrefix = "[Lcom.vmware.sva.common";
    private static final String modelPackageArrayPrefix = "[Lcom.vmware.sva.messaging.ws.model";

    public static Object convert(Object obj, Class<?> toClass) {
        if (obj == null) {
            return null;
        }
        Class<?> fromClass = obj.getClass();
        toClass = ConverterUtil.resolveToClass(fromClass, toClass);
        Object newObj = ConverterUtil.convertCollection(obj, toClass);
        if (newObj != null) {
            return newObj;
        }
        newObj = ConverterUtil.convertSimpleType(obj, toClass);
        if (newObj != null) {
            return newObj;
        }
        try {
            BeanInfo from = Introspector.getBeanInfo(obj.getClass());
            BeanInfo to = Introspector.getBeanInfo(toClass);
            PropertyDescriptor[] fromProps = from.getPropertyDescriptors();
            PropertyDescriptor[] toProps = to.getPropertyDescriptors();
            newObj = toClass.newInstance();
            block2: for (PropertyDescriptor toProp : toProps) {
                String toPropName = toProp.getName();
                if (toPropName.equals("class")) continue;
                Class<?> toClz = toProp.getPropertyType();
                Method writeMethod = toProp.getWriteMethod();
                if (writeMethod != null) {
                    for (PropertyDescriptor fromProp : fromProps) {
                        if (!fromProp.getName().equals(toPropName)) continue;
                        Object value = fromProp.getReadMethod().invoke(obj, (Object[])null);
                        if (value == null) continue block2;
                        writeMethod.invoke(newObj, ConverterUtil.convert(value, toClz));
                        continue block2;
                    }
                    continue;
                }
                log.warn((Object)("No setter for " + toPropName + "  of " + toClass.getName()));
            }
        }
        catch (Exception e) {
            log.error((Object)("failed to convert type: " + obj.getClass()), (Throwable)e);
            throw new RuntimeException("failed to convert type: " + obj.getClass(), e);
        }
        return newObj;
    }

    private static Class<?> resolveToClass(Class<?> fromClass, Class<?> toClass) {
        if (toClass != null && (toClass.isArray() || Collection.class.isAssignableFrom(toClass))) {
            if (List.class.isAssignableFrom(toClass)) {
                return ArrayList.class;
            }
            return toClass;
        }
        if (fromClass == IPv4Address.class) {
            return InetAddress.class;
        }
        if (InetAddress.class.isAssignableFrom(fromClass)) {
            return IPv4Address.class;
        }
        String fromClassName = fromClass.getCanonicalName();
        String toClassName = null;
        if (fromClassName.startsWith(commonPackagePrefix)) {
            toClassName = modelPackagePrefix + fromClassName.substring(commonPackagePrefix.length());
        } else if (fromClassName.startsWith(modelPackagePrefix)) {
            toClassName = commonPackagePrefix + fromClassName.substring(modelPackagePrefix.length());
        } else if (fromClassName.startsWith(commonPackageArrayPrefix)) {
            toClassName = modelPackageArrayPrefix + fromClassName.substring(commonPackageArrayPrefix.length());
        } else if (fromClassName.startsWith(modelPackageArrayPrefix)) {
            toClassName = commonPackageArrayPrefix + fromClassName.substring(modelPackageArrayPrefix.length());
        } else if (toClass != null) {
            return toClass;
        }
        if (toClassName == null) {
            return fromClass;
        }
        try {
            return Class.forName(toClassName);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("ClassNotFoundException " + e.getMessage()));
            throw new RuntimeException("Failed to resolve class type for " + fromClassName, e);
        }
    }

    private static Class<?> getComponentType(Class<?> baseClass) {
        if (baseClass.isArray()) {
            return baseClass.getComponentType();
        }
        if (List.class.isAssignableFrom(baseClass)) {
            return ArrayList.class;
        }
        return null;
    }

    private static Object convertCollection(Object obj, Class<?> toClass) {
        if (obj == null) {
            return null;
        }
        Class<?> fromClass = obj.getClass();
        Object[] array = null;
        int length = 0;
        if (fromClass.isArray()) {
            length = Array.getLength(obj);
            array = new Object[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.get(obj, i);
            }
        } else if (Collection.class.isAssignableFrom(fromClass)) {
            length = ((Collection)obj).size();
            array = ((Collection)obj).toArray();
        } else {
            return null;
        }
        Object retval = null;
        Class<?> componentType = ConverterUtil.getComponentType(toClass);
        if (toClass.isArray()) {
            Object[] newArray = (Object[])Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                newArray[i] = ConverterUtil.convert(array[i], componentType);
            }
            retval = newArray;
        } else if (Collection.class.isAssignableFrom(toClass)) {
            try {
                Collection col = (Collection)toClass.newInstance();
                for (int i = 0; i < length; ++i) {
                    col.add(ConverterUtil.convert(array[i], null));
                }
                retval = col;
            }
            catch (Exception e) {
                String msg = "Failed to create collection type : " + toClass.getName();
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        return retval;
    }

    private static Object convertSimpleType(Object obj, Class<?> toClass) {
        Class<?> fromClass = obj.getClass();
        if (fromClass == toClass || toClass.isPrimitive()) {
            return obj;
        }
        Object newObj = null;
        if (toClass == String.class) {
            newObj = Enum.class.isAssignableFrom(fromClass) ? ((Enum)obj).name() : obj.toString();
        } else if (Enum.class.isAssignableFrom(fromClass)) {
            String factory = toClass.getCanonicalName() + "$Factory";
            try {
                Class<?> factoryClz = Class.forName(factory);
                Method m = factoryClz.getMethod("fromValue", String.class);
                newObj = m.invoke(null, obj.toString());
            }
            catch (Exception e) {
                log.error((Object)"convertSimpleType", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else if (Enum.class.isAssignableFrom(toClass)) {
            newObj = Enum.valueOf(toClass, obj.toString());
        } else if (toClass == UUID.class) {
            newObj = UUID.fromString(obj.toString());
        } else if (InetAddress.class.isAssignableFrom(toClass) && fromClass == IPv4Address.class) {
            try {
                newObj = InetAddress.getByName(((IPv4Address)obj).getIPAddress());
            }
            catch (UnknownHostException e) {
                log.error((Object)"failed to create InetAddress", (Throwable)e);
            }
        } else if (InetAddress.class.isAssignableFrom(fromClass) && toClass == IPv4Address.class) {
            IPv4Address addr = new IPv4Address();
            addr.setIPAddress(((InetAddress)obj).getHostAddress());
            newObj = addr;
        }
        return newObj;
    }

    public static void main(String[] args) throws UnknownHostException {
        Object o = ConverterUtil.convert(InetAddress.getByName("10.10.10.1"), null);
        log.info((Object)ConverterUtil.convert(o, null).toString());
        com.vmware.sva.common.PingResult res1 = new com.vmware.sva.common.PingResult("layer 1 message 1");
        com.vmware.sva.common.PingResult res21 = new com.vmware.sva.common.PingResult("layer 2 message 1");
        com.vmware.sva.common.PingResult res22 = new com.vmware.sva.common.PingResult("layer 2 message 2");
        com.vmware.sva.common.PingResult res31 = new com.vmware.sva.common.PingResult("layer 3 message 1");
        com.vmware.sva.common.PingResult res32 = new com.vmware.sva.common.PingResult("layer 3 message 2");
        res1.addLayerResponse(res21);
        res1.addLayerResponse(res22);
        res21.addLayerResponse(res31);
        res22.addLayerResponse(res32);
        PingResult ps = (PingResult)ConverterUtil.convert(res1, null);
        log.info((Object)ps.getMessage());
        for (PingResult r : ps.getLayerResponses()) {
            log.info((Object)("   " + r.getMessage()));
            for (PingResult r1 : r.getLayerResponses()) {
                log.info((Object)("      " + r1.getMessage()));
            }
        }
        com.vmware.sva.common.NetConfigProtocol ncp = com.vmware.sva.common.NetConfigProtocol.BOOTP;
        NetConfigProtocol wsncp = (NetConfigProtocol)ConverterUtil.convert(ncp, null);
        log.info((Object)("ws NetConfigProtocol: " + wsncp.getValue()));
        ncp = (com.vmware.sva.common.NetConfigProtocol)ConverterUtil.convert(wsncp, null);
        log.info((Object)("common NetConfigProtocol: " + ncp.toString()));
        com.vmware.sva.common.mgmtevents.MemberOnlineEvent on = new com.vmware.sva.common.mgmtevents.MemberOnlineEvent(UUID.randomUUID(), UUID.randomUUID(), null, true);
        MemberOnlineEvent mgon = (MemberOnlineEvent)ConverterUtil.convert(on, null);
        log.info((Object)("MemberOnlineEvent : " + mgon.getBlcId()));
        com.vmware.sva.common.exceptions.SvaNotMemberOfClusterException ex = new com.vmware.sva.common.exceptions.SvaNotMemberOfClusterException(UUID.randomUUID());
        SvaNotMemberOfClusterException notex = (SvaNotMemberOfClusterException)ConverterUtil.convert(ex, null);
        log.info((Object)("SvaNotMemberOfClusterException : " + notex.getMessage()));
        com.vmware.sva.common.Volume vol = new com.vmware.sva.common.Volume();
        vol.setSyncPercent(Float.valueOf(0.3f));
        vol.setSize(300L);
        Volume volume = (Volume)ConverterUtil.convert(vol, null);
        log.info((Object)("volume : syncPercent = " + volume.getSyncPercent()));
    }
}

