/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.jms;

import com.vmware.sva.messaging.messages.BaseMessage;
import com.vmware.sva.messaging.ws.model.Disk;
import com.vmware.sva.messaging.ws.model.NFSv3Export;
import com.vmware.sva.messaging.ws.model.NFSv3StorageEntity;
import com.vmware.sva.messaging.ws.model.Volume;
import com.vmware.sva.messaging.ws.model.mgmtevents.AbstractManagementEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.AbstractSasTaskManagementEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.CreateStorageClusterTaskCompletedEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.CreateStorageClusterTaskFailedEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.FileSystemExceededThresholdEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.FileSystemRecededBelowThresholdEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.MemberOfflineEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.MemberOnlineEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.NewMasterElectionEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.StorageEntityHealthEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.SvaShutdownEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.VolumeSyncCompletedEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.VolumeSyncProgressEvent;
import com.vmware.sva.messaging.ws.model.mgmtevents.VolumeSyncStartEvent;
import com.vmware.sva.webservice.SvaWebserviceInterfaceCli;
import java.lang.reflect.Method;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ManagementClientEventListener
implements MessageListener,
Runnable {
    private String brokerUrl = "";
    private final String user;
    private final String password;

    public ManagementClientEventListener(String brokerIp, String user, String password) {
        this.brokerUrl = "tcp://" + brokerIp + ":" + "4335";
        this.user = user;
        this.password = password;
        this.run();
    }

    @Override
    public void run() {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.user, this.password, this.brokerUrl);
        try {
            Connection conn1 = factory.createConnection();
            conn1.start();
            Session session1 = conn1.createSession(false, 1);
            Topic clusterTopic = session1.createTopic("cluster.topic");
            MessageConsumer clusConsumer = session1.createConsumer(clusterTopic);
            clusConsumer.setMessageListener(this);
            Connection conn2 = factory.createConnection();
            conn2.start();
            Session session2 = conn2.createSession(false, 1);
            Topic nodeTopic = session2.createTopic("node.topic");
            MessageConsumer nodeConsumer = session2.createConsumer(nodeTopic);
            nodeConsumer.setMessageListener(this);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMessage(Message msg) {
        try {
            if (msg instanceof ObjectMessage) {
                Method method;
                BaseMessage obj = (BaseMessage)((ObjectMessage)msg).getObject();
                AbstractManagementEvent event = obj.getEvent();
                System.out.println("\nMessage Id: " + event.getBlcId());
                System.out.println("\tMessage Type: " + event.getClass().getSimpleName());
                if (obj.isTask()) {
                    System.out.println("\t\tTask Id: " + ((AbstractSasTaskManagementEvent)event).getTaskId());
                }
                if (event instanceof StorageEntityHealthEvent) {
                    this.printStorageEntityEvent(event);
                } else if (event instanceof NewMasterElectionEvent) {
                    this.printNewMasterElectionEvent((NewMasterElectionEvent)event);
                } else if (event instanceof MemberOfflineEvent) {
                    this.printMemeberEvent(event, false);
                } else if (event instanceof MemberOnlineEvent) {
                    this.printMemeberEvent(event, true);
                } else if (event instanceof VolumeSyncProgressEvent || event instanceof VolumeSyncStartEvent || event instanceof VolumeSyncCompletedEvent) {
                    this.printVolumeSyncEvent(event);
                } else if (event instanceof SvaShutdownEvent) {
                    SvaWebserviceInterfaceCli.printSvaServerInfo(((SvaShutdownEvent)event).getSvaServerInfo());
                }
                if (obj.isProgress() && (method = event.getClass().getMethod("getProgress", new Class[0])) != null) {
                    System.out.println("\t\tTask Progress: " + method.invoke((Object)event, new Object[0]));
                }
                System.out.println("\tMessage Description: " + obj.getDescription());
                System.out.println();
                if (event instanceof CreateStorageClusterTaskCompletedEvent) {
                    SvaWebserviceInterfaceCli.validateCluster();
                    System.exit(0);
                } else if (event instanceof CreateStorageClusterTaskFailedEvent) {
                    System.exit(-1);
                } else if (event instanceof FileSystemExceededThresholdEvent) {
                    this.printFileSystemExceededThresholdEvent((FileSystemExceededThresholdEvent)event);
                } else if (event instanceof FileSystemRecededBelowThresholdEvent) {
                    this.printFileSystemRecededBelowThresholdEvent((FileSystemRecededBelowThresholdEvent)event);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printNewMasterElectionEvent(NewMasterElectionEvent event) {
        System.out.println("\tStorage Cluster ID:\t" + event.getStorageClusterId());
        System.out.println("\tNew Master SVA ID:\t" + event.getNewMasterSvaId());
    }

    private void printMemeberEvent(AbstractManagementEvent event, boolean isOnline) {
        if (isOnline) {
            MemberOnlineEvent mOnEvent = (MemberOnlineEvent)event;
            if (!mOnEvent.getPseudoSVA()) {
                SvaWebserviceInterfaceCli.printMember(mOnEvent.getMember());
            }
        } else {
            MemberOfflineEvent mOffEvent = (MemberOfflineEvent)event;
            if (!mOffEvent.getPseudoSVA()) {
                SvaWebserviceInterfaceCli.printMember(mOffEvent.getMember());
            }
        }
    }

    private void printStorageEntityEvent(AbstractManagementEvent event) {
        StorageEntityHealthEvent healthEvent = (StorageEntityHealthEvent)event;
        NFSv3StorageEntity storageEntity = (NFSv3StorageEntity)healthEvent.getStorageEntity();
        NFSv3Export export = (NFSv3Export)storageEntity.getExports()[0];
        Volume volume = export.getVolume();
        System.out.println("\tStorage Entity: ");
        System.out.format("\t\t%-20s %-30s%n", "Id:", storageEntity.getId());
        String ts = String.format("%1$TT.%1$TL", event.getTimestamp());
        System.out.format("\t\t%-20s %-30s%n", "Timestamp:", ts);
        System.out.format("\t\t%-20s %-30s%n", "State:", storageEntity.getState());
        System.out.format("\t\t%-20s %-30s%n", "Export Member Sva Id:", storageEntity.getExportMemberSvaId());
        System.out.format("\t\t%-20s %-30s%n", "Exported:", storageEntity.getExported());
        System.out.println("\t\tVolume:");
        System.out.format("\t\t\t%-20s %-30s%n", "State:", volume.getState());
        System.out.format("\t\t\t%-20s %-30s%n", "Primary Owner:", volume.getPrimaryVolumeOwner());
        System.out.format("\t\t\t%-20s %-30s%n", "Current Owner:", volume.getCurrentVolumeOwner());
        System.out.println("\t\t\t[Volume Syncing]");
        System.out.format("\t\t\t%-20s %-30.2f%n", "Sync % Complete:", Float.valueOf(volume.getSyncPercent() * 100.0f));
        System.out.format("\t\t\t%-20s %-30d%n", "Sync Speed (KB/s):", volume.getSyncSpeed());
        System.out.format("\t\t\t%-20s %-30d%n", "Time to Synced (s):", volume.getSyncTimeToComplete());
        Disk[] disks = volume.getDisks();
        if (disks != null) {
            int i = 0;
            for (Disk d : disks) {
                System.out.format("\t\t\tDisks[%d]:%n", i++);
                System.out.format("\t\t\t\t%-15s %-30s%n", "Id:", d.getId());
                System.out.format("\t\t\t\t%-15s %-30s%n", "State:", d.getState());
                System.out.format("\t\t\t\t%-15s %-30s%n", "Synced:", d.getDiskSynced());
            }
        } else {
            System.out.println("\t\t\t[No Disk info.]");
        }
    }

    private void printVolumeSyncEvent(AbstractManagementEvent mgmtEvent) {
        System.out.println("\tStorage Entity: ");
        if (mgmtEvent instanceof VolumeSyncProgressEvent) {
            VolumeSyncProgressEvent syncEvent = (VolumeSyncProgressEvent)mgmtEvent;
            System.out.format("\t\t%-20s %-30s%n", "Id:", syncEvent.getStorageEntityId());
            System.out.format("\t\t%-20s %-30d%n", "Sync Speed (KB/s):", syncEvent.getSyncSpeed());
            System.out.format("\t\t%-20s %-30.2f%n", "Sync % Complete:", Float.valueOf(syncEvent.getSyncPercent() * 100.0f));
            System.out.format("\t\t%-20s %-30d%n", "Time to Synced (s):", syncEvent.getSyncTimeToComplete());
        } else if (mgmtEvent instanceof VolumeSyncStartEvent) {
            VolumeSyncStartEvent startEvent = (VolumeSyncStartEvent)mgmtEvent;
            System.out.format("\t\t%-20s %-30s%n", "Id:", startEvent.getStorageEntityId());
        } else if (mgmtEvent instanceof VolumeSyncCompletedEvent) {
            VolumeSyncCompletedEvent completedEvent = (VolumeSyncCompletedEvent)mgmtEvent;
            System.out.format("\t\t%-20s %-30s%n", "Id:", completedEvent.getStorageEntityId());
        }
    }

    private void printFileSystemExceededThresholdEvent(FileSystemExceededThresholdEvent event) {
        String fsName = event.getFileSystemName();
        int threshold = event.getThreshold();
        long totalSpace = event.getTotalSpace();
        long usableSpace = event.getUsableSpace();
        System.out.println("Files system \"" + fsName + "\" current usage exceeded a threshold of " + threshold + "%");
        System.out.println("Current usable space is " + usableSpace + " bytes of total space " + totalSpace + " bytes");
    }

    private void printFileSystemRecededBelowThresholdEvent(FileSystemRecededBelowThresholdEvent event) {
        String fsName = event.getFileSystemName();
        int threshold = event.getThreshold();
        long totalSpace = event.getTotalSpace();
        long usableSpace = event.getUsableSpace();
        System.out.println("Files system \"" + fsName + "\" current usage receded below a threshold of " + threshold + "%");
        System.out.println("Current usable space is " + usableSpace + " bytes of total space " + totalSpace + " bytes");
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }
}

