/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.ws.model;

import com.vmware.sva.messaging.ws.model.AbstractStorageEntity;
import com.vmware.sva.messaging.ws.model.AbstractUniqueObject;
import com.vmware.sva.messaging.ws.model.IPv4Address;
import com.vmware.sva.messaging.ws.model.MemberSva;
import com.vmware.sva.messaging.ws.model.NetworkInterface;
import com.vmware.sva.messaging.ws.sva.ExtensionMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;

public class StorageCluster
extends AbstractUniqueObject
implements ADBBean {
    protected NetworkInterface localManagementInterface;
    protected boolean localManagementInterfaceTracker = false;
    protected String localMasterId;
    protected boolean localMasterIdTracker = false;
    protected MemberSva[] localMembers;
    protected boolean localMembersTracker = false;
    protected long localPhysicalCapacity;
    protected boolean localPhysicalCapacityTracker = false;
    protected long localStorageCapacity;
    protected boolean localStorageCapacityTracker = false;
    protected IPv4Address localPseudoSvaAddress;
    protected boolean localPseudoSvaAddressTracker = false;
    protected boolean localPseudoSvaOnline;
    protected boolean localPseudoSvaOnlineTracker = false;
    protected boolean localInMaintenanceMode;
    protected boolean localInMaintenanceModeTracker = false;
    protected AbstractStorageEntity[] localStorageEntities;
    protected boolean localStorageEntitiesTracker = false;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("urn:commonTypes")) {
            return "";
        }
        return BeanUtil.getUniquePrefix();
    }

    public NetworkInterface getManagementInterface() {
        return this.localManagementInterface;
    }

    public void setManagementInterface(NetworkInterface param) {
        this.localManagementInterfaceTracker = param != null;
        this.localManagementInterface = param;
    }

    public String getMasterId() {
        return this.localMasterId;
    }

    public void setMasterId(String param) {
        this.localMasterIdTracker = param != null;
        this.localMasterId = param;
    }

    public MemberSva[] getMembers() {
        return this.localMembers;
    }

    protected void validateMembers(MemberSva[] param) {
    }

    public void setMembers(MemberSva[] param) {
        this.validateMembers(param);
        this.localMembersTracker = param != null;
        this.localMembers = param;
    }

    public void addMembers(MemberSva param) {
        if (this.localMembers == null) {
            this.localMembers = new MemberSva[0];
        }
        this.localMembersTracker = true;
        List list = ConverterUtil.toList(this.localMembers);
        list.add(param);
        this.localMembers = list.toArray(new MemberSva[list.size()]);
    }

    public long getPhysicalCapacity() {
        return this.localPhysicalCapacity;
    }

    public void setPhysicalCapacity(long param) {
        this.localPhysicalCapacityTracker = param != Long.MIN_VALUE;
        this.localPhysicalCapacity = param;
    }

    public long getStorageCapacity() {
        return this.localStorageCapacity;
    }

    public void setStorageCapacity(long param) {
        this.localStorageCapacityTracker = param != Long.MIN_VALUE;
        this.localStorageCapacity = param;
    }

    public IPv4Address getPseudoSvaAddress() {
        return this.localPseudoSvaAddress;
    }

    public void setPseudoSvaAddress(IPv4Address param) {
        this.localPseudoSvaAddressTracker = param != null;
        this.localPseudoSvaAddress = param;
    }

    public boolean getPseudoSvaOnline() {
        return this.localPseudoSvaOnline;
    }

    public void setPseudoSvaOnline(boolean param) {
        this.localPseudoSvaOnlineTracker = true;
        this.localPseudoSvaOnline = param;
    }

    public boolean getInMaintenanceMode() {
        return this.localInMaintenanceMode;
    }

    public void setInMaintenanceMode(boolean param) {
        this.localInMaintenanceModeTracker = true;
        this.localInMaintenanceMode = param;
    }

    public AbstractStorageEntity[] getStorageEntities() {
        return this.localStorageEntities;
    }

    protected void validateStorageEntities(AbstractStorageEntity[] param) {
    }

    public void setStorageEntities(AbstractStorageEntity[] param) {
        this.validateStorageEntities(param);
        this.localStorageEntitiesTracker = param != null;
        this.localStorageEntities = param;
    }

    public void addStorageEntities(AbstractStorageEntity param) {
        if (this.localStorageEntities == null) {
            this.localStorageEntities = new AbstractStorageEntity[0];
        }
        this.localStorageEntitiesTracker = true;
        List list = ConverterUtil.toList(this.localStorageEntities);
        list.add(param);
        this.localStorageEntities = list.toArray(new AbstractStorageEntity[list.size()]);
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    @Override
    public OMElement getOMElement(QName parentQName, final OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName){

            @Override
            public void serialize(MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
                StorageCluster.this.serialize(this.parentQName, factory, xmlWriter);
            }
        };
        return new OMSourcedElementImpl(parentQName, factory, dataSource);
    }

    @Override
    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, factory, xmlWriter, false);
    }

    @Override
    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        int i;
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = StorageCluster.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        String namespacePrefix = this.registerPrefix(xmlWriter, "urn:commonTypes");
        if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
            this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":StorageCluster", xmlWriter);
        } else {
            this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "StorageCluster", xmlWriter);
        }
        if (this.localIdTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = StorageCluster.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "id", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "id");
                }
            } else {
                xmlWriter.writeStartElement("id");
            }
            if (this.localId == null) {
                throw new ADBException("id cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localId);
            xmlWriter.writeEndElement();
        }
        if (this.localNameTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = StorageCluster.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "name", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "name");
                }
            } else {
                xmlWriter.writeStartElement("name");
            }
            if (this.localName == null) {
                throw new ADBException("name cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localName);
            xmlWriter.writeEndElement();
        }
        if (this.localManagementInterfaceTracker) {
            if (this.localManagementInterface == null) {
                throw new ADBException("managementInterface cannot be null!!");
            }
            this.localManagementInterface.serialize(new QName("urn:commonTypes", "managementInterface"), factory, xmlWriter);
        }
        if (this.localMasterIdTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = StorageCluster.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "masterId", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "masterId");
                }
            } else {
                xmlWriter.writeStartElement("masterId");
            }
            if (this.localMasterId == null) {
                throw new ADBException("masterId cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localMasterId);
            xmlWriter.writeEndElement();
        }
        if (this.localMembersTracker) {
            if (this.localMembers != null) {
                for (i = 0; i < this.localMembers.length; ++i) {
                    if (this.localMembers[i] == null) continue;
                    this.localMembers[i].serialize(new QName("urn:commonTypes", "members"), factory, xmlWriter);
                }
            } else {
                throw new ADBException("members cannot be null!!");
            }
        }
        if (this.localPhysicalCapacityTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = StorageCluster.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "physicalCapacity", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "physicalCapacity");
                }
            } else {
                xmlWriter.writeStartElement("physicalCapacity");
            }
            if (this.localPhysicalCapacity == Long.MIN_VALUE) {
                throw new ADBException("physicalCapacity cannot be null!!");
            }
            xmlWriter.writeCharacters(ConverterUtil.convertToString(this.localPhysicalCapacity));
            xmlWriter.writeEndElement();
        }
        if (this.localStorageCapacityTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = StorageCluster.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "storageCapacity", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "storageCapacity");
                }
            } else {
                xmlWriter.writeStartElement("storageCapacity");
            }
            if (this.localStorageCapacity == Long.MIN_VALUE) {
                throw new ADBException("storageCapacity cannot be null!!");
            }
            xmlWriter.writeCharacters(ConverterUtil.convertToString(this.localStorageCapacity));
            xmlWriter.writeEndElement();
        }
        if (this.localPseudoSvaAddressTracker) {
            if (this.localPseudoSvaAddress == null) {
                throw new ADBException("pseudoSvaAddress cannot be null!!");
            }
            this.localPseudoSvaAddress.serialize(new QName("urn:commonTypes", "pseudoSvaAddress"), factory, xmlWriter);
        }
        if (this.localPseudoSvaOnlineTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = StorageCluster.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "pseudoSvaOnline", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "pseudoSvaOnline");
                }
            } else {
                xmlWriter.writeStartElement("pseudoSvaOnline");
            }
            xmlWriter.writeCharacters(ConverterUtil.convertToString(this.localPseudoSvaOnline));
            xmlWriter.writeEndElement();
        }
        if (this.localInMaintenanceModeTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = StorageCluster.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "inMaintenanceMode", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "inMaintenanceMode");
                }
            } else {
                xmlWriter.writeStartElement("inMaintenanceMode");
            }
            xmlWriter.writeCharacters(ConverterUtil.convertToString(this.localInMaintenanceMode));
            xmlWriter.writeEndElement();
        }
        if (this.localStorageEntitiesTracker) {
            if (this.localStorageEntities != null) {
                for (i = 0; i < this.localStorageEntities.length; ++i) {
                    if (this.localStorageEntities[i] == null) continue;
                    this.localStorageEntities[i].serialize(new QName("urn:commonTypes", "storageEntities"), factory, xmlWriter);
                }
            } else {
                throw new ADBException("storageEntities cannot be null!!");
            }
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = StorageCluster.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString(qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = StorageCluster.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString(qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = StorageCluster.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    @Override
    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        int i;
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList<QName> attribList = new ArrayList<QName>();
        attribList.add(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"));
        attribList.add(new QName("urn:commonTypes", "StorageCluster"));
        if (this.localIdTracker) {
            elementList.add(new QName("urn:commonTypes", "id"));
            if (this.localId != null) {
                elementList.add(ConverterUtil.convertToString(this.localId));
            } else {
                throw new ADBException("id cannot be null!!");
            }
        }
        if (this.localNameTracker) {
            elementList.add(new QName("urn:commonTypes", "name"));
            if (this.localName != null) {
                elementList.add(ConverterUtil.convertToString(this.localName));
            } else {
                throw new ADBException("name cannot be null!!");
            }
        }
        if (this.localManagementInterfaceTracker) {
            elementList.add(new QName("urn:commonTypes", "managementInterface"));
            if (this.localManagementInterface == null) {
                throw new ADBException("managementInterface cannot be null!!");
            }
            elementList.add(this.localManagementInterface);
        }
        if (this.localMasterIdTracker) {
            elementList.add(new QName("urn:commonTypes", "masterId"));
            if (this.localMasterId != null) {
                elementList.add(ConverterUtil.convertToString(this.localMasterId));
            } else {
                throw new ADBException("masterId cannot be null!!");
            }
        }
        if (this.localMembersTracker) {
            if (this.localMembers != null) {
                for (i = 0; i < this.localMembers.length; ++i) {
                    if (this.localMembers[i] == null) continue;
                    elementList.add(new QName("urn:commonTypes", "members"));
                    elementList.add(this.localMembers[i]);
                }
            } else {
                throw new ADBException("members cannot be null!!");
            }
        }
        if (this.localPhysicalCapacityTracker) {
            elementList.add(new QName("urn:commonTypes", "physicalCapacity"));
            elementList.add(ConverterUtil.convertToString(this.localPhysicalCapacity));
        }
        if (this.localStorageCapacityTracker) {
            elementList.add(new QName("urn:commonTypes", "storageCapacity"));
            elementList.add(ConverterUtil.convertToString(this.localStorageCapacity));
        }
        if (this.localPseudoSvaAddressTracker) {
            elementList.add(new QName("urn:commonTypes", "pseudoSvaAddress"));
            if (this.localPseudoSvaAddress == null) {
                throw new ADBException("pseudoSvaAddress cannot be null!!");
            }
            elementList.add(this.localPseudoSvaAddress);
        }
        if (this.localPseudoSvaOnlineTracker) {
            elementList.add(new QName("urn:commonTypes", "pseudoSvaOnline"));
            elementList.add(ConverterUtil.convertToString(this.localPseudoSvaOnline));
        }
        if (this.localInMaintenanceModeTracker) {
            elementList.add(new QName("urn:commonTypes", "inMaintenanceMode"));
            elementList.add(ConverterUtil.convertToString(this.localInMaintenanceMode));
        }
        if (this.localStorageEntitiesTracker) {
            if (this.localStorageEntities != null) {
                for (i = 0; i < this.localStorageEntities.length; ++i) {
                    if (this.localStorageEntities[i] == null) continue;
                    elementList.add(new QName("urn:commonTypes", "storageEntities"));
                    elementList.add(this.localStorageEntities[i]);
                }
            } else {
                throw new ADBException("storageEntities cannot be null!!");
            }
        }
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }

    public static class Factory {
        public static StorageCluster parse(XMLStreamReader reader) throws Exception {
            StorageCluster object = new StorageCluster();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String content;
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"StorageCluster".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (StorageCluster)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector handledAttributes = new Vector();
                reader.next();
                ArrayList<MemberSva> list5 = new ArrayList<MemberSva>();
                ArrayList<AbstractStorageEntity> list11 = new ArrayList<AbstractStorageEntity>();
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "id").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setId(ConverterUtil.convertToString(content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "name").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setName(ConverterUtil.convertToString(content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "managementInterface").equals(reader.getName())) {
                    object.setManagementInterface(NetworkInterface.Factory.parse(reader));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "masterId").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setMasterId(ConverterUtil.convertToString(content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "members").equals(reader.getName())) {
                    list5.add(MemberSva.Factory.parse(reader));
                    boolean loopDone5 = false;
                    while (!loopDone5) {
                        while (!reader.isEndElement()) {
                            reader.next();
                        }
                        reader.next();
                        while (!reader.isStartElement() && !reader.isEndElement()) {
                            reader.next();
                        }
                        if (reader.isEndElement()) {
                            loopDone5 = true;
                            continue;
                        }
                        if (new QName("urn:commonTypes", "members").equals(reader.getName())) {
                            list5.add(MemberSva.Factory.parse(reader));
                            continue;
                        }
                        loopDone5 = true;
                    }
                    object.setMembers((MemberSva[])ConverterUtil.convertToArray(MemberSva.class, list5));
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "physicalCapacity").equals(reader.getName())) {
                    String content2 = reader.getElementText();
                    object.setPhysicalCapacity(ConverterUtil.convertToLong(content2));
                    reader.next();
                } else {
                    object.setPhysicalCapacity(Long.MIN_VALUE);
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "storageCapacity").equals(reader.getName())) {
                    String content3 = reader.getElementText();
                    object.setStorageCapacity(ConverterUtil.convertToLong(content3));
                    reader.next();
                } else {
                    object.setStorageCapacity(Long.MIN_VALUE);
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "pseudoSvaAddress").equals(reader.getName())) {
                    object.setPseudoSvaAddress(IPv4Address.Factory.parse(reader));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "pseudoSvaOnline").equals(reader.getName())) {
                    String content4 = reader.getElementText();
                    object.setPseudoSvaOnline(ConverterUtil.convertToBoolean(content4));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "inMaintenanceMode").equals(reader.getName())) {
                    String content5 = reader.getElementText();
                    object.setInMaintenanceMode(ConverterUtil.convertToBoolean(content5));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "storageEntities").equals(reader.getName())) {
                    list11.add(AbstractStorageEntity.Factory.parse(reader));
                    boolean loopDone11 = false;
                    while (!loopDone11) {
                        while (!reader.isEndElement()) {
                            reader.next();
                        }
                        reader.next();
                        while (!reader.isStartElement() && !reader.isEndElement()) {
                            reader.next();
                        }
                        if (reader.isEndElement()) {
                            loopDone11 = true;
                            continue;
                        }
                        if (new QName("urn:commonTypes", "storageEntities").equals(reader.getName())) {
                            list11.add(AbstractStorageEntity.Factory.parse(reader));
                            continue;
                        }
                        loopDone11 = true;
                    }
                    object.setStorageEntities((AbstractStorageEntity[])ConverterUtil.convertToArray(AbstractStorageEntity.class, list11));
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

