/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.webservice;

import com.vmware.sva.messaging.ws.model.IPv4Address;
import com.vmware.sva.messaging.ws.model.MemberSvaConfig;
import com.vmware.sva.messaging.ws.model.NetworkInterface;
import com.vmware.sva.messaging.ws.model.PingResult;
import com.vmware.sva.messaging.ws.model.PseudoSvaServerInfo;
import com.vmware.sva.messaging.ws.model.StorageClusterConfig;
import com.vmware.sva.messaging.ws.model.StorageEntityNetworkReconfig;
import com.vmware.sva.messaging.ws.model.SvaServerInfo;
import com.vmware.sva.messaging.ws.model.TaskRef;
import com.vmware.sva.messaging.ws.pseudosva.ExecuteResponse;
import com.vmware.sva.messaging.ws.pseudosva.PseudosvaserviceStub;
import com.vmware.sva.webservice.WebServiceInterfaceFactory;
import com.vmware.sva.webservice.interfaces.PseudosvaWebServiceInterface;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import org.apache.axis2.AxisFault;

public class PseudosvaWebServiceInterfaceImpl
implements PseudosvaWebServiceInterface {
    private PseudosvaserviceStub psvaclient = null;
    private final Integer SOCKET_TIMEOUT = new Integer(60000);
    private final Integer SOCKET_TIMEOUT_ATTACHMENT = new Integer(300000);

    @Override
    public void connect(String serviceUrl) throws AxisFault {
        if (this.psvaclient == null) {
            this.psvaclient = new PseudosvaserviceStub(serviceUrl);
            WebServiceInterfaceFactory.updateStub(this.psvaclient, this.SOCKET_TIMEOUT, "4336");
        }
    }

    @Override
    public PseudoSvaServerInfo getPseudoSvaServerInfo(String ipAddr) throws Exception {
        PseudoSvaServerInfo psvsInfo = null;
        if (this.psvaclient != null) {
            psvsInfo = this.psvaclient.getPseudoSvaServerInfo(ipAddr);
        }
        return psvsInfo;
    }

    @Override
    public String getSvaVersion() throws Exception {
        if (this.psvaclient != null) {
            return this.psvaclient.getSvaVersion();
        }
        return null;
    }

    @Override
    public PingResult wsPing() throws Exception {
        PingResult pingResult = null;
        if (this.psvaclient != null) {
            pingResult = this.psvaclient.ping();
        }
        return pingResult;
    }

    @Override
    public void login(String username, String passwd) throws Exception {
        this.psvaclient.login(username, passwd);
    }

    @Override
    public void close() throws Exception {
        if (this.psvaclient != null) {
            this.psvaclient._getServiceClient().cleanup();
        }
    }

    @Override
    public InputStream getDiagnosticInfo() throws Exception {
        if (this.psvaclient != null) {
            DataHandler diagnosticInfo = this.psvaclient.getDiagnosticInfo();
            return diagnosticInfo.getInputStream();
        }
        return null;
    }

    @Override
    public String faultInsertion(List<String> args) throws Exception {
        if (this.psvaclient != null) {
            String[] cArgs = args.toArray(new String[0]);
            return this.psvaclient.faultInsertion(cArgs);
        }
        return null;
    }

    @Override
    public String listConstants() throws Exception {
        if (this.psvaclient != null) {
            return this.psvaclient.listConstants();
        }
        return null;
    }

    @Override
    public String listDebug() throws Exception {
        if (this.psvaclient != null) {
            return this.psvaclient.listDebug();
        }
        return null;
    }

    @Override
    public void destroyPseudoSva() throws Exception {
        if (this.psvaclient != null) {
            this.psvaclient.destroyPseudoSva();
        }
    }

    @Override
    public TaskRef svaWSCreateStorageCluster(String taskId, StorageClusterConfig config) throws Exception {
        throw new UnsupportedOperationException("Not supported on PeudoSVA");
    }

    @Override
    public SvaServerInfo svaWSGetSvaServerInfo() throws Exception {
        throw new UnsupportedOperationException("Not supported on PeudoSVA");
    }

    @Override
    public void shutdownSvaServer(boolean maintenanceMode) throws Exception {
        throw new UnsupportedOperationException("Not supported on PeudoSVA");
    }

    @Override
    public TaskRef reconfigureNetwork(NetworkInterface mgmtInterface, List<MemberSvaConfig> members, List<StorageEntityNetworkReconfig> storageEntities, IPv4Address pseudoSvaAddress) throws Exception {
        throw new UnsupportedOperationException("Not supported on PeudoSVA");
    }

    @Override
    public void reset(boolean force) throws Exception {
        throw new UnsupportedOperationException("Not supported on PeudoSVA");
    }

    @Override
    public InputStream getDiagnosticInfo(boolean includeDump) throws Exception {
        return this.getDiagnosticInfo();
    }

    @Override
    public void uploadFile(String srcFileName, String dstFileName, String permissions) throws Exception {
        if (this.psvaclient != null) {
            this.deleteFile(dstFileName);
            this.createFile(dstFileName, permissions);
            this.appendToFile(srcFileName, dstFileName);
        }
    }

    @Override
    public void createFile(String fileName, String permissions) throws Exception {
        this.psvaclient.createFile(fileName, permissions, false);
    }

    @Override
    public void createDirectory(String dirName, String permissions) throws Exception {
        this.psvaclient.createFile(dirName, permissions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendToFile(String srcFileName, String dstFileName) throws Exception {
        try {
            PseudosvaserviceStub pseudosvaserviceStub = this.psvaclient;
            synchronized (pseudosvaserviceStub) {
                this.psvaclient._getServiceClient().getServiceContext().getConfigurationContext().setProperty("SO_TIMEOUT", this.SOCKET_TIMEOUT_ATTACHMENT);
            }
            FileDataSource dataSource = new FileDataSource(new File(srcFileName));
            DataHandler dataHandler = new DataHandler(dataSource);
            this.psvaclient.writeToFile(dstFileName, dataHandler, true);
        }
        finally {
            this.psvaclient._getServiceClient().getServiceContext().getConfigurationContext().setProperty("SO_TIMEOUT", this.SOCKET_TIMEOUT);
        }
    }

    @Override
    public void deleteFile(String fileName) throws Exception {
        this.psvaclient.deleteFile(fileName);
    }

    @Override
    public ExecuteResponse execute(String filename, String workDirectory, boolean async, String[] parameters, String stdinData) throws Exception {
        ExecuteResponse executeResponse = this.psvaclient.execute(filename, workDirectory, async, parameters, stdinData);
        return executeResponse;
    }

    @Override
    public long getAvailableSpace() throws Exception {
        return this.psvaclient.getAvailableSpace();
    }

    @Override
    public String getProductDirectoryName() throws Exception {
        return this.psvaclient.getProductDirectoryName();
    }

    @Override
    public void changePermissions(String filename, String permissions, boolean recursive) throws Exception {
        this.psvaclient.changePermissions(filename, permissions, recursive);
    }

    @Override
    public void enterMaintenanceMode(boolean shutdownRMI) throws Exception {
        if (this.psvaclient != null) {
            this.psvaclient.enterMaintenanceMode(shutdownRMI);
        }
    }

    @Override
    public void exitMaintenanceMode() throws Exception {
        if (this.psvaclient != null) {
            this.psvaclient.exitMaintenanceMode();
        }
    }

    @Override
    public void restart() throws Exception {
        this.psvaclient.restart();
    }
}

