/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description.java2wsdl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.utils.NamespaceMap;

public class DocLitBareSchemaGenerator
extends DefaultSchemaGenerator {
    private static final Log log = LogFactory.getLog(DocLitBareSchemaGenerator.class);
    private HashMap processedParameters = new LinkedHashMap();

    public DocLitBareSchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix, AxisService service) throws Exception {
        super(loader, className, schematargetNamespace, schematargetNamespacePrefix, service);
    }

    protected Method[] processMethods(Method[] declaredMethods) throws Exception {
        ArrayList<Method> list = new ArrayList<Method>();
        Arrays.sort(declaredMethods, new DefaultSchemaGenerator.MathodComparator());
        LinkedHashMap<String, Method> uniqueMethods = new LinkedHashMap<String, Method>();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Class<?> methodParameter;
            XmlSchemaComplexType methodSchemaType;
            XmlSchemaSequence sequence;
            String methodName;
            Method jMethod = declaredMethods[i];
            WebMethod methodAnnon = jMethod.getAnnotation(WebMethod.class);
            if (methodAnnon != null && methodAnnon.exclude() || this.excludeMethods.contains(methodName = jMethod.getName())) continue;
            if (((HashMap)uniqueMethods).get(methodName) != null) {
                log.warn("We don't support method overloading. Ignoring [" + methodName + "]");
                continue;
            }
            if (!Modifier.isPublic(jMethod.getModifiers())) continue;
            boolean addToService = false;
            AxisOperation axisOperation = this.service.getOperation(new QName(methodName));
            if (axisOperation == null) {
                AxisMessage outMessage;
                axisOperation = Utils.getAxisOperationForJmethod(jMethod);
                if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(axisOperation.getMessageExchangePattern()) && (outMessage = axisOperation.getMessage("Out")) != null) {
                    outMessage.setName(methodName + "Result");
                }
                addToService = true;
            }
            list.add(jMethod);
            this.processException(jMethod, axisOperation);
            uniqueMethods.put(methodName, jMethod);
            uniqueMethods.put(methodName, jMethod);
            Class<?>[] paras = jMethod.getParameterTypes();
            String[] parameterNames = this.methodTable.getParameterNames(methodName);
            AxisMessage inMessage = axisOperation.getMessage("In");
            if (inMessage != null) {
                inMessage.setName(methodName + "RequestMessage");
            }
            Annotation[][] parameterAnnotation = jMethod.getParameterAnnotations();
            if (paras.length > 1) {
                String parameterName;
                sequence = new XmlSchemaSequence();
                methodSchemaType = this.createSchemaTypeForMethodPart(methodName);
                methodSchemaType.setParticle(sequence);
                inMessage.setElementQName(this.typeTable.getQNamefortheType(methodName));
                this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
                inMessage.setPartName(methodName);
                for (int j = 0; j < paras.length && !this.generateRequestSchema(methodParameter = paras[j], parameterName = this.getParameterName(parameterAnnotation, j, parameterNames), jMethod, sequence); ++j) {
                }
            } else if (paras.length == 1) {
                if (paras[0].isArray()) {
                    sequence = new XmlSchemaSequence();
                    methodSchemaType = this.createSchemaTypeForMethodPart(methodName);
                    methodSchemaType.setParticle(sequence);
                    Class<?> methodParameter2 = paras[0];
                    inMessage.setElementQName(this.typeTable.getQNamefortheType(methodName));
                    this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
                    inMessage.setPartName(methodName);
                    String parameterName = this.getParameterName(parameterAnnotation, 0, parameterNames);
                    if (this.generateRequestSchema(methodParameter2, parameterName, jMethod, sequence)) {
                        break;
                    }
                } else {
                    String parameterName = this.getParameterName(parameterAnnotation, 0, parameterNames);
                    methodParameter = paras[0];
                    Method processMethod = (Method)this.processedParameters.get(parameterName);
                    if (processMethod != null) {
                        throw new AxisFault("Inavalid Java class, there are two methods [" + processMethod.getName() + " and " + jMethod.getName() + " ]which have the same parameter names");
                    }
                    this.processedParameters.put(parameterName, jMethod);
                    this.generateSchemaForType(null, methodParameter, parameterName);
                    inMessage.setElementQName(this.typeTable.getQNamefortheType(parameterName));
                    inMessage.setPartName(parameterName);
                    inMessage.setWrapped(false);
                    this.service.addMessageElementQNameToOperationMapping(this.typeTable.getQNamefortheType(parameterName), axisOperation);
                }
            }
            Class<?> returnType = jMethod.getReturnType();
            if (!"void".equals(jMethod.getReturnType().getName())) {
                AxisMessage outMessage = axisOperation.getMessage("Out");
                if (returnType.isArray()) {
                    methodSchemaType = this.createSchemaTypeForMethodPart(jMethod.getName() + "Result");
                    sequence = new XmlSchemaSequence();
                    methodSchemaType.setParticle(sequence);
                    WebResult returnAnnon = jMethod.getAnnotation(WebResult.class);
                    String returnName = "return";
                    if (returnAnnon != null && (returnName = returnAnnon.name()) != null && !"".equals(returnName)) {
                        returnName = "return";
                    }
                    if (this.nonRpcMethods.contains(methodName)) {
                        this.generateSchemaForType(sequence, null, returnName);
                    } else {
                        this.generateSchemaForType(sequence, returnType, returnName);
                    }
                } else {
                    this.generateSchemaForType(null, returnType, methodName + "Result");
                    outMessage.setWrapped(false);
                }
                outMessage.setElementQName(this.typeTable.getQNamefortheType(methodName + "Result"));
                outMessage.setName(methodName + "ResponseMessage");
                outMessage.setPartName(methodName + "Result");
                this.service.addMessageElementQNameToOperationMapping(this.typeTable.getQNamefortheType(methodName + "Result"), axisOperation);
            }
            if (!addToService) continue;
            this.service.addOperation(axisOperation);
        }
        return list.toArray(new Method[list.size()]);
    }

    private boolean generateRequestSchema(Class methodParameter, String parameterName, Method jMethod, XmlSchemaSequence sequence) throws Exception {
        if (this.nonRpcMethods.contains(jMethod.getName())) {
            this.generateSchemaForType(sequence, null, jMethod.getName());
            return true;
        }
        this.generateSchemaForType(sequence, methodParameter, parameterName);
        return false;
    }

    private QName generateSchemaForType(XmlSchemaSequence sequence, Class type, String partName) throws Exception {
        QName schemaTypeName;
        boolean isArrayType = false;
        if (type != null) {
            isArrayType = type.isArray();
        }
        if (isArrayType) {
            type = type.getComponentType();
        }
        if (AxisFault.class.getName().equals(type)) {
            return null;
        }
        String classTypeName = type == null ? "java.lang.Object" : type.getName();
        if (isArrayType && "byte".equals(classTypeName)) {
            classTypeName = "base64Binary";
            isArrayType = false;
        }
        if (this.isDataHandler(type)) {
            classTypeName = "base64Binary";
        }
        if ((schemaTypeName = this.typeTable.getSimpleSchemaTypeName(classTypeName)) == null && type != null) {
            schemaTypeName = this.generateSchema(type);
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
            String schemaNamespace = this.resolveSchemaNamespace(this.getQualifiedName(type.getPackage()));
            this.addImport(this.getXmlSchema(schemaNamespace), schemaTypeName);
            if (sequence == null) {
                this.generateSchemaForSingleElement(schemaTypeName, partName, isArrayType);
            }
        } else if (sequence == null) {
            this.generateSchemaForSingleElement(schemaTypeName, partName, isArrayType);
        } else {
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
        }
        this.addImport(this.getXmlSchema(this.schemaTargetNameSpace), schemaTypeName);
        return schemaTypeName;
    }

    protected void generateSchemaForSingleElement(QName schemaTypeName, String paraName, boolean isArray) throws Exception {
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(paraName);
        elt1.setSchemaTypeName(schemaTypeName);
        elt1.setNillable(true);
        QName elementName = new QName(this.schemaTargetNameSpace, paraName, this.schema_namespace_prefix);
        elt1.setQName(elementName);
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        xmlSchema.getElements().add(elementName, elt1);
        xmlSchema.getItems().add(elt1);
        this.typeTable.addComplexSchema(paraName, elementName);
    }

    private XmlSchemaComplexType createSchemaTypeForMethodPart(String localPartName) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType complexType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix));
        if (complexType == null) {
            complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaElement globalElement = new XmlSchemaElement();
            globalElement.setSchemaType(complexType);
            globalElement.setName(localPartName);
            globalElement.setQName(elementName);
            xmlSchema.getItems().add(globalElement);
            xmlSchema.getElements().add(elementName, globalElement);
        }
        this.typeTable.addComplexSchema(localPartName, elementName);
        return complexType;
    }

    protected XmlSchema getXmlSchema(String targetNamespace) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(targetNamespace);
        if (xmlSchema == null) {
            String targetNamespacePrefix = targetNamespace.equals(this.schemaTargetNameSpace) && this.schema_namespace_prefix != null ? this.schema_namespace_prefix : this.generatePrefix();
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
            xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
            this.targetNamespacePrefixMap.put(targetNamespace, targetNamespacePrefix);
            this.schemaMap.put(targetNamespace, xmlSchema);
            NamespaceMap prefixmap = new NamespaceMap();
            prefixmap.put("xs", "http://www.w3.org/2001/XMLSchema");
            prefixmap.put(targetNamespacePrefix, targetNamespace);
            xmlSchema.setNamespaceContext(prefixmap);
        }
        return xmlSchema;
    }
}

