/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws;

import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.apache.axis2.jaxws.binding.BindingUtils;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.client.PropertyValidator;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingProvider
implements org.apache.axis2.jaxws.spi.BindingProvider {
    private static final Log log = LogFactory.getLog(BindingProvider.class);
    protected Map<String, Object> requestContext;
    protected Map<String, Object> responseContext;
    protected EndpointDescription endpointDesc;
    protected ServiceDelegate serviceDelegate;
    private Binding binding;

    public BindingProvider(ServiceDelegate svcDelegate, EndpointDescription epDesc, org.apache.axis2.addressing.EndpointReference epr, String addressingNamespace, WebServiceFeature ... features) {
        this.endpointDesc = epDesc;
        this.serviceDelegate = svcDelegate;
        this.initialize(epr, addressingNamespace, features);
    }

    private void initialize(org.apache.axis2.addressing.EndpointReference epr, String addressingNamespace, WebServiceFeature ... features) {
        String endpointAddress;
        this.requestContext = new ValidatingClientContext();
        this.responseContext = new ValidatingClientContext();
        this.requestContext.put("javax.xml.ws.session.maintain", Boolean.FALSE);
        this.requestContext.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        this.requestContext.put("disableAddressingForOutMessages", Boolean.TRUE);
        String string = endpointAddress = epr != null ? epr.getAddress() : this.endpointDesc.getEndpointAddress();
        if (endpointAddress != null && !"".equals(endpointAddress)) {
            this.requestContext.put("javax.xml.ws.service.endpoint.address", endpointAddress);
        }
        this.binding = (Binding)BindingUtils.createBinding(this.endpointDesc);
        if (log.isDebugEnabled()) {
            log.debug("Lookign for Handler Resolver");
        }
        HandlerResolver handlerResolver = null;
        if (this.serviceDelegate.getHandlerResolver() != null) {
            if (log.isDebugEnabled()) {
                log.debug("Reading default Handler Resolver ");
            }
            handlerResolver = this.serviceDelegate.getHandlerResolver();
        } else {
            handlerResolver = new HandlerResolverImpl(this.endpointDesc.getServiceDescription(), this.serviceDelegate);
            if (log.isDebugEnabled()) {
                log.debug("Creating new Handler Resolver using HandlerResolverImpl");
            }
        }
        if (this.binding instanceof SOAPBinding) {
            boolean enableMTOMFromMetadata = false;
            enableMTOMFromMetadata = this.endpointDesc.getEndpointInterfaceDescription() != null && this.endpointDesc.getEndpointInterfaceDescription().getSEIClass() != null ? this.endpointDesc.getServiceDescription().isMTOMEnabled(this.serviceDelegate, this.endpointDesc.getEndpointInterfaceDescription().getSEIClass()) : this.endpointDesc.getServiceDescription().isMTOMEnabled(this.serviceDelegate);
            if (!enableMTOMFromMetadata) {
                String bindingType = this.endpointDesc.getClientBindingID();
                boolean bl = enableMTOMFromMetadata = bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
            }
            if (enableMTOMFromMetadata) {
                ((SOAPBinding)this.binding).setMTOMEnabled(true);
            }
        }
        String seiName = null;
        if (this.endpointDesc.getEndpointInterfaceDescription() != null && this.endpointDesc.getEndpointInterfaceDescription().getSEIClass() != null) {
            seiName = this.endpointDesc.getEndpointInterfaceDescription().getSEIClass().getName();
        }
        String portQNameString = this.endpointDesc.getPortQName().toString();
        String key = seiName + ":" + portQNameString;
        Map<String, Object> bProps = this.endpointDesc.getServiceDescription().getBindingProperties(this.serviceDelegate, key);
        if (bProps != null) {
            if (log.isDebugEnabled()) {
                log.debug("Setting binding props with size: " + bProps.size() + " on " + "BindingProvider RequestContext");
            }
            this.requestContext.putAll(bProps);
        }
        this.binding.setHandlerChain(handlerResolver.getHandlerChain(this.endpointDesc.getPortInfo()));
        try {
            this.binding.setAxis2EndpointReference(epr);
            this.binding.setAddressingNamespace(addressingNamespace);
            this.binding.setFeatures(features);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public ServiceDelegate getServiceDelegate() {
        return this.serviceDelegate;
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.endpointDesc;
    }

    @Override
    public javax.xml.ws.Binding getBinding() {
        return this.binding;
    }

    @Override
    public Map<String, Object> getRequestContext() {
        return this.requestContext;
    }

    @Override
    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    protected void checkMaintainSessionState(MessageContext mc, InvocationContext ic) {
        Map<String, Object> properties = ic.getServiceClient().getServiceContext().getProperties();
        boolean bValue = false;
        if (properties != null && properties.containsKey("javax.xml.ws.session.maintain")) {
            bValue = (Boolean)properties.get("javax.xml.ws.session.maintain");
        }
        if (mc.isMaintainSession() || bValue) {
            this.setupSessionContext(properties);
        }
    }

    protected void setupSessionContext(Map<String, Object> properties) {
        String sessionKey = null;
        Object sessionValue = null;
        if (properties == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("NoMaintainSessionProperty"));
        }
        if (properties.containsKey("Location")) {
            sessionKey = "Location";
            sessionValue = properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("javax.xml.ws.service.endpoint.address", sessionValue);
            }
        } else if (properties.containsKey("Cookie")) {
            sessionKey = "Cookie";
            sessionValue = properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("Cookie", sessionValue);
            }
        } else if (properties.containsKey("Cookie2")) {
            sessionKey = "Cookie2";
            sessionValue = properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("Cookie", sessionValue);
            }
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("NoMaintainSessionProperty"));
        }
        if (sessionValue == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("NullValueForMaintainSessionProperty", sessionKey));
        }
    }

    protected boolean useSoapAction() {
        Boolean use = (Boolean)this.requestContext.get("javax.xml.ws.soap.http.soapaction.use");
        if (use != null) {
            return use != false;
        }
        return true;
    }

    @Override
    public EndpointReference getEndpointReference() {
        return this.getEndpointReference(W3CEndpointReference.class);
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        EndpointReference jaxwsEPR = null;
        String addressingNamespace = EndpointReferenceUtils.getAddressingNamespace(clazz);
        try {
            org.apache.axis2.addressing.EndpointReference epr = this.binding.getAxis2EndpointReference();
            if (epr == null) {
                String address = (String)this.requestContext.get("javax.xml.ws.service.endpoint.address");
                if (address == null) {
                    address = this.endpointDesc.getEndpointAddress();
                }
                QName service = this.endpointDesc.getServiceQName();
                QName port = this.endpointDesc.getPortQName();
                String wsdlLocation = ((ServiceDescriptionWSDL)((Object)this.endpointDesc.getServiceDescription())).getWSDLLocation();
                epr = EndpointReferenceUtils.createAxis2EndpointReference(address, service, port, wsdlLocation, addressingNamespace);
            } else if (!addressingNamespace.equals(this.binding.getAddressingNamespace())) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("bindingProviderErr1", this.binding.getAddressingNamespace(), addressingNamespace));
            }
            jaxwsEPR = EndpointReferenceUtils.convertFromAxis2(epr, addressingNamespace);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointRefConstructionFailure3", e.toString()));
        }
        return (T)((EndpointReference)clazz.cast(jaxwsEPR));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValidatingClientContext
    extends Hashtable<String, Object> {
        private static final long serialVersionUID = 3485112205801917858L;

        ValidatingClientContext() {
        }

        @Override
        public synchronized Object put(String key, Object value) {
            if (value == null) {
                return null;
            }
            if (PropertyValidator.validate(key, value)) {
                return super.put(key, value);
            }
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invalidPropValue", key, value.getClass().getName(), PropertyValidator.getExpectedValue(key).getName()));
        }
    }
}

