/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client;

import java.io.Serializable;
import java.util.Map;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigrator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMigrator
implements ApplicationContextMigrator,
Serializable {
    private static final Log log = LogFactory.getLog(PropertyMigrator.class);

    @Override
    public void migratePropertiesFromMessageContext(Map<String, Object> userContext, MessageContext messageContext) {
        MEPContext mepContext;
        if (log.isDebugEnabled()) {
            log.debug("Starting migratePropertyFromMessageContext");
        }
        if ((mepContext = messageContext.getMEPContext()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Reading ApplicationScopedProperties from MEPContext");
            }
            userContext.putAll(mepContext.getApplicationScopedProperties());
        }
        if (log.isDebugEnabled()) {
            log.debug("migratePropertyFromMessageContext Complete");
        }
    }

    @Override
    public void migratePropertiesToMessageContext(Map<String, Object> userContext, MessageContext messageContext) {
        if (userContext != null) {
            String[] keys = new String[userContext.keySet().size()];
            keys = userContext.keySet().toArray(keys);
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                Object value = userContext.get(key);
                if (key.equalsIgnoreCase("enableMTOM")) {
                    value = messageContext.getMessage().isMTOMEnabled();
                    messageContext.getMEPContext().put(key, value);
                }
                messageContext.setProperty(key, value);
            }
        }
    }
}

