/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.attachments;

import java.io.File;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMNavigator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentUtils {
    private static final Log log = LogFactory.getLog(AttachmentUtils.class);
    private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");

    public static ArrayList<OMElement> findXopElements(OMElement env) {
        ArrayList<OMElement> xops = new ArrayList<OMElement>();
        AttachmentUtils.findXopElements(env, xops);
        return xops;
    }

    private static void findXopElements(OMElement root, ArrayList<OMElement> xops) {
        root.getNextOMSibling();
        OMNavigator nav = new OMNavigator(root);
        while (nav.isNavigable()) {
            OMElement element;
            OMNode curr = nav.next();
            if (!nav.visited() || !(curr instanceof OMElement) || !(element = (OMElement)curr).getQName().equals(XOP_INCLUDE)) continue;
            if (log.isDebugEnabled()) {
                log.debug("[XOP_INCLUDE] " + element.getLocalName());
            }
            xops.add(element);
        }
    }

    public static ArrayList<OMText> findBinaryNodes(SOAPEnvelope env) {
        ArrayList<OMText> nodes = new ArrayList<OMText>();
        AttachmentUtils.findBinaryElements(env, nodes);
        return nodes;
    }

    private static void findBinaryElements(OMNode node, ArrayList<OMText> attachments) {
        node.getNextOMSibling();
        OMNavigator nav = new OMNavigator(node);
        while (nav.isNavigable()) {
            OMText textNode;
            OMNode curr = nav.next();
            if (!(curr instanceof OMText)) continue;
            if (log.isDebugEnabled()) {
                log.debug("text node found");
            }
            if (!(textNode = (OMText)curr).isOptimized()) continue;
            if (log.isDebugEnabled()) {
                log.debug("optimized text node found");
            }
            attachments.add(textNode);
        }
    }

    public static OMText makeBinaryOMNode(OMElement xop, DataHandler dh) {
        OMFactory factory = xop.getOMFactory();
        OMText binaryNode = factory.createOMText(dh, true);
        return binaryNode;
    }

    public static OMElement makeXopElement(OMText data) {
        OMFactory factory = data.getOMFactory();
        OMElement xop = factory.createOMElement(XOP_INCLUDE, null);
        xop.addAttribute("href", data.getContentID(), null);
        return xop;
    }

    public static void findCachedAttachment(Attachments attachments) {
        if (attachments == null) {
            return;
        }
        String[] contentIds = attachments.getAllContentIDs();
        if (contentIds.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Attachments exist....");
            }
            for (int i = 0; i < contentIds.length; ++i) {
                DataHandler dh = attachments.getDataHandler(contentIds[i]);
                if (dh == null) continue;
                DataSource dataSource = dh.getDataSource();
                if (dh == null || !(dataSource instanceof CachedFileDataSource)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Attachment's DataHandler uses CachedFileDataSource...");
                }
                File file = ((CachedFileDataSource)dataSource).getFile();
                if (log.isDebugEnabled()) {
                    log.debug(" Making file.deleteOnExit() request on " + file.getAbsolutePath());
                }
                file.deleteOnExit();
            }
        }
    }
}

