/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.ClassFinder;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinderImpl
implements ClassFinder {
    private static final Log log = LogFactory.getLog(ClassFinderImpl.class);

    @Override
    public ArrayList<Class> getClassesFromJarFile(String pkg, ClassLoader cl) throws ClassNotFoundException {
        try {
            ArrayList<Class> classes = new ArrayList<Class>();
            URLClassLoader ucl = (URLClassLoader)cl;
            URL[] srcURL = ucl.getURLs();
            String path = pkg.replace('.', '/');
            for (URL url : srcURL) {
                File f;
                if (!"file".equals(url.getProtocol()) || !(f = new File(url.toURI().getPath())).exists() || f.isDirectory()) continue;
                try {
                    JarFile jf = new JarFile(f);
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry je = entries.nextElement();
                        String clazzName = je.getName();
                        if (clazzName == null || !clazzName.endsWith(".class")) continue;
                        clazzName = clazzName.substring(0, clazzName.length() - 6);
                        if (!(clazzName = clazzName.replace('/', '.').replace('\\', '.').replace(':', '.')).startsWith(pkg)) continue;
                        try {
                            Class clazz = ClassFinderImpl.forName(clazzName, false, cl);
                            if (clazz.isInterface() || !clazz.getPackage().getName().equals(pkg) || ClassUtils.getDefaultPublicConstructor(clazz) == null || ClassUtils.isJAXWSClass(clazz)) continue;
                            if (log.isDebugEnabled()) {
                                log.debug("Adding class: " + clazzName);
                            }
                            classes.add(clazz);
                        }
                        catch (Throwable e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Tried to load class " + clazzName + " while constructing a JAXBContext.  This class will be skipped.  Processing Continues.");
                            log.debug("  The reason that class could not be loaded:" + e.toString());
                            log.trace(JavaUtils.stackToString(e));
                        }
                    }
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(Messages.getMessage("ClassUtilsErr4"));
                }
            }
            return classes;
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }
}

