/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.attachments.AttachmentUtils;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageUtils {
    private static final Log log = LogFactory.getLog(MessageUtils.class);

    public static SOAPFactory getSOAPFactory(OMElement e) {
        OMFactory factory;
        StAXBuilder staxBuilder;
        OMDocument document;
        OMXMLParserWrapper builder = e.getBuilder();
        if (builder instanceof StAXBuilder && (document = (staxBuilder = (StAXBuilder)builder).getDocument()) != null && (factory = document.getOMFactory()) instanceof SOAPFactory) {
            return (SOAPFactory)factory;
        }
        while (e != null && !(e instanceof SOAPEnvelope)) {
            e = (OMElement)e.getParent();
        }
        if (e instanceof SOAPEnvelope) {
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(e.getNamespace().getNamespaceURI())) {
                return OMAbstractFactory.getSOAP11Factory();
            }
            return OMAbstractFactory.getSOAP12Factory();
        }
        return null;
    }

    public static AttachmentPart createAttachmentPart(String cid, DataHandler dh, SOAPMessage message) {
        AttachmentPart ap = message.createAttachmentPart(dh);
        ap.setContentId(cid);
        return ap;
    }

    public static Message getMessageFromMessageContext(MessageContext msgContext) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Start getMessageFromMessageContext");
        }
        Message message = null;
        SOAPEnvelope soapEnv = msgContext.getEnvelope();
        if (soapEnv != null) {
            Map headerMap;
            MessageFactory msgFactory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            try {
                Protocol protocol = msgContext.isDoingREST() ? Protocol.rest : null;
                message = msgFactory.createFrom(soapEnv, protocol);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("msgFromMsgErr"), e);
            }
            Object property = msgContext.getProperty("enableMTOM");
            if (property != null && JavaUtils.isTrueExplicitly(property)) {
                message.setMTOMEnabled(true);
            }
            if ((headerMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS")) != null) {
                message.setMimeHeaders(headerMap);
            }
            if (soapEnv.hasFault()) {
                soapEnv.toString();
            }
        }
        return message;
    }

    public static void putMessageOnMessageContext(Message message, MessageContext msgContext) throws AxisFault, WebServiceException {
        SOAPEnvelope envelope = (SOAPEnvelope)message.getAsOMElement();
        msgContext.setEnvelope(envelope);
        Map headerMap = message.getMimeHeaders();
        msgContext.setProperty("TRANSPORT_HEADERS", headerMap);
        msgContext.setProperty("HTTP_HEADERS", headerMap);
        if (message.getProtocol() == Protocol.rest) {
            msgContext.setDoingREST(true);
            msgContext.setProperty("ContentType", "application/xml");
        }
        if (message.getMessageContext() != null) {
            AttachmentsAdapter.install(message.getMessageContext());
            TransportHeadersAdapter.install(message.getMessageContext());
            SOAPHeadersAdapter.install(message.getMessageContext());
        }
        if (message.isDoingSWA()) {
            msgContext.setDoingSwA(true);
            msgContext.setProperty("enableSwA", "true");
        }
        if (message.isMTOMEnabled()) {
            msgContext.setProperty("enableMTOM", "true");
        }
    }

    private static void makeBinaryNodes(Message msg) {
        SOAPEnvelope envelope;
        ArrayList<OMElement> xops;
        if (log.isDebugEnabled()) {
            log.debug("MTOM is enabled on the JAX-WS Message...look for XOP Includes");
        }
        if ((xops = AttachmentUtils.findXopElements(envelope = (SOAPEnvelope)msg.getAsOMElement())) != null && xops.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Found XOP:Include Elements");
            }
            QName href = new QName("", "href");
            for (OMElement xop : xops) {
                String cid = xop.getAttributeValue(href);
                DataHandler dh = msg.removeDataHandler(cid);
                if (log.isDebugEnabled()) {
                    log.debug("Create Binary OMNode for attachment:" + cid);
                }
                OMText binaryNode = AttachmentUtils.makeBinaryOMNode(xop, dh);
                xop.insertSiblingAfter(binaryNode);
                xop.detach();
            }
        }
    }

    private static void makeXOPIncludeNodes(MessageContext msgContext, Message message) {
        Attachments as = (Attachments)msgContext.getProperty("Attachments");
        if (as != null) {
            ArrayList<OMText> binaryNodes;
            if (log.isDebugEnabled()) {
                log.debug("Found Axis MTOM Attachments");
            }
            if ((binaryNodes = AttachmentUtils.findBinaryNodes((SOAPEnvelope)message.getAsOMElement())) != null && binaryNodes.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Found " + binaryNodes.size() + "MTOM Binary Nodes");
                }
                for (OMText node : binaryNodes) {
                    OMElement xop = AttachmentUtils.makeXopElement(node);
                    node.getParent().addChild(xop);
                    node.detach();
                    if (log.isDebugEnabled()) {
                        log.debug("Create MTOM Message Attachment for " + node.getContentID());
                    }
                    message.addDataHandler((DataHandler)node.getDataHandler(), node.getContentID());
                }
            }
        }
    }

    private static void persistMessageContext(MessageContext mc) {
        try {
            ConfigurationContext cc = mc.getConfigurationContext();
            OperationContext op = mc.getOperationContext();
            if (cc == null && op != null) {
                cc = op.getConfigurationContext();
            }
            File theFile = null;
            theFile = File.createTempFile("DebugPersist", null);
            FileOutputStream outStream = new FileOutputStream(theFile);
            ObjectOutputStream outObjStream = new ObjectOutputStream(outStream);
            outObjStream.writeObject(mc);
            outObjStream.flush();
            outObjStream.close();
            outStream.flush();
            outStream.close();
            FileInputStream inStream = new FileInputStream(theFile);
            ObjectInputStream inObjStream = new ObjectInputStream(inStream);
            MessageContext restoredMC = (MessageContext)inObjStream.readObject();
            inObjStream.close();
            inStream.close();
            if (cc == null && op == null) {
                return;
            }
            if (cc != null) {
                restoredMC.activate(cc);
            } else {
                restoredMC.activateWithOperationContext(op);
            }
            if (restoredMC.getServiceContext() == null) {
                throw ExceptionFactory.makeWebServiceException("No Service Group!");
            }
            if (cc != null) {
                mc.activate(cc);
            } else {
                mc.activateWithOperationContext(op);
            }
            if (mc.getOperationContext() == null) {
                throw new RuntimeException("No Operation Context");
            }
            if (mc.getOperationContext().getServiceContext() == null) {
                throw new RuntimeException("No Service Context");
            }
            return;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

