/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.deployment.WarBasedAxisConfigurator;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.transport.http.util.QueryStringParser;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServlet
extends HttpServlet
implements TransportListener {
    private static final Log log = LogFactory.getLog(AxisServlet.class);
    public static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";
    public static final String SESSION_ID = "SessionId";
    private static final Set<String> metadataQueryParamNames = new HashSet<String>(Arrays.asList("wsdl2", "wsdl", "xsd", "policy"));
    protected transient ConfigurationContext configContext;
    protected transient AxisConfiguration axisConfiguration;
    protected transient ServletConfig servletConfig;
    protected transient ListingAgent agent;
    protected transient String contextRoot = null;
    protected boolean disableREST = false;
    private static final String LIST_SERVICES_SUFFIX = "/services/listServices";
    private static final String LIST_FAULTY_SERVICES_SUFFIX = "/services/ListFaultyServices";
    private boolean closeReader = true;
    private static final int BUFFER_SIZE = 8192;
    private boolean initCalled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setBufferSize(8192);
        }
        catch (Throwable t) {
            log.info("Old Servlet API :" + t);
        }
        this.initContextRoot(request);
        ServletOutputStream out = response.getOutputStream();
        String contentType = request.getContentType();
        if (!HTTPTransportUtils.isRESTRequest(contentType)) {
            MessageContext msgContext = this.createMessageContext(request, response);
            msgContext.setProperty("ContentType", contentType);
            try {
                String url;
                try {
                    url = request.getRequestURL().toString();
                }
                catch (Throwable t) {
                    log.info("Old Servlet API (fallback to HttpServletRequest.getRequestURI) :" + t);
                    url = request.getRequestURI();
                }
                Handler.InvocationResponse pi = HTTPTransportUtils.processHTTPPostRequest(msgContext, new BufferedInputStream(request.getInputStream()), new BufferedOutputStream(out), contentType, request.getHeader("SOAPAction"), url);
                Boolean holdResponse = (Boolean)msgContext.getProperty("HoldResponse");
                if (pi.equals(Handler.InvocationResponse.SUSPEND) || holdResponse != null && Boolean.TRUE.equals(holdResponse)) {
                    ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).awaitResponse();
                }
                response.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
                if (TransportUtils.isResponseWritten(msgContext) || ((RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl")).getStatus() == RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED) return;
                response.setStatus(202);
                return;
            }
            catch (AxisFault e) {
                this.setResponseState(msgContext, response);
                log.debug(e);
                if (msgContext == null) throw new ServletException(e);
                this.processAxisFault(msgContext, response, out, e);
                return;
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                try {
                    if (AddressingHelper.isFaultRedirected(msgContext)) {
                        response.setStatus(202);
                    } else {
                        Integer code;
                        AxisBindingMessage axisBindingMessage;
                        response.setStatus(500);
                        AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                        if (axisBindingOperation != null && (axisBindingMessage = axisBindingOperation.getFault((String)msgContext.getProperty("faultName"))) != null && (code = (Integer)axisBindingMessage.getProperty("whttp:code")) != null) {
                            response.setStatus(code);
                        }
                    }
                    this.handleFault(msgContext, out, new AxisFault(t.toString(), t));
                    return;
                }
                catch (AxisFault e2) {
                    log.info(e2);
                    throw new ServletException(e2);
                }
            }
            finally {
                this.closeStaxBuilder(msgContext);
                TransportUtils.deleteAttachments(msgContext);
            }
        }
        if (!this.disableREST) {
            new RestRequestProcessor("POST", request, response).processXMLRequest();
            return;
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        String requestURI = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && new QueryStringParser(query).search(metadataQueryParamNames)) {
            this.agent.initTransportListener(request);
            this.agent.processListService(request, response);
        } else if (requestURI.endsWith(".xsd") || requestURI.endsWith(".wsdl")) {
            this.agent.processExplicitSchemaAndWSDL(request, response);
        } else if (requestURI.endsWith(LIST_SERVICES_SUFFIX) || requestURI.endsWith(LIST_FAULTY_SERVICES_SUFFIX)) {
            try {
                this.agent.handle(request, response);
            }
            catch (Exception e) {
                throw new ServletException(e);
            }
        } else if (!this.disableREST) {
            new RestRequestProcessor("GET", request, response).processURLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        if (!this.disableREST) {
            new RestRequestProcessor("DELETE", request, response).processURLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        if (!this.disableREST) {
            new RestRequestProcessor("PUT", request, response).processXMLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    protected void showRestDisabledErrorMessage(HttpServletResponse response) throws IOException {
        PrintWriter writer = new PrintWriter(response.getOutputStream());
        writer.println("<html><body><h2>Please enable REST support in WEB-INF/conf/axis2.xml and WEB-INF/web.xml</h2></body></html>");
        writer.flush();
        response.setStatus(202);
    }

    private void closeStaxBuilder(MessageContext messageContext) throws ServletException {
        if (this.closeReader && messageContext != null) {
            try {
                StAXBuilder builder;
                SOAPEnvelope envelope = messageContext.getEnvelope();
                if (envelope != null && (builder = (StAXBuilder)envelope.getBuilder()) != null) {
                    builder.close();
                }
            }
            catch (Exception e) {
                log.debug(e.toString(), e);
            }
        }
    }

    private void processAxisFault(MessageContext msgContext, HttpServletResponse res, OutputStream out, AxisFault e) {
        try {
            if (AddressingHelper.isFaultRedirected(msgContext)) {
                res.setStatus(202);
            } else {
                Integer code;
                AxisBindingMessage fault;
                String status2 = (String)msgContext.getProperty("axis2.http.response.state");
                if (status2 == null) {
                    res.setStatus(500);
                } else {
                    res.setStatus(Integer.parseInt(status2));
                }
                AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                if (axisBindingOperation != null && (fault = axisBindingOperation.getFault((String)msgContext.getProperty("faultName"))) != null && (code = (Integer)fault.getProperty("whttp:code")) != null) {
                    res.setStatus(code);
                }
            }
            this.handleFault(msgContext, out, e);
        }
        catch (AxisFault e2) {
            log.info(e2);
        }
    }

    protected void handleFault(MessageContext msgContext, OutputStream out, AxisFault e) throws AxisFault {
        msgContext.setProperty("TRANSPORT_OUT", out);
        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgContext, e);
        HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        if (response != null) {
            SOAPFaultCode code = faultContext.getEnvelope().getBody().getFault().getCode();
            OMElement valueElement = null;
            if (code != null) {
                valueElement = code.getFirstChildWithName(new QName("http://www.w3.org/2003/05/soap-envelope", "Value"));
            }
            if (valueElement != null && "Sender".equals(valueElement.getTextAsQName().getLocalPart()) && !msgContext.isDoingREST()) {
                response.setStatus(400);
            }
        }
        AxisEngine.sendFault(faultContext);
    }

    public void init(ServletConfig config) throws ServletException {
        this.initCalled = true;
        super.init(config);
        try {
            this.servletConfig = config;
            ServletContext servletContext = this.servletConfig.getServletContext();
            this.configContext = (ConfigurationContext)servletContext.getAttribute(CONFIGURATION_CONTEXT);
            if (this.configContext == null) {
                this.configContext = this.initConfigContext(config);
                config.getServletContext().setAttribute(CONFIGURATION_CONTEXT, this.configContext);
            }
            this.axisConfiguration = this.configContext.getAxisConfiguration();
            ListenerManager listenerManager = new ListenerManager();
            listenerManager.init(this.configContext);
            TransportInDescription transportInDescription = new TransportInDescription("http");
            transportInDescription.setReceiver(this);
            listenerManager.addListener(transportInDescription, true);
            listenerManager.start();
            ListenerManager.defaultConfigurationContext = this.configContext;
            this.agent = new ListingAgent(this.configContext);
            this.initParams();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        try {
            if (this.configContext != null) {
                this.configContext.terminate();
            }
        }
        catch (AxisFault axisFault) {
            log.info(axisFault.getMessage());
        }
        try {
            super.destroy();
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    protected void initParams() {
        Parameter parameter = this.axisConfiguration.getParameter("disableREST");
        if (parameter != null) {
            boolean bl = this.disableREST = !JavaUtils.isFalseExplicitly(parameter.getValue());
        }
        if ((parameter = this.axisConfiguration.getParameter("axis2.close.reader")) != null) {
            this.closeReader = JavaUtils.isTrueExplicitly(parameter.getValue());
        }
    }

    public void init() throws ServletException {
        if (this.servletConfig != null && !this.initCalled) {
            this.init(this.servletConfig);
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        try {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContext(new WarBasedAxisConfigurator(config));
            configContext.setProperty("ContainerManaged", "true");
            return configContext;
        }
        catch (Exception e) {
            log.info(e);
            throw new ServletException(e);
        }
    }

    public void initContextRoot(HttpServletRequest req) {
        if (this.contextRoot != null && this.contextRoot.trim().length() != 0) {
            return;
        }
        String contextPath = null;
        try {
            contextPath = req.getContextPath();
        }
        catch (Throwable t) {
            log.info("Old Servlet API (Fallback to HttpServletRequest.getServletPath) :" + t);
            contextPath = req.getServletPath();
        }
        if (contextPath != null && contextPath.length() == 0) {
            contextPath = "/";
        }
        this.contextRoot = contextPath;
        this.configContext.setContextRoot(this.contextRoot);
    }

    protected Map getTransportHeaders(HttpServletRequest req) {
        return new TransportHeaders(req);
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String port = (String)this.configContext.getProperty("RUNNING_PORT");
        if (port == null) {
            port = "8080";
        }
        if (ip == null) {
            try {
                ip = Utils.getIpAddress(this.axisConfiguration);
                if (ip == null) {
                    ip = "localhost";
                }
            }
            catch (SocketException e) {
                throw AxisFault.makeFault(e);
            }
        }
        String endpointRefernce = "http://" + ip + ":" + port;
        endpointRefernce = this.configContext.getServiceContextPath().startsWith("/") ? endpointRefernce + this.configContext.getServiceContextPath() + "/" + serviceName : endpointRefernce + '/' + this.configContext.getServiceContextPath() + "/" + serviceName;
        EndpointReference endpoint = new EndpointReference(endpointRefernce + "/");
        return new EndpointReference[]{endpoint};
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
    }

    public void start() throws AxisFault {
    }

    public void stop() throws AxisFault {
    }

    protected MessageContext createMessageContext(HttpServletRequest request, HttpServletResponse response, boolean invocationType) throws IOException {
        String query;
        MessageContext msgContext = this.configContext.createMessageContext();
        String requestURI = request.getRequestURI();
        String trsPrefix = null;
        int sepindex = -1;
        try {
            trsPrefix = request.getRequestURL().toString();
        }
        catch (Throwable t) {
            log.info("Old Servlet API (Fallback to HttpServletRequest.getRequestURI) :" + t);
            trsPrefix = request.getRequestURI();
        }
        sepindex = trsPrefix.indexOf(58);
        if (sepindex > -1) {
            trsPrefix = trsPrefix.substring(0, sepindex);
            msgContext.setIncomingTransportName(trsPrefix);
        } else {
            msgContext.setIncomingTransportName("http");
            trsPrefix = "http";
        }
        TransportInDescription transportIn = this.axisConfiguration.getTransportIn(msgContext.getIncomingTransportName());
        TransportOutDescription transportOut = this.axisConfiguration.getTransportOut(trsPrefix);
        if (transportOut == null) {
            transportOut = this.axisConfiguration.getTransportOut("http");
        }
        msgContext.setTransportIn(transportIn);
        msgContext.setTransportOut(transportOut);
        msgContext.setServerSide(true);
        if (!invocationType && (query = request.getQueryString()) != null) {
            requestURI = requestURI + "?" + query;
        }
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setFrom(new EndpointReference(request.getRemoteAddr()));
        msgContext.setProperty("REMOTE_ADDR", request.getRemoteAddr());
        msgContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(response));
        msgContext.setProperty("TRANSPORT_HEADERS", this.getTransportHeaders(request));
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, request);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, response);
        try {
            ServletContext context = this.getServletContext();
            if (context != null) {
                msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, context);
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), e);
        }
        msgContext.setProperty("RequestResponseTransportControl", new ServletRequestResponseTransport(response));
        return msgContext;
    }

    protected MessageContext createMessageContext(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        return this.createMessageContext(req, resp, true);
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        HttpServletRequest req = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        SessionContext sessionContext = (SessionContext)req.getSession(true).getAttribute("SessionContext");
        String sessionId = req.getSession().getId();
        if (sessionContext == null) {
            sessionContext = new SessionContext(null);
            sessionContext.setCookieID(sessionId);
            req.getSession().setAttribute("SessionContext", sessionContext);
        }
        messageContext.setSessionContext(sessionContext);
        messageContext.setProperty(SESSION_ID, sessionId);
        return sessionContext;
    }

    private void setResponseState(MessageContext messageContext, HttpServletResponse response) {
        int stateInt;
        String state = (String)messageContext.getProperty("axis2.http.response.state");
        if (state != null && (stateInt = Integer.parseInt(state)) == 401) {
            String realm = (String)messageContext.getProperty("axis2.authentication.realm");
            response.addHeader("WWW-Authenticate", "basic realm=\"" + realm + "\"");
        }
    }

    protected class RestRequestProcessor {
        protected MessageContext messageContext;
        private HttpServletRequest request;
        private HttpServletResponse response;

        public RestRequestProcessor(String httpMethodString, HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.request = request;
            this.response = response;
            this.messageContext = AxisServlet.this.createMessageContext(this.request, this.response, false);
            this.messageContext.setProperty("HTTP_METHOD_OBJECT", httpMethodString);
        }

        public void processXMLRequest() throws IOException, ServletException {
            try {
                RESTUtil.processXMLRequest(this.messageContext, this.request.getInputStream(), this.response.getOutputStream(), this.request.getContentType());
                this.checkResponseWritten();
            }
            catch (AxisFault axisFault) {
                this.processFault(axisFault);
            }
            AxisServlet.this.closeStaxBuilder(this.messageContext);
        }

        public void processURLRequest() throws IOException, ServletException {
            try {
                RESTUtil.processURLRequest(this.messageContext, this.response.getOutputStream(), this.request.getContentType());
                this.checkResponseWritten();
            }
            catch (AxisFault e) {
                AxisServlet.this.setResponseState(this.messageContext, this.response);
                this.processFault(e);
            }
            AxisServlet.this.closeStaxBuilder(this.messageContext);
        }

        private void checkResponseWritten() {
            if (!TransportUtils.isResponseWritten(this.messageContext)) {
                this.response.setStatus(202);
            }
        }

        private void processFault(AxisFault e) throws ServletException, IOException {
            log.debug(e);
            if (this.messageContext == null) {
                throw new ServletException(e);
            }
            AxisServlet.this.processAxisFault(this.messageContext, this.response, this.response.getOutputStream(), e);
        }
    }

    protected class ServletRequestResponseTransport
    implements RequestResponseTransport {
        private HttpServletResponse response;
        private boolean responseWritten = false;
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        AxisFault faultToBeThrownOut = null;

        ServletRequestResponseTransport(HttpServletResponse response) {
            this.response = response;
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            this.responseReadySignal.countDown();
        }

        public void awaitResponse() throws InterruptedException, AxisFault {
            log.debug("Blocking servlet thread -- awaiting response");
            this.responseReadySignal.await();
            if (this.faultToBeThrownOut != null) {
                throw this.faultToBeThrownOut;
            }
        }

        public void signalResponseReady() {
            log.debug("Signalling response available");
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public void signalFaultReady(AxisFault fault) {
            this.faultToBeThrownOut = fault;
            this.signalResponseReady();
        }

        public boolean isResponseWritten() {
            return this.responseWritten;
        }

        public void setResponseWritten(boolean responseWritten) {
            this.responseWritten = responseWritten;
        }
    }
}

