#######################################################################
# Copyright 2012 VMware, Inc.  All rights reserved.                   #
#######################################################################

#Functions

print_msg() {
    eval echo -e `gettext 'INFO: $@'`
}

print_err() {
    eval echo -e `gettext 'ERROR: $@'`
}

print_verbose() {
    if [ $VERBOSE != 0 ]
    then
        eval echo -e `gettext 'DEBUG: $@'`
    fi
}

# Adds a warning message to the array of messages that have to be
# displayed at the end of the successfull installation.
add_warning() {
   warningMessages=( "${warningMessages[@]}" "$@" )
}

# Prints warnings accumulated in $warningMessages array.
print_warnings() {
   for msg in "${warningMessages[@]}"
   do
      echo -e WARNING: $msg
   done
}

# Removes user account
# Arguments
# $1 - user account name.
# $2 - silent [0|1] - do not prompt for confirmation
remove_useraccount() {
    username=$1
    silent=$2

    print_verbose "Perform user account deletion $@"
    if [ "X$username" == "X" ]
    then
        print_msg "Must specify user name for deletion"
        return 1
    fi

    if [ $silent == 1 ]
    then
        doDelete="y"
    else
        read -p "Delete user $username account and the home directory? [y/n]: " doDelete
    fi

    if [ "$doDelete" == "y" -o "$doDelete" == "Y" ]
    then
        print_msg "Deleting user account $username."
        uerr=`userdel -rf $username 2>&1`
        if [ $? != 0 ]
        then
            echo "$uerr" | grep mail > /dev/null 2>&1
            if [ $? != 0 ]
            then
                print_msg "Failed delete user account $deluser"
                print_msg "$uerr"
                return 1
            fi
        fi
    fi

    print_verbose "Done user account deletion"

    return 0
}

# Removes the product directory
# Arguments
# $1 - product directory.
# $2 - silent [0|1] - do not prompt for confirmation
remove_directory() {
    productDir=$1
    silent=$2

    if [ $silent == 1 ]
    then
        doDelete="y"
    else
        read -p "Delete directory $productDir? [y/n]: " doDelete
    fi

    if [ "$doDelete" == "y" -o "$doDelete" == "Y" ]
    then
        print_msg "Deleting directory $productDir."
        rm -r $productDir
    fi
}

# Returns the list of ports from a given 'ini' file.
# Arguments
# $1 - ini file
get_list_of_ports() {
    inifile=$1

    if [ ! -e "$inifile" ]
    then
        print_err "File $inifile does not exist."
        return 1
    fi

    result=""
    while read line
    do
        port=`echo "$line" | sed 's/\(.*\)=\(.*\)/\2/'`
        if [ "X$result" != "X" ]
        then
            result="${result},${port}"
        else
            result="${port}"
        fi
    done < $1

    echo $result
    return 0
}

# Returns Linux distribution using standard output. Possible values are:
# RedHat
# SuSE
# Ubuntu
# Generic - if the distribution cannot be detected.
get_linux_distribution() {
    if [ -f /etc/redhat-release -o -f /etc/redhat_version -o -f /etc/fedora-release ]  ; then
        echo "RedHat"
    elif [ -f /etc/SuSE-release ] ; then
        echo "SuSE"
    elif [ -f /etc/lsb-release ] ; then
        echo "Ubuntu"
    else
        echo "Generic"
    fi

    return 0
}