/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.token.impl;

import com.rsa.names._2009._12.std_ext.saml2.RSAAdviceType;
import com.rsa.names._2009._12.std_ext.saml2.RenewRestrictionType;
import com.rsa.names._2010._04.std_prof.saml2.AttributeNames;
import com.vmware.identity.token.impl.PrincipalIdParser;
import com.vmware.identity.token.impl.Util;
import com.vmware.identity.token.impl.ValidateUtil;
import com.vmware.identity.token.impl.X509TrustChainKeySelector;
import com.vmware.identity.token.impl.exception.ParserException;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.Advice;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.IssuerNameId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SubjectNameId;
import com.vmware.vim.sso.client.ValidatableSamlTokenEx;
import com.vmware.vim.sso.client.XmlParserFactory;
import com.vmware.vim.sso.client.exception.InvalidSignatureException;
import com.vmware.vim.sso.client.exception.InvalidTimingException;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.MalformedTokenException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import oasis.names.tc.saml._2_0.assertion.AdviceType;
import oasis.names.tc.saml._2_0.assertion.AssertionType;
import oasis.names.tc.saml._2_0.assertion.AttributeStatementType;
import oasis.names.tc.saml._2_0.assertion.AttributeType;
import oasis.names.tc.saml._2_0.assertion.AudienceRestrictionType;
import oasis.names.tc.saml._2_0.assertion.AuthnStatementType;
import oasis.names.tc.saml._2_0.assertion.ConditionAbstractType;
import oasis.names.tc.saml._2_0.assertion.ConditionsType;
import oasis.names.tc.saml._2_0.assertion.KeyInfoConfirmationDataType;
import oasis.names.tc.saml._2_0.assertion.NameIDType;
import oasis.names.tc.saml._2_0.assertion.ProxyRestrictionType;
import oasis.names.tc.saml._2_0.assertion.SubjectConfirmationDataType;
import oasis.names.tc.saml._2_0.assertion.SubjectConfirmationType;
import oasis.names.tc.saml._2_0.assertion.SubjectType;
import oasis.names.tc.saml._2_0.conditions.delegation.DelegateType;
import oasis.names.tc.saml._2_0.conditions.delegation.DelegationRestrictionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig_.KeyInfoType;
import org.w3._2000._09.xmldsig_.X509DataType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SamlTokenImpl
implements ValidatableSamlTokenEx {
    private long _startTime;
    private long _expirationTime;
    private boolean _isRenewable;
    private boolean _isDelegable;
    private ConfirmationType _confirmationType;
    private PrincipalId _subjectUPN;
    private SubjectNameId _subjectId;
    private IssuerNameId _issuerId;
    private final Document _parsedToken;
    private long _issueInstant;
    private String _id;
    private List<SamlToken.TokenDelegate> _delegationChain = Collections.emptyList();
    private List<ValidatableSamlTokenEx.TokenDelegateEx> _delegationChainEx = Collections.emptyList();
    private Set<String> _audienceRestrictionList = Collections.emptySet();
    private X509Certificate _confirmationCertificate;
    private List<Advice> _advice = Collections.emptyList();
    private List<PrincipalId> _groups = Collections.emptyList();
    private boolean _isSolution;
    private final AtomicBoolean _tokenValidated = new AtomicBoolean(false);
    private static final Schema SAML_SCHEMA = SamlTokenImpl.loadSamlSchema();
    private XMLGregorianCalendar _subjConfExp;
    private static final String ATTRIBUTE_FORMAT_URI = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
    private static final String SAML_SCHEMA_FILENAME = "profiled-saml-schema-assertion-2.0.xsd";
    private static final String DEFAULT_TIME_ZONE = "GMT";
    private static final String BEARER_CONFIRMATION = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    private static final String HOLDER_OF_KEY_CONFIRMATION = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
    private static final String XMLNS_NS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String SIGNATURE_ELEMENT_NAME = "Signature";
    private static final String ASSERTION_ID_ATTR_NAME = "ID";
    private static final String SIGNATURE_VALIDATION_ERROR_MSG = "Signature validation failed";
    private static final String PARSING_TOKEN_ERROR_MSG = "Error parsing SAML token.";
    private static final String PARSE_DELEGATION_ERR_MSG = "Cannot parse delegation restrictions.";
    private static final String X509_CERT_FACTORY_TYPE = "X.509";
    private static final String CERTIFICATE_PARSE_ERR_MSG = "Cannot parse user's confirmation certificate";
    private static final String SUBJ_CONF_DATA_NOT_FOUNT_MSG = "Cannot find subject confirmation data";
    private static final String SUBJ_CONF_DATA_WRONG_TYPE_MSG = "SubjectConfirmationData is not instance of KeyInfoConfirmationData type which is necessary for this kind of tokens (HOK).";
    private static final String ERR_LOADNIG_SAML_SCHEMA = "An error occured while loading SAML schema.";
    private static final String PARSE_GROUPS_ERR_MSG = "Cannot parse group information";
    private static final String PARSE_ISSOLUTION_ERR_MSG = "Value for attribute isSolution is not valid.";
    private static final String UPN_FORMAT_URI = "http://schemas.xmlsoap.org/claims/UPN";
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final XmlParserFactory xmlParserFactory = XmlParserFactory.Factory.createSecureXmlParserFactory();
    private final Logger _log = LoggerFactory.getLogger(SamlTokenImpl.class);
    private final JAXBContext _jaxbContext;

    private SamlTokenImpl(String sourceType, Document tokenDoc, JAXBContext jaxbContext, Boolean allowNonUpnFormat) throws InvalidTokenException {
        ValidateUtil.validateNotNull(tokenDoc, "token " + sourceType);
        ValidateUtil.validateNotNull(jaxbContext, "JAXBContext");
        this._jaxbContext = jaxbContext;
        this._parsedToken = tokenDoc;
        this.validateAndPopulate(allowNonUpnFormat);
        SamlTokenImpl.markAssertionIdAttribute(this._parsedToken.getDocumentElement());
        this._log.info("SAML token for " + this._subjectId + " successfully parsed from " + sourceType);
    }

    public SamlTokenImpl(String xml, JAXBContext jaxbContext) throws InvalidTokenException {
        this("XML", SamlTokenImpl.parseTokenXmlToDom(xml), jaxbContext, false);
    }

    public SamlTokenImpl(Element tokenRoot, JAXBContext jaxbContext) throws InvalidTokenException {
        this("Element", SamlTokenImpl.createStandaloneCopy(tokenRoot), jaxbContext, false);
    }

    public SamlTokenImpl(String xml, JAXBContext jaxbContext, Boolean allowDelegateInNonUpnFormat) throws InvalidTokenException {
        this("XML", SamlTokenImpl.parseTokenXmlToDom(xml), jaxbContext, allowDelegateInNonUpnFormat);
    }

    public SamlTokenImpl(Element tokenRoot, JAXBContext jaxbContext, Boolean allowDelegateInNonUpnFormat) throws InvalidTokenException {
        this("Element", SamlTokenImpl.createStandaloneCopy(tokenRoot), jaxbContext, allowDelegateInNonUpnFormat);
    }

    @Override
    public Date getStartTime() {
        this.checkIsSignatureValidated();
        return new Date(this._startTime);
    }

    @Override
    public Date getExpirationTime() {
        this.checkIsSignatureValidated();
        return new Date(this._expirationTime);
    }

    @Override
    public boolean isRenewable() {
        this.checkIsSignatureValidated();
        return this._isRenewable;
    }

    @Override
    public boolean isDelegable() {
        this.checkIsSignatureValidated();
        return this._isDelegable;
    }

    @Override
    public ConfirmationType getConfirmationType() {
        this.checkIsSignatureValidated();
        return this._confirmationType;
    }

    @Override
    public String toXml() {
        this.checkIsSignatureValidated();
        try {
            return Util.serializeToString(this._parsedToken.getDocumentElement());
        }
        catch (ParserException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Node importTo(Document hostDocument) {
        ValidateUtil.validateNotNull(hostDocument, "Host document");
        Element clonedTokenElement = (Element)hostDocument.importNode(this._parsedToken.getDocumentElement(), true);
        SamlTokenImpl.markAssertionIdAttribute(clonedTokenElement);
        return clonedTokenElement;
    }

    public void export(Result destination) {
        Transformer xfrm;
        this.checkIsSignatureValidated();
        TransformerFactory xfrmFactory = TransformerFactory.newInstance();
        try {
            xfrm = xfrmFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Failed to create XML identity transformer (incompliant Java implementation?)", e);
        }
        try {
            xfrm.transform(new DOMSource(this._parsedToken), destination);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Exporting SAML XML failed with the supplied destination", e);
        }
    }

    @Override
    public PrincipalId getSubject() {
        this.checkIsSignatureValidated();
        return this._subjectUPN;
    }

    @Override
    public SubjectNameId getSubjectNameId() {
        this.checkIsSignatureValidated();
        return this._subjectId;
    }

    @Override
    public IssuerNameId getIssuerNameId() {
        this.checkIsSignatureValidated();
        return this._issuerId;
    }

    @Override
    public String getId() {
        this.checkIsSignatureValidated();
        return this._id;
    }

    @Override
    public List<SamlToken.TokenDelegate> getDelegationChain() {
        this.checkIsSignatureValidated();
        return this._delegationChain;
    }

    @Override
    public List<ValidatableSamlTokenEx.TokenDelegateEx> getDelegationChainEx() {
        this.checkIsSignatureValidated();
        return this._delegationChainEx;
    }

    @Override
    public Set<String> getAudience() {
        this.checkIsSignatureValidated();
        return this._audienceRestrictionList;
    }

    @Override
    public X509Certificate getConfirmationCertificate() {
        this.checkIsSignatureValidated();
        return this._confirmationCertificate;
    }

    @Override
    public List<Advice> getAdvice() {
        this.checkIsSignatureValidated();
        return this._advice;
    }

    @Override
    public List<PrincipalId> getGroupList() {
        this.checkIsSignatureValidated();
        return this._groups;
    }

    @Override
    public boolean isSolution() {
        this.checkIsSignatureValidated();
        return this._isSolution;
    }

    @Override
    public void validate(X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        ValidateUtil.validateNotEmpty(trustedRootCertificates, "Trusted root certificates");
        X509TrustChainKeySelector signKeySelector = new X509TrustChainKeySelector(trustedRootCertificates);
        if (!this.validateSignature(signKeySelector)) {
            this._log.info("SAML token cannot be constructed: Signature validation failed");
            throw new InvalidSignatureException(SIGNATURE_VALIDATION_ERROR_MSG);
        }
        this.validateWithinTokenLifePeriod(clockToleranceSec);
        this.validateSubjectConfirmationExpDate();
        this._tokenValidated.set(true);
        this._log.debug("Token is successfully validated");
    }

    private void validateAndPopulate(Boolean allowNonUpnFormat) throws InvalidTokenException {
        JAXBElement jaxbParserResult = null;
        try {
            Unmarshaller unmarshaller = this._jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(SAML_SCHEMA);
            jaxbParserResult = (JAXBElement)unmarshaller.unmarshal((Node)this._parsedToken);
        }
        catch (JAXBException e) {
            this._log.info(PARSING_TOKEN_ERROR_MSG, (Throwable)e);
            throw new MalformedTokenException(PARSING_TOKEN_ERROR_MSG, e);
        }
        AssertionType assertion = (AssertionType)jaxbParserResult.getValue();
        this.parseAssertionAttributes(assertion);
        this.parseConditions(assertion.getConditions(), allowNonUpnFormat);
        this.parseSubject(assertion.getSubject());
        this.parseIssuer(assertion.getIssuer());
        this.parseAuthnStatement(assertion.getAuthnStatement());
        if (assertion.getAttributeStatement() != null) {
            this.parseAttributeStatement(assertion.getAttributeStatement());
        }
        if (assertion.getAdvice() != null) {
            this.parseAdvice(assertion.getAdvice());
        }
        this._log.debug("Token fields are successfully populated");
    }

    private void parseAssertionAttributes(AssertionType assertion) {
        this._issueInstant = assertion.getIssueInstant().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis();
        this._id = assertion.getID();
        assert (this._id != null) : "assertion ID is required attribute";
        if (this._log.isDebugEnabled()) {
            this._log.debug("SAML assertion attributes successfully parsed. Got issueInstant: " + new Date(this._issueInstant));
        }
    }

    private boolean validateSignature(KeySelector keySelector) throws MalformedTokenException {
        NodeList securityNodeList = this._parsedToken.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_ELEMENT_NAME);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance();
        DOMValidateContext valContext = new DOMValidateContext(keySelector, securityNodeList.item(0));
        boolean isValid = false;
        try {
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            isValid = signature.validate(valContext);
        }
        catch (MarshalException e) {
            this._log.error(SIGNATURE_VALIDATION_ERROR_MSG, (Throwable)e);
            throw new MalformedTokenException(SIGNATURE_VALIDATION_ERROR_MSG, e);
        }
        catch (XMLSignatureException e) {
            this._log.error(SIGNATURE_VALIDATION_ERROR_MSG, (Throwable)e);
            throw new MalformedTokenException(SIGNATURE_VALIDATION_ERROR_MSG, e);
        }
        this._log.debug("SAML token signature is valid status: " + isValid);
        return isValid;
    }

    private static Document parseTokenXmlToDom(String xmlToken) throws MalformedTokenException {
        Document parsedToken;
        if (xmlToken == null) {
            return null;
        }
        Logger log = LoggerFactory.getLogger(SamlTokenImpl.class);
        try {
            parsedToken = xmlParserFactory.newDocumentBuilder().parse(new InputSource(new StringReader(xmlToken)));
        }
        catch (SAXException e) {
            log.info(PARSING_TOKEN_ERROR_MSG, (Throwable)e);
            throw new MalformedTokenException(PARSING_TOKEN_ERROR_MSG, e);
        }
        catch (IOException e) {
            String message = "Error reading from in-memory stream (heap space exhausted?)";
            log.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
        catch (ParserConfigurationException e) {
            String message = "DOM Document builder is not available (incompatible Java implementation?)";
            log.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
        return parsedToken;
    }

    private static Document createStandaloneCopy(Element element) {
        Transformer tx;
        HashMap<String, String> visibleNamespaces = new HashMap<String, String>();
        for (Node walker = element.getParentNode(); walker != null && walker.getNodeType() == 1; walker = walker.getParentNode()) {
            NamedNodeMap attrs = walker.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (!XMLNS_NS_URI.equals(attr.getNamespaceURI()) || visibleNamespaces.containsKey(attr.getName())) continue;
                visibleNamespaces.put(attr.getName(), attr.getValue());
            }
        }
        try {
            tx = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed to create identity XML transformer. Incompatible Java platform?", e);
        }
        DOMResult result = new DOMResult();
        try {
            tx.transform(new DOMSource(element), result);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Unexpected failure in Identity DOM-to-DOM transformation", e);
        }
        Document standaloneDoc = (Document)result.getNode();
        Element standaloneToken = standaloneDoc.getDocumentElement();
        for (Map.Entry nsAttr : visibleNamespaces.entrySet()) {
            standaloneToken.setAttributeNS(XMLNS_NS_URI, (String)nsAttr.getKey(), (String)nsAttr.getValue());
        }
        return standaloneDoc;
    }

    private void parseConditions(ConditionsType conditions, Boolean allowNonUpnFormat) throws MalformedTokenException {
        this._startTime = conditions.getNotBefore().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis();
        this._expirationTime = conditions.getNotOnOrAfter().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis();
        List<ConditionAbstractType> conditionList = conditions.getConditionOrAudienceRestrictionOrProxyRestriction();
        for (ConditionAbstractType condition : conditionList) {
            BigInteger count;
            if (condition instanceof ProxyRestrictionType) {
                count = ((ProxyRestrictionType)condition).getCount();
                this._isDelegable = count != null && count.longValue() > 0L;
                continue;
            }
            if (condition instanceof AudienceRestrictionType) {
                HashSet<String> audienceSet = new HashSet<String>();
                audienceSet.addAll(((AudienceRestrictionType)condition).getAudience());
                this._audienceRestrictionList = Collections.unmodifiableSet(audienceSet);
                continue;
            }
            if (condition instanceof RenewRestrictionType) {
                count = ((RenewRestrictionType)condition).getCount();
                this._isRenewable = count != null && count.longValue() > 0L;
                continue;
            }
            if (!(condition instanceof DelegationRestrictionType)) continue;
            this.parseDelegationChain((DelegationRestrictionType)condition, allowNonUpnFormat);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Conditions parsed successfully. Got startTime: " + new Date(this._startTime) + " expirationTime: " + new Date(this._expirationTime));
        }
    }

    private void validateWithinTokenLifePeriod(long clockToleranceSec) throws InvalidTimingException {
        if (this._expirationTime < this._startTime) {
            String message = "Start time / Expiration time not valid: StartTime: " + new Date(this._startTime) + " ExpirationTime: " + new Date(this._expirationTime);
            this._log.error(message);
            throw new InvalidTimingException(message);
        }
        long effectiveExpirationTime = this._expirationTime + clockToleranceSec * 1000L;
        long currentTime = Calendar.getInstance(TimeZone.getTimeZone(DEFAULT_TIME_ZONE)).getTimeInMillis();
        if (effectiveExpirationTime < currentTime) {
            String message = "Token expiration date: " + new Date(this._expirationTime) + " is in the past.";
            this._log.info(message);
            throw new InvalidTimingException(message);
        }
    }

    private void parseDelegationChain(DelegationRestrictionType delegation, Boolean allowNonUpnFormat) throws MalformedTokenException {
        ArrayList<TokenDelegateExImpl> delegationChain = new ArrayList<TokenDelegateExImpl>();
        for (DelegateType delegate : delegation.getDelegate()) {
            PrincipalId subject;
            try {
                subject = SamlTokenImpl.parseSubject(delegate.getNameID(), allowNonUpnFormat);
            }
            catch (ParserException e) {
                this._log.error(PARSE_DELEGATION_ERR_MSG, (Throwable)e);
                throw new MalformedTokenException(PARSE_DELEGATION_ERR_MSG, e);
            }
            delegationChain.add(new TokenDelegateExImpl(new SubjectNameId(delegate.getNameID().getValue(), delegate.getNameID().getFormat()), subject, delegate.getDelegationInstant().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis()));
        }
        Collections.sort(delegationChain, new Comparator<SamlToken.TokenDelegate>(){

            @Override
            public int compare(SamlToken.TokenDelegate o1, SamlToken.TokenDelegate o2) {
                long o2Date;
                long o1Date = o1.getDelegationDate().getTime();
                return o1Date < (o2Date = o2.getDelegationDate().getTime()) ? -1 : (o1Date == o2Date ? 0 : 1);
            }
        });
        this._delegationChainEx = Collections.unmodifiableList(delegationChain);
        this._delegationChain = Collections.unmodifiableList(delegationChain);
    }

    private void parseSubject(SubjectType subject) throws MalformedTokenException {
        NameIDType subjectNameID = subject.getNameID();
        this._subjectId = SamlTokenImpl.getSubjectId(subjectNameID);
        try {
            if (this._subjectId.getFormat().equalsIgnoreCase(UPN_FORMAT_URI)) {
                this._subjectUPN = PrincipalIdParser.parseUpn(subjectNameID.getValue());
            }
        }
        catch (ParserException e) {
            String upnParsingErrMsg = "Cannot parse subject because its value is not in UPN format";
            this._log.debug(upnParsingErrMsg, (Throwable)e);
            throw new MalformedTokenException(upnParsingErrMsg, e);
        }
        SubjectConfirmationType subConf = subject.getSubjectConfirmation();
        if (subConf.getMethod().equalsIgnoreCase(BEARER_CONFIRMATION)) {
            SubjectConfirmationDataType subConfData = subConf.getSubjectConfirmationData();
            this._subjConfExp = subConfData.getNotOnOrAfter();
            this._confirmationType = ConfirmationType.BEARER;
        } else if (subConf.getMethod().equalsIgnoreCase(HOLDER_OF_KEY_CONFIRMATION)) {
            this.parseHolderOfKeyConfirmation(subject);
            this._confirmationType = ConfirmationType.HOLDER_OF_KEY;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug(this._subjectId + " successfully extracted from the token");
            this._log.debug("Got confirmation type: " + (Object)((Object)this._confirmationType));
        }
    }

    private void parseIssuer(NameIDType issuer) throws MalformedTokenException {
        this._issuerId = null;
        if (issuer != null) {
            try {
                this._issuerId = new IssuerNameId(issuer.getValue(), issuer.getFormat());
                if (this._log.isDebugEnabled()) {
                    this._log.debug(this._issuerId + " successfully extracted from the token");
                }
            }
            catch (Exception ex) {
                this._log.debug("Cannot parse issuer.", (Throwable)ex);
                throw new MalformedTokenException("Invalid issuer.", ex);
            }
        }
    }

    private void validateSubjectConfirmationExpDate() throws InvalidTimingException {
        long subjConfExp;
        if (this._subjConfExp != null && (subjConfExp = this._subjConfExp.toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis()) > this._expirationTime) {
            String message = "Subject confirmation expiration time is not valid: Subject time: " + new Date(subjConfExp) + " Token ExpirationTime: " + new Date(this._expirationTime);
            this._log.error(message);
            throw new InvalidTimingException(message);
        }
    }

    private static PrincipalId parseSubject(NameIDType subject, Boolean allowNonUpnFormat) throws ParserException {
        String subjectFormat = subject.getFormat();
        String nameQualifier = subject.getNameQualifier();
        if (!(allowNonUpnFormat.booleanValue() || subjectFormat.equalsIgnoreCase(UPN_FORMAT_URI) && nameQualifier == null)) {
            throw new ParserException(String.format("Failed to parse subject: format = '%s', name qualifier = '%s'", subjectFormat, nameQualifier));
        }
        PrincipalId principal = null;
        if (subjectFormat.equalsIgnoreCase(UPN_FORMAT_URI)) {
            principal = PrincipalIdParser.parseUpn(subject.getValue());
        }
        return principal;
    }

    private static SubjectNameId getSubjectId(NameIDType subject) {
        assert (subject != null);
        return new SubjectNameId(subject.getValue(), subject.getFormat());
    }

    private void parseHolderOfKeyConfirmation(SubjectType subject) throws MalformedTokenException {
        byte[] cert;
        SubjectConfirmationDataType subjectConfirmationData = subject.getSubjectConfirmation().getSubjectConfirmationData();
        if (!(subjectConfirmationData instanceof KeyInfoConfirmationDataType)) {
            this._log.error(SUBJ_CONF_DATA_WRONG_TYPE_MSG);
            throw new MalformedTokenException(SUBJ_CONF_DATA_WRONG_TYPE_MSG);
        }
        KeyInfoType keyInfo = SamlTokenImpl.getTheValue(subjectConfirmationData.getContent(), KeyInfoType.class);
        X509DataType x509Data = keyInfo != null ? SamlTokenImpl.getTheValue(keyInfo.getContent(), X509DataType.class) : null;
        byte[] byArray = cert = x509Data != null ? SamlTokenImpl.getTheValue(x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName(), byte[].class) : null;
        if (cert != null) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance(X509_CERT_FACTORY_TYPE);
                this._confirmationCertificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
            }
            catch (CertificateException e) {
                this._log.error(CERTIFICATE_PARSE_ERR_MSG, (Throwable)e);
                throw new MalformedTokenException(CERTIFICATE_PARSE_ERR_MSG, e);
            }
        }
        if (this._confirmationCertificate == null) {
            this._log.error(SUBJ_CONF_DATA_NOT_FOUNT_MSG);
            throw new MalformedTokenException(SUBJ_CONF_DATA_NOT_FOUNT_MSG);
        }
    }

    private static <T> T getTheValue(List<?> list, Class<T> valueType) {
        JAXBElement<?> theOnlyElement = SamlTokenImpl.getSingleJaxbElement(list);
        return (T)(valueType.isInstance(theOnlyElement.getValue()) ? theOnlyElement.getValue() : null);
    }

    private static JAXBElement<?> getSingleJaxbElement(List<?> list) {
        JAXBElement theOnlyElement = null;
        for (Object obj : list) {
            if (!(obj instanceof JAXBElement)) continue;
            if (theOnlyElement != null) {
                return null;
            }
            theOnlyElement = (JAXBElement)obj;
        }
        return theOnlyElement;
    }

    private void parseAuthnStatement(AuthnStatementType authnStatement) {
        authnStatement.getAuthnInstant();
        authnStatement.getAuthnContext().getAuthnContextClassRef();
    }

    private void parseAdvice(AdviceType advice) {
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        for (RSAAdviceType rsaAdvice : advice.getRSAAdvice()) {
            String source = rsaAdvice.getAdviceSource();
            ArrayList<Advice.AdviceAttribute> adviceAttributes = new ArrayList<Advice.AdviceAttribute>();
            if (rsaAdvice.getAttribute() != null) {
                for (AttributeType attribute : rsaAdvice.getAttribute()) {
                    List<String> attrValues = attribute.getAttributeValue();
                    String attrName = attribute.getName();
                    String friendlyName = attribute.getFriendlyName();
                    if (attrValues == null) {
                        attrValues = new ArrayList<String>();
                    }
                    adviceAttributes.add(new Advice.AdviceAttribute(attrName, friendlyName, attrValues));
                }
            }
            adviceList.add(new Advice(source, adviceAttributes));
        }
        this._advice = Collections.unmodifiableList(adviceList);
    }

    private void parseAttributeStatement(AttributeStatementType attrStatement) throws MalformedTokenException {
        List<AttributeType> attributeList = attrStatement.getAttribute();
        ArrayList<PrincipalId> groupList = new ArrayList<PrincipalId>();
        for (AttributeType attribute : attributeList) {
            this.verifyElementFormatURI(attribute.getNameFormat(), ATTRIBUTE_FORMAT_URI);
            String attributeName = attribute.getName();
            if (attributeName.equals(AttributeNames.HTTP_RSA_COM_SCHEMAS_ATTR_NAMES_2009_01_GROUP_IDENTITY.value())) {
                try {
                    groupList.addAll(SamlTokenImpl.parseGroup(attribute.getAttributeValue()));
                }
                catch (ParserException e) {
                    this._log.debug(PARSE_GROUPS_ERR_MSG, (Throwable)e);
                    throw new MalformedTokenException(PARSE_GROUPS_ERR_MSG, e);
                }
                this._log.debug("Groups successfully extracted from token");
                continue;
            }
            if (!attributeName.equals(AttributeNames.HTTP_VMWARE_COM_SCHEMAS_ATTR_NAMES_2011_07_IS_SOLUTION.value())) continue;
            List<String> attributeValue = attribute.getAttributeValue();
            if (null != attributeValue && 1 == attributeValue.size()) {
                this._isSolution = Boolean.parseBoolean(attributeValue.get(0));
                this._log.debug("isSolution attribute parsed successfully from " + attributeValue + " to: " + this._isSolution);
                continue;
            }
            throw new MalformedTokenException(PARSE_ISSOLUTION_ERR_MSG);
        }
        this._groups = Collections.unmodifiableList(groupList);
        this._log.debug("Attribute statements successfully parsed");
    }

    private static List<PrincipalId> parseGroup(List<String> groupList) throws ParserException {
        assert (groupList != null);
        ArrayList<PrincipalId> groupResult = new ArrayList<PrincipalId>(groupList.size());
        for (String group : groupList) {
            groupResult.add(PrincipalIdParser.parseGroupId(group));
        }
        return groupResult;
    }

    private void verifyElementFormatURI(String gotFormat, String expectedFormat) throws MalformedTokenException {
        if (!gotFormat.equalsIgnoreCase(expectedFormat)) {
            String message = "Element format does not match the expected URI format. Got: " + gotFormat + " Expected: " + expectedFormat;
            this._log.error(message);
            throw new MalformedTokenException(message);
        }
    }

    private static Schema loadSamlSchema() {
        try {
            Schema samlSchema = Util.loadXmlSchemaFromResource(SamlTokenImpl.class, SAML_SCHEMA_FILENAME);
            return samlSchema;
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(SamlTokenImpl.class).error(String.format("Schema resource `%s' is missing.", SAML_SCHEMA_FILENAME), (Throwable)e);
            throw new DeploymentError(String.format("Schema resource `%s' is missing.", SAML_SCHEMA_FILENAME));
        }
        catch (SAXException e) {
            LoggerFactory.getLogger(SamlTokenImpl.class).error(ERR_LOADNIG_SAML_SCHEMA, (Throwable)e);
            throw new DeploymentError(ERR_LOADNIG_SAML_SCHEMA, e);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SamlToken && this.getId().equals(((SamlToken)other).getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    private void checkIsSignatureValidated() {
        if (!this._tokenValidated.get()) {
            throw new IllegalStateException("Until token signature is validated accessors cannot be used.");
        }
    }

    private static void markAssertionIdAttribute(Element assertionElement) {
        assert (assertionElement != null);
        assert (assertionElement.hasAttribute(ASSERTION_ID_ATTR_NAME));
        assertionElement.setIdAttribute(ASSERTION_ID_ATTR_NAME, true);
    }

    public static class TokenDelegateExImpl
    implements ValidatableSamlTokenEx.TokenDelegateEx {
        protected SubjectNameId _subjectNameId;
        protected PrincipalId _subject;
        protected long _delegationDate;

        public TokenDelegateExImpl(SubjectNameId subjectNameId, PrincipalId subject, long delegationDate) {
            assert (subjectNameId != null);
            this._subjectNameId = subjectNameId;
            this._subject = subject;
            this._delegationDate = delegationDate;
        }

        @Override
        public PrincipalId getSubject() {
            return this._subject;
        }

        @Override
        public Date getDelegationDate() {
            return new Date(this._delegationDate);
        }

        @Override
        public SubjectNameId getSubjectNameId() {
            return this._subjectNameId;
        }

        public String toString() {
            return String.format("TokenDelegateImpl [subject=%s, delegationDate=%s]", this._subjectNameId, this._delegationDate);
        }
    }

    public static class TokenDelegateImpl
    implements SamlToken.TokenDelegate {
        private final PrincipalId _subject;
        private final long _delegationDate;

        public TokenDelegateImpl(PrincipalId subject, long delegationDate) {
            assert (subject != null);
            this._subject = subject;
            this._delegationDate = delegationDate;
        }

        @Override
        public PrincipalId getSubject() {
            return this._subject;
        }

        @Override
        public Date getDelegationDate() {
            return new Date(this._delegationDate);
        }

        public String toString() {
            return String.format("TokenDelegateImpl [subject=%s, delegationDate=%s]", this._subject, this._delegationDate);
        }
    }

    static class DeploymentError
    extends Error {
        private static final long serialVersionUID = -6610749680263268064L;

        public DeploymentError(String message, Throwable cause) {
            super(message, cause);
        }

        public DeploymentError(String message) {
            super(message);
        }
    }
}

