/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.token.impl;

import com.vmware.identity.token.impl.ValidateUtil;
import com.vmware.identity.token.impl.exception.ParserException;
import com.vmware.vim.sso.client.SamlToken;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public final class Util {
    private static Logger getLog() {
        return LoggerFactory.getLogger(Util.class);
    }

    public static String serializeToString(Node content) throws ParserException {
        TransformerFactory tf = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        try {
            Transformer trans = tf.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.transform(new DOMSource(content), new StreamResult(writer));
        }
        catch (TransformerException e) {
            String message = "Error while serializing Node to String";
            Util.getLog().error(message);
            throw new ParserException(message, e);
        }
        return writer.toString();
    }

    public static String createRedactedDescription(SamlToken token) {
        return String.format("%s [subject=%s, groups=%s, delegactionChain=%s, startTime=%s, expirationTime=%s, renewable=%s, delegable=%s, isSolution=%s,confirmationType=%s]", new Object[]{token.getClass().getSimpleName(), Util.getTokenSubjectForLog(token), token.getGroupList(), token.getDelegationChain(), token.getStartTime(), token.getExpirationTime(), token.isRenewable(), token.isDelegable(), token.isSolution(), token.getConfirmationType()});
    }

    static String getTokenSubjectForLog(SamlToken token) {
        String tokenSubject = null;
        if (token != null) {
            if (token.getSubject() != null) {
                tokenSubject = token.getSubject().toString();
            } else if (token.getSubjectNameId() != null) {
                tokenSubject = token.getSubjectNameId().toString();
            }
        }
        if (tokenSubject == null) {
            tokenSubject = "NULL";
        }
        return tokenSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema loadXmlSchemaFromResource(ClassLoader theClassLoader, String resourceLocation, String resourceName) throws IllegalArgumentException, SAXException {
        Schema schema;
        Util.getLog().debug("loadXmlSchemaFromResource([{}], [{}], [{}])", new Object[]{theClassLoader.getClass().getName(), resourceLocation, resourceName});
        ClassLoaderResourceProvider resourceProvider = new ClassLoaderResourceProvider(theClassLoader, resourceLocation);
        try {
            schema = Util.loadXmlSchemaFromResource(resourceProvider, resourceName);
        }
        catch (Throwable throwable) {
            try {
                resourceProvider.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        resourceProvider.close();
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema loadXmlSchemaFromResource(Class<?> theClass, String resourceName) throws IllegalArgumentException, SAXException {
        Schema schema;
        Util.getLog().debug("loadXmlSchemaFromResource([{}], [{}])", (Object)theClass.getName(), (Object)resourceName);
        ClassResourceProvider resourceProvider = new ClassResourceProvider(theClass, resourceName);
        try {
            schema = Util.loadXmlSchemaFromResource(resourceProvider, resourceName);
        }
        catch (Throwable throwable) {
            try {
                resourceProvider.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        resourceProvider.close();
        return schema;
    }

    private Util() {
    }

    private static Schema loadXmlSchemaFromResource(IResourceProvider resourceProvider, String resourceName) throws IllegalArgumentException, SAXException {
        ResourceResolver resolver = new ResourceResolver(resourceProvider);
        InputStream is = resourceProvider.getResource(resourceName);
        if (is == null) {
            String message = String.format("Schema resource `%s' is missing.", resourceName);
            IllegalArgumentException e = new IllegalArgumentException(message);
            Util.getLog().error(message, (Throwable)e);
            throw e;
        }
        Util.getLog().debug("Resources's [{}] InputStream type is: [{};{}]", new Object[]{resourceName, is.getClass().getName(), is.toString()});
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setResourceResolver(resolver);
        StreamSource schemaSource = new StreamSource(is);
        Schema schema = sf.newSchema(schemaSource);
        return schema;
    }

    private static class ResourceResolver
    implements LSResourceResolver {
        private final IResourceProvider _resourceProvider;

        public ResourceResolver(IResourceProvider resourceProvider) {
            ValidateUtil.validateNotNull(resourceProvider, "resourceProvider");
            this._resourceProvider = resourceProvider;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            InputStream resourceAsStream = this._resourceProvider.getResource(systemId);
            if (resourceAsStream == null) {
                Util.getLog().debug("Resource [{}] being resolved is null.", (Object)systemId);
            } else {
                Util.getLog().debug("Resources's [{}] InputStream type is: [{};{}]", new Object[]{systemId, resourceAsStream.getClass().getName(), resourceAsStream.toString()});
            }
            return new LSInputImpl(publicId, systemId, baseURI, resourceAsStream);
        }

        private static class LSInputImpl
        implements LSInput {
            private String publicId;
            private String systemId;
            private String baseUri;
            private InputStream inputStream;

            public LSInputImpl(String publicId, String sysId, String baseURI, InputStream input) {
                this.publicId = publicId;
                this.systemId = sysId;
                this.baseUri = baseURI;
                this.inputStream = input;
            }

            @Override
            public String getPublicId() {
                return this.publicId;
            }

            @Override
            public void setPublicId(String publicId) {
            }

            @Override
            public String getBaseURI() {
                return this.baseUri;
            }

            @Override
            public InputStream getByteStream() {
                return this.inputStream;
            }

            @Override
            public boolean getCertifiedText() {
                return false;
            }

            @Override
            public Reader getCharacterStream() {
                return null;
            }

            @Override
            public String getEncoding() {
                return null;
            }

            @Override
            public String getStringData() {
                return null;
            }

            @Override
            public void setBaseURI(String baseURI) {
            }

            @Override
            public void setByteStream(InputStream byteStream) {
            }

            @Override
            public void setCertifiedText(boolean certifiedText) {
            }

            @Override
            public void setCharacterStream(Reader characterStream) {
            }

            @Override
            public void setEncoding(String encoding) {
            }

            @Override
            public void setStringData(String stringData) {
            }

            @Override
            public String getSystemId() {
                return this.systemId;
            }

            @Override
            public void setSystemId(String systemId) {
            }
        }
    }

    private static class ClassResourceProvider
    implements IResourceProvider {
        private final Class<?> _class;
        private ZipFile _zipFile;
        private final String _resourcePath;
        private List<InputStream> _streams;

        public ClassResourceProvider(Class<?> theClass, String mainResourceName) throws IOException {
            this._class = theClass;
            this._resourcePath = this._class.getPackage().getName().replace('.', '/') + "/";
            this._streams = new ArrayList<InputStream>(10);
            URL url = this._class.getResource(mainResourceName);
            if (url == null) {
                Util.getLog().error("Unable to find resource [{}].", (Object)mainResourceName);
                throw new IllegalArgumentException("unable to locate resource " + mainResourceName);
            }
            if ("jar".equalsIgnoreCase(url.getProtocol()) && url.getPath() != null && url.getPath().toLowerCase().startsWith("file:")) {
                String filePath = url.getPath();
                int index = filePath.indexOf(33);
                if (index > -1) {
                    filePath = filePath.substring(0, index);
                }
                Util.getLog().info("Reading resources from zip file path=[{}] ", (Object)filePath);
                URI uri = null;
                try {
                    uri = new URI(filePath);
                }
                catch (URISyntaxException e) {
                    Util.getLog().error("Unable to build Uri from path [{}]", (Object)url.getPath());
                    throw new IOException("Unable to build URI from path [" + url.getPath() + "].", e);
                }
                File file = new File(uri);
                this._zipFile = new ZipFile(file, 1);
            } else {
                this._zipFile = null;
            }
        }

        @Override
        public InputStream getResource(String resourceName) {
            InputStream is = null;
            if (this._zipFile != null) {
                ZipEntry entry = this._zipFile.getEntry(this._resourcePath + resourceName);
                if (entry == null) {
                    Util.getLog().error("Unable to read resource [{}{}]", (Object)this._resourcePath, (Object)resourceName);
                } else {
                    try {
                        is = this._zipFile.getInputStream(entry);
                    }
                    catch (IOException e) {
                        Util.getLog().error("Unable to read resource [{}]", (Object)(this._resourcePath + resourceName), (Object)e);
                        is = null;
                    }
                }
            } else {
                is = this._class.getResourceAsStream(resourceName);
            }
            if (is != null) {
                this._streams.add(is);
            }
            return is;
        }

        @Override
        public void close() throws IOException {
            if (this._streams != null) {
                for (InputStream is : this._streams) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        Util.getLog().error("Closing resource stream thrown exception. Ignoring.", (Throwable)ex);
                    }
                }
                this._streams = null;
            }
            if (this._zipFile != null) {
                try {
                    this._zipFile.close();
                }
                catch (IOException ex) {
                    Util.getLog().error("Closing zip file thrown exception. Ignoring.", (Throwable)ex);
                }
                this._zipFile = null;
            }
        }
    }

    private static class ClassLoaderResourceProvider
    implements IResourceProvider {
        private final String _resourceLocation;
        private final ClassLoader _classLoader;
        private List<InputStream> _streams;

        public ClassLoaderResourceProvider(ClassLoader theClassLoader, String resourceLocation) {
            this._classLoader = theClassLoader;
            this._streams = new ArrayList<InputStream>(10);
            this._resourceLocation = resourceLocation == null || resourceLocation.isEmpty() ? "" : (resourceLocation.endsWith("/") ? resourceLocation : resourceLocation + "/");
        }

        @Override
        public InputStream getResource(String resourceName) {
            InputStream is = this._classLoader.getResourceAsStream(this._resourceLocation + resourceName);
            if (is != null) {
                this._streams.add(is);
            }
            return is;
        }

        @Override
        public void close() throws IOException {
            if (this._streams != null) {
                for (InputStream is : this._streams) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        Util.getLog().error("Closing resource stream had thrown exception. Ignoring.", (Throwable)ex);
                    }
                }
                this._streams = null;
            }
        }
    }

    private static interface IResourceProvider
    extends Closeable {
        public InputStream getResource(String var1);
    }
}

